/*
 * Decompiled with CFR 0.152.
 */
package fiw.core;

import fiw.core.EnumerationIterator;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ContentTypeManager {
    private Properties cntTypes = null;
    private String htmlCharset;
    static /* synthetic */ Class class$fiw$core$Settings;

    public ContentTypeManager(String htmlCharset) throws FileNotFoundException {
        this.htmlCharset = htmlCharset;
        try {
            InputStream in = (class$fiw$core$Settings == null ? (class$fiw$core$Settings = ContentTypeManager.class$("fiw.core.Settings")) : class$fiw$core$Settings).getResourceAsStream("/res/mimetype.txt");
            if (in == null) {
                System.err.println("There is *no* mimetype.txt in your jar.");
                throw new FileNotFoundException();
            }
            Properties cntTypes2 = new Properties();
            cntTypes2.load(in);
            in.close();
            this.cntTypes = new Properties(cntTypes2);
            in = new FileInputStream("mimetype.conf");
            this.cntTypes.load(in);
            in.close();
            if (this.cntTypes.getProperty("png") == null) {
                System.err.println("Your content type file is fscked up.");
                if (cntTypes2.getProperty("png") != null) {
                    System.err.println("Possible JVM bug?");
                }
                throw new FileNotFoundException();
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            System.err.println("FATAL ERROR WHILE LOADING MIME TYPES:");
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public String parseEncoding(String ctype) {
        if (ctype.equals("text/html") && this.htmlCharset.length() != 0) {
            return ctype + ";charset=" + this.htmlCharset;
        }
        return ctype;
    }

    public String getCType(String filename) {
        int posi = filename.indexOf(46);
        if (posi == -1) {
            return "application/octet-stream";
        }
        String ct = this.cntTypes.getProperty(filename.substring(posi + 1).toLowerCase());
        if (ct == null) {
            ct = "application/octet-stream";
        }
        return this.parseEncoding(ct);
    }

    public List getIgnoredFileNames() {
        ArrayList<String> result = new ArrayList<String>();
        EnumerationIterator it = new EnumerationIterator(this.cntTypes.propertyNames());
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.startsWith("-ignore-") || this.cntTypes.get("-noignore-" + key.substring(8)) != null) continue;
            result.add(key.substring(8));
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

