/*
 * Decompiled with CFR 0.152.
 */
package fiw.cli;

import fiw.Main;
import fiw.core.FIWSystem;
import fiw.core.NimChecker;
import fiw.core.Stoppable;
import fiw.core.insert.InsertEngine;
import fiw.core.insert.InsertLogger;
import fiw.core.insert.event.InsertListener;
import fiw.core.insert.event.InsertLoggerListener;
import fiw.fcp.FCPConnection;
import fiw.gui.awt.InsertDialog;
import java.io.File;

public class CliInsert
implements InsertLogger {
    public static void listProjects() {
        String[] pr = FIWSystem.setts().getProjectNames();
        for (int i = 0; i < pr.length; ++i) {
            System.out.println("[" + (i + 1) + "] " + pr[i]);
        }
    }

    public static void cliInsertFile(String[] args) {
        if (args.length == 5) {
            FCPConnection fc = Main.doNodeHello();
            new InsertEngine(fc, Integer.parseInt(args[1]), false, args[2], args[3], new File(args[4]), new InsertLoggerListener(new CliInsert()));
        } else {
            System.out.println("Usage: fiw cliinsfile htl key mimetype filename.");
        }
    }

    public static void cliInsertProject(String[] args) {
        try {
            int project = Integer.parseInt(args[0]) - 1;
            if (project < 0 || project >= FIWSystem.setts().getProjCount()) {
                System.err.println("Incorrect project number");
                return;
            }
            int htl = Integer.parseInt(args[2]);
            if ("true".equals(FIWSystem.setts().getProjectSetting(project, "dbr"))) {
                int first = 1;
                int last = 1;
                if (args.length == 4) {
                    first = last = Integer.parseInt(args[3]);
                } else if (args.length == 5) {
                    first = Integer.parseInt(args[3]);
                    last = Integer.parseInt(args[4]);
                }
                long increment = Integer.parseInt(CliInsert.getval(project, "dbr.increment", "86400"));
                if (increment == 0L) {
                    increment = 86400L;
                }
                long offset = Integer.parseInt(CliInsert.getval(project, "dbr.offset", "0"));
                long timetemp = System.currentTimeMillis() / 1000L - offset;
                timetemp = timetemp / increment * increment + offset;
                long firstx = timetemp + (long)first * increment;
                long lastx = timetemp + (long)last * increment;
                FIWSystem.setts().saveProject(project, "dbr.first", "" + firstx);
                FIWSystem.setts().saveProject(project, "dbr.last", "" + lastx);
            } else if (args.length == 4) {
                int edvalue = Integer.parseInt(args[3]);
                if (edvalue < 0 || !args[3].equals("" + edvalue)) {
                    System.err.println("Incorrect Edition number");
                    return;
                }
                FIWSystem.setts().saveProject(project, "editionx", args[3]);
            } else if (args.length == 5) {
                System.err.println("NO DBR site!");
                return;
            }
            FCPConnection fc = Main.doNodeHello();
            InsertLogger logr = args[1].toLowerCase().equals("cliins") ? new CliInsert() : new InsertDialog(true, true);
            new InsertEngine(fc, project, htl, false, true, (InsertListener)new InsertLoggerListener(logr));
        }
        catch (NumberFormatException e) {
            System.err.println("Not a number: " + e.getMessage());
        }
    }

    public static void cliCheckNims(String[] args) {
        if (args.length == 3) {
            FCPConnection fc = Main.doNodeHello();
            InsertLogger il = args[0].toLowerCase().equals("guichecknims") ? new InsertDialog(false, true) : new CliInsert();
            new NimChecker(fc, new InsertLoggerListener(il), Integer.parseInt(args[1]), Integer.parseInt(args[2]));
        } else {
            System.out.println("Usage: fiw " + args[0] + " HTL advance");
        }
    }

    private static String getval(int project, String name, String def) {
        String ret = FIWSystem.setts().getProjectSetting(project, name);
        if (ret == null) {
            ret = def;
        }
        return ret;
    }

    public void addlogNoNewline(String s) {
        System.out.print(s);
    }

    public void addlog(String s) {
        System.out.println(s);
    }

    public void done() {
        System.exit(0);
    }

    public void setStatus(String s) {
    }

    public int addThread(int globalno) {
        return -1;
    }

    public void setThread(int no, String s) {
    }

    public void setThread(int no, int retry, int actionIndex, String desc) {
    }

    public void removeThread(int no) {
    }

    public void restart() {
    }

    public void iamhere(Stoppable ie) {
    }
}

