/*
 * Decompiled with CFR 0.152.
 */
package fiw.cli;

import fiw.core.FIWSystem;
import fiw.core.FileUtil;
import fiw.core.option.ButtonOption;
import fiw.core.option.DayTimeOptionType;
import fiw.core.option.GlobalOptions;
import fiw.core.option.Option;
import fiw.core.option.Options;
import fiw.fcp.FCPConnection;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public class Cli {
    private BufferedReader stdIn;
    private int project;

    public Cli() {
        try {
            while (System.in.available() != 0) {
                System.in.read();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.stdIn = new BufferedReader(new InputStreamReader(System.in));
    }

    public void start() {
        try {
            if (this.initialize()) {
                while (true) {
                    switch (this.mainSelect()) {
                        case -1: {
                            System.out.println("Unknown command");
                            break;
                        }
                        case 0: {
                            return;
                        }
                        case 1: {
                            this.editProject();
                            break;
                        }
                        case 2: {
                            this.deleteProject();
                            break;
                        }
                        case 3: {
                            this.insertProject();
                            break;
                        }
                        case 4: {
                            this.moveCloneProject();
                        }
                    }
                }
            }
            System.out.println("\n\nThanks for using FIW!");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private boolean initialize() throws IOException {
        this.createHelpFile();
        System.out.println("Welcome to the FIW command line interface!\nYou can find help in the file \"fiwcli.txt\".\nThis file is divided into sections - each section is about one 'step' \nin FIW cli.\n");
        System.out.println("------------------");
        System.out.println("Step 0 - configure FCP connection");
        FCPConnection fc = FIWSystem.getInstance().createFCPConnection();
        while (true) {
            System.out.println("\nCurrent config: " + fc.getHost() + ":" + fc.getPort());
            String s = fc.handshake();
            if (s == null) {
                System.out.println("Could not connect to host.\n\nPress return to retry with same settings");
            } else {
                System.out.println("Connection successful. Answer from fred:\n\n" + s + "\n\nPress Return to go " + "to the next step\nPress 'a' for advanced " + "settings");
            }
            System.out.println("Enter new host:port pair to change config\nEnter 'q' to quit");
            System.out.print("fiw>");
            String line = this.stdIn.readLine();
            if (line == null) {
                return false;
            }
            if (line.equals("") && s != null) {
                return true;
            }
            if (line.equals("")) continue;
            if (line.equals("q")) {
                return false;
            }
            if (line.equals("a") && s != null) {
                this.advancedSettings();
                continue;
            }
            if (line.indexOf(":") == -1) {
                System.out.println("Unknown line.");
                continue;
            }
            int pos = line.indexOf(":");
            try {
                int port = Integer.parseInt(line.substring(pos + 1));
                String host = line.substring(0, pos);
                fc = FIWSystem.getInstance().createFCPConnection(host, port);
                continue;
            }
            catch (NumberFormatException ex) {
                System.out.println("Invalid port number.");
                continue;
            }
            break;
        }
    }

    private int mainSelect() throws IOException {
        String line;
        String[] pr;
        block17: {
            System.out.println("------------------");
            System.out.println("Step 2 - Select what to do\n");
            pr = FIWSystem.setts().getProjectNames();
            for (int i = 0; i < pr.length; ++i) {
                System.out.println("[" + (i + 1) + "] " + pr[i]);
            }
            System.out.println("\nActions:\n[C]reate new, [E]dit #, [I]nsert #, [D]elete #, [M]ove/clone, [Q]uit");
            System.out.println("Enter the letter of of the desired action plus the number of the\nproject, e.g. e3 to edit Project 3");
            System.out.print("fiw>");
            line = this.stdIn.readLine();
            if (line == null || line.length() < 1) {
                return -1;
            }
            if (line.length() > 1) {
                try {
                    this.project = Integer.parseInt(line.substring(1));
                    if (this.project < 1 || this.project > pr.length) {
                        return -1;
                    }
                    break block17;
                }
                catch (NumberFormatException ex) {
                    return -1;
                }
            }
            this.project = -1;
        }
        switch (line.toLowerCase().charAt(0)) {
            case 'q': {
                return 0;
            }
            case 'c': {
                this.project = pr.length + 1;
                return 1;
            }
            case 'e': {
                if (this.project == -1) {
                    return -1;
                }
                return 1;
            }
            case 'd': {
                if (this.project == -1) {
                    return -1;
                }
                return 2;
            }
            case 'i': {
                if (this.project == -1) {
                    return -1;
                }
                return 3;
            }
            case 'm': {
                return 4;
            }
        }
        return -1;
    }

    private void editProject() throws IOException {
        System.out.println("------------------");
        System.out.println("Step 3 - create/edit a project\n");
        System.out.println("NOTE: Most options are not checked here - so do not complain \nif a project created w/ cli throws an exception...\n");
        int currentStep = 3;
        Options os = new Options(this.project - 1);
        Option[] oss = os.getSettings();
        block7: for (int i = 0; i < oss.length; ++i) {
            String line;
            Option o = oss[i];
            int panel = o.getPanelNumber();
            if ((panel < 3 || panel > 6) && panel != 1001) continue;
            if (o instanceof ButtonOption) {
                System.out.print(o.getName() + " [y/N]:");
                line = this.stdIn.readLine();
                if (line != null && line.equals("q")) break;
                if (line == null || !line.equals("y")) continue;
                ((ButtonOption)o).handleAction();
                continue;
            }
            if (o.isSpecial()) {
                switch (o.getSpecialNumber()) {
                    case 1: {
                        System.out.println("\nTo generate a new key pair, just leave these values as is and enter 'y' in \nthe following question.");
                        break;
                    }
                    case 3: {
                        System.out.println("\nCreate a file called description.txt in your project folder and add the\ndescription for this project there.\n");
                        break;
                    }
                    case 4: {
                        System.out.println("\nAdd the files you want to parse (including index.html, if you want to parse\nthat file) into .fiw/parse.ini.\n");
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 6: {
                        if (os.getOption("dbr").getValue().equals("true")) continue block7;
                        i += 2;
                        break;
                    }
                    default: {
                        System.out.println("ERROR: Special number invalid in Option #" + i);
                        break;
                    }
                }
                continue;
            }
            if (o.getPanelNumber() != currentStep && o.getPanelNumber() != 1001) {
                currentStep = o.getPanelNumber();
                System.out.println("\n------------------");
                System.out.println("Step " + currentStep + " - create/edit a project\n");
            }
            while (true) {
                System.out.print(o.getName() + (o.getType() instanceof DayTimeOptionType ? " (seconds)" : "") + " [" + o.getValue() + "]: ");
                line = this.stdIn.readLine();
                if (line == null || line.equals("")) continue block7;
                if (line.equals("q")) break block7;
                boolean ok = o.setValue(line);
                if (ok) continue block7;
                System.out.println(o.getInvalidReason(line));
            }
        }
        System.out.println("--- saving settings ---");
        os.save();
        System.out.print("--- settings saved - press return ---");
        this.stdIn.readLine();
    }

    private void advancedSettings() throws IOException {
        System.out.println("------------------");
        System.out.println("Step 1 - advanced settings\n");
        System.out.println("NOTE: Most options are not checked here\n");
        GlobalOptions os = new GlobalOptions();
        Option[] oss = os.getSettings();
        block3: for (int i = 0; i < oss.length; ++i) {
            String line;
            Option o = oss[i];
            int panel = o.getPanelNumber();
            if (panel != 1) continue;
            if (o.isSpecial()) {
                switch (o.getSpecialNumber()) {
                    case 1: {
                        System.out.println("Configure geeky settings?");
                        System.out.print("y/n>");
                        line = this.stdIn.readLine();
                        if (line == null || line.equals("y")) continue block3;
                        break block3;
                    }
                    default: {
                        System.out.println("ERROR: Special number invalid in Option #" + i);
                        break;
                    }
                }
                continue;
            }
            while (true) {
                System.out.print(o.getName() + " [" + o.getValue() + "]: ");
                line = this.stdIn.readLine();
                if (line == null || line.equals("")) continue block3;
                if (line.equals("q")) break block3;
                boolean ok = o.setValue(line);
                if (ok) continue block3;
                System.out.println(o.getInvalidReason(line));
            }
        }
        os.save();
    }

    private void deleteProject() throws IOException {
        System.out.println("------------------");
        System.out.println("Step 7 -delete a project\n");
        int p = this.project - 1;
        System.out.println("Deleting a project cannot be undone.\nDo you want to proceed?\n");
        System.out.println("Project name: '" + FIWSystem.setts().getProjectSetting(p, "name") + "'" + "\npublic key: " + FIWSystem.setts().getProjectSetting(p, "pubkey") + "\nprivate key: " + FIWSystem.setts().getProjectSetting(p, "privkey"));
        System.out.print("y/n>");
        String line = this.stdIn.readLine();
        if (line != null && line.toLowerCase().equals("y")) {
            FIWSystem.setts().deleteProperties("proj." + p + ".");
            for (int i = p; i < FIWSystem.setts().getProjCount(); ++i) {
                FIWSystem.setts().renameProperties("proj." + (i + 1) + ".", "proj." + i + ".");
            }
            FIWSystem.setts().setProperty("proj.count", "" + (FIWSystem.setts().getProjCount() - 1));
        }
    }

    private void insertProject() throws IOException {
        System.out.println("------------------");
        System.out.println("Step 8 -insert a project\n");
        System.out.println("Please use the `fiw cliins' command!");
        System.out.print("\nPress return. ");
        this.stdIn.readLine();
    }

    private void moveCloneProject() throws IOException {
        while (true) {
            System.out.println("------------------");
            System.out.println("Step 2b - move/clone projects\n");
            String[] pr = FIWSystem.setts().getProjectNames();
            for (int i = 0; i < pr.length; ++i) {
                System.out.println("[" + (i + 1) + "] " + pr[i]);
            }
            System.out.println("\nMove [u]p #, Move [d]own #, [C]lone #, [Q]uit");
            System.out.print("fiw>");
            String line = this.stdIn.readLine();
            if (line == null) {
                return;
            }
            if (line.length() < 1) {
                this.project = -2;
            } else if (line.length() > 1) {
                try {
                    this.project = Integer.parseInt(line.substring(1));
                    if (this.project < 1 || this.project > pr.length) {
                        this.project = -2;
                    }
                }
                catch (NumberFormatException ex) {
                    this.project = -2;
                }
            } else {
                this.project = -1;
            }
            if (this.project == -2) {
                System.out.println("Unknown command");
                continue;
            }
            switch (line.toLowerCase().charAt(0)) {
                case 'q': {
                    return;
                }
                case 'c': {
                    if (this.project == -1) {
                        System.out.println("Unknown command");
                        break;
                    }
                    int newnum = pr.length;
                    int projectnum = this.project - 1;
                    FIWSystem.setts().setProjCount(newnum + 1);
                    FIWSystem.setts().copyProperties("proj." + projectnum + ".", "proj." + newnum + ".", false);
                    break;
                }
                case 'u': {
                    if (this.project == -1) {
                        System.out.println("Unknown command");
                        break;
                    }
                    if (this.project == 1) {
                        System.out.println("Project 1 cannot be moved up.");
                        break;
                    }
                    int projectnum = this.project - 1;
                    FIWSystem.setts().renameProperties("proj." + projectnum + ".", "proj.TEMP.");
                    FIWSystem.setts().renameProperties("proj." + (projectnum - 1) + ".", "proj." + projectnum + ".");
                    FIWSystem.setts().renameProperties("proj.TEMP.", "proj." + (projectnum - 1) + ".");
                    break;
                }
                case 'd': {
                    if (this.project == -1) {
                        System.out.println("Unknown command");
                        break;
                    }
                    if (this.project == pr.length) {
                        System.out.println("Project " + this.project + " cannot be moved down.");
                        break;
                    }
                    int projectnum = this.project - 1;
                    FIWSystem.setts().renameProperties("proj." + projectnum + ".", "proj.TEMP.");
                    FIWSystem.setts().renameProperties("proj." + (projectnum + 1) + ".", "proj." + projectnum + ".");
                    FIWSystem.setts().renameProperties("proj.TEMP.", "proj." + (projectnum + 1) + ".");
                    break;
                }
            }
        }
    }

    private void createHelpFile() throws IOException {
        File dest = new File("fiwcli.txt");
        if (dest.exists()) {
            return;
        }
        try {
            String desc;
            PrintWriter w = new PrintWriter(new BufferedWriter(new FileWriter(dest)));
            for (int i = 0; i < 100 && !(desc = FileUtil.getWizardDesc(i)).startsWith("["); ++i) {
                w.println("======================");
                w.println("STEP " + i);
                w.println("======================");
                w.println(desc);
                w.println();
            }
            w.flush();
            w.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

