/*
 * Decompiled with CFR 0.152.
 */
package fiw.addon;

import fiw.fcp.DataNotFoundResult;
import fiw.fcp.FCPConnection;
import fiw.fcp.FCPGetResult;
import fiw.fcp.GeneralErrorResult;
import fiw.fcp.MetadataResult;
import fiw.fcp.RouteNotFoundResult;
import fiw.fcp.SocketTimeoutResult;
import fiw.fcp.URIErrorResult;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;

public class MetaDataBrowser
extends Frame
implements ActionListener,
KeyListener {
    private static final String GREETING = "Welcome to FMDB 0.08\n\nEnter an URI into the text box below and press Return to view.\nPlace the Cursor in a line that contains a redirect URI and press Return to follow it.\nIf that URI is a DateRedirect, you can set the date you want to use for redirection in the text field below.\nYou can also remove files from your local datastore. For that, visit the file and click the \"Zap\" button.\n\nHave Fun!\n\n\n\nFred says:\n";
    private String serverState;
    private TextArea view;
    private TextField uri;
    private TextField htl;
    private TextField date;
    private Button back;
    private Button zap;
    private ArrayList oldUris = new ArrayList();
    private FCPConnection fcpConn;
    static /* synthetic */ Class class$fiw$Main;

    public MetaDataBrowser(FCPConnection fcpConn, boolean standalone) {
        this(fcpConn, "SSK@rBjVda8pC-Kq04jUurIAb8IzAGcPAgM/TFE", standalone);
    }

    public MetaDataBrowser(FCPConnection fcpConn, String startUri, final boolean standalone) {
        super(fcpConn.getHost() + ":" + fcpConn.getPort() + " - Freenet MetaData Browser " + "0.08" + " (c) 2003 by mihi");
        this.fcpConn = fcpConn;
        Font font = new Font("Monospaced", 0, 12);
        this.setIconImage(Toolkit.getDefaultToolkit().createImage((class$fiw$Main == null ? (class$fiw$Main = MetaDataBrowser.class$("fiw.Main")) : class$fiw$Main).getResource("/res/icon2.gif")));
        this.view = new TextArea("", 30, 100, 1);
        this.add((Component)this.view, "Center");
        this.view.setEditable(false);
        this.view.addKeyListener(this);
        this.view.setFont(font);
        this.setBackground(Color.lightGray);
        Panel p = new Panel(new BorderLayout());
        this.add((Component)p, "South");
        Panel p2 = new Panel(new GridLayout(2, 1));
        p.add((Component)p2, "East");
        p2.add(new Label("Date:"));
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.date = new TextField(df.format(new Date()));
        p2.add(this.date);
        p2 = new Panel(new GridLayout(2, 1));
        p.add((Component)p2, "Center");
        Panel p3 = new Panel(new BorderLayout());
        p2.add(p3);
        this.back = new Button("Back");
        p3.add((Component)this.back, "West");
        this.back.addActionListener(this);
        Panel p4 = new Panel(new BorderLayout());
        p3.add((Component)p4, "Center");
        this.zap = new Button("Zap");
        p4.add((Component)this.zap, "West");
        this.zap.addActionListener(this);
        p4.add((Component)new Label("URI:"), "Center");
        this.uri = new TextField("about:");
        p2.add(this.uri);
        this.uri.addActionListener(this);
        p2 = new Panel(new GridLayout(2, 1));
        p.add((Component)p2, "West");
        p2.add(new Label("HTL:"));
        this.htl = new TextField("0");
        p2.add(this.htl);
        this.htl.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                if (standalone) {
                    System.exit(0);
                } else {
                    MetaDataBrowser.this.dispose();
                }
            }
        });
        this.pack();
        this.serverState = fcpConn.handshake();
        if (this.serverState != null) {
            this.followLink();
            this.uri.setText(startUri);
        } else {
            this.uri.setEditable(false);
            this.uri.setText("noconn:");
            this.followLink();
        }
        this.show();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.back) {
            if (this.oldUris.size() > 1) {
                this.oldUris.remove(this.oldUris.size() - 1);
                this.uri.setText((String)this.oldUris.get(this.oldUris.size() - 1));
                this.oldUris.remove(this.oldUris.size() - 1);
                this.followLink();
            }
        } else if (evt.getSource() == this.zap) {
            String urii = this.uri.getText();
            if (urii.indexOf("@") != -1 && !urii.startsWith("invalid:")) {
                this.fcpConn.deleteKey(urii);
                this.oldUris.remove(this.oldUris.size() - 1);
                this.followLink();
            }
        } else {
            this.followLink();
        }
    }

    public void keyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            String line = this.getLine(0);
            if (line.startsWith("Redirect.Target=")) {
                this.uri.setText(line.substring(16));
                this.followLink();
            } else if (line.startsWith("DateRedirect.Target=")) {
                String ll;
                int i;
                String to = line.substring(20);
                long inc = 86400L;
                long offs = 0L;
                for (i = 1; i < 3; ++i) {
                    ll = this.getLine(-i);
                    if (ll.startsWith("DateRedirect.Increment=")) {
                        inc = Integer.parseInt(ll.substring(23), 16);
                        continue;
                    }
                    if (!ll.startsWith("DateRedirect.Offset=")) break;
                    offs = Integer.parseInt(ll.substring(20), 16);
                }
                for (i = 1; i < 3; ++i) {
                    ll = this.getLine(i);
                    if (ll.startsWith("DateRedirect.Increment=")) {
                        inc = Integer.parseInt(ll.substring(23), 16);
                        continue;
                    }
                    if (!ll.startsWith("DateRedirect.Offset=")) break;
                    offs = Integer.parseInt(ll.substring(20), 16);
                }
                long now = this.getDateSeconds(this.date.getText()) - offs;
                now = now / inc * inc + offs;
                String slotnum = Integer.toHexString((int)now) + "-";
                if (to.startsWith("KSK@")) {
                    to = "KSK@" + slotnum + to.substring(4);
                } else if (to.startsWith("freenet:KSK@")) {
                    to = "KSK@" + slotnum + to.substring(12);
                } else if (to.startsWith("SSK@") || to.startsWith("freenet:SSK@")) {
                    int pp = to.indexOf("/");
                    to = to.substring(0, pp + 1) + slotnum + to.substring(pp + 1);
                } else {
                    to = "/";
                }
                this.uri.setText(to);
                this.followLink();
            } else if (line.indexOf("CHK@") != -1) {
                int p = line.indexOf("CHK@");
                this.uri.setText(line.substring(p));
                this.followLink();
            } else {
                this.uri.setText("/");
                this.followLink();
            }
        }
    }

    public void keyTyped(KeyEvent evt) {
    }

    public void keyReleased(KeyEvent evt) {
    }

    private String getLine(int offset) {
        int i;
        int caret = this.view.getCaretPosition() + 4;
        String line = "\n\n\n\n" + this.view.getText() + "\n\n\n\n";
        int pos = line.substring(0, caret).lastIndexOf("\n");
        for (i = 0; i > offset; --i) {
            pos = line.substring(0, pos).lastIndexOf("\n");
        }
        line = line.substring(pos + 1);
        for (i = 0; i < offset; ++i) {
            pos = line.indexOf("\n");
            line = line.substring(pos + 1);
        }
        pos = line.indexOf("\n");
        line = line.substring(0, pos);
        return line;
    }

    private void followLink() {
        int htlvalue;
        String urii = this.uri.getText();
        this.view.setText("");
        if (urii.startsWith("freenet:")) {
            urii = urii.substring(8);
            this.uri.setText(urii);
        }
        this.oldUris.add(urii);
        if (urii.length() == 0) {
            this.view.setText("No URI specified");
            return;
        }
        if (urii.equals("/")) {
            this.view.setText("No URI found. Move your cursor to lines containing the word \"Target\".");
            return;
        }
        if (urii.equals("about:")) {
            this.view.setText(GREETING + this.serverState);
            return;
        }
        if (urii.equals("noconn:")) {
            this.view.setText("Error: could not connect to fred.");
            return;
        }
        if (urii.startsWith("invalid:")) {
            this.view.setText("Error: URIs start with SSK@, CHK@, KSK@ or SVK@");
            return;
        }
        if (!(urii.startsWith("SSK@") || urii.startsWith("KSK@") || urii.startsWith("CHK@") || urii.startsWith("SVK@"))) {
            this.uri.setText("invalid:" + urii);
            this.view.setText("Error: URIs start with SSK@, CHK@, KSK@ or SVK@");
            return;
        }
        try {
            htlvalue = Integer.parseInt(this.htl.getText());
        }
        catch (NumberFormatException e) {
            htlvalue = -1;
        }
        if (htlvalue < 0 || htlvalue > 100) {
            this.view.setText("Error: Incorrect HTL.");
            return;
        }
        long ttime = System.currentTimeMillis();
        FCPGetResult result = this.fcpConn.fetchMetadata(urii, htlvalue);
        ttime = System.currentTimeMillis() - ttime;
        if (result instanceof RouteNotFoundResult) {
            RouteNotFoundResult rnfr = (RouteNotFoundResult)result;
            this.view.setText("Error: RouteNotFound\n\nUnreachable: " + rnfr.getUnreachable() + "\nRestarted: " + rnfr.getRestarted() + "\nRejected: " + rnfr.getRejected());
        } else if (result instanceof DataNotFoundResult) {
            this.view.setText("Error: DataNotFound");
        } else if (result instanceof URIErrorResult) {
            this.view.setText("Error: URIError\nReason:-3\n" + ((URIErrorResult)result).getReason());
        } else if (result instanceof GeneralErrorResult) {
            this.view.setText("Error: Unexpected error:\n" + ((GeneralErrorResult)result).getReason());
        } else if (result instanceof SocketTimeoutResult) {
            this.view.setText("Error: Socket Timeout");
        } else if (!(result instanceof MetadataResult)) {
            this.view.setText("Error: Unexpected error: check logfile.\n\nResult type: " + result.getClass().getName());
        } else {
            String mdata = result.getPayload();
            long len = ((MetadataResult)result).getDataLength();
            if (mdata.length() == 0) {
                mdata = "[no metadata]";
            }
            this.view.setText(mdata + "\n----------\nRawDataLength=" + len);
        }
        this.view.insert("Time taken: " + ttime + "\n\n", 0);
    }

    private long getDateSeconds(String date) {
        boolean timePresent = date.indexOf(" ") != -1;
        SimpleDateFormat df = new SimpleDateFormat(timePresent ? "yyyy-MM-dd HH:mm" : "yyyy-MM-dd");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        df.setLenient(true);
        try {
            Date dd = df.parse(date);
            return dd.getTime() / 1000L;
        }
        catch (ParseException e) {
            return 0L;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

