/*
 * Decompiled with CFR 0.152.
 */
package fiw.addon;

import fiw.fcp.FCPConnection;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;

public class LoadStatus
extends Frame
implements Runnable {
    private GraphCanvas mainGraph;
    private GraphCanvas slowGraph;
    private TextArea disp;
    private TextArea records;
    private FCPConnection fcpConn;
    private int valCount30 = 0;
    private int valMin = 100;
    private int valMax = 0;
    private long valSum = 0L;
    private long valCount = 0L;
    private int valMin30 = 100;
    private int valMax30 = 0;
    static /* synthetic */ Class class$fiw$Main;

    public LoadStatus(FCPConnection fcpConn, final boolean standalone) {
        super("Freenet Load Status");
        this.fcpConn = fcpConn;
        this.setIconImage(Toolkit.getDefaultToolkit().createImage((class$fiw$Main == null ? (class$fiw$Main = LoadStatus.class$("fiw.Main")) : class$fiw$Main).getResource("/res/icon1.gif")));
        this.setBackground(Color.lightGray);
        this.disp = new TextArea(25, 40);
        this.add((Component)this.disp, "Center");
        Panel p = new Panel(new BorderLayout());
        this.add((Component)p, "West");
        p.add((Component)new Label("Last 10 minutes:"), "North");
        Panel panel = p;
        p = new Panel(new BorderLayout());
        panel.add((Component)p, "Center");
        this.mainGraph = new GraphCanvas();
        p.add((Component)this.mainGraph, "North");
        Panel panel2 = p;
        p = new Panel(new BorderLayout());
        panel2.add((Component)p, "Center");
        p.add((Component)new Label("Last 5 hours:"), "North");
        Panel panel3 = p;
        p = new Panel(new BorderLayout());
        panel3.add((Component)p, "Center");
        this.slowGraph = new GraphCanvas();
        p.add((Component)this.slowGraph, "North");
        this.records = new TextArea(4, 4);
        p.add((Component)this.records, "Center");
        this.disp.setEditable(false);
        this.records.setEditable(false);
        new Thread(this).start();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (standalone) {
                    System.exit(0);
                } else {
                    LoadStatus.this.dispose();
                }
            }
        });
        this.pack();
        this.show();
    }

    public void run() {
        try {
            while (true) {
                String nodeInfo = this.fcpConn.getNodeInfo();
                int load = this.fcpConn.getNetworkLoad();
                if (load == -1) {
                    this.setTitle("Not running - Freenet Load Status");
                    this.disp.setText("");
                    this.addValue(-1);
                } else {
                    this.setTitle(load + "% - Freenet Load Status");
                    this.disp.setText(nodeInfo);
                    this.addValue(load);
                }
                Thread.sleep(2000L);
            }
        }
        catch (InterruptedException e) {
            this.setTitle(e.toString());
            e.printStackTrace();
            return;
        }
    }

    private void addValue(int val) {
        int val2 = val == -1 ? 100 : val;
        this.mainGraph.addValue(val2);
        ++this.valCount30;
        if (this.valMin30 > val2) {
            this.valMin30 = val2;
        }
        if (this.valMax30 < val2) {
            this.valMax30 = val2;
        }
        if (this.valCount30 == 30) {
            this.slowGraph.addValue(this.valMin30, this.valMax30);
            this.valMax30 = 0;
            this.valCount30 = 0;
            this.valMin30 = 100;
        }
        this.valSum += (long)val2;
        ++this.valCount;
        if (val != -1) {
            if (val < this.valMin) {
                this.valMin = val;
            }
            if (val > this.valMax) {
                this.valMax = val;
            }
        }
        this.records.setText("Number of NodeInfo samples: " + this.valCount + "\n" + (this.valMin <= this.valMax ? "Minimum load:     " + this.valMin + "%\n" + "Maximum load:     " + this.valMax + "%\n" : "") + "Average load:     " + this.valSum / this.valCount + "%\n" + "FCP host/port: " + this.fcpConn.getHost() + ":" + this.fcpConn.getPort());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class GraphCanvas
    extends Canvas {
        private BufferedImage img;
        private int[] values = new int[300];
        private int[] values2 = new int[300];
        private int pointer = 0;
        private int lastPointer = 0;

        GraphCanvas() {
        }

        public void addValue(int val) {
            this.addValue(val, val);
        }

        public void addValue(int val1, int val2) {
            this.values[this.pointer] = val1;
            this.values2[this.pointer] = val2;
            ++this.pointer;
            this.pointer %= 300;
            this.repaint();
        }

        public void update(Graphics g) {
            this.paint(g);
        }

        public void paint(Graphics g) {
            if (this.img == null) {
                this.img = new BufferedImage(310, 110, 1);
                Graphics gg = this.img.getGraphics();
                gg.setColor(Color.lightGray);
                gg.fillRect(0, 0, 310, 110);
                gg.setColor(Color.blue);
                gg.drawRect(4, 4, 301, 102);
                gg.setColor(Color.white);
                gg.fillRect(5, 5, 300, 100);
                gg.setColor(Color.black);
                gg.drawLine(5, 105, 304, 105);
                gg.setColor(Color.green);
                gg.drawLine(5, 5, 304, 5);
                gg.drawLine(5, 30, 304, 30);
                gg.drawLine(5, 55, 304, 55);
                gg.drawLine(5, 80, 304, 80);
            }
            this.paint2(this.img.getGraphics());
            g.drawImage(this.img, 0, 0, this);
        }

        private void paint2(Graphics g) {
            g.setColor(Color.red);
            g.drawLine(this.pointer + 5, 5, this.pointer + 5, 105);
            while (this.lastPointer != this.pointer) {
                int llp = this.lastPointer - 1;
                if (this.lastPointer == 0) {
                    llp = 0;
                }
                g.setColor(Color.white);
                g.drawLine(this.lastPointer + 5, 5, this.lastPointer + 5, 105);
                g.setColor(Color.green);
                g.drawLine(this.lastPointer + 5, 5, this.lastPointer + 5, 5);
                g.drawLine(this.lastPointer + 5, 30, this.lastPointer + 5, 30);
                g.drawLine(this.lastPointer + 5, 55, this.lastPointer + 5, 55);
                g.drawLine(this.lastPointer + 5, 80, this.lastPointer + 5, 80);
                g.drawLine(this.lastPointer + 5, 105, this.lastPointer + 5, 105);
                g.setColor(Color.black);
                g.drawLine(llp + 5, 105 - this.values[llp], this.lastPointer + 5, 105 - this.values[this.lastPointer]);
                g.drawLine(llp + 5, 105 - this.values2[llp], this.lastPointer + 5, 105 - this.values2[this.lastPointer]);
                g.drawLine(this.lastPointer + 5, 105 - this.values[this.lastPointer], this.lastPointer + 5, 105 - this.values2[this.lastPointer]);
                this.lastPointer = (this.lastPointer + 1) % 300;
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(310, 110);
        }
    }
}

