/*
 * Decompiled with CFR 0.152.
 */
package fiw;

import fiw.addon.LoadStatus;
import fiw.addon.MetaDataBrowser;
import fiw.cli.Cli;
import fiw.cli.CliInsert;
import fiw.core.DBRcalc;
import fiw.core.FIWSystem;
import fiw.core.GUIHelper;
import fiw.core.insert.InsertEngine;
import fiw.core.insert.event.InsertLoggerListener;
import fiw.fcp.DataNotFoundResult;
import fiw.fcp.FCPConnection;
import fiw.fcp.FCPGetResult;
import fiw.fcp.FingerprintResult;
import fiw.fcp.RouteNotFoundResult;
import fiw.fcp.SocketTimeoutResult;
import fiw.gui.awt.InsertDialog;
import fiw.gui.awt.Wizard;
import java.io.File;
import java.lang.reflect.Method;

public class Main {
    public static final String VERSION = "0.08";
    static /* synthetic */ Class class$java$lang$String;

    public static void main(String[] args) {
        System.out.println("Freesite Insertion Wizard 0.08\n");
        if (args.length == 0) {
            new Wizard();
        } else if (args[0].toLowerCase().equals("cli")) {
            new Cli().start();
        } else if (args[0].toLowerCase().equals("list")) {
            CliInsert.listProjects();
        } else if (args[0].toLowerCase().equals("language")) {
            if (args.length == 2) {
                FIWSystem.getInstance().setLanguage(args[1]);
                System.out.println("Language changed.");
            } else {
                System.out.println("Available languages:");
                String[] langs = GUIHelper.getInstance().getAvailableLanguages();
                for (int i = 0; i < langs.length; ++i) {
                    System.out.println(langs[i]);
                }
            }
        } else if (args[0].toLowerCase().equals("delete")) {
            FCPConnection fc = Main.doNodeHello();
            for (int i = 1; i < args.length; ++i) {
                FCPGetResult res = fc.fetchFingerprint(args[i], 0, true);
                System.out.println("Before deleting: " + (res instanceof FingerprintResult ? "DataFound" : (res instanceof RouteNotFoundResult ? "RouteNotFound" : (res instanceof DataNotFoundResult ? "DataNotFound" : (res instanceof SocketTimeoutResult ? "SocketTimeout" : "Unexpected Error")))));
                System.out.println("After deleting: " + fc.deleteKey(args[i]));
            }
        } else if (args[0].toLowerCase().equals("mdbrowser")) {
            FCPConnection fc = Main.doNodeHello();
            new MetaDataBrowser(fc, true);
        } else if (args[0].toLowerCase().equals("loadstatus")) {
            FCPConnection fc = Main.doNodeHello();
            new LoadStatus(fc, true);
        } else if (args[0].toLowerCase().equals("makereport")) {
            FIWSystem.setts().makeReport();
            System.out.println("report saved as fiw-conf-report.log");
        } else if (args[0].toLowerCase().equals("guiinsfile")) {
            if (args.length == 5) {
                FCPConnection fc = Main.doNodeHello();
                new InsertEngine(fc, Integer.parseInt(args[1]), false, args[2], args[3], new File(args[4]), new InsertLoggerListener(new InsertDialog(false)));
            } else {
                System.out.println("Usage: fiw guiinsfile htl key mimetype filename.");
            }
        } else if (args[0].toLowerCase().equals("cliinsfile")) {
            CliInsert.cliInsertFile(args);
        } else if (args[0].toLowerCase().equals("dbrcalc")) {
            if (args.length == 4) {
                DBRcalc.calc(args[1], (long)Integer.parseInt(args[2], 16) * 86400L, (long)Integer.parseInt(args[3], 16) * 86400L);
            } else if (args.length == 2) {
                DBRcalc.calc(args[1], 86400L, 0L);
            } else {
                System.out.println("Usage: fiw DBRcalc yyyymmdd [incr offs]\nincr and offs are hex and in days.");
            }
        } else if (args[0].toLowerCase().equals("genkey")) {
            if (args.length == 2) {
                Main.doNodeHello();
                Main.makeNiceSSK(args[1]);
            } else {
                System.out.println("Usage: fiw GenKey regex\n       needs Java 1.4 or higher.");
            }
        } else if (args[0].toLowerCase().equals("clichecknims") || args[0].toLowerCase().equals("guichecknims")) {
            CliInsert.cliCheckNims(args);
        } else if (args.length == 2 && args[1].toLowerCase().equals("updatenim")) {
            try {
                int project = Integer.parseInt(args[0]) - 1;
                if (project < 0 || project >= FIWSystem.setts().getProjCount()) {
                    System.err.println("Incorrect project number");
                    return;
                }
                if (FIWSystem.setts().getProjectSettingDef(project, "nimprefix", "").length() == 0) {
                    System.out.println("project does not use NIMs.");
                    return;
                }
                int newnum = FIWSystem.setts().updateNimNumber(project);
                System.out.println("Updated NIM number from " + FIWSystem.setts().getProjectSettingDef(project, "nextnim", "1") + " to " + newnum);
                FIWSystem.setts().saveProject(project, "nextnim", "" + newnum);
            }
            catch (NumberFormatException e) {
                System.err.println("Not a number: " + e.getMessage());
            }
        } else if (args.length >= 3 && args.length <= 5 && (args[1].toLowerCase().equals("guiins") || args[1].toLowerCase().equals("cliins"))) {
            CliInsert.cliInsertProject(args);
        } else {
            System.out.println("Usage: \nfiw List          to list all the projects\nfiw <project> GuiIns <htl> [<edition>| <from> [<to>]]   to insert a project\n                  (HTL -1 for test inserts)\n                  default for <to> is <from>, for <from> is 1 \n                  (i.e. the next slot, 0 is the current slot)\nfiw <project> CliIns ...  the same w/o gui\nfiw <project> updatenim   update next free nim slot\nfiw guiinsfile/cliinsfile insert a file\nfiw guichecknims/clichecknims\n                          checks NIMs\nfiw cli                   start interactive CLI\nfiw dbrcalc               calculate DBR code\nfiw delete <key> ...      delete keys from local datastore\nfiw mdbrowser Try it (GUI)!\nfiw loadstatus Try it (GUI)!\nfiw genkey <regex>        creates 'nice' ssk pair\n                          (requires Java 1.4+)\nfiw language <locale>     Set language\nfiw help                  to show this text");
        }
    }

    public static FCPConnection doNodeHello() {
        System.out.println("Logging in:");
        FCPConnection result = FIWSystem.getInstance().createFCPConnection();
        String s = result.handshake();
        if (s == null) {
            System.err.println("could not connect to host");
            System.exit(1);
        }
        System.out.println(s + "\n");
        return result;
    }

    public static void makeNiceSSK(String regex) {
        try {
            Class<?> clazz = Class.forName("SSKNicer");
            Method meth = clazz.getMethod("makeNiceSSK", class$java$lang$String == null ? (class$java$lang$String = Main.class$("java.lang.String")) : class$java$lang$String);
            meth.invoke(null, (Object[])new String[]{regex});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

