//PROFILE-NO
unit WaitForThread;

// *****************************************************************************
// * Copyright 2003-2006 mxbee                                                 *
// *****************************************************************************
// * This program is free software; you can redistribute it and/or modify      *
// * it under the terms of the GNU General Public License as published by      *
// * the Free Software Foundation; either version 2 of the License, or         *
// * (at your option) any later version.                                       *
// *                                                                           *
// * This program is distributed in the hope that it will be useful,           *
// * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
// * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
// * GNU General Public License for more details.                              *
// *                                                                           *
// * You should have received a copy of the GNU General Public License         *
// * along with this program; if not, write to the Free Software               *
// * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
// *****************************************************************************

{$INCLUDE CompilerOpts.pas}

{
  Called with a suspended TFreenetThread.
  Resume thread and display status messages.
}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, FreenetUtils, ExtCtrls, BaseFormUnit;

type
  TFrmWaitForThread = class(TBaseForm)
    LbStatus3: TLabel;
    BtAbort: TButton;
    TimerTicker: TTimer;
    LbAbort: TLabel;
    LbStatus2: TLabel;
    Label4: TLabel;
    LbStatus1: TLabel;
    procedure TimerTickerTimer(Sender: TObject);
    procedure BtAbortClick(Sender: TObject);
  private
    FThread:   TFreenetThread;
    FOnStatus: TTextMsgEvent;
    FLogLevel: Integer;
    procedure StatusCallback(Sender: TObject; Msg: String; Level: Integer = LOGLVL_NORMAL);
  public
    function  LaunchAndWait(Thread: TFreenetThread): TModalResult;
  end;

var
  FrmWaitForThread: TFrmWaitForThread;

implementation

{$R *.dfm}

function TFrmWaitForThread.LaunchAndWait(Thread: TFreenetThread): TModalResult;
begin
  FThread := Thread;

  // hook threads OnStatus event
  FOnStatus := FThread.OnStatus;
  FThread.OnStatus := StatusCallback;

  // set log level to debug (we will display NORMAL on this form)
  FLogLevel := LOG_LEVEL;
  LOG_LEVEL := LOGLVL_DEBUG;

  // Enable ticker and resume thread
  TimerTicker.Enabled := True;
  Thread.Resume;

  Result := ShowModal;
end;

procedure TFrmWaitForThread.StatusCallback(Sender: TObject; Msg: String; Level: Integer);
begin
  // display message
  if Level >= LOGLVL_NORMAL then begin
    LbStatus3.Caption := LbStatus2.Caption;
    LbStatus2.Caption := LbStatus1.Caption;
    LbStatus1.Caption := Msg;
    if Showing then begin LbStatus1.Update; LbStatus2.Update; LbStatus3.Update; end;
  end;
  
  // call real message handler
  if Assigned(FOnStatus) and (Level >= FLogLevel) then FOnStatus(Sender, Msg, Level);
end;

procedure TFrmWaitForThread.TimerTickerTimer(Sender: TObject);
begin
  // check if thread is done
  if not FThread.Done then exit;
  TimerTicker.Enabled := False;
  FThread.WaitFor;
  LOG_LEVEL := FLogLevel;
  ModalResult := mrOk;
end;

procedure TFrmWaitForThread.BtAbortClick(Sender: TObject);
begin
  FThread.Unnecessary := True;
  FThread.TerminateSafely;
  BtAbort.Enabled := False;
  LbAbort.Visible := True;
end;

end.
