//PROFILE-NO
unit Settings;

// *****************************************************************************
// * Copyright 2003-2006 mxbee                                                 *
// *****************************************************************************
// * This program is free software; you can redistribute it and/or modify      *
// * it under the terms of the GNU General Public License as published by      *
// * the Free Software Foundation; either version 2 of the License, or         *
// * (at your option) any later version.                                       *
// *                                                                           *
// * This program is distributed in the hope that it will be useful,           *
// * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
// * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
// * GNU General Public License for more details.                              *
// *                                                                           *
// * You should have received a copy of the GNU General Public License         *
// * along with this program; if not, write to the Free Software               *
// * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
// *****************************************************************************

{$INCLUDE CompilerOpts.pas}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Spin, ComCtrls, CheckLst, ExtCtrls, Menus, BaseFormUnit,
  Buttons;

{$DEFINE SETTINGS_CHECKSUM_PERMANENT}

type
  TSettings = record
    // FCP
    FCPAddr:       Cardinal;
    FCPPort:       Word;
    // Insert
    InsThreads:    Integer;
    InsHTL:        Integer;
    InsUseHeadHTL: Boolean;
    InsHeadHTL:    Integer;
    InsRepHead:    Integer;
    InsSingleHead: Boolean;
    SkipLocal:     Boolean;
    MetaFirst:     Boolean;
    InsUseOrgFile: Boolean;
    InsTimeoutMin: Integer;
    InsFiniAnim:   Boolean;
    InsFiniSound:  Boolean;
    InsFiniWav:    String;
    // General
    LogToFile:     Boolean;
    LogKeys:       Boolean;
    LogGetKeys:    Boolean;
    MinToTray:     Boolean;
    TrayAnim:      Boolean;
    AutoActive:    Boolean;
    StartMini:     Boolean;
    ClearStats:    Boolean;
    ChkUpdate:     Boolean;
    ChkUpdateInt:  Integer;
    LogLevel:      Integer;
    ProcPrio:      Integer; // -2..+2
    // Download
    GetThreads:    Integer;
    GetHTL:        Integer;
    GetRetries:    Integer;
    GetHTLInc:     Integer;
    GetHealPerc:   Integer;
    GetHealHTL:    Integer;
    GetSkipLocal:  Boolean;
    VerifyCHK:     Boolean;
    GetGetAll:     Boolean;
    GetMultiDlg:   Boolean;
    GetSpread:     Boolean;
    GetMaxFiles:   Integer;
    GetRetMin:     Integer;
    GetTimeoutMin: Integer;
    GetFiniAnim:   Boolean;
    GetFiniSound:  Boolean;
    GetFiniWav:    String;
    GetPriorityTimeOut: Integer;
    GetPriorityToHighest: Integer;
    GetPriorityFromHighest: Integer;
    GetPriorityPercentage: Integer;
    GetPriorityBlocks: Integer; //Vanessa7
    GetMaxThreadsHighestPercentage: Integer;
    CheckDownloadLog: Boolean;
    StrictMaxThreadHighest: Boolean;
    MinimumOnTotalFinalized: Boolean; //Vanessa7
    GetPriorityStraightOn: Boolean;
    SessionFile: String;
    GetPriorityAutoOn: Boolean;
    SpiderEnabled: Boolean; //VanessasSpider
    SpiderMutex:   Boolean;
    GetPriorityDropTo: Integer; //Vanessa
    // Troubleshooting
    NoNativeCHK:   Boolean;
    NoNativeFEC:   Boolean;
    NoDeferredQueueSave: Boolean;
    // Clipboard formats
    ClipFmts:      String;
    // Settings warning
    NoSetWarnVer:  String; // <- VERSIONSTRING
    // Colors
    ClrNormal:     Array [1..4] of Integer;
    ClrFrozen:     Array [1..4] of Integer;
    ClrDone:       Array [1..4] of Integer;
    ClrError:      Array [1..4] of Integer;
    ClrEmpty:      Array [1..1] of Integer;
    // Groups
    Groups:        String;
    // --- Freenet 0.7 ---
    EnableFNOld:   Boolean;
    EnableFNNew:   Boolean;
    // FCP
    FCP2Addr:      Cardinal;
    FCP2Port:      Word;
    Dot7GlobalIns: Boolean;
    Dot7GlobalGet: Boolean;
    Dot7MaxIns:    Integer;
    Dot7MaxGet:    Integer;
    Dot7MaxGetAuto: Integer; //Vanessa7
    Dot7UseDisk:   Boolean;
    Dot7Compress:  Boolean;
  end;

  TClipFormatShort = record
    Description:  String;
    FormatString: String;
    Enabled:      Boolean;
  end;
  PClipFormatShort = ^TClipFormatShort;

  TGroupEntry = record
    ID:        Integer;
    GroupName: String;
    Ins,Get:   Boolean;
    Folder:    String;
  end;
  PGroupEntry = ^TGroupEntry;

const
  // Group constants
  GROUP_ALLFILES = $7FFFFFFF; // combo box has problems with negative numbers
  GROUP_NOGROUP  = 0;

type
  TFrmSettings = class(TBaseForm)
    PageControl: TPageControl;
    TsGeneral: TTabSheet;
    GroupBoxGeneral: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    EdFCPAddress: TEdit;
    EdFCPPort: TEdit;
    GroupBoxIns: TGroupBox;
    Label3: TLabel;
    Label4: TLabel;
    EdInsThreads: TSpinEdit;
    EdInsHTL: TSpinEdit;
    CbSkipLocal: TCheckBox;
    CbMetaFirst: TCheckBox;
    CbInsUseOrgFile: TCheckBox;
    GroupBoxGet: TGroupBox;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    LbGetRetMin2: TLabel;
    LbGetRetMin1: TLabel;
    EdGetThreads: TSpinEdit;
    EdGetHTL: TSpinEdit;
    EdGetRetries: TSpinEdit;
    EdGetHTLInc: TSpinEdit;
    EdGetHealPerc: TSpinEdit;
    EdGetHealHTL: TSpinEdit;
    CbGetSkipLocal: TCheckBox;
    CbVerifyCHK: TCheckBox;
    CbGetGetAll: TCheckBox;
    CbGetSpread: TCheckBox;
    EdGetRetMin: TSpinEdit;
    TsClipboard: TTabSheet;
    Label12: TLabel;
    BtClipFmtAdd: TButton;
    BtClipFmtUp: TButton;
    BtClipFmtDown: TButton;
    PanelClipFmt: TPanel;
    LbClipFmtDescription: TLabel;
    EdClipFmtDescription: TEdit;
    LbClipFmtFormat: TLabel;
    EdClipFmtFormat: TEdit;
    CbClipFmtEnabled: TCheckBox;
    BtClipFmtDel: TButton;
    LbxClipFormats: TListBox;
    BtClipFmtTest: TButton;
    Label13: TLabel;
    PopupClipFormats: TPopupMenu;
    URIwithfreenetprefix1: TMenuItem;
    URIwithoutprefix1: TMenuItem;
    Keywithoutdocumentname1: TMenuItem;
    Keyparts1: TMenuItem;
    Documentname1: TMenuItem;
    Routingkey1: TMenuItem;
    Cryptokey1: TMenuItem;
    Metainfo1: TMenuItem;
    Metastrings1: TMenuItem;
    Plaintext1: TMenuItem;
    N1: TMenuItem;
    Examples1: TMenuItem;
    N2: TMenuItem;
    Askuserfortext1: TMenuItem;
    Askuseryesno1: TMenuItem;
    Copykeyswithfilenames1: TMenuItem;
    Copykeysonly1: TMenuItem;
    Copyextendedinfo1: TMenuItem;
    CopyasFrostattachment1: TMenuItem;
    CopyasHTMLtag1: TMenuItem;
    RichEdClipFmtQuickHelp: TRichEdit;
    Panel1: TPanel;
    BtOk: TButton;
    BtSave: TButton;
    BtReset: TButton;
    BtCancel: TButton;
    TsTrouble: TTabSheet;
    Label14: TLabel;
    CbNoNativeCHK: TCheckBox;
    CbNoNativeFEC: TCheckBox;
    LbGetMaxFiles: TLabel;
    EdGetMaxFiles: TSpinEdit;
    LbGetMaxFiles2: TLabel;
    CbLogToFile: TCheckBox;
    LbLogFile: TLabel;
    CbLogKeys: TCheckBox;
    LbInsLog: TLabel;
    EdChkUpdate: TSpinEdit;
    LbChkUpdate: TLabel;
    CbChkUpdate: TCheckBox;
    Label16: TLabel;
    ComboLogLevel: TComboBox;
    CbNoSetWarn: TCheckBox;
    CbInsHeadHTL: TCheckBox;
    EdInsHeadHTL: TSpinEdit;
    Label15: TLabel;
    EdInsRepHead: TSpinEdit;
    Label17: TLabel;
    CbInsSingleHead: TCheckBox;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    Label21: TLabel;
    EdInsTimeout: TSpinEdit;
    EdGetTimeout: TSpinEdit;
    TsMisc: TTabSheet;
    OpenDialogWav: TOpenDialog;
    CbLogGetKeys: TCheckBox;
    LbGetLog: TLabel;
    GroupBox1: TGroupBox;
    CbAutoActive: TCheckBox;
    CbStartMini: TCheckBox;
    CbClearStats: TCheckBox;
    GroupBox2: TGroupBox;
    CbInsFiniAnim: TCheckBox;
    CbInsFiniSound: TCheckBox;
    EdInsFiniWav: TEdit;
    BtBrowseInsFiniWav: TButton;
    BtTestInsFiniWav: TButton;
    GroupBox3: TGroupBox;
    CbGetFiniAnim: TCheckBox;
    CbGetFiniSound: TCheckBox;
    EdGetFiniWav: TEdit;
    BtBrowseGetFiniWav: TButton;
    BtTestGetFiniWav: TButton;
    GroupBox4: TGroupBox;
    CbMinToTray: TCheckBox;
    CbTrayAnim: TCheckBox;
    GbQueueColors: TGroupBox;
    Label22: TLabel;
    LbClrNormal_1: TLabel;
    LbClrNormal_2: TLabel;
    Label23: TLabel;
    LbClrFrozen_1: TLabel;
    LbClrFrozen_2: TLabel;
    Label26: TLabel;
    LbClrDone_1: TLabel;
    LbClrDone_2: TLabel;
    Label29: TLabel;
    LbClrError_1: TLabel;
    LbClrError_2: TLabel;
    BtClrDefault_Normal: TButton;
    ColorDialog: TColorDialog;
    BtClrDefault_Frozen: TButton;
    BtClrDefault_Done: TButton;
    BtClrDefault_Error: TButton;
    Label24: TLabel;
    Label25: TLabel;
    LbClrEmpty_1: TLabel;
    BtClrDefault_Empty: TButton;
    BtResetSplitter: TButton;
    TsAdvanced: TTabSheet;
    GroupBoxAdvancedIns: TGroupBox;
    GroupBoxAdvancedGet: TGroupBox;
    GroupBoxLogging: TGroupBox;
    Label11: TLabel;
    ComboProcPrio: TComboBox;
    GbPrioritySettings: TGroupBox;
    Label11a: TLabel;
    Label30: TLabel;
    Label34: TLabel;
    Label35: TLabel;
    CbCheckDownloadLog: TCheckBox;
    EdGetMaxThreadsHighestPercentage: TSpinEdit;
    EdGetPriorityPercentage: TSpinEdit;
    EdGetPriorityFromHighest: TSpinEdit;
    EdGetPriorityToHighest: TSpinEdit;
    CbStrictMaxThreadHighest: TCheckBox;
    Label33: TLabel;
    Label32: TLabel;
    Label31: TLabel;
    EdGetPriorityTimeOut: TSpinEdit;
    Label27: TLabel;
    OpenDialogSessionFile: TOpenDialog;
    Label38: TLabel;
    PanelGetPriorityToHighest: TPanel;
    RbGetPriorityStraightOn: TRadioButton;
    RbGetPriorityToHighest: TRadioButton;
    CbGetPriorityAutoOn: TCheckBox;
    GbSpiderManagement: TGroupBox;
    CboGetPriorityTo: TComboBox;
    Label41: TLabel;
    CbSpiderEnabled: TCheckBox;
    CbNoDeferredQueueSaving: TCheckBox;
    CbGetMultiDlg: TCheckBox;
    CbSpiderMutex: TCheckBox;
    TsGroups: TTabSheet;
    LbGroupsInfo1: TLabel;
    LvGroups: TListView;
    BtGroupsMoveTop: TBitBtn;
    BtGroupsMoveUp: TBitBtn;
    BtGroupsMoveDown: TBitBtn;
    BtGroupsMoveBtm: TBitBtn;
    GbGroupsEdit: TGroupBox;
    LbGroupName: TLabel;
    EdGroupName: TEdit;
    LbGroupValidFor: TLabel;
    CbGroupIns: TCheckBox;
    CbGroupGet: TCheckBox;
    Label28: TLabel;
    EdGroupFolder: TEdit;
    BtGroupBrowseFolder: TButton;
    BtGroupAdd: TButton;
    BtGroupReplace: TButton;
    BtGroupClear: TButton;
    LbGroupsInfo2: TLabel;
    BtGroupDelete: TButton;
    OpenDialogGroups: TOpenDialog;
    PopupGroups: TPopupMenu;
    Edit1: TMenuItem;
    Delete1: TMenuItem;
    N3: TMenuItem;
    MiGroupsMoveTop: TMenuItem;
    MiGroupsMoveUp: TMenuItem;
    MiGroupsMoveDown: TMenuItem;
    MiGroupsMoveBtm: TMenuItem;
    TsFreenetDot7: TTabSheet;
    CbEnableFNNew: TCheckBox;
    Label28a: TLabel;
    EdFCP2Address: TEdit;
    Label36: TLabel;
    EdFCP2Port: TEdit;
    CbEnableFNOld: TCheckBox;
    CbDot7GlobalIns: TCheckBox;
    CbDot7GlobalGet: TCheckBox;
    Label37: TLabel;
    Label39: TLabel;
    Label40: TLabel;
    Label42: TLabel;
    Label43: TLabel;
    Label46: TLabel;
    Label47: TLabel;
    EdDot7MaxIns: TSpinEdit;
    Label48: TLabel;
    Label49: TLabel;
    EdDot7MaxGet: TSpinEdit;
    Label50: TLabel;
    CbDot7UseDisk: TCheckBox;
    CbDot7Compress: TCheckBox;
    Label44: TLabel;
    EdGetPriorityBlocks: TSpinEdit;
    Label45: TLabel;
    CbMinimumOnTotalFinalized: TCheckBox;
    Label51: TLabel;
    EdDot7MaxGetAuto: TSpinEdit;
    Label52: TLabel;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BtOkClick(Sender: TObject);
    procedure BtResetClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure LbxClipFormatsClick(Sender: TObject);
    procedure ClipFmtChanged(Sender: TObject);
    procedure BtClipFmtAddClick(Sender: TObject);
    procedure BtClipFmtDelClick(Sender: TObject);
    procedure BtClipFmtMoveClick(Sender: TObject);
    procedure BtClipFmtTestClick(Sender: TObject);
    procedure ClipFmtTemplateClick(Sender: TObject);
    procedure CbGetSpreadClick(Sender: TObject);
    procedure CbChkUpdateClick(Sender: TObject);
    procedure CbInsHeadHTLClick(Sender: TObject);
    procedure BtBrowseFinishedWavClick(Sender: TObject);
    procedure BtTestFinishedWavClick(Sender: TObject);
    procedure BtClrDefaultClick(Sender: TObject);
    procedure LbClrMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure BtResetSplitterClick(Sender: TObject);
    procedure RbGetPriorityHighestClick(Sender: TObject);
    procedure BtGroupAddReplaceClick(Sender: TObject);
    procedure BtGroupDeleteClick(Sender: TObject);
    procedure BtGroupClearClick(Sender: TObject);
    procedure BtGroupBrowseFolderClick(Sender: TObject);
    procedure LvGroupsDblClick(Sender: TObject);
    procedure BtGroupsMoveClick(Sender: TObject);
  private
    FInitingClip:  Boolean;
    procedure ClearClipFormats;
    function  SetClipFmtListItem(Index: Integer; pClip: PClipFormatShort): Integer;
    procedure ClearGroups;
    procedure SetGroupListItem(item: TListItem);
    procedure InitFromSettings(Settings: TSettings; InitClipFormats,InitGroups: Boolean);
    procedure SetAnchors;
    function  ColorLabel(Prefix: String; Index: Integer): TLabel;
    function  GetQueueColor(AName: String; Index: Integer): TColor; 
    procedure SetQueueColor(AName: String; Index: Integer; AColor: TColor); 
  public
    { Public declarations }
  end;

var
  GlobalSettings: TSettings;
  LOGFILENAME,
  KEYFILENAME,
  GETKEYFILENAME: String;
  SPIDERREQUESTSBASEFILENAME: String; //VanessasSpider
  SPIDERRESPONSEFILENAME: String; //VanessasSpider

procedure ClipFormats_StringToList(FmtString: String; FmtList: TList);
function  ClipFormats_ListToString(FmtList: TList): String;
procedure ClipFormats_ClearList(FmtList: TList);
procedure ClipFormats_FreeList(FmtList: TList);
function  GroupListToString(GList: TList): String;
procedure StringToGroupList(S: String; GList: TList);
procedure ClearGroupList(GList: TList; FreeList: Boolean);
function  FindGroupByID(GList: TList; ID: Integer): PGroupEntry;
function  GetGroupName(GList: TList; ID: Integer): String;

function  CheckSettings: Boolean;

implementation

uses IniFiles,Winsock, Misc, ClipboardFormats, FreenetUtils, Clipbrd, MMSystem, Main;

{$R *.DFM}

const
  DefaultSettings: TSettings = (
    FCPAddr:       INADDR_LOOPBACK; // 127.0.0.1
    FCPPort:       8481;
    InsThreads:    10;
    InsHTL:        25;
    InsUseHeadHTL: False;
    InsHeadHTL:    25;
    InsRepHead:    2;
    InsSingleHead: True;
    SkipLocal:     True;
    MetaFirst:     False;
    InsUseOrgFile: True;
    InsTimeoutMin: 75;
    InsFiniAnim:   False;
    InsFiniSound:  False;
    InsFiniWav:    '';
    LogToFile:     False;
    LogKeys:       True;
    LogGetKeys:    False;
    MinToTray:     False;
    TrayAnim:      True;
    AutoActive:    False;
    StartMini:     False;
    ClearStats:    False;
    ChkUpdate:     False;
    ChkUpdateInt:  24;
    LogLevel:      LOGLVL_NORMAL;
    ProcPrio:      0;
    GetThreads:    10;
    GetHTL:        15;
    GetRetries:    4;
    GetHTLInc:     5;
    GetHealPerc:   5;
    GetHealHTL:    5;
    GetSkipLocal:  False;
    VerifyCHK:     True;
    GetGetAll:     True;
    GetMultiDlg:   False;
    GetSpread:     False;
    GetMaxFiles:   5;
    GetRetMin:     10;
    GetTimeoutMin: 45;
    GetFiniAnim:   False;
    GetFiniSound:  False;
    GetFiniWav:    '';
    GetPriorityTimeOut: 4; //Vanessa7
    GetPriorityToHighest: 5; //Vanessa7
    GetPriorityFromHighest: 2; //Vanessa7
    GetPriorityPercentage: 80; //Vanessa7
    GetPriorityBlocks: 2; //Vanessa7
    GetMaxThreadsHighestPercentage: 50;
    CheckDownloadLog: False;
    StrictMaxThreadHighest: False;
    MinimumOnTotalFinalized: False; //Vanessa7
    GetPriorityStraightOn: True;
    SessionFile:    '';
    GetPriorityAutoOn:   True; //Vanessa7
    SpiderEnabled: False; //VanessasSpider
    SpiderMutex:   False;
    GetPriorityDropTo: 1; //Vanessa (mxbee:default changed to 1(low))
    NoNativeCHK:         False;
    NoNativeFEC:         False;
    NoDeferredQueueSave: False;
    NoSetWarnVer:  '';
    ClrNormal:     (clWhite, $DDFFFF, clWindowText, clWindowText);
    ClrFrozen:     ($FFFCD2, $FFF9B7, clWindowText, clWindowText);
    ClrDone:       ($CAFFCA, $AEFFAE, clWindowText, clWindowText);
    ClrError:      ($CECEFF, $C1C1FF, clWindowText, clWindowText);
    ClrEmpty:      (clWindow);
    Groups:        '';
    // --- Freenet 0.7 ---
    EnableFNOld:   False;
    EnableFNNew:   True;
    FCP2Addr:      INADDR_LOOPBACK; // 127.0.0.1
    FCP2Port:      9481;
    Dot7GlobalIns: False;
    Dot7GlobalGet: False;
    Dot7MaxIns:    2;
    Dot7MaxGet:    10;
    Dot7MaxGetAuto: 1; //Vanessa7
    Dot7UseDisk:   True;
    Dot7Compress:  False;
  );

procedure ClipFormats_StringToList(FmtString: String; FmtList: TList);
var
  s,sFmt: String;
  i:      Integer;
  pClip: PClipFormatShort;
begin
  FmtList.Clear;
  s := FmtString;
  while s <> '' do begin
    i := Pos(#13,s);
    if i = 0 then begin
      sFmt := s; s := ''
    end else begin
      sFmt := Copy(s,1,i-1); Delete(s,1,i);
    end;
    New(pClip);
    i := Pos(#9,sFmt); pClip^.Description  := Copy(sFmt,1,i-1); Delete(sFmt,1,i);
    i := Pos(#9,sFmt); pClip^.FormatString := Copy(sFmt,1,i-1); Delete(sFmt,1,i);
    pClip^.Enabled := (Copy(sFmt,1,1) = 'Y');
    FmtList.Add(pClip);
  end;
end;

function  ClipFormats_ListToString(FmtList: TList): String;
var
  i:     Integer;
  pClip: PClipFormatShort;
begin
  Result := '';
  for i := 0 to FmtList.Count-1 do begin
    pClip := FmtList.Items[i];
    if i > 0 then Result := Result + #13;
    while Pos(#9, pClip^.Description ) <> 0 do pClip^.Description [Pos(#9, pClip^.Description )] := ' ';
    while Pos(#9, pClip^.FormatString) <> 0 do pClip^.FormatString[Pos(#9, pClip^.FormatString)] := ' ';
    Result := Result + pClip^.Description + #9 + pClip^.FormatString + #9;
    if pClip^.Enabled then Result := Result + 'Y' else Result := Result + 'N';
  end;
end;

procedure ClipFormats_ClearList(FmtList: TList);
var pClip: PClipFormatShort;
begin
  if FmtList = nil then exit;
  while FmtList.Count > 0 do begin
    pClip := FmtList.Items[0];
    FmtList.Delete(0);
    Dispose(pClip);
  end;
end;

procedure ClipFormats_FreeList(FmtList: TList);
begin
  ClipFormats_ClearList(FmtList);
  FmtList.Free;
end;

procedure ClearGroupList(GList: TList; FreeList: Boolean);
var i: Integer;
begin
  if Assigned(GList) then begin
    for i := 0 to GList.Count-1 do Dispose(GList.Items[i]);
    GList.Clear;
    if FreeList then GList.Free;
  end;
end;

function  GroupEntryToString(pg: PGroupEntry): String;
const SPECIAL = '{},';
var   sIG: String;
begin
  // {ID,IG,Name,Folder}
  sIG := ''; if pg^.Ins then sIG := sIG + 'I'; if pg^.Get then sIG := sIG + 'G';
  Result := '{'
          + IntToStr(pg^.ID) + ','
          + sIG + ','
          + EncodeString(pg^.GroupName, SPECIAL) + ','
          + EncodeString(pg^.Folder, SPECIAL)
          + '}'
          ;
end;

function  StringToGroupEntry(S: String): TGroupEntry;
  procedure Err; begin raise Exception.Create('Invalid group entry string'); end;
var
  i:   Integer;
  sIG: String;
begin
  if (Copy(S,1,1) <> '{') or (Copy(S,Length(S),1) <> '}') then Err;
  S := Copy(S,2,Length(S)-2);

  i := Pos(',',S); if i = 0 then Err;
  Result.ID := StrToInt(Copy(S,1,i-1)); Delete(S,1,i);
  i := Pos(',',S); if i = 0 then Err;
  sIG := Copy(S,1,i-1); Delete(S,1,i);
  Result.Ins := ( Pos('I',sIG) <> 0 );
  Result.Get := ( Pos('G',sIG) <> 0 );
  i := Pos(',',S); if i = 0 then Err;
  Result.GroupName := DecodeString(Copy(S,1,i-1)); Delete(S,1,i);
  Result.Folder    := DecodeString(S);
end;

function  GroupListToString(GList: TList): String;
var
  i:  Integer;
  pG: PGroupEntry;
begin
  // {entry1}{entry2}...
  Result := '';
  for i := 0 to GList.Count-1 do begin
    pG := GList.Items[i];
    Result := Result + GroupEntryToString(pG);
  end;
end;

procedure StringToGroupList(S: String; GList: TList);
var
  i: Integer;
  g: TGroupEntry;
  p: PGroupEntry;
begin
  ClearGroupList(GList, False);
  repeat
    i := Pos('}',S);
    if i <> 0 then begin
      g := StringToGroupEntry(Copy(S,1,i)); Delete(S,1,i);
      New(p); p^ := g; GList.Add(p);
    end;
  until i = 0;
end;

function  FindGroupByID(GList: TList; ID: Integer): PGroupEntry;
var i: Integer;
begin
  for i := 0 to GList.Count-1 do begin
    Result := GList.Items[i];
    if Result^.ID = ID then exit;
  end;
  Result := nil;
end;

function  GetGroupName(GList: TList; ID: Integer): String;
var p: PGroupEntry;
begin
  if ID = 0 then
    Result := '(no group)'
  else begin
    p := FindGroupByID(GList, ID);
    if Assigned(p) then Result := p^.GroupName else Result := '(invalid group)';
  end;
end;

procedure SaveSettings(Settings: TSettings);
var
  ini: TSafeSaveMemIniFile;
  ClipList: TList;
  i:        Integer;
  pClip:    PClipFormatShort;
  s:        String;
  bRetry:   Boolean;
  GroupList: TList;
  pGroup:    PGroupEntry;
begin
  ClipList := nil; GroupList := nil;
  ini := nil;
  repeat
    bRetry := False;
    if not FrmMain.LockTicker then begin
      bRetry := (mrYes = MessageDlg('Cannot save settings - failed to lock ticker. Retry?', mtWarning, [mbYes,mbNo], 0));
      if not bRetry then raise Exception.Create('Failed to save settings');
    end;
  until not bRetry;
  try
    ini := TSafeSaveMemIniFile.Create(ChangeFileExt(Application.ExeName, '.ini'));
    ini.EraseSection('Settings');
    ini.WriteInteger('Settings', 'FCPIP',         Settings.FCPAddr);
    ini.WriteInteger('Settings', 'FCPPort',       Settings.FCPPort);
    ini.WriteInteger('Settings', 'InsThreads',    Settings.InsThreads);
    ini.WriteInteger('Settings', 'InsHTL',        Settings.InsHTL);
    ini.WriteBool   ('Settings', 'InsUseHeadHTL', Settings.InsUseHeadHTL);
    ini.WriteInteger('Settings', 'InsHeadHTL',    Settings.InsHeadHTL);
    ini.WriteInteger('Settings', 'InsRepHead',    Settings.InsRepHead);
    ini.WriteBool   ('Settings', 'InsSingleHead', Settings.InsSingleHead);
    ini.WriteBool   ('Settings', 'SkipLocal',     Settings.SkipLocal);
    ini.WriteBool   ('Settings', 'MetaFirst',     Settings.MetaFirst);
    ini.WriteBool   ('Settings', 'InsUseOrgFile', Settings.InsUseOrgFile);
    ini.WriteInteger('Settings', 'InsTimeoutMin', Settings.InsTimeoutMin);
    ini.WriteBool   ('Settings', 'InsFiniAnim',   Settings.InsFiniAnim);
    ini.WriteBool   ('Settings', 'InsFiniSound',  Settings.InsFiniSound);
    ini.WriteString ('Settings', 'InsFiniWav',    Settings.InsFiniWav);
    ini.WriteBool   ('Settings', 'LogToFile',     Settings.LogToFile);
    ini.WriteBool   ('Settings', 'LogKeys',       Settings.LogKeys);
    ini.WriteBool   ('Settings', 'LogGetKeys',    Settings.LogGetKeys);
    ini.WriteBool   ('Settings', 'MinToTray',     Settings.MinToTray);
    ini.WriteBool   ('Settings', 'TrayAnim',      Settings.TrayAnim);
    ini.WriteBool   ('Settings', 'AutoActive',    Settings.AutoActive);
    ini.WriteBool   ('Settings', 'StartMini',     Settings.StartMini);
    ini.WriteBool   ('Settings', 'ClearStats',    Settings.ClearStats);
    ini.WriteBool   ('Settings', 'ChkUpdate',     Settings.ChkUpdate);
    ini.WriteInteger('Settings', 'ChkUpdateInt',  Settings.ChkUpdateInt);
    ini.WriteInteger('Settings', 'LogLevel',      Settings.LogLevel);
    ini.WriteInteger('Settings', 'ProcPrio',      Settings.ProcPrio);
    ini.WriteInteger('Settings', 'GetThreads',    Settings.GetThreads);
    ini.WriteInteger('Settings', 'GetHTL',        Settings.GetHTL);
    ini.WriteInteger('Settings', 'GetRetries',    Settings.GetRetries);
    ini.WriteInteger('Settings', 'GetHTLInc',     Settings.GetHTLInc);
    ini.WriteInteger('Settings', 'GetHealPerc',   Settings.GetHealPerc);
    ini.WriteInteger('Settings', 'GetHealHTL',    Settings.GetHealHTL);
    ini.WriteBool   ('Settings', 'GetSkipLocal',  Settings.GetSkipLocal);
    ini.WriteBool   ('Settings', 'VerifyCHK',     Settings.VerifyCHK);
    ini.WriteBool   ('Settings', 'GetGetAll',     Settings.GetGetAll);
    ini.WriteBool   ('Settings', 'GetMultiDlg',   Settings.GetMultiDlg);
    ini.WriteBool   ('Settings', 'GetSpread',     Settings.GetSpread);
    ini.WriteInteger('Settings', 'GetMaxFiles',   Settings.GetMaxFiles);
    ini.WriteInteger('Settings', 'GetRetMin',     Settings.GetRetMin);
    ini.WriteInteger('Settings', 'GetTimeoutMin', Settings.GetTimeoutMin);
    ini.WriteInteger('Settings', 'GetPriorityTimeOut',             Settings.GetPriorityTimeOut);
    ini.WriteInteger('Settings', 'GetPriorityToHighest',           Settings.GetPriorityToHighest);
    ini.WriteInteger('Settings', 'GetPriorityFromHighest',         Settings.GetPriorityFromHighest);
    ini.WriteInteger('Settings', 'GetPriorityPercentage',          Settings.GetPriorityPercentage);
    ini.WriteInteger('Settings', 'GetPriorityBlocks',              Settings.GetPriorityBlocks); //Vanessa7
    ini.WriteInteger('Settings', 'GetMaxThreadsHighestPercentage', Settings.GetMaxThreadsHighestPercentage);
    ini.WriteBool   ('Settings', 'CheckDownloadLog',               Settings.CheckDownloadLog);
    ini.WriteBool   ('Settings', 'StrictMaxThreadHighest',         Settings.StrictMaxThreadHighest);
    ini.WriteBool   ('Settings', 'MinimumOnTotalFinalized',        Settings.MinimumOnTotalFinalized); //Vanessa7
    ini.WriteBool   ('Settings', 'GetPriorityStraightOn',          Settings.GetPriorityStraightOn);
    ini.WriteString ('Settings', 'SessionFile',                    Settings.SessionFile);
    ini.WriteBool   ('Settings', 'GetPriorityAutoOn',              Settings.GetPriorityAutoOn);
    ini.WriteBool   ('Settings', 'SpiderEnabled',                  Settings.SpiderEnabled); //VanessasSpider
    ini.WriteBool   ('Settings', 'SpiderMutex',                    Settings.SpiderMutex);
    ini.WriteInteger('Settings', 'GetPriorityDropTo',              Settings.GetPriorityDropTo); //Vanessa
    ini.WriteBool   ('Settings', 'GetFiniAnim',   Settings.GetFiniAnim);
    ini.WriteBool   ('Settings', 'GetFiniSound',  Settings.GetFiniSound);
    ini.WriteString ('Settings', 'GetFiniWav',    Settings.GetFiniWav);
    ini.WriteBool   ('Settings', 'NoNativeCHK',   Settings.NoNativeCHK);
    ini.WriteBool   ('Settings', 'NoNativeFEC',   Settings.NoNativeFEC);
    ini.WriteBool   ('Settings', 'NoDeferredQS',  Settings.NoDeferredQueueSave);
    ini.WriteString ('Settings', 'NoSetWarnVer',  Settings.NoSetWarnVer);
    for i := Low(Settings.ClrNormal) to High(Settings.ClrNormal) do ini.WriteInteger('Settings', 'ClrNormal_' + IntToStr(i), Settings.ClrNormal[i]);
    for i := Low(Settings.ClrFrozen) to High(Settings.ClrFrozen) do ini.WriteInteger('Settings', 'ClrFrozen_' + IntToStr(i), Settings.ClrFrozen[i]);
    for i := Low(Settings.ClrDone  ) to High(Settings.ClrDone  ) do ini.WriteInteger('Settings', 'ClrDone_'   + IntToStr(i), Settings.ClrDone[i]);
    for i := Low(Settings.ClrError ) to High(Settings.ClrError ) do ini.WriteInteger('Settings', 'ClrError_'  + IntToStr(i), Settings.ClrError[i]);
    for i := Low(Settings.ClrEmpty ) to High(Settings.ClrEmpty ) do ini.WriteInteger('Settings', 'ClrEmpty_'  + IntToStr(i), Settings.ClrEmpty[i]);
    // --- Freenet 0.7 ---
    ini.WriteBool   ('Settings', 'EnableFNOld',   Settings.EnableFNOld);
    ini.WriteBool   ('Settings', 'EnableFNNew',   Settings.EnableFNNew);
    ini.WriteInteger('Settings', 'FCP2IP',        Settings.FCP2Addr);
    ini.WriteInteger('Settings', 'FCP2Port',      Settings.FCP2Port);
    ini.WriteBool   ('Settings', 'Dot7GlobalIns', Settings.Dot7GlobalIns);
    ini.WriteBool   ('Settings', 'Dot7GlobalGet', Settings.Dot7GlobalGet);
    ini.WriteInteger('Settings', 'Dot7MaxIns',    Settings.Dot7MaxIns);
    ini.WriteInteger('Settings', 'Dot7MaxGet',    Settings.Dot7MaxGet);
    ini.WriteInteger('Settings', 'Dot7MaxGetAuto', Settings.Dot7MaxGetAuto); //Vanessa7
    ini.WriteBool   ('Settings', 'Dot7UseDisk',   Settings.Dot7UseDisk);
    ini.WriteBool   ('Settings', 'Dot7Compress',  Settings.Dot7Compress);

    ClipList := TList.Create;
    ClipFormats_StringToList(Settings.ClipFmts, ClipList);
    ini.WriteInteger('ClipFormats', 'Count',     ClipList.Count);
    for i := 0 to ClipList.Count-1 do begin
      s := '_' + IntToStr(i+1);
      pClip := ClipList.Items[i];
      ini.WriteString('ClipFormats', 'Name'+s,    pClip^.Description);
      ini.WriteString('ClipFormats', 'Format'+s,  pClip^.FormatString);
      ini.WriteBool  ('ClipFormats', 'Enabled'+s, pClip^.Enabled);
    end;

    GroupList := TList.Create;
    StringToGroupList(Settings.Groups, GroupList);
    ini.WriteInteger('Groups', 'Count', GroupList.Count);
    for i := 0 to GroupList.Count-1 do begin
      s := '_' + IntToStr(i+1);
      pGroup := GroupList.Items[i];
      ini.WriteInteger('Groups', 'ID'+s,      pGroup^.ID);
      ini.WriteString ('Groups', 'Name'+s,    pGroup^.GroupName);
      ini.WriteBool   ('Groups', 'Ins'+s,     pGroup^.Ins);
      ini.WriteBool   ('Groups', 'Get'+s,     pGroup^.Get);
      ini.WriteString ('Groups', 'Folder'+s,  pGroup^.Folder);
    end;

    ini.UpdateFile;
  finally
    FrmMain.UnLockTicker;
    ini.Free;
    ClipFormats_FreeList(ClipList);
    ClearGroupList(GroupList, True);
  end;
end;

procedure LoadSettings(var Settings: TSettings);
var
  ini:   TSafeSaveMemIniFile;
  i,cnt: Integer;
  pClip: PClipFormatShort;
  ClipList: TList;
  s:        String;
  pGroup:    PGroupEntry;
  GroupList: TList;
begin
  // not necessary to lock ticker here as long as we only call it from initialization
  ClipList := nil; GroupList := nil;
  ini := TSafeSaveMemIniFile.Create(ChangeFileExt(Application.ExeName, '.ini'));
  try
    Settings.FCPAddr        := ini.ReadInteger('Settings', 'FCPIP',          Settings.FCPAddr);
    Settings.FCPPort        := ini.ReadInteger('Settings', 'FCPPort',        Settings.FCPPort);
    Settings.InsThreads     := ini.ReadInteger('Settings', 'InsThreads',     Settings.InsThreads);
    Settings.InsHTL         := ini.ReadInteger('Settings', 'InsHTL',         Settings.InsHTL);
    Settings.InsUseHeadHTL  := ini.ReadBool   ('Settings', 'InsUseHeadHTL',  Settings.InsUseHeadHTL);
    Settings.InsHeadHTL     := ini.ReadInteger('Settings', 'InsHeadHTL',     Settings.InsHeadHTL);
    Settings.InsRepHead     := ini.ReadInteger('Settings', 'InsRepHead',     Settings.InsRepHead);
    Settings.InsSingleHead  := ini.ReadBool   ('Settings', 'InsSingleHead',  Settings.InsSingleHead);
    Settings.SkipLocal      := ini.ReadBool   ('Settings', 'SkipLocal',      Settings.SkipLocal);
    Settings.MetaFirst      := ini.ReadBool   ('Settings', 'MetaFirst',      Settings.MetaFirst);
    Settings.InsUseOrgFile  := ini.ReadBool   ('Settings', 'InsUseOrgFile',  Settings.InsUseOrgFile);
    Settings.InsTimeoutMin  := ini.ReadInteger('Settings', 'InsTimeoutMin',  Settings.InsTimeoutMin);
    Settings.InsFiniAnim    := ini.ReadBool   ('Settings', 'InsFiniAnim',    Settings.InsFiniAnim);
    Settings.InsFiniSound   := ini.ReadBool   ('Settings', 'InsFiniSound',   Settings.InsFiniSound);
    Settings.InsFiniWav     := ini.ReadString ('Settings', 'InsFiniWav',     Settings.InsFiniWav);
    Settings.LogToFile      := ini.ReadBool   ('Settings', 'LogToFile',      Settings.LogToFile);
    Settings.LogKeys        := ini.ReadBool   ('Settings', 'LogKeys',        Settings.LogKeys);
    Settings.LogGetKeys     := ini.ReadBool   ('Settings', 'LogGetKeys',     Settings.LogGetKeys);
    Settings.MinToTray      := ini.ReadBool   ('Settings', 'MinToTray',      Settings.MinToTray);
    Settings.TrayAnim       := ini.ReadBool   ('Settings', 'TrayAnim',       Settings.TrayAnim);
    Settings.AutoActive     := ini.ReadBool   ('Settings', 'AutoActive',     Settings.AutoActive);
    Settings.StartMini      := ini.ReadBool   ('Settings', 'StartMini',      Settings.StartMini);
    Settings.ClearStats     := ini.ReadBool   ('Settings', 'ClearStats',     Settings.ClearStats);
    Settings.ChkUpdate      := ini.ReadBool   ('Settings', 'ChkUpdate',      Settings.ChkUpdate);
    Settings.ChkUpdateInt   := ini.ReadInteger('Settings', 'ChkUpdateInt',   Settings.ChkUpdateInt);
    Settings.LogLevel       := ini.ReadInteger('Settings', 'LogLevel',       Settings.LogLevel);
    Settings.ProcPrio       := ini.ReadInteger('Settings', 'ProcPrio',       Settings.ProcPrio);
    Settings.GetThreads     := ini.ReadInteger('Settings', 'GetThreads',     Settings.GetThreads);
    Settings.GetHTL         := ini.ReadInteger('Settings', 'GetHTL',         Settings.GetHTL);
    Settings.GetRetries     := ini.ReadInteger('Settings', 'GetRetries',     Settings.GetRetries);
    Settings.GetHTLInc      := ini.ReadInteger('Settings', 'GetHTLInc',      Settings.GetHTLInc);
    Settings.GetHealPerc    := ini.ReadInteger('Settings', 'GetHealPerc',    Settings.GetHealPerc);
    Settings.GetHealHTL     := ini.ReadInteger('Settings', 'GetHealHTL',     Settings.GetHealHTL);
    Settings.GetSkipLocal   := ini.ReadBool   ('Settings', 'GetSkipLocal',   Settings.GetSkipLocal);
    Settings.VerifyCHK      := ini.ReadBool   ('Settings', 'VerifyCHK',      Settings.VerifyCHK);
    Settings.GetGetAll      := ini.ReadBool   ('Settings', 'GetGetAll',      Settings.GetGetAll);
    Settings.GetMultiDlg    := ini.ReadBool   ('Settings', 'GetMultiDlg',    Settings.GetMultiDlg);
    Settings.GetSpread      := ini.ReadBool   ('Settings', 'GetSpread',      Settings.GetSpread);
    Settings.GetMaxFiles    := ini.ReadInteger('Settings', 'GetMaxFiles',    Settings.GetMaxFiles);
    Settings.GetRetMin      := ini.ReadInteger('Settings', 'GetRetMin',      Settings.GetRetMin);
    Settings.GetTimeoutMin  := ini.ReadInteger('Settings', 'GetTimeoutMin',  Settings.GetTimeoutMin);
    Settings.GetPriorityTimeOut             := ini.ReadInteger('Settings', 'GetPriorityTimeOut',              Settings.GetPriorityTimeOut);
    Settings.GetPriorityToHighest           := ini.ReadInteger('Settings', 'GetPriorityToHighest',            Settings.GetPriorityToHighest);
    Settings.GetPriorityFromHighest         := ini.ReadInteger('Settings', 'GetPriorityFromHighest',          Settings.GetPriorityFromHighest);
    Settings.GetPriorityPercentage          := ini.ReadInteger('Settings', 'GetPriorityPercentage',           Settings.GetPriorityPercentage);
    Settings.GetPriorityBlocks              := ini.ReadInteger('Settings', 'GetPriorityBlocks',               Settings.GetPriorityBlocks); //Vanessa7
    Settings.GetMaxThreadsHighestPercentage := ini.ReadInteger('Settings', 'GetMaxThreadsHighestPercentage',  Settings.GetMaxThreadsHighestPercentage);
    Settings.CheckDownloadLog               := ini.ReadBool   ('Settings', 'CheckDownloadLog',                Settings.CheckDownloadLog);
    Settings.StrictMaxThreadHighest         := ini.ReadBool   ('Settings', 'StrictMaxThreadHighest',          Settings.StrictMaxThreadHighest);
    Settings.MinimumOnTotalFinalized        := ini.ReadBool   ('Settings', 'MinimumOnTotalFinalized',         Settings.MinimumOnTotalFinalized); //Vanessa7
    Settings.GetPriorityStraightOn          := ini.ReadBool   ('Settings', 'GetPriorityStraightOn',           Settings.GetPriorityStraightOn);
    Settings.SessionFile                    := ini.ReadString ('Settings', 'SessionFile',                     Settings.SessionFile);
    Settings.GetPriorityAutoOn              := ini.ReadBool   ('Settings', 'GetPriorityAutoOn',               Settings.GetPriorityAutoOn);
    Settings.SpiderEnabled                  := ini.ReadBool   ('Settings', 'SpiderEnabled',                   Settings.SpiderEnabled); //VanessasSpider
    Settings.SpiderMutex                    := ini.ReadBool   ('Settings', 'SpiderMutex',                     Settings.SpiderMutex);
    Settings.GetPriorityDropTo              := ini.ReadInteger('Settings', 'GetPriorityDropTo',               Settings.GetPriorityDropTo); //Vanessa
    Settings.GetFiniAnim                    := ini.ReadBool   ('Settings', 'GetFiniAnim',    Settings.GetFiniAnim);
    Settings.GetFiniSound                   := ini.ReadBool   ('Settings', 'GetFiniSound',   Settings.GetFiniSound);
    Settings.GetFiniWav                     := ini.ReadString ('Settings', 'GetFiniWav',     Settings.GetFiniWav);
    Settings.NoNativeCHK                    := ini.ReadBool   ('Settings', 'NoNativeCHK',    Settings.NoNativeCHK);
    Settings.NoNativeFEC                    := ini.ReadBool   ('Settings', 'NoNativeFEC',    Settings.NoNativeFEC);
    Settings.NoDeferredQueueSave            := ini.ReadBool   ('Settings', 'NoDeferredQS',   Settings.NoDeferredQueueSave);
    Settings.NoSetWarnVer                   := ini.ReadString ('Settings', 'NoSetWarnVer',   Settings.NoSetWarnVer);
    for i := Low(Settings.ClrNormal) to High(Settings.ClrNormal) do Settings.ClrNormal[i] := ini.ReadInteger('Settings', 'ClrNormal_' + IntToStr(i), Settings.ClrNormal[i]);
    for i := Low(Settings.ClrFrozen) to High(Settings.ClrFrozen) do Settings.ClrFrozen[i] := ini.ReadInteger('Settings', 'ClrFrozen_' + IntToStr(i), Settings.ClrFrozen[i]);
    for i := Low(Settings.ClrDone  ) to High(Settings.ClrDone  ) do Settings.ClrDone[i]   := ini.ReadInteger('Settings', 'ClrDone_'   + IntToStr(i), Settings.ClrDone[i]);
    for i := Low(Settings.ClrError ) to High(Settings.ClrError ) do Settings.ClrError[i]  := ini.ReadInteger('Settings', 'ClrError_'  + IntToStr(i), Settings.ClrError[i]);
    for i := Low(Settings.ClrEmpty ) to High(Settings.ClrEmpty ) do Settings.ClrEmpty[i]  := ini.ReadInteger('Settings', 'ClrEmpty_'  + IntToStr(i), Settings.ClrEmpty[i]);
    // --- Freenet 0.7 ---
    Settings.EnableFNOld    := ini.ReadBool   ('Settings', 'EnableFNOld',   Settings.EnableFNOld);
    Settings.EnableFNNew    := ini.ReadBool   ('Settings', 'EnableFNNew',   Settings.EnableFNNew);
    Settings.FCP2Addr       := ini.ReadInteger('Settings', 'FCP2IP',        Settings.FCP2Addr);
    Settings.FCP2Port       := ini.ReadInteger('Settings', 'FCP2Port',      Settings.FCP2Port);
    Settings.Dot7GlobalIns  := ini.ReadBool   ('Settings', 'Dot7GlobalIns', Settings.Dot7GlobalIns);
    Settings.Dot7GlobalGet  := ini.ReadBool   ('Settings', 'Dot7GlobalGet', Settings.Dot7GlobalGet);
    Settings.Dot7MaxIns     := ini.ReadInteger('Settings', 'Dot7MaxIns',    Settings.Dot7MaxIns);
    Settings.Dot7MaxGet     := ini.ReadInteger('Settings', 'Dot7MaxGet',    Settings.Dot7MaxGet);
    Settings.Dot7MaxGetAuto := ini.ReadInteger('Settings', 'Dot7MaxGetAuto', Settings.Dot7MaxGetAuto); //Vanessa7
    Settings.Dot7UseDisk    := ini.ReadBool   ('Settings', 'Dot7UseDisk',   Settings.Dot7UseDisk);
    Settings.Dot7Compress   := ini.ReadBool   ('Settings', 'Dot7Compress',  Settings.Dot7Compress);

    ClipList := TList.Create;
    cnt := ini.ReadInteger('ClipFormats', 'Count',     0);
    for i := 0 to cnt-1 do begin
      s := '_' + IntToStr(i+1);
      New(pClip);
      pClip^.Description  := ini.ReadString('ClipFormats', 'Name'+s,    'Unnamed');
      pClip^.FormatString := ini.ReadString('ClipFormats', 'Format'+s,  '');
      pClip^.Enabled      := ini.ReadBool  ('ClipFormats', 'Enabled'+s, True);
      ClipList.Add(pClip);
    end;
    Settings.ClipFmts := ClipFormats_ListToString(ClipList);

    GroupList := TList.Create;
    cnt := ini.ReadInteger('Groups', 'Count',     0);
    for i := 0 to cnt-1 do begin
      s := '_' + IntToStr(i+1);
      New(pGroup);
      pGroup^.ID        := ini.ReadInteger('Groups', 'ID'+s,     0);
      pGroup^.GroupName := ini.ReadString ('Groups', 'Name'+s,   'unnamed');
      pGroup^.Ins       := ini.ReadBool   ('Groups', 'Ins'+s,    False);
      pGroup^.Get       := ini.ReadBool   ('Groups', 'Get'+s,    False);
      pGroup^.Folder    := ini.ReadString ('Groups', 'Folder'+s, '');
      GroupList.Add(pGroup);
    end;
    Settings.Groups := GroupListToString(GroupList);

    ini.UpdateFile;
  finally
    ini.Free;
    ClipFormats_FreeList(ClipList);
    ClearGroupList(GroupList, True);
  end;
end;

function  CheckSettings: Boolean;
var
  s: String;
  bFixInsTimeout,bFixGetTimeout: Boolean;
begin
  Result := False;
  if GlobalSettings.NoSetWarnVer = VERSIONSTRING then exit;
  s := '';
  if GlobalSettings.SkipLocal = False then
    s := s + '- "Don''t check local node when inserting" should be ON (else reinserts won''t work)'#13;
  if GlobalSettings.VerifyCHK = False then
    s := s + '- "Verify each downloaded block" should be ON (to detect corrupted data)'#13;
  bFixInsTimeout := (GlobalSettings.InsTimeoutMin <> 0) and (GlobalSettings.InsTimeoutMin < (DefaultSettings.InsTimeoutMin - 10));
  bFixGetTimeout := (GlobalSettings.GetTimeoutMin <> 0) and (GlobalSettings.GetTimeoutMin < (DefaultSettings.GetTimeoutMin - 10));
  if bFixInsTimeout then
    s := s + Format('- "Timeout for insert threads is very low (%d min) - %d min is recommended',[GlobalSettings.InsTimeoutMin,DefaultSettings.InsTimeoutMin]) + #13;
  if bFixGetTimeout then
    s := s + Format('- "Timeout for download threads is very low (%d min) - %d min is recommended',[GlobalSettings.GetTimeoutMin,DefaultSettings.GetTimeoutMin]) + #13;
  if s = '' then exit;
  Insert('Fuqid has detected bad settings:'#13#13,s,1);
  s := s + #13#13'Do you want these settings to be corrected?';
  if MessageDlg(s, mtWarning, [mbYes,mbNo], 0) <> mrYes then exit;
  GlobalSettings.SkipLocal  := True;
  GlobalSettings.VerifyCHK  := True;
  if bFixInsTimeout then GlobalSettings.InsTimeoutMin := DefaultSettings.InsTimeoutMin;
  if bFixGetTimeout then GlobalSettings.GetTimeoutMin := DefaultSettings.GetTimeoutMin;
  SaveSettings(GlobalSettings);
  Result := True;
end;

procedure TFrmSettings.FormCreate(Sender: TObject);
var
  i:    Integer;
  ctrl: TControl;
  s:    String;
begin
  SetAnchors;
  AdjustFormSize(Self);
  LbLogFile.Caption := ExtractFileName(LOGFILENAME);
  LbInsLog.Caption  := ExtractFileName(KEYFILENAME);
  LbGetLog.Caption  := ExtractFileName(GETKEYFILENAME);
  PageControl.ActivePage := TsGeneral;
  InitFromSettings(GlobalSettings, True, True);
  // init hints - replace # by #13
  for i := 0 to ComponentCount-1 do
    if Components[i] is TControl then begin
      ctrl := Components[i] as TControl;
      s := ctrl.Hint;
      while Pos('#',s) <> 0 do s[Pos('#',s)] := #13;
      ctrl.Hint := s;
    end;

  try ClipboardFormats.QuickHelpToRichEd(RichEdClipFmtQuickHelp); except end;
end;

procedure TFrmSettings.FormDestroy(Sender: TObject);
begin
  ClearClipFormats;
  ClearGroups;
end;

procedure TFrmSettings.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TFrmSettings.InitFromSettings(Settings: TSettings; InitClipFormats,InitGroups: Boolean);
  procedure SetEdValue(Ed: TSpinEdit; Value,DefVal: Integer);
  begin
    try Ed.Value  := Value; except Ed.Value := DefVal; end;
  end;
var
  p: PChar;
  s: String;
  i:      Integer;
  ClipList: TList;
  pClip:    PClipFormatShort;
  GroupList: TList;
  pGroup:    PGroupEntry;
  item:      TListItem;
begin
  p := inet_ntoa(TInAddr(htonl(Settings.FCPAddr)));
  if p = nil then s := '???' else s := p;
  EdFCPAddress.Text  := s;
  EdFCPPort.Text     := IntToStr(Settings.FCPPort);
  SetEdValue(EdInsThreads,   Settings.InsThreads,    DefaultSettings.InsThreads);
  SetEdValue(EdInsHTL,       Settings.InsHTL,        DefaultSettings.InsHTL);
  CbInsHeadHTL.Checked    := Settings.InsUseHeadHTL; CbInsHeadHTLClick(CbInsHeadHTL);
  SetEdValue(EdInsHeadHTL,   Settings.InsHeadHTL,    DefaultSettings.InsHeadHTL);
  SetEdValue(EdInsRepHead,   Settings.InsRepHead,    DefaultSettings.InsRepHead);
  CbInsSingleHead.Checked := Settings.InsSingleHead;
  CbSkipLocal.Checked     := Settings.SkipLocal;
  CbMetaFirst.Checked     := Settings.MetaFirst;
  CbInsUseOrgFile.Checked := Settings.InsUseOrgFile;
  SetEdValue(EdInsTimeout,   Settings.InsTimeoutMin, DefaultSettings.InsTimeoutMin);
  CbInsFiniAnim.Checked   := Settings.InsFiniAnim;
  CbInsFiniSound.Checked  := Settings.InsFiniSound;
  EdInsFiniWav.Text       := Settings.InsFiniWav;
  CbLogToFile.Checked     := Settings.LogToFile;
  CbLogKeys.Checked       := Settings.LogKeys;
  CbLogGetKeys.Checked    := Settings.LogGetKeys;
  CbMinToTray.Checked     := Settings.MinToTray;
  CbTrayAnim.Checked      := Settings.TrayAnim;
  CbAutoActive.Checked    := Settings.AutoActive;
  CbStartMini.Checked     := Settings.StartMini;
  CbClearStats.Checked    := Settings.ClearStats;
  CbChkUpdate.Checked     := Settings.ChkUpdate;     CbChkUpdateClick(CbChkUpdate);
  SetEdValue(EdChkUpdate,    Settings.ChkUpdateInt,  DefaultSettings.ChkUpdateInt);
  case Settings.LogLevel of
    LOGLVL_DEBUG:     ComboLogLevel.ItemIndex := 0;
    LOGLVL_IMPORTANT: ComboLogLevel.ItemIndex := 2;
    LOGLVL_NONE:      ComboLogLevel.ItemIndex := 3;
    else              ComboLogLevel.ItemIndex := 1;
  end;
  if (Settings.ProcPrio >= -2) and (Settings.ProcPrio <= 2) then
    ComboProcPrio.ItemIndex := 2 + Settings.ProcPrio
  else
    ComboProcPrio.ItemIndex := 2;
  SetEdValue(EdGetThreads,   Settings.GetThreads,    DefaultSettings.GetThreads);
  SetEdValue(EdGetHTL,       Settings.GetHTL,        DefaultSettings.GetHTL);
  SetEdValue(EdGetRetries,   Settings.GetRetries,    DefaultSettings.GetRetries);
  SetEdValue(EdGetHTLInc,    Settings.GetHTLInc,     DefaultSettings.GetHTLInc);
  SetEdValue(EdGetHealPerc,  Settings.GetHealPerc,   DefaultSettings.GetHealPerc);
  SetEdValue(EdGetHealHTL,   Settings.GetHealHTL,    DefaultSettings.GetHealHTL);
  CbGetSkipLocal.Checked  := Settings.GetSkipLocal;
  CbVerifyCHK.Checked     := Settings.VerifyCHK;
  CbGetGetAll.Checked     := Settings.GetGetAll;
  CbGetMultiDlg.Checked   := Settings.GetMultiDlg;
  CbGetSpread.Checked     := Settings.GetSpread;     CbGetSpreadClick(CbGetSpread);
  SetEdValue(EdGetMaxFiles,  Settings.GetMaxFiles,   DefaultSettings.GetMaxFiles);
  SetEdValue(EdGetRetMin,    Settings.GetRetMin,     DefaultSettings.GetRetMin);
  SetEdValue(EdGetTimeout,   Settings.GetTimeoutMin, DefaultSettings.GetTimeoutMin);
  SetEdValue(EdGetPriorityTimeOut,               Settings.GetPriorityTimeOut,             DefaultSettings.GetPriorityTimeOut);
  SetEdValue(EdGetPriorityToHighest,             Settings.GetPriorityToHighest,           DefaultSettings.GetPriorityToHighest);
  SetEdValue(EdGetPriorityFromHighest,           Settings.GetPriorityFromHighest,         DefaultSettings.GetPriorityFromHighest);
  SetEdValue(EdGetPriorityPercentage,            Settings.GetPriorityPercentage,          DefaultSettings.GetPriorityPercentage);
  SetEdValue(EdGetPriorityBlocks,               Settings.GetPriorityBlocks,               DefaultSettings.GetPriorityBlocks); //Vanessa7
  SetEdValue(EdGetMaxThreadsHighestPercentage,   Settings.GetMaxThreadsHighestPercentage, DefaultSettings.GetMaxThreadsHighestPercentage);
  CbCheckDownloadLog.Checked       := Settings.CheckDownloadLog;
  CbStrictMaxThreadHighest.Checked := Settings.StrictMaxThreadHighest;
  CbMinimumOnTotalFinalized.Checked := Settings.MinimumOnTotalFinalized; //Vanessa7
  RbGetPriorityStraightOn.Checked  := Settings.GetPriorityStraightOn;
  RbGetPriorityToHighest.Checked   := not RbGetPriorityStraightOn.Checked; RbGetPriorityHighestClick(nil);
  CbGetPriorityAutoOn.Checked      := Settings.GetPriorityAutoOn;
  CbSpiderEnabled.Checked          := Settings.SpiderEnabled; //VanessasSpider
  CbSpiderMutex.Checked            := Settings.SpiderMutex;
  CboGetPriorityTo.ItemIndex       := Settings.GetPriorityDropTo; //Vanessa

  CbGetFiniAnim.Checked            := Settings.GetFiniAnim;
  CbGetFiniSound.Checked           := Settings.GetFiniSound;
  EdGetFiniWav.Text                := Settings.GetFiniWav;

  CbNoNativeCHK.Checked            := Settings.NoNativeCHK;
  CbNoNativeFEC.Checked            := Settings.NoNativeFEC;
  CbNoDeferredQueueSaving.Checked  := Settings.NoDeferredQueueSave;
  CbNoSetWarn.Checked              := (Settings.NoSetWarnVer = VERSIONSTRING);

  for i := Low(Settings.ClrNormal) to High(Settings.ClrNormal) do SetQueueColor('LbClrNormal', i, Settings.ClrNormal[i]);
  for i := Low(Settings.ClrFrozen) to High(Settings.ClrFrozen) do SetQueueColor('LbClrFrozen', i, Settings.ClrFrozen[i]);
  for i := Low(Settings.ClrDone  ) to High(Settings.ClrDone  ) do SetQueueColor('LbClrDone',   i, Settings.ClrDone  [i]);
  for i := Low(Settings.ClrError ) to High(Settings.ClrError ) do SetQueueColor('LbClrError',  i, Settings.ClrError [i]);
  for i := Low(Settings.ClrEmpty ) to High(Settings.ClrEmpty ) do SetQueueColor('LbClrEmpty',  i, Settings.ClrEmpty [i]);

  // --- Freenet 0.7 ---
  CbEnableFNOld.Checked := Settings.EnableFNOld;
  CbEnableFNNew.Checked := Settings.EnableFNNew;
  p := inet_ntoa(TInAddr(htonl(Settings.FCP2Addr)));
  if p = nil then s := '???' else s := p;
  EdFCP2Address.Text    := s;
  EdFCP2Port.Text       := IntToStr(Settings.FCP2Port);
  CbDot7GlobalIns.Checked := Settings.Dot7GlobalIns;
  CbDot7GlobalGet.Checked := Settings.Dot7GlobalGet;
  SetEdValue(EdDot7MaxIns, Settings.Dot7MaxIns, DefaultSettings.Dot7MaxIns);
  SetEdValue(EdDot7MaxGet, Settings.Dot7MaxGet, DefaultSettings.Dot7MaxGet);
  SetEdValue(EdDot7MaxGetAuto, Settings.Dot7MaxGetAuto, DefaultSettings.Dot7MaxGetAuto); //Vanessa7
  CbDot7UseDisk.Checked   := Settings.Dot7UseDisk;
  CbDot7Compress.Checked  := Settings.Dot7Compress;

  if InitClipFormats then begin
    // build clip format list
    ClipList := nil;
    LbxClipFormats.Items.BeginUpdate;
    try
      ClearClipFormats;
      ClipList := TList.Create;
      ClipFormats_StringToList(Settings.ClipFmts, ClipList);
      for i := 0 to ClipList.Count-1 do begin
        pClip := ClipList.Items[i];
        SetClipFmtListItem(-1, pClip);
      end;
    finally
      LbxClipFormats.Items.EndUpdate;
      ClipList.Free; // NOT ClipFormats_FreeList(ClipList), we reuse the pointers!
    end;
  end;

  if InitGroups then begin
    // build groups
    GroupList := nil;
    LvGroups.Items.BeginUpdate;
    try
      ClearGroups;
      GroupList := TList.Create;
      StringToGroupList(Settings.Groups, GroupList);
      for i := 0 to GroupList.Count-1 do begin
        pGroup := GroupList.Items[i];
        item := LvGroups.Items.Add;
        item.Data := pGroup;
        SetGroupListItem(item);
      end;
    finally
      LvGroups.Items.EndUpdate;
      GroupList.Free; // NOT ClearGroupList, we reuse the pointers!
    end;
  end;
end;

procedure TFrmSettings.BtOkClick(Sender: TObject);
var
  s: String;
  NewSettings: TSettings;
  ctrl: TWinControl;
  i:     Integer;
  ClipList: TList;
  GroupList: TList;
begin
  ctrl := nil;
  try
    ctrl := EdFCPAddress;
    s := Trim(EdFCPAddress.Text);
    NewSettings.FCPAddr := ntohl(inet_addr(PChar(s)));
    if NewSettings.FCPAddr = Cardinal(INADDR_NONE) then raise EAbort.Create('Invalid IP address for FCP');

    ctrl := EdFCPPort;
    NewSettings.FCPPort := 0;
    try NewSettings.FCPPort := StrToInt(EdFCPPort.Text); except end;
    if NewSettings.FCPPort = 0 then raise EAbort.Create('Invalid port for FCP');

    ctrl := EdInsThreads;
    NewSettings.InsThreads := EdInsThreads.Value;
    if NewSettings.InsThreads < 1 then raise EAbort.Create('Invalid number of insert threads');

    ctrl := EdInsHTL;
    NewSettings.InsHTL := EdInsHTL.Value;
    if NewSettings.InsHTL < 0 then raise EAbort.Create('Invalid insert HTL');

    NewSettings.InsUseHeadHTL := CbInsHeadHTL.Checked;

    ctrl := EdInsHeadHTL;
    NewSettings.InsHeadHTL := EdInsHeadHTL.Value;
    if NewSettings.InsHeadHTL < 0 then raise EAbort.Create('Invalid insert HTL for headers');

    ctrl := EdInsRepHead;
    NewSettings.InsRepHead := EdInsRepHead.Value;
    if NewSettings.InsRepHead < 0 then raise EAbort.Create('Invalid number of header reinserts');

    ctrl := EdInsTimeout;
    NewSettings.InsTimeoutMin := EdInsTimeout.Value;
    if NewSettings.InsTimeoutMin < 0 then raise EAbort.Create('Invalid insert thread timeout');

    NewSettings.InsFiniAnim   := CbInsFiniAnim.Checked;
    NewSettings.InsFiniSound  := CbInsFiniSound.Checked;
    NewSettings.InsFiniWav    := EdInsFiniWav.Text;

    NewSettings.InsSingleHead := CbInsSingleHead.Checked;
    NewSettings.SkipLocal     := CbSkipLocal.Checked;
    NewSettings.MetaFirst     := CbMetaFirst.Checked;
    NewSettings.InsUseOrgFile := CbInsUseOrgFile.Checked;
    NewSettings.LogToFile     := CbLogToFile.Checked;
    NewSettings.LogKeys       := CbLogKeys.Checked;
    NewSettings.LogGetKeys    := CbLogGetKeys.Checked;
    NewSettings.MinToTray     := CbMinToTray.Checked;
    NewSettings.TrayAnim      := CbTrayAnim.Checked;
    NewSettings.AutoActive    := CbAutoActive.Checked;
    NewSettings.StartMini     := CbStartMini.Checked;
    NewSettings.ClearStats    := CbClearStats.Checked;
    NewSettings.ChkUpdate     := CbChkUpdate.Checked;

    ctrl := EdChkUpdate;
    NewSettings.ChkUpdateInt := EdChkUpdate.Value;
    if NewSettings.ChkUpdateInt < 1 then raise EAbort.Create('Invalid number of hours between update checks');

    case ComboLogLevel.ItemIndex of
      0:   NewSettings.LogLevel := LOGLVL_DEBUG;
      2:   NewSettings.LogLevel := LOGLVL_IMPORTANT;
      3:   NewSettings.LogLevel := LOGLVL_NONE;
      else NewSettings.LogLevel := LOGLVL_NORMAL;
    end;

    NewSettings.ProcPrio := ComboProcPrio.ItemIndex - 2;
    if (NewSettings.ProcPrio < -2) or (NewSettings.ProcPrio > 2) then NewSettings.ProcPrio := 0;

    ctrl := EdGetThreads;
    NewSettings.GetThreads := EdGetThreads.Value;
    if NewSettings.GetThreads < 1 then raise EAbort.Create('Invalid number of download threads');

    ctrl := EdGetHTL;
    NewSettings.GetHTL := EdGetHTL.Value;
    if NewSettings.GetHTL < 0 then raise EAbort.Create('Invalid download HTL');

    ctrl := EdGetRetries;
    NewSettings.GetRetries := EdGetRetries.Value;
    if (NewSettings.GetRetries < 0) or (NewSettings.GetRetries > 63) then raise EAbort.Create('Invalid download retries');

    ctrl := EdGetHTLInc;
    NewSettings.GetHTLInc := EdGetHTLInc.Value;
    if NewSettings.GetHTLInc < 0 then raise EAbort.Create('Invalid download HTL increment');

    ctrl := EdGetHealPerc;
    NewSettings.GetHealPerc := EdGetHealPerc.Value;
    if NewSettings.GetHealPerc < 0 then raise EAbort.Create('Invalid download heal percentage');

    ctrl := EdGetHealHTL;
    NewSettings.GetHealHTL := EdGetHealHTL.Value;
    if NewSettings.GetHealHTL < 0 then raise EAbort.Create('Invalid download heal HTL');

    NewSettings.GetSkipLocal := CbGetSkipLocal.Checked;
    NewSettings.VerifyCHK    := CbVerifyCHK.Checked;
    NewSettings.GetGetAll    := CbGetGetAll.Checked;
    NewSettings.GetMultiDlg  := CbGetMultiDlg.Checked;
    NewSettings.GetSpread    := CbGetSpread.Checked;

    ctrl := EdGetMaxFiles;
    NewSettings.GetMaxFiles := EdGetMaxFiles.Value;
    if NewSettings.GetMaxFiles < 0 then raise EAbort.Create('Invalid number of maximum simultaneous download files');

    ctrl := EdGetRetMin;
    NewSettings.GetRetMin := EdGetRetMin.Value;
    if NewSettings.GetRetMin < 0 then raise EAbort.Create('Invalid number of minutes for retry');

    ctrl := EdGetPriorityTimeOut;
    NewSettings.GetPriorityTimeOut := EdGetPriorityTimeOut.Value;
    //Vanessa20060302 if NewSettings.GetPriorityTimeOut < 0 then raise EAbort.Create('Invalid priority timeout');

    ctrl := EdGetPriorityToHighest;
    NewSettings.GetPriorityToHighest := EdGetPriorityToHighest.Value;
    if NewSettings.GetPriorityToHighest < 0 then raise EAbort.Create('Invalid to highest');

    ctrl := EdGetPriorityFromHighest;
    NewSettings.GetPriorityFromHighest := EdGetPriorityFromHighest.Value;
    if NewSettings.GetPriorityFromHighest < 0 then raise EAbort.Create('Invalid from highest');

    ctrl := EdGetPriorityPercentage;
    NewSettings.GetPriorityPercentage := EdGetPriorityPercentage.Value;
    if NewSettings.GetPriorityPercentage < 0 then raise EAbort.Create('Invalid priority percentage');

    //Vanessa7
    ctrl := EdGetPriorityBlocks;
    NewSettings.GetPriorityBlocks := EdGetPriorityBlocks.Value;
    if NewSettings.GetPriorityBlocks < 0 then raise EAbort.Create('Invalid number of blocks');
    //~Vanessa7

    ctrl := EdGetMaxThreadsHighestPercentage;
    NewSettings.GetMaxThreadsHighestPercentage := EdGetMaxThreadsHighestPercentage.Value;
    if NewSettings.GetMaxThreadsHighestPercentage < 0 then raise EAbort.Create('Invalid max threads highest priority percentage');

    NewSettings.CheckDownloadLog := CbCheckDownloadLog.Checked;
    NewSettings.StrictMaxThreadHighest := CbStrictMaxThreadHighest.Checked;
    NewSettings.MinimumOnTotalFinalized := CbMinimumOnTotalFinalized.Checked; //Vanessa7
    NewSettings.GetPriorityStraightOn := RbGetPriorityStraightOn.Checked;

    NewSettings.GetPriorityAutoOn := CbGetPriorityAutoOn.Checked;

    NewSettings.SpiderEnabled := CbSpiderEnabled.Checked;
    NewSettings.SpiderMutex   := CbSpiderMutex.Checked;

    ctrl := CboGetPriorityTo;
    NewSettings.GetPriorityDropTo := CboGetPriorityTo.ItemIndex;
    if NewSettings.GetPriorityDropTo < 0 then raise EAbort.Create('Invalid drop to value');

    ctrl := EdGetTimeout;
    NewSettings.GetTimeoutMin := EdGetTimeout.Value;
    if NewSettings.GetTimeoutMin < 0 then raise EAbort.Create('Invalid download thread timeout');

    NewSettings.GetFiniAnim   := CbGetFiniAnim.Checked;
    NewSettings.GetFiniSound  := CbGetFiniSound.Checked;
    NewSettings.GetFiniWav    := EdGetFiniWav.Text;

    NewSettings.NoNativeCHK          := CbNoNativeCHK.Checked;
    NewSettings.NoNativeFEC          := CbNoNativeFEC.Checked;
    NewSettings.NoDeferredQueueSave  := CbNoDeferredQueueSaving.Checked;

    for i := Low(NewSettings.ClrNormal) to High(NewSettings.ClrNormal) do NewSettings.ClrNormal[i] := GetQueueColor('LbClrNormal', i);
    for i := Low(NewSettings.ClrFrozen) to High(NewSettings.ClrFrozen) do NewSettings.ClrFrozen[i] := GetQueueColor('LbClrFrozen', i);
    for i := Low(NewSettings.ClrDone  ) to High(NewSettings.ClrDone  ) do NewSettings.ClrDone  [i] := GetQueueColor('LbClrDone',   i);
    for i := Low(NewSettings.ClrError ) to High(NewSettings.ClrError ) do NewSettings.ClrError [i] := GetQueueColor('LbClrError',  i);
    for i := Low(NewSettings.ClrEmpty ) to High(NewSettings.ClrEmpty ) do NewSettings.ClrEmpty [i] := GetQueueColor('LbClrEmpty',  i);

  // --- Freenet 0.7 ---
    NewSettings.EnableFNOld := CbEnableFNOld.Checked;
    NewSettings.EnableFNNew := CbEnableFNNew.Checked;

    ctrl := EdFCP2Address;
    s := Trim(EdFCP2Address.Text);
    NewSettings.FCP2Addr := ntohl(inet_addr(PChar(s)));
    if NewSettings.FCP2Addr = Cardinal(INADDR_NONE) then raise EAbort.Create('Invalid IP address for FCP2 (Freenet 0.7)');

    ctrl := EdFCP2Port;
    NewSettings.FCP2Port := 0;
    try NewSettings.FCP2Port := StrToInt(EdFCP2Port.Text); except end;
    if NewSettings.FCP2Port = 0 then raise EAbort.Create('Invalid port for FCP2 (Freenet 0.7)');

    NewSettings.Dot7GlobalIns := CbDot7GlobalIns.Checked;
    NewSettings.Dot7GlobalGet := CbDot7GlobalGet.Checked;

    ctrl := EdDot7MaxIns;
    NewSettings.Dot7MaxIns := EdDot7MaxIns.Value;
    if NewSettings.Dot7MaxIns < 0 then raise EAbort.Create('Invalid number of maximum inserts (Freenet 0.7)');

    ctrl := EdDot7MaxGet;
    NewSettings.Dot7MaxGet := EdDot7MaxGet.Value;
    if NewSettings.Dot7MaxGet < 0 then raise EAbort.Create('Invalid number of maximum downloads (Freenet 0.7)');

    //Vanessa7
    ctrl := EdDot7MaxGetAuto;
    NewSettings.Dot7MaxGetAuto := EdDot7MaxGetAuto.Value;
    if NewSettings.Dot7MaxGetAuto < 0 then raise EAbort.Create('Invalid number of maximum download autos (Freenet 0.7)');
    //~Vanessa7

    NewSettings.Dot7UseDisk  := CbDot7UseDisk.Checked;
    NewSettings.Dot7Compress := CbDot7Compress.Checked;

    // Warnings only if Dot7UseDisk or FCP2 have changed...
    if (NewSettings.Dot7UseDisk <> GlobalSettings.Dot7UseDisk)
    or (NewSettings.FCP2Addr    <> GlobalSettings.FCP2Addr) then begin
      if NewSettings.Dot7UseDisk and (NewSettings.FCP2Addr <> Cardinal(INADDR_LOOPBACK)) then begin
        if mrYes <> MessageDlg(
                      'It looks like your Freenet 0.7 node is located on a different PC.'#13+
                      'You also checked "direct disk access", but that only works with local nodes.'#13#13+
                      'Are you sure your settings are correct?',
                      mtConfirmation, [mbYes,mbAbort], 0
                    )
        then
          exit;
      end;
    end;


    if CbNoSetWarn.Checked then
      NewSettings.NoSetWarnVer := VERSIONSTRING
    else
      NewSettings.NoSetWarnVer := '';

    ClipList := TList.Create;
    try
      for i := 0 to LbxClipFormats.Items.Count-1 do
        ClipList.Add(LbxClipFormats.Items.Objects[i]);
      NewSettings.ClipFmts := ClipFormats_ListToString(ClipList);
    finally
      ClipList.Free; // only the list, not the pointers
    end;

    GroupList := TList.Create;
    try
      for i := 0 to LvGroups.Items.Count-1 do
        GroupList.Add(LvGroups.Items[i].Data);
      NewSettings.Groups := GroupListToString(GroupList);
    finally
      GroupList.Free; // only the list, not the pointers
    end;

  except
    on E: EAbort do begin
      MessageDlg(E.Message, mtError, [mbOk], 0);
      if Assigned(ctrl) then try ctrl.SetFocus; except end;
      exit;
    end else
      raise;
  end;

  if (Sender = BtSave) then SaveSettings(NewSettings);

  GlobalSettings := NewSettings;
  ModalResult := mrOk;
end;

procedure TFrmSettings.BtResetClick(Sender: TObject);
var bInitClip,bInitGroups: Boolean;
begin
  if MessageDlg('Reset to default settings?',mtConfirmation,[mbYes,mbNo],0) <> mrYes then exit;
  bInitClip   := ( mrNo = MessageDlg('Keep current custom clipboard formats?',mtConfirmation,[mbYes,mbNo],0) );
  bInitGroups := ( mrNo = MessageDlg('Keep current custom groups?',mtConfirmation,[mbYes,mbNo],0) );
  InitFromSettings(DefaultSettings, bInitClip, bInitGroups);
end;

procedure TFrmSettings.ClearClipFormats;
var p: PClipFormatShort;
begin
  LbxClipFormats.Items.BeginUpdate;
  try
    while LbxClipFormats.Items.Count > 0 do begin
      p := PClipFormatShort(LbxClipFormats.Items.Objects[0]);
      LbxClipFormats.Items.Delete(0);
      Dispose(p);
    end;
  finally
    LbxClipFormats.Items.EndUpdate;
  end;
end;

function  TFrmSettings.SetClipFmtListItem(Index: Integer; pClip: PClipFormatShort): Integer;
var s: String;
begin
  if pClip^.Enabled then s := '' else s := '(disabled) ';
  if Index = -1 then
    Index := LbxClipFormats.Items.AddObject(s + pClip^.Description, Pointer(pClip))
  else begin
    LbxClipFormats.Items.Strings[Index] := s + pClip^.Description;
    LbxClipFormats.Items.Objects[Index] := Pointer(pClip);
  end;
  Result := Index;
end;

procedure TFrmSettings.LbxClipFormatsClick(Sender: TObject);
var
  en:   Boolean;
  Clip: TClipFormatShort;
begin
  if LbxClipFormats.ItemIndex < 0 then begin
    en := False;
    Clip.Description  := '';
    Clip.FormatString := '';
    Clip.Enabled      := False;
  end else begin
    en := True;
    Clip := PClipFormatShort(LbxClipFormats.Items.Objects[LbxClipFormats.ItemIndex])^;
  end;

  FInitingClip := True;
  try
    with EdClipFmtDescription do begin Text    := Clip.Description;  Enabled := en; end;
    with EdClipFmtFormat      do begin Text    := Clip.FormatString; Enabled := en; end;
    with CbClipFmtEnabled     do begin Checked := Clip.Enabled;      Enabled := en; end;
    LbClipFmtDescription.Enabled := en;
    LbClipFmtFormat.Enabled      := en;
    BtClipFmtTest.Enabled        := en;
    BtClipFmtDel.Enabled         := en;
  finally
    FInitingClip := False;
  end;
end;

procedure TFrmSettings.ClipFmtChanged(Sender: TObject);
var
  i:     Integer;
  pClip: PClipFormatShort;
begin
  if FInitingClip then exit;
  i := LbxClipFormats.ItemIndex; if i < 0 then exit; // shouldn't happen
  pClip := PClipFormatShort(LbxClipFormats.Items.Objects[i]);
  pClip.Description  := EdClipFmtDescription.Text;
  pClip.FormatString := EdClipFmtFormat.Text;
  pClip.Enabled      := CbClipFmtEnabled.Checked;
  SetClipFmtListItem(i, pClip);
end;

procedure TFrmSettings.BtClipFmtAddClick(Sender: TObject);
var
  pClip: PClipFormatShort;
begin
  New(pClip);
  pClip^.Description  := 'Unnamed';
  pClip^.FormatString := '';
  pClip^.Enabled      := True;
  LbxClipFormats.ItemIndex := SetClipFmtListItem(-1, pClip);
  LbxClipFormats.OnClick(nil);
end;

procedure TFrmSettings.BtClipFmtDelClick(Sender: TObject);
var
  pClip: PClipFormatShort;
  i:     Integer;
begin
  i := LbxClipFormats.ItemIndex; if i < 0 then exit;
  pClip := PClipFormatShort(LbxClipFormats.Items.Objects[i]);
  if MessageDlg('Delete clipboard format "' + pClip^.Description + '" ?', mtConfirmation, [mbYes,mbNo], 0) <> mrYes then exit;
  LbxClipFormats.Items.Delete(i);
  Dispose(pClip);
  if i >= LbxClipFormats.Items.Count then dec(i);
  if i >= 0 then LbxClipFormats.ItemIndex := i;
  LbxClipFormats.OnClick(nil);
end;

procedure TFrmSettings.BtClipFmtMoveClick(Sender: TObject);
var
  d,i: Integer;
  pClip,pClip2: PClipFormatShort;
begin
  if Sender = BtClipFmtUp then d := -1 else d := 1;
  i := LbxClipFormats.ItemIndex; if i < 0 then exit;
  if (i+d < 0) or (i+d >= LbxClipFormats.Items.Count) then exit;
  pClip  := PClipFormatShort(LbxClipFormats.Items.Objects[i]);
  pClip2 := PClipFormatShort(LbxClipFormats.Items.Objects[i+d]);
  SetClipFmtListItem(i,  pClip2);
  SetClipFmtListItem(i+d,pClip);
  LbxClipFormats.ItemIndex := i+d; 
end;

procedure TFrmSettings.BtClipFmtTestClick(Sender: TObject);
const s: String = '';
var
  cf:  TClipboardFormat;
  uri: TFreenetURI;
  UriList:  TList;
  SizeList: TList;
  CommentList: TStringList;
  ok:  Boolean;
  sRes: String;
begin
  cf := nil; uri := nil; UriList := nil; SizeList := nil; CommentList := nil;
  try
    cf := TClipboardFormat.Create;
    cf.Init(EdClipFmtDescription.Text, EdClipFmtFormat.Text);

    uri := TFreenetURI.Create;
    UriList  := TList.Create;
    SizeList := TList.Create;
    CommentList := TStringList.Create;
    repeat
      if not InputQuery('Testing format "' +EdClipFmtDescription.Text + '"', 'Enter a freenet key', s) then exit;
      ok := False;
      try
        uri.SetURI(s);
        ok := True;
      except
        on E: Exception do MessageDlg('Invalid freenet key: ' + s, mtError, [mbOk], 0);
      end;
    until ok;

    UriList.Add(uri); SizeList.Add(Pointer(123456789)); CommentList.Add('This is a comment');
    if MessageDlg('Test copying multiple keys?', mtConfirmation, [mbYes,mbNo], 0) = mrYes then begin
      UriList.Add(uri); SizeList.Add(Pointer(123456789)); CommentList.Add('This is a comment');
      UriList.Add(uri); SizeList.Add(Pointer(123456789)); CommentList.Add('This is a comment');
      UriList.Add(uri); SizeList.Add(Pointer(123456789)); CommentList.Add('This is a comment');
    end;

    sRes := cf.FormatKeys(UriList, SizeList, CommentList);

    if MessageDlg('Test passed, results below:'#13#13 + sRes + #13#13'Copy result to clipboard?', mtConfirmation, [mbYes,mbNo], 0) = mrYes then
      Clipboard.AsText := sRes;

  finally
    cf.Free;
    uri.Free;
    UriList.Free;
    SizeList.Free;
    CommentList.Free;
  end;
end;

procedure TFrmSettings.ClipFmtTemplateClick(Sender: TObject);
var
  s1,s2,sTmp:  String;
  bReplaceAll: Boolean;
begin
  if not (Sender is TMenuItem) then exit;
  bReplaceAll := False;
  case (Sender as TMenuItem).Tag of
     1:  sTmp := '%fulluri%';
     2:  sTmp := '%uri%';
     3:  sTmp := '%key%';
     4:  sTmp := '%docname%';
     5:  sTmp := '%routingkey%';
     6:  sTmp := '%cryptokey%';
     7:  sTmp := '%metainfo%';
     8:  sTmp := '%metastring%';
     9:  begin
           s1 := ''; s2 := '';
           if not InputQuery('Ask user for text', 'Enter the question:', s1) then exit;
           if MessageDlg('Do you want to have a default text?', mtConfirmation, [mbYes,mbNo], 0) = mrYes then begin
             if not InputQuery('Ask user for text', 'Enter the default text:', s2) then exit;
             sTmp := '%asktext("' + EscapeString(s1) + '","' + EscapeString(s2) + '")%';
           end else
             sTmp := '%asktext("' + EscapeString(s1) + '")%';
         end;
    10:  begin
           s1 := ''; s2 := '';
           if not InputQuery('Ask user a yes/no question', 'Enter the question:', s1) then exit;
           if MessageDlg('Do you want to have a default answer?', mtConfirmation, [mbYes,mbNo], 0) = mrYes then begin
             if MessageDlg('Select the default answer for your question:'#13#13 + s1, mtConfirmation, [mbYes,mbNo], 0) = mrYes then
               s2 := 'Y'
             else
               s2 := 'N';
             sTmp := '%askyesno("' + EscapeString(s1) + '","' + EscapeString(s2) + '")%';
           end else
             sTmp := '%askyesno("' + EscapeString(s1) + '")%';
         end;
    11:  begin
           s1 := '';
           if not InputQuery('Add plain text to the clipboard format', 'Enter the text:', s1) then exit;
           sTmp := '"' + EscapeString(s1) + '"';
         end;
    90:  begin
           bReplaceAll := True;
           sTmp := '%!uri%';
         end;
    91:  begin
           bReplaceAll := True;
           sTmp := '%!key%';
         end;
    92:  begin
           bReplaceAll := True;
           sTmp := '"File:  " %!docname% "\nKey:   " %!key% "\nBytes: " %size% "\n"';
         end;
    93:  begin
           bReplaceAll := True;
           sTmp := '"<attached>" %!key% " * " %!docname% "</attached>"';
         end;
    94:  begin
           bReplaceAll := True;
           sTmp := '"<A HREF=\"/" %!key% "\">" %!docname% "</A>"';
         end;
    else exit;
  end;
  if bReplaceAll then
    EdClipFmtFormat.Text := sTmp
  else
    EdClipFmtFormat.SelText := sTmp;
end;

procedure TFrmSettings.ClearGroups;
var
  i: Integer;
  p: PGroupEntry;
  item: TListItem;
begin
  for i := 0 to LvGroups.Items.Count-1 do begin
    item := LvGroups.Items[i];
    p := item.Data;
    Dispose(p);
  end;
  LvGroups.Items.Clear;
end;

procedure TFrmSettings.SetGroupListItem(item: TListItem);
var p: PGroupEntry;
begin
  p := item.Data;
  item.Caption := p^.GroupName;
  item.SubItems.Clear;
  if p^.Ins then item.SubItems.Add('Y') else item.SubItems.Add('-');
  if p^.Get then item.SubItems.Add('Y') else item.SubItems.Add('-');
  item.SubItems.Add(p^.Folder);
end;


procedure TFrmSettings.CbGetSpreadClick(Sender: TObject);
var bChecked: Boolean;
begin
  bChecked := CbGetSpread.Checked;
  LbGetMaxFiles.Enabled  := bChecked;
  EdGetMaxFiles.Enabled  := bChecked;
  LbGetMaxFiles2.Enabled := bChecked;
end;

procedure TFrmSettings.CbChkUpdateClick(Sender: TObject);
var bChecked: Boolean;
begin
  bChecked := CbChkUpdate.Checked;
  EdChkUpdate.Enabled := bChecked;
  LbChkUpdate.Enabled := bChecked;
end;

procedure TFrmSettings.CbInsHeadHTLClick(Sender: TObject);
begin
  EdInsHeadHTL.Enabled := CbInsHeadHTL.Checked;
end;

procedure TFrmSettings.SetAnchors;
begin
  // Set anchors for controls that stick to the right or bottom of their parent.
  // Normally this would be done at design time, but D7 then saves .DesignSize,
  // breaking compatibility with earlier Delphi versions. So do it at runtime.
  with PanelClipFmt           do Anchors := [akLeft,akTop,akRight,akBottom];
  with RichEdClipFmtQuickHelp do Anchors := [akLeft,akTop,akRight,akBottom];
  with EdClipFmtDescription   do Anchors := [akLeft,akTop,akRight];
  with EdClipFmtFormat        do Anchors := [akLeft,akTop,akRight];
end;

procedure TFrmSettings.BtBrowseFinishedWavClick(Sender: TObject);
var Ed: TEdit;
begin
  if      Sender = BtBrowseInsFiniWav then Ed := EdInsFiniWav
  else if Sender = BtBrowseGetFiniWav then Ed := EdGetFiniWav
  else exit;

  if OpenDialogWav.Execute then Ed.Text := OpenDialogWav.Filename;
end;

procedure TFrmSettings.BtTestFinishedWavClick(Sender: TObject);
var
  Ed: TEdit;
  s:  String;
begin
  if      Sender = BtTestInsFiniWav then Ed := EdInsFiniWav
  else if Sender = BtTestGetFiniWav then Ed := EdGetFiniWav
  else exit;

  s := Ed.Text;
  PlaySound(PChar(s), 0, SND_FILENAME or SND_ASYNC or SND_NODEFAULT or SND_NOWAIT);
end;

procedure TFrmSettings.LbClrMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Button = mbLeft then begin
    ColorDialog.Color := (Sender as TLabel).Color;
    if ColorDialog.Execute then (Sender as TLabel).Color := ColorDialog.Color;
  end else begin
    ColorDialog.Color := (Sender as TLabel).Font.Color;
    if ColorDialog.Execute then (Sender as TLabel).Font.Color := ColorDialog.Color;
  end;
end;


procedure TFrmSettings.BtClrDefaultClick(Sender: TObject);
var i: Integer;
begin
  if Sender = BtClrDefault_Normal then begin
    for i := Low(DefaultSettings.ClrNormal) to High(DefaultSettings.ClrNormal) do SetQueueColor('LbClrNormal', i, DefaultSettings.ClrNormal[i]);
  end else if Sender = BtClrDefault_Frozen then begin
    for i := Low(DefaultSettings.ClrFrozen) to High(DefaultSettings.ClrFrozen) do SetQueueColor('LbClrFrozen', i, DefaultSettings.ClrFrozen[i]);
  end else if Sender = BtClrDefault_Done then begin
    for i := Low(DefaultSettings.ClrDone  ) to High(DefaultSettings.ClrDone  ) do SetQueueColor('LbClrDone',   i, DefaultSettings.ClrDone  [i]);
  end else if Sender = BtClrDefault_Error then begin
    for i := Low(DefaultSettings.ClrError ) to High(DefaultSettings.ClrError ) do SetQueueColor('LbClrError',  i, DefaultSettings.ClrError [i]);
  end else if Sender = BtClrDefault_Empty then begin
    for i := Low(DefaultSettings.ClrEmpty ) to High(DefaultSettings.ClrEmpty ) do SetQueueColor('LbClrEmpty',  i, DefaultSettings.ClrEmpty [i]);
  end;
end;

function TFrmSettings.ColorLabel(Prefix: String; Index: Integer): TLabel;
var
  i: Integer;
  s: String;
begin
  s := Prefix + IntToStr(Index);
  for i := 0 to GbQueueColors.ControlCount-1 do
    if CompareText(GbQueueColors.Controls[i].Name, s) = 0 then begin
      Result := GbQueueColors.Controls[i] as TLabel;
      exit;
    end;
  raise Exception.Create('Cannot find color label "'+s+'"');
end;

function TFrmSettings.GetQueueColor(AName: String; Index: Integer): TColor;
begin
  if Index <= 2 then Result := ColorLabel(AName + '_', Index  ).Color
                else Result := ColorLabel(AName + '_', Index-2).Font.Color;
end;

procedure TFrmSettings.SetQueueColor(AName: String; Index: Integer; AColor: TColor);
begin
  if Index <= 2 then ColorLabel(AName + '_', Index  ).Color := AColor
                else ColorLabel(AName + '_', Index-2).Font.Color := AColor;
end;

procedure TFrmSettings.BtResetSplitterClick(Sender: TObject);
var h: Integer;
begin
  h := FrmMain.ClientHeight - FrmMain.PanelCtrl.Height - FrmMain.PanelCurrentFile.Height;
  FrmMain.PanelInsQueue.Height := h div 2;
end;

procedure TFrmSettings.RbGetPriorityHighestClick(Sender: TObject);
begin
  EdGetPriorityToHighest.Enabled := RbGetPriorityToHighest.Checked;
end;

procedure TFrmSettings.BtGroupAddReplaceClick(Sender: TObject);
var
  g: TGroupEntry;
  p: PGroupEntry;
  bNew: Boolean;
  item: TListItem;
  i:    Integer;
  ok:   Boolean;
begin
  bNew := (Sender = BtGroupAdd);
  if not bNew then begin
    item := LvGroups.Selected;
    if item = nil then begin
      MessageDlg('You have to select the group to replace first', mtError, [mbOk], 0);
      exit;
    end;
    p := item.Data;
    g.ID := p.ID;
  end else begin
    item := nil;
    g.ID := 0;
    repeat
      inc(g.ID); ok := True;
      for i := 0 to LvGroups.Items.Count-1 do begin
        p := LvGroups.Items[i].Data;
        if p.ID = g.ID then begin ok := False; break; end;
      end;
    until ok;
  end;
  g.GroupName := Trim(EdGroupName.Text);
  g.Folder    := Trim(EdGroupFolder.Text);
  if g.Folder <> '' then begin
    if Copy(g.Folder,Length(g.Folder),1) <> '\' then g.Folder := g.Folder + '\';
    if not DirectoryExists(g.Folder) then begin
      if mrYes <> MessageDlg('The default folder "' + g.Folder + '" does not exist. Use it anyway?', mtWarning, [mbYes,mbAbort], 0) then
        exit;
    end;
  end;
  g.Ins := CbGroupIns.Checked;
  g.Get := CbGroupGet.Checked;
  if g.GroupName = '' then begin
    MessageDlg('You must enter a name for the group', mtError, [mbOk], 0);
    exit;
  end;
  if bNew then begin
    item := LvGroups.Items.Add;
    New(p); p^ := g; item.Data := p;
  end else begin
    p := item.Data;
    p^ := g;
  end;
  SetGroupListItem(item);
  BtGroupClear.Click;
end;

procedure TFrmSettings.BtGroupDeleteClick(Sender: TObject);
var
  item: TListItem;
  p:    PGroupEntry;
begin
  item := LvGroups.Selected;
  if item = nil then begin
    MessageDlg('You have to select the group to delete first', mtError, [mbOk], 0);
    exit;
  end;
  p := item.Data;
  Dispose(p);
  item.Delete;
end;

procedure TFrmSettings.BtGroupClearClick(Sender: TObject);
begin
  EdGroupName.Text   := '';
  CbGroupIns.Checked := False;
  CbGroupGet.Checked := False;
  EdGroupFolder.Text := '';
end;

procedure TFrmSettings.LvGroupsDblClick(Sender: TObject);
var
  item: TListItem;
  p:    PGroupEntry;
begin
  item := LvGroups.Selected; if item = nil then exit;
  p := item.Data;
  EdGroupName.Text   := p^.GroupName;
  CbGroupIns.Checked := p^.Ins;
  CbGroupGet.Checked := p^.Get;
  EdGroupFolder.Text := p^.Folder;
end;

procedure TFrmSettings.BtGroupBrowseFolderClick(Sender: TObject);
var sDir: String;
begin
  {
  OpenDialogGroups.FileName := '(Dummy-File, leave this alone)';
  if OpenDialogGroups.Execute then EdGroupFolder.Text := ExtractFilePath(OpenDialogGroups.FileName);
  }
  sDir := AskForFolder(Handle, 'Select default folder for current group', EdGroupFolder.Text);
  if sDir <> '' then EdGroupFolder.Text := sDir;
end;

procedure TFrmSettings.BtGroupsMoveClick(Sender: TObject);
var
  item:     TListItem;
  i,iPos:   Integer;
  p:        PGroupEntry;
begin
  item := LvGroups.Selected; if item = nil then exit;
  if      (Sender is TMenuItem) then i := (Sender as TMenuItem).Tag
  else if (Sender is TButton)   then i := (Sender as TButton).Tag
  else exit;
  case i of
    -2: iPos := 0;
    -1: iPos := item.Index - 1;
     1: iPos := item.Index + 1;
     2: iPos := LvGroups.Items.Count-1;
    else exit;
  end;
  if iPos < 0 then iPos := 0;
  if iPos >= LvGroups.Items.Count then iPos := LvGroups.Items.Count-1;
  if iPos = item.Index then exit;
  p := item.Data;
  item.Delete;
  item := LvGroups.Items.Insert(iPos);
  item.Data := p;
  SetGroupListItem(item);
  item.Selected := True;
  item.Focused := True;
end;

initialization
  LOGFILENAME                := ChangeFileExt(Application.ExeName, '.log');
  KEYFILENAME                := ChangeFileExt(Application.ExeName, '-Keys.log');
  GETKEYFILENAME             := ChangeFileExt(Application.ExeName, '-Downloads.log');
  SPIDERREQUESTSBASEFILENAME := ChangeFileExt(Application.ExeName, '-SpiderRequests.txt'); //VanessasSpider
  SPIDERRESPONSEFILENAME     := ChangeFileExt(Application.ExeName, '-SpiderResponses.txt'); //VanessasSpider
  GlobalSettings := DefaultSettings;
  LoadSettings(GlobalSettings);

finalization

end.
