unit NodeMonitor;

// *****************************************************************************
// * Copyright 2003-2006 mxbee                                                 *
// *****************************************************************************
// * This program is free software; you can redistribute it and/or modify      *
// * it under the terms of the GNU General Public License as published by      *
// * the Free Software Foundation; either version 2 of the License, or         *
// * (at your option) any later version.                                       *
// *                                                                           *
// * This program is distributed in the hope that it will be useful,           *
// * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
// * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
// * GNU General Public License for more details.                              *
// *                                                                           *
// * You should have received a copy of the GNU General Public License         *
// * along with this program; if not, write to the Free Software               *
// * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
// *****************************************************************************

{$INCLUDE CompilerOpts.pas}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TNodeInfo = record
    ActiveJobs:               Integer;
    EstimateRateLimitingLoad: Integer;
    EstimatedLoad:            Integer;
    FreeMemory:               Int64;
    RoutingTime:              Integer;
    AvailableThreads:         Integer;
  end;
  PNodeInfo = ^TNodeInfo;
{
   // there is more info, but we don't use these values:
    DatastoreUsed,MaximumMemory,MostRecentTimestamp,DatastoreMax,AllocatedMemory
    MaxFileSize,JavaVendor,JavaName,OperatingSystemVersion,NodeAddress,
    DatastoreFree,NodePort,Processors,JavaVersion,OperatingSystem,
    LeastRecentTimestamp,Architecture
}

  TFrmNodeMonitor = class(TForm)
    PanelTop: TPanel;
    CbEnable: TCheckBox;
    TimerNodeMon: TTimer;
    PanelStats: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    LbActiveJobs: TLabel;
    LbAvailableThreads: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    LbEstimatedLoad: TLabel;
    LbEstimateRateLimitingLoad: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    LbFreeMemory: TLabel;
    LbRoutingTime: TLabel;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDestroy(Sender: TObject);
    procedure CbEnableClick(Sender: TObject);
    procedure TimerNodeMonTimer(Sender: TObject);
  private
    FInTimerProc: Boolean;
    procedure AddInfo(pNi: PNodeInfo);
  public
  end;

var FrmNodeMonitor: TFrmNodeMonitor = nil;

implementation

uses FreenetUtils, Settings;

{$R *.dfm}


procedure TFrmNodeMonitor.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TFrmNodeMonitor.FormDestroy(Sender: TObject);
begin
  FrmNodeMonitor := nil;
end;

procedure TFrmNodeMonitor.CbEnableClick(Sender: TObject);
begin
  TimerNodeMon.Enabled := CbEnable.Checked;
end;

procedure TFrmNodeMonitor.TimerNodeMonTimer(Sender: TObject);
var
  fcp:  TFCPSession;
  sMsg: String;
  ni:   TNodeInfo;
begin
  if FInTimerProc then exit;
  fcp := nil;
  try
    FInTimerProc := True;
    try
      fcp := TFCPSession.Create(GlobalSettings.FCPAddr, GlobalSettings.FCPPort);
      fcp.SendStringCommand('ClientInfo'#10'EndMessage'#10);
      if not fcp.WaitForDataAvailable(500) then exit;
      sMsg := fcp.ReadNextMessage;
      if sMsg <> 'NodeInfo' then exit;
      ni.ActiveJobs               := StrToIntDef  ('$' + fcp.Msg.Values['ActiveJobs'              ], 0);
      ni.EstimateRateLimitingLoad := StrToIntDef  ('$' + fcp.Msg.Values['EstimateRateLimitingLoad'], 0);
      ni.EstimatedLoad            := StrToIntDef  ('$' + fcp.Msg.Values['EstimatedLoad'           ], 0);
      ni.FreeMemory               := StrToInt64Def('$' + fcp.Msg.Values['FreeMemory'              ], 0);
      ni.RoutingTime              := StrToIntDef  ('$' + fcp.Msg.Values['RoutingTime'             ], 0);
      ni.AvailableThreads         := StrToIntDef  ('$' + fcp.Msg.Values['AvailableThreads'        ], 0);
      AddInfo(@ni);

    except
    end;
  finally
    fcp.Free;
    FInTimerProc := False;
  end;
end;

procedure TFrmNodeMonitor.AddInfo(pNi: PNodeInfo);
begin
  LbActiveJobs.Caption               := IntToStr( pNi^.ActiveJobs );
  LbAvailableThreads.Caption         := IntToStr( pNi^.AvailableThreads );
  LbEstimatedLoad.Caption            := IntToStr( pNi^.EstimatedLoad );
  LbEstimateRateLimitingLoad.Caption := IntToStr( pNi^.EstimateRateLimitingLoad );
  LbFreeMemory.Caption               := IntToStr( pNi^.FreeMemory );
  LbRoutingTime.Caption              := IntToStr( pNi^.RoutingTime );
end;

end.
