unit InsertOptions;

// *****************************************************************************
// * Copyright 2003-2006 mxbee                                                 *
// *****************************************************************************
// * This program is free software; you can redistribute it and/or modify      *
// * it under the terms of the GNU General Public License as published by      *
// * the Free Software Foundation; either version 2 of the License, or         *
// * (at your option) any later version.                                       *
// *                                                                           *
// * This program is distributed in the hope that it will be useful,           *
// * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
// * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
// * GNU General Public License for more details.                              *
// *                                                                           *
// * You should have received a copy of the GNU General Public License         *
// * along with this program; if not, write to the Free Software               *
// * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
// *****************************************************************************

{$INCLUDE CompilerOpts.pas}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, FreenetUtils, BaseFormUnit;

type
  TFrmInsertOptions = class(TBaseForm)
    GbOld: TGroupBox;
    Label1: TLabel;
    RbFuqid: TRadioButton;
    RbFIW: TRadioButton;
    RbFProxy: TRadioButton;
    LbMimeType: TLabel;
    EdMimeType: TEdit;
    BtOk: TButton;
    BtCancel: TButton;
    RbFrost: TRadioButton;
    RbRaw: TRadioButton;
    LbRawEncoding: TLabel;
    ComboRawEncoding: TComboBox;
    RbFCPCmd: TRadioButton;
    CbFrozen: TCheckBox;
    Label2: TLabel;
    EdComment: TEdit;
    GbDot7: TGroupBox;
    procedure RbClick(Sender: TObject);
    procedure BtOkClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    FStyle:   TInsertStyle;
    FFrozen:  Boolean;
    FComment: String;
    FDot7:    Boolean;
  public
  end;

function  AskInsertOptions(bDot7: Boolean; var Style: TInsertStyle; var Frozen: Boolean; var Comment: String): Boolean;

implementation

uses CryptUtils;

{$R *.dfm}

function  AskInsertOptions(bDot7: Boolean; var Style: TInsertStyle; var Frozen: Boolean; var Comment: String): Boolean;
var frm: TFrmInsertOptions;
begin
  frm := TFrmInsertOptions.Create(Application);
  try
    frm.FDot7    := bDot7;
    frm.FStyle   := Style;
    frm.FFrozen  := Frozen;
    frm.FComment := Comment;
    Result := (frm.ShowModal = mrOk);
    if Result then begin
      Style   := frm.FStyle;
      Frozen  := frm.FFrozen;
      Comment := frm.FComment;
    end;
  finally
    frm.Free;
  end;
end;

procedure TFrmInsertOptions.FormShow(Sender: TObject);
begin
  CbFrozen.Checked := FFrozen;
  EdComment.Text   := FComment;
  GbOld.Visible    := not FDot7;
  GbDot7.Visible   := FDot7;
end;

procedure TFrmInsertOptions.RbClick(Sender: TObject);
begin
  LbMimeType.Enabled := RbFProxy.Checked;
  EdMimeType.Enabled := LbMimeType.Enabled;
  LbRawEncoding.Enabled    := RbRaw.Checked;
  ComboRawEncoding.Enabled := LbRawEncoding.Enabled;
  if ComboRawEncoding.Enabled then begin
    if (ComboRawEncoding.ItemIndex < 0) then ComboRawEncoding.ItemIndex := 0
  end else
    ComboRawEncoding.ItemIndex := -1;
end;

procedure TFrmInsertOptions.BtOkClick(Sender: TObject);
begin
  if RbFuqid.Checked then begin
    FStyle := InsertStyle_Fuqid;
  end else if RbFIW.Checked then begin
    FStyle := InsertStyle_FIW;
  end else if RbFProxy.Checked then begin
    FStyle := InsertStyle_FProxy;
    FStyle.FixedMimeType := EdMimeType.Text;
    if FStyle.FixedMimeType = '' then begin
      MessageDlg('You must specify the mime type for FProxy-style inserts, since FProxy depends on the webbrowser to get it.', mtError, [mbOk], 0);
      exit;
    end;
    if Pos('/',FStyle.FixedMimeType) = 0 then begin
      MessageDlg('Invalid mime type: ' + FStyle.FixedMimeType, mtError, [mbOk], 0);
      exit;
    end;
  end else if RbFrost.Checked then begin
    FStyle := InsertStyle_Frost;
  end else if RbRaw.Checked then begin
    FStyle := InsertStyle_Raw;
    case ComboRawEncoding.ItemIndex of
      0:   FStyle.Header_Cipher := CIPHERNAME_RIJNDAEL;
      1:   FStyle.Header_Cipher := CIPHERNAME_TWOFISH;
      else begin
             MessageDlg('You must specify the encoding cipher to use for raw inserts.', mtError, [mbOk], 0);
             exit;
           end;
    end
  end else if RbFCPCmd.Checked then begin
    FStyle := InsertStyle_FCPCmd;
  end else
    raise Exception.Create('No insert style selected');

  FComment := EdComment.Text;
  FFrozen  := CbFrozen.Checked;

  ModalResult := mrOk;
end;

procedure TFrmInsertOptions.FormCreate(Sender: TObject);
begin
  inherited;
  GbDot7.Left := GbOld.Left;
  GbDot7.Top  := GbOld.Top;
end;

end.
