program Fuqid;

// *****************************************************************************
// * Copyright 2003-2006 mxbee                                                 *
// *****************************************************************************
// * This program is free software; you can redistribute it and/or modify      *
// * it under the terms of the GNU General Public License as published by      *
// * the Free Software Foundation; either version 2 of the License, or         *
// * (at your option) any later version.                                       *
// *                                                                           *
// * This program is distributed in the hope that it will be useful,           *
// * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
// * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
// * GNU General Public License for more details.                              *
// *                                                                           *
// * You should have received a copy of the GNU General Public License         *
// * along with this program; if not, write to the Free Software               *
// * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
// *****************************************************************************

{$INCLUDE CompilerOpts.pas}
 
{$R 'CustomOpenDialog.res' 'CustomOpenDialog.rc'}

uses
  Forms,
  Windows,
  SysUtils,
  Dialogs,
  Controls,
  FreenetUtils in 'FreenetUtils.pas',
  Main in 'Main.pas' {FrmMain},
  Settings in 'Settings.pas' {FrmSettings},
  Log in 'Log.pas' {FrmLog},
  FCPConsole in 'FCPConsole.pas' {FrmFCPConsole},
  FixedThread in 'FixedThread.pas',
  SHA1 in 'SHA1.pas',
  Misc in 'Misc.pas',
  Base64 in 'Base64.pas',
  AddMultipleKeys in 'AddMultipleKeys.pas' {FrmAddMultipleKeys},
  PrepFileDetails in 'PrepFileDetails.pas' {FrmPrepFileDetails},
  Twofish in 'Twofish.pas',
  CryptUtils in 'CryptUtils.pas',
  Rijndael in 'Rijndael.pas',
  FEC in 'FEC.pas',
  FECUtils in 'FECUtils.pas',
  ClipboardFormats in 'ClipboardFormats.pas',
  InsertOptions in 'InsertOptions.pas' {FrmInsertOptions},
  AskBaseKey in 'AskBaseKey.pas' {FrmAskBaseKey},
  Splash in 'Splash.pas' {FrmSplash},
  ColumnConfig in 'ColumnConfig.pas' {FrmColumnConfig},
  FreenetWinLauncherUtils in 'FreenetWinLauncherUtils.pas',
  ScanFrost in 'ScanFrost.pas' {FrmScanFrost},
  WaitForThread in 'WaitForThread.pas' {FrmWaitForThread},
  IncompleteFile in 'IncompleteFile.pas' {FrmIncompleteFile},
  QueueFile in 'QueueFile.pas',
  AddSingleKey in 'AddSingleKey.pas' {FrmAddSingleKey},
  CustomOpenDialog in 'CustomOpenDialog.pas',
  FrostSearchProgress in 'FrostSearchProgress.pas' {FrmFrostSearchProgress},
  FrostSearchResults in 'FrostSearchResults.pas' {FrmFrostSearchResults},
  BaseFormUnit in 'BaseFormUnit.pas' {BaseForm},
  NodeMonitor in 'NodeMonitor.pas' {FrmNodeMonitor},
  GfxData in 'GfxData.pas' {DmGfxData: TDataModule},
  FuqidMemoryManager in 'FuqidMemoryManager.pas',
  AskFreenetVersion in 'AskFreenetVersion.pas' {FrmAskFreenetVersion};

{$R *.RES}
{$R TrayIcons.res}

var
  hMutex:    THandle;
  dwErr:     DWord;
  sPrefix:   String;
  sMutNam:   String;
  SplashForm: TFrmSplash;
  Len:        Integer;
begin
  sPrefix := APPNAME + '_MUTEX_';
  sMutNam := sPrefix + Application.ExeName;
  if Length(sMutNam) >= MAX_PATH then begin // trim it, but keep the prefix intact
    Len := Length(sMutNam) - MAX_PATH + 1;
    Delete(sMutNam, Length(sPrefix)+1, Len);
  end;
  while Pos('\',sMutNam) <> 0 do sMutNam[Pos('\',sMutNam)] := '/'; // no backslashes allowed in mutex names 
  hMutex := CreateMutex(nil, True, PChar(sMutNam)); dwErr := GetLastError;
  try
    // if (dwErr = ERROR_ALREADY_EXISTS) and CommandLineOption('-nodupcheck') then begin
    //  if MessageDlg('Warning: ' + APPNAME + ' is already running.'#13'Quit this instance?',mtWarning,[mbYes,mbNo],0) = mrNo then
    //    dwErr := 0;
    // end;
    if (hMutex <> 0) and (dwErr <> ERROR_ALREADY_EXISTS) then begin
      Application.Initialize;
      SplashForm := TFrmSplash.Create(Application);
      SplashForm.Show;
      SplashForm.Update;
      Application.CreateForm(TFrmMain, FrmMain);
      Application.CreateForm(TFrmLog, FrmLog);
      Application.CreateForm(TDmGfxData, DmGfxData);
      SplashForm.Close;
      Application.Run;
    end else if dwErr = ERROR_ALREADY_EXISTS then begin
      MessageDlg(APPNAME + ' is already running from the same directory!', mtError, [mbOk], 0);
    end else
      MessageDlg('Critical error: Failed to create mutex (' + IntToStr(dwErr) + ') !', mtError, [mbOk], 0);
  finally
    if hMutex <> 0 then CloseHandle(hMutex);
  end;
end.
