unit FrostSearchProgress;

// *****************************************************************************
// * Copyright 2003-2006 mxbee                                                 *
// *****************************************************************************
// * This program is free software; you can redistribute it and/or modify      *
// * it under the terms of the GNU General Public License as published by      *
// * the Free Software Foundation; either version 2 of the License, or         *
// * (at your option) any later version.                                       *
// *                                                                           *
// * This program is distributed in the hope that it will be useful,           *
// * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
// * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
// * GNU General Public License for more details.                              *
// *                                                                           *
// * You should have received a copy of the GNU General Public License         *
// * along with this program; if not, write to the Free Software               *
// * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
// *****************************************************************************

{$INCLUDE CompilerOpts.pas}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, BaseFormUnit;

type
  TFrmFrostSearchProgress = class(TBaseForm)
    Label1: TLabel;
    Label2: TLabel;
    LbBoard: TLabel;
    LbMessage: TLabel;
    BtSkipBoard: TButton;
    BtCancel: TButton;
    Label3: TLabel;
    LbFound: TLabel;
    ProgressBar: TProgressBar;
    LbPercent: TLabel;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure BtCancelClick(Sender: TObject);
    procedure BtSkipBoardClick(Sender: TObject);
  private
    FFileList:  TStringList;
    FCallback:  TNotifyEvent;
    FAbort:     Boolean;
    FSkipBoard: Boolean;
    FCurrentFile: String;
    FMatchCount:  Integer;

    procedure Init;
    procedure IterateFiles;
  public
    // to be used in callback:
    procedure Abort;
    property  CurrentFile: String  read FCurrentFile;
    property  MatchCount:  Integer read FMatchCount write FMatchCount;
  end;

procedure IterateFrostMessages(Files: String; CallbackFunc: TNotifyEvent);

implementation

{$R *.dfm}

procedure IterateFrostMessages(Files: String; CallbackFunc: TNotifyEvent);
var Frm: TFrmFrostSearchProgress;
begin
  Frm := TFrmFrostSearchProgress.Create(Application);
  try
    Frm.FFileList.Text := Files;
    Frm.FCallback      := CallbackFunc;
    Frm.Init;
    Frm.Show;
    Frm.IterateFiles;
  finally
    Frm.Free;
  end;
end;

procedure TFrmFrostSearchProgress.FormCreate(Sender: TObject);
begin
  FFileList := TStringList.Create;
end;

procedure TFrmFrostSearchProgress.FormDestroy(Sender: TObject);
begin
  FFileList.Free;
end;

procedure TFrmFrostSearchProgress.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TFrmFrostSearchProgress.Init;
begin
  LbBoard.Caption   := '';
  LbMessage.Caption := '';
  LbFound.Caption   := '0';
  ProgressBar.Position := 0;
  LbPercent.Caption    := '0%';
  FMatchCount := 0;
  FAbort      := False;
  FSkipBoard  := False;
end;

procedure TFrmFrostSearchProgress.IterateFiles;
var
  iFile,iPerc:         Integer;
  sBoard,sPrevBoard,s: String;
begin
  sPrevBoard := '';
  for iFile := 0 to FFileList.Count-1 do begin
    if FAbort then break;

    FCurrentFile := FFileList.Strings[iFile];
    s := ExtractFilePath(FCurrentFile); Delete(s,Length(s),1);
    s := ExtractFilePath(s);            Delete(s,Length(s),1);
    sBoard := ExtractFileName(s);

    if FSkipBoard and (sBoard = sPrevBoard) then continue;
    FSkipBoard := False;
    sPrevBoard := sBoard;

    LbBoard.Caption   := sBoard;
    LbMessage.Caption := ExtractFileName(FCurrentFile);
    iPerc := Round((iFile + 1) * 100.0 / FFileList.Count);
    LbPercent.Caption := IntToStr(iPerc) + '%';
    ProgressBar.Position := iPerc;

    // now expect user events
    FCallback(Self);
    LbFound.Caption := IntToStr(FMatchCount);
    Application.ProcessMessages;
  end;
end;

procedure TFrmFrostSearchProgress.Abort;
begin
  FAbort := True;
end;

procedure TFrmFrostSearchProgress.BtCancelClick(Sender: TObject);
begin
  Abort;
end;

procedure TFrmFrostSearchProgress.BtSkipBoardClick(Sender: TObject);
begin
  FSkipBoard := True;
end;

end.
