//PROFILE-NO
unit ColumnConfig;

// *****************************************************************************
// * Copyright 2003-2006 mxbee                                                 *
// *****************************************************************************
// * This program is free software; you can redistribute it and/or modify      *
// * it under the terms of the GNU General Public License as published by      *
// * the Free Software Foundation; either version 2 of the License, or         *
// * (at your option) any later version.                                       *
// *                                                                           *
// * This program is distributed in the hope that it will be useful,           *
// * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
// * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
// * GNU General Public License for more details.                              *
// *                                                                           *
// * You should have received a copy of the GNU General Public License         *
// * along with this program; if not, write to the Free Software               *
// * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
// *****************************************************************************

{$INCLUDE CompilerOpts.pas}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, ComCtrls, StdCtrls, Menus, Buttons, BaseFormUnit;

type
  // Column index of listview columns
  // needed for sorting and width-saving

  TInsColumn = (
    inscol_STATUS,
    inscol_FILE,
    inscol_SIZE,
    inscol_DATE,
    inscol_KEY,
    inscol_THREADS,
    inscol_PROGRESS,
    inscol_NUMSUCC,
    inscol_LASTSUCC,
    inscol_NUMFAIL,
    inscol_LASTFAIL,
    inscol_COMMENT,
    inscol_ERRORS,
    inscol_GROUP,
    inscol_NETWORK,
    inscol_PERSIST,
    inscol_PRIORITY
  );

  TGetColumn = (
    getcol_STATUS,
    getcol_PRI,
    getcol_DIR,
    getcol_FILE,
    getcol_SIZE,
    getcol_DATE,
    getcol_KEY,
    getcol_THREADS,
    getcol_PROGRESS,
    getcol_BLOCKS,
    getcol_NUMSUCC,
    getcol_LASTSUCC,
    getcol_NUMFAIL,
    getcol_LASTFAIL,
    getcol_COMMENT,
    getcol_ERRORS,
    getcol_GROUP,
    getcol_NETWORK,
    getcol_PERSIST,
    getcol_NUMTODO, //Vanessa7
    getcol_PCTCOMPL, //Vanessa7
    getcol_DOC, //Vanessa7
    getcol_EXT //Vanessa7
  );

  TColumnConfig = record
    ID:       Integer; // just to uniquely identify each record
    InsQueue: Boolean;
    Column:   Integer; // Ord() of a TInsColumn or TGetColumn
    Caption:  String;
    Visible:  Boolean;
    Position: Integer; // desired position (regardless if visible or not)
    Index:    Integer; // current index in ListView.Columns[]
    Width:    Integer;
    Align:    TAlignment;
    Descript: String;
    Option:   Integer; // date-time formats, etc.
    Options:  String;  // '|'-separated list of possible options
  end;
  PColumnConfig = ^TColumnConfig;

var
  // not specified fields initialized at program startup
  DefaultColumnConfig: Array [0..Ord(High(TInsColumn))+Ord(High(TGetColumn))+1] of TColumnConfig = (
    ( InsQueue: True;  Column: Ord(inscol_STATUS);    Caption: 'Status';      Visible: True;  Position:  3; Width:  70; Align: taLeftJustify;  ),
    ( InsQueue: True;  Column: Ord(inscol_FILE);      Caption: 'Filename';    Visible: True;  Position:  5; Width: 170; Align: taLeftJustify;  ),
    ( InsQueue: True;  Column: Ord(inscol_SIZE);      Caption: 'MB';          Visible: True;  Position:  6; Width:  45; Align: taRightJustify; ),
    ( InsQueue: True;  Column: Ord(inscol_DATE);      Caption: 'Date added';  Visible: True;  Position:  7; Width:  75; Align: taCenter;       Options: 'Absolute|Relative'; ),
    ( InsQueue: True;  Column: Ord(inscol_KEY);       Caption: 'Key';         Visible: True;  Position:  8; Width: 125; Align: taLeftJustify;  ),
    ( InsQueue: True;  Column: Ord(inscol_THREADS);   Caption: 'T.';          Visible: True;  Position:  9; Width:  25; Align: taRightJustify; Descript: 'Number of threads'; ),
    ( InsQueue: True;  Column: Ord(inscol_PROGRESS);  Caption: 'Progress';    Visible: True;  Position: 10; Width:  70; Align: taLeftJustify;  ),
    ( InsQueue: True;  Column: Ord(inscol_NUMSUCC);   Caption: 'OK';          Visible: True;  Position: 11; Width:  30; Align: taRightJustify; Descript: 'Blocks succeeded'; ),
    ( InsQueue: True;  Column: Ord(inscol_LASTSUCC);  Caption: 'Last OK';     Visible: True;  Position: 12; Width:  75; Align: taCenter;       Options: 'Absolute|Relative'; ),
    ( InsQueue: True;  Column: Ord(inscol_NUMFAIL);   Caption: 'Failed';      Visible: True;  Position: 13; Width:  30; Align: taRightJustify; Descript: 'Blocks failed';    ),
    ( InsQueue: True;  Column: Ord(inscol_LASTFAIL);  Caption: 'Last Failed'; Visible: True;  Position: 14; Width:  75; Align: taCenter;       Options: 'Absolute|Relative'; ),
    ( InsQueue: True;  Column: Ord(inscol_COMMENT);   Caption: 'Comment';     Visible: True;  Position: 15; Width: 120; Align: taLeftJustify;  ),
    ( InsQueue: True;  Column: Ord(inscol_ERRORS);    Caption: 'Errors';      Visible: False; Position: 16; Width: 120; Align: taLeftJustify;  ),
    ( InsQueue: True;  Column: Ord(inscol_GROUP);     Caption: 'Group';       Visible: True;  Position: 17; Width: 120; Align: taLeftJustify;  ),
    ( InsQueue: True;  Column: Ord(inscol_NETWORK);   Caption: 'Net';         Visible: True;  Position:  1; Width:  30; Align: taCenter;       Descript: 'Network'; ),
    ( InsQueue: True;  Column: Ord(inscol_PERSIST);   Caption: 'In Node';     Visible: True;  Position:  2; Width:  50; Align: taCenter;       Descript: 'Persistant put in node'; ),
    ( InsQueue: True;  Column: Ord(inscol_PRIORITY);  Caption: 'Priority';    Visible: True;  Position:  4; Width:  50; Align: taCenter;       ),

    ( InsQueue: False; Column: Ord(getcol_STATUS);    Caption: 'Status';      Visible: True;  Position:  3; Width:  70; Align: taLeftJustify;  ),
    ( InsQueue: False; Column: Ord(getcol_PRI);       Caption: 'Priority';    Visible: True;  Position:  4; Width:  50; Align: taCenter;       ),
    ( InsQueue: False; Column: Ord(getcol_DIR);       Caption: 'Folder';      Visible: True;  Position:  5; Width:  50; Align: taLeftJustify;  ),
    ( InsQueue: False; Column: Ord(getcol_FILE);      Caption: 'Filename';    Visible: True;  Position:  6; Width:  75; Align: taLeftJustify;  ),
    ( InsQueue: False; Column: Ord(getcol_SIZE);      Caption: 'MB';          Visible: True;  Position:  7; Width:  45; Align: taRightJustify; ),
    ( InsQueue: False; Column: Ord(getcol_DATE);      Caption: 'Date added';  Visible: True;  Position:  8; Width:  75; Align: taCenter;       Options: 'Absolute|Relative'; ),
    ( InsQueue: False; Column: Ord(getcol_KEY);       Caption: 'Key';         Visible: True;  Position:  9; Width:  60; Align: taLeftJustify;  ),
    ( InsQueue: False; Column: Ord(getcol_THREADS);   Caption: 'T.';          Visible: True;  Position: 10; Width:  25; Align: taRightJustify; Descript: 'Number of threads'; ),
    ( InsQueue: False; Column: Ord(getcol_PROGRESS);  Caption: 'Progress';    Visible: True;  Position: 11; Width:  75; Align: taLeftJustify;  ),
    ( InsQueue: False; Column: Ord(getcol_BLOCKS);    Caption: 'Blocks';      Visible: True;  Position: 12; Width: 140; Align: taLeftJustify;  ),
    ( InsQueue: False; Column: Ord(getcol_NUMSUCC);   Caption: 'OK';          Visible: True;  Position: 13; Width:  30; Align: taRightJustify; Descript: 'Blocks succeeded'; ),
    ( InsQueue: False; Column: Ord(getcol_LASTSUCC);  Caption: 'Last OK';     Visible: True;  Position: 14; Width:  75; Align: taCenter;       Options: 'Absolute|Relative'; ),
    ( InsQueue: False; Column: Ord(getcol_NUMFAIL);   Caption: 'Failed';      Visible: True;  Position: 15; Width:  30; Align: taRightJustify; Descript: 'Blocks failed';    ),
    ( InsQueue: False; Column: Ord(getcol_LASTFAIL);  Caption: 'Last Failed'; Visible: True;  Position: 16; Width:  75; Align: taCenter;       Options: 'Absolute|Relative'; ),
    ( InsQueue: False; Column: Ord(getcol_COMMENT);   Caption: 'Comment';     Visible: True;  Position: 17; Width: 120; Align: taLeftJustify;  ),
    ( InsQueue: False; Column: Ord(getcol_ERRORS);    Caption: 'Errors';      Visible: False; Position: 18; Width: 120; Align: taLeftJustify;  ),
    ( InsQueue: False; Column: Ord(getcol_GROUP);     Caption: 'Group';       Visible: True;  Position: 19; Width: 120; Align: taLeftJustify;  ),
    ( InsQueue: False; Column: Ord(getcol_NETWORK);   Caption: 'Net';         Visible: True;  Position:  1; Width:  30; Align: taCenter;       Descript: 'Network'; ),
    ( InsQueue: False; Column: Ord(getcol_PERSIST);   Caption: 'In Node';     Visible: True;  Position:  2; Width:  50; Align: taCenter;       Descript: 'Persistant get in node'; ),
    ( InsQueue: False; Column: Ord(getcol_NUMTODO);   Caption: 'To Do';       Visible: True;  Position: 20; Width:  30; Align: taRightJustify; Descript: 'Blocks todo'; ), //Vanessa7
    ( InsQueue: False; Column: Ord(getcol_PCTCOMPL);  Caption: '%';           Visible: True;  Position: 21; Width:  30; Align: taRightJustify; Descript: 'Pct. Completed'; ), //Vanessa7
    ( InsQueue: False; Column: Ord(getcol_DOC);       Caption: 'Document';    Visible: False; Position: 22; Width:  30; Align: taLeftJustify;  Descript: 'Document'; ), //Vanessa7
    ( InsQueue: False; Column: Ord(getcol_EXT);       Caption: 'Extension';   Visible: False; Position: 23; Width:  30; Align: taLeftJustify;  Descript: 'Extension'; ) //Vanessa7
  );

const
  InsColSaveName: Array [TInsColumn] of String = (
    'COL_INS_STATUS',
    'COL_INS_FILE',
    'COL_INS_SIZE',
    'COL_INS_DATE',
    'COL_INS_KEY',
    'COL_INS_THREADS',
    'COL_INS_PROGRESS',
    'COL_INS_NUMSUCC',
    'COL_INS_LASTSUCC',
    'COL_INS_NUMFAIL',
    'COL_INS_LASTFAIL',
    'COL_INS_COMMENT',
    'COL_INS_ERRORS',
    'COL_INS_GROUP',
    'COL_INS_NETWORK',
    'COL_INS_PERSIST',
    'COL_INS_PRIORITY'
  );
  GetColSaveName: Array [TGetColumn] of String = (
    'COL_GET_STATUS',
    'COL_GET_PRI',
    'COL_GET_DIR',
    'COL_GET_FILE',
    'COL_GET_SIZE',
    'COL_GET_DATE',
    'COL_GET_KEY',
    'COL_GET_THREADS',
    'COL_GET_PROGRESS',
    'COL_GET_BLOCKS',
    'COL_GET_NUMSUCC',
    'COL_GET_LASTSUCC',
    'COL_GET_NUMFAIL',
    'COL_GET_LASTFAIL',
    'COL_GET_COMMENT',
    'COL_GET_ERRORS',
    'COL_GET_GROUP',
    'COL_GET_NETWORK',
    'COL_GET_PERSIST',
    'COL_GET_NUMTODO', //Vanessa7
    'COL_GET_PCTCOMPL', //Vanessa7
    'COL_GET_DOC', //Vanessa7
    'COL_GET_EXT' //Vanessa7
  );

type
  TFrmColumnConfig = class(TBaseForm)
    LvColumns: TListView;
    Panel1: TPanel;
    BtApply: TButton;
    PopupMenu1: TPopupMenu;
    MiShow: TMenuItem;
    MiRename: TMenuItem;
    MiUp: TMenuItem;
    MiDn: TMenuItem;
    MiOptions: TMenuItem;
    MiOption0: TMenuItem;
    MiOption1: TMenuItem;
    MiOption2: TMenuItem;
    BtOk: TButton;
    BtCancel: TButton;
    BtReset: TButton;
    PanelRight: TPanel;
    BtUp: TButton;
    BtDn: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BtApplyClick(Sender: TObject);
    procedure LvColumnsChange(Sender: TObject; Item: TListItem; Change: TItemChange);
    procedure MiUpDnClick(Sender: TObject);
    procedure PopupMenu1Popup(Sender: TObject);
    procedure MiShowClick(Sender: TObject);
    procedure MiRenameClick(Sender: TObject);
    procedure MiOptionClick(Sender: TObject);
    procedure BtCancelClick(Sender: TObject);
    procedure BtResetClick(Sender: TObject);
  private
    FInsQueue: Boolean;
    FWorkList: TList;
    FOnApply:   TNotifyEvent;
    FOnClosing: TNotifyEvent;
    procedure ClearColCfgList(Lst: TList);
    procedure SetListViewItem(Item: TListItem);
    procedure UpdateListView;
    procedure SetAnchors;
  public
    constructor Create(AOwner: TComponent; ForInsertQueue: Boolean); reintroduce;
    procedure SetWorkList(OrigList: TList);
    procedure GetWorkList(OrigList: TList);
    property  OnApply:   TNotifyEvent read FOnApply   write FOnApply;
    property  OnClosing: TNotifyEvent read FOnClosing write FOnClosing;
    property  InsQueue: Boolean      read FInsQueue;
  end;

function  GetColumnConfigForColumn(ConfList: TList; InsQueue: Boolean; Column: Integer): PColumnConfig; overload;
function  GetColumnConfigForColumn(ConfList: TList; Column: TInsColumn): PColumnConfig; overload;
function  GetColumnConfigForColumn(ConfList: TList; Column: TGetColumn): PColumnConfig; overload;
function  GetColumnConfigForID(ConfList: TList; ID: Integer): PColumnConfig;
function  CompareColumnConfig_ByPosition(Item1, Item2: Pointer): Integer;

implementation

{$R *.dfm}

function  GetColumnConfigForColumn(ConfList: TList; InsQueue: Boolean; Column: Integer): PColumnConfig;
var i: Integer;
begin
  for i := 0 to ConfList.Count-1 do begin
    Result := PColumnConfig(ConfList.Items[i]);
    if (Result^.InsQueue = InsQueue) and (Result^.Column = Column) then exit;
  end;
  Result := nil;
end;

function  GetColumnConfigForColumn(ConfList: TList; Column: TInsColumn): PColumnConfig;
begin Result := GetColumnConfigForColumn(ConfList, True, Ord(Column)); end;

function  GetColumnConfigForColumn(ConfList: TList; Column: TGetColumn): PColumnConfig; overload;
begin Result := GetColumnConfigForColumn(ConfList, False, Ord(Column)); end;

function  CompareColumnConfig_ByPosition(Item1, Item2: Pointer): Integer;
begin
  Result := PColumnConfig(Item1)^.Position - PColumnConfig(Item2)^.Position;
end;

function  GetColumnConfigForID(ConfList: TList; ID: Integer): PColumnConfig;
var i: Integer;
begin
  for i := 0 to ConfList.Count-1 do begin
    Result := PColumnConfig(ConfList.Items[i]);
    if (Result^.ID = ID) then exit;
  end;
  Result := nil;
end;

function  GetDisplayOption(Options: String; Option: Integer): String;
var iPos: Integer;
begin
  repeat
    iPos := Pos('|', Options);
    if iPos = 0 then begin
      Result := Options; Options := '';
    end else begin
      Result := Copy(Options,1,iPos-1); Delete(Options,1,iPos);
    end;
    dec(Option);
  until (Option < 0) or (Result = '');
end;

constructor TFrmColumnConfig.Create(AOwner: TComponent; ForInsertQueue: Boolean);
begin
  inherited Create(AOwner);
  FInsQueue := ForInsertQueue;
  if FInsQueue then Caption := 'Insert queue columns' else Caption := 'Download queue columns';
end;

procedure TFrmColumnConfig.FormCreate(Sender: TObject);
begin
  SetAnchors;
  FWorkList := TList.Create;
end;

procedure TFrmColumnConfig.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if Assigned(FOnClosing) then FOnClosing(Self);
  Action := caFree;
end;

procedure TFrmColumnConfig.FormDestroy(Sender: TObject);
begin
  ClearColCfgList(FWorkList);
  FWorkList.Free;
end;

procedure TFrmColumnConfig.ClearColCfgList(Lst: TList);
begin
  while Lst.Count > 0 do begin
    Dispose(Lst.Items[0]);
    Lst.Delete(0);
  end;
end;

procedure TFrmColumnConfig.SetWorkList(OrigList: TList);
var
  i:           Integer;
  pColCfgWork: PColumnConfig;
  pColCfgOrig: PColumnConfig;
begin
  ClearColCfgList(FWorkList);
  for i := 0 to OrigList.Count-1 do begin
    pColCfgOrig := OrigList.Items[i];
    if pColCfgOrig^.InsQueue = FInsQueue then begin
      New(pColCfgWork);
      pColCfgWork^ := pColCfgOrig^;
      FWorkList.Add(pColCfgWork);
    end;
  end;
  FWorkList.Sort(CompareColumnConfig_ByPosition);
  UpdateListView;
end;

procedure TFrmColumnConfig.GetWorkList(OrigList: TList);
var
  i,j:         Integer;
  pColCfgWork: PColumnConfig;
  pColCfgOrig: PColumnConfig;
begin
  // we never want to realloc the entries in the OrigList
  // just search the corresponding entry in Orig list and replace contents
  for i := 0 to OrigList.Count-1 do begin
    pColCfgOrig := OrigList.Items[i];
    for j := 0 to FWorkList.Count-1 do begin
      pColCfgWork := FWorkList.Items[j];
      if pColCfgOrig^.ID = pColCfgWork^.ID then begin
        pColCfgOrig^ := pColCfgWork^;
        break;
      end;
    end;
  end;
end;

procedure TFrmColumnConfig.UpdateListView;
var
  i:       Integer;
  pColCfg: PColumnConfig;
  item:    TListItem;
begin
  LvColumns.Items.BeginUpdate;
  try
    LvColumns.Items.Clear;
    for i := 0 to FWorkList.Count-1 do begin
      pColCfg := FWorkList.Items[i];
      item := LvColumns.Items.Add;
      item.Data := pColCfg;
      SetListViewItem(item);
    end;
  finally
    LvColumns.Items.EndUpdate;
  end;
end;

procedure TFrmColumnConfig.SetListViewItem(Item: TListItem);
var
  pColCfg: PColumnConfig;
  OldOnChange: TLVChangeEvent;
begin
  OldOnChange := LvColumns.OnChange;
  try
    LvColumns.OnChange := nil;
    pColCfg := Item.Data;
    Item.Caption := pColCfg^.Caption;
    Item.Checked := pColCfg^.Visible;
    Item.SubItems.Clear;
    Item.SubItems.Add(GetDisplayOption(pColCfg^.Options, pColCfg^.Option));
    Item.SubItems.Add(pColCfg^.Descript);
  finally
    LvColumns.OnChange := OldOnChange;
  end;
end;

procedure TFrmColumnConfig.BtApplyClick(Sender: TObject);
begin
  if Assigned(FOnApply) then FOnApply(Self);
  if Sender = BtOk then Close;
end;

procedure TFrmColumnConfig.LvColumnsChange(Sender: TObject; Item: TListItem; Change: TItemChange);
var
  pColCfg: PColumnConfig;
  Changed: Boolean;
begin
  pColCfg := Item.Data; if pColCfg = nil then exit;
  Changed := False;
  if Item.Caption <> pColCfg^.Caption then begin Changed := False; pColCfg^.Caption := Item.Caption; end;
  if Item.Checked <> pColCfg^.Visible then begin Changed := False; pColCfg^.Visible := Item.Checked; end;
  if Changed then SetListViewItem(Item);
end;


// ---- initialization of DefaultColumnConfig ----

procedure InitDefaultColumnConfig;
var i: Integer;
begin
  for i := Low(DefaultColumnConfig) to High(DefaultColumnConfig) do begin
    with DefaultColumnConfig[i] do begin
      ID := i;
      if Descript = '' then Descript := Caption;
    end;
  end;
end;

procedure TFrmColumnConfig.MiUpDnClick(Sender: TObject);
var
  bUp:     Boolean;
  item:    Array [1..2] of TListItem;
  pColCfg: Array [1..2] of PColumnConfig;
  idx,iPos: Integer;
begin
  bUp := (Sender = MiUp) or (Sender = BtUp);
  item[1] := LvColumns.Selected; if item[1] = nil then exit;
  idx := item[1].Index;
  if bUp then dec(idx) else inc(idx);
  if (idx >= 0) and (idx < LvColumns.Items.Count) then
    item[2] := LvColumns.Items[idx]
  else
    exit;
  pColCfg[1] := item[1].Data; pColCfg[2] := item[2].Data;
  item[1].Data := pColCfg[2]; item[2].Data := pColCfg[1];
  iPos := pColCfg[1]^.Position;
  pColCfg[1]^.Position := pColCfg[2]^.Position;
  pColCfg[2]^.Position := iPos;
  SetListViewItem(item[1]);
  SetListViewItem(item[2]);
  item[2].Selected := True;
  if item[1].Focused then item[2].Focused := True;
end;

procedure TFrmColumnConfig.PopupMenu1Popup(Sender: TObject);
var
  pColCfg:  PColumnConfig;
  bEnable:  Boolean;
  i,OptCnt: Integer;
  s:        String;
begin
  if LvColumns.Selected <> nil then pColCfg := LvColumns.Selected.Data else pColCfg := nil;
  bEnable := (pColCfg <> nil);
  OptCnt := 0;
  if pColCfg <> nil then begin
    MiShow.Checked := pColCfg^.Visible;
    for i := 0 to MiOptions.Count-1 do begin
      s := GetDisplayOption(pColCfg^.Options, i);
      MiOptions.Items[i].Caption := s;
      if s = '' then
        MiOptions.Items[i].Visible := False
      else begin
        MiOptions.Items[i].Visible := True;
        MiOptions.Items[i].Checked := (i = pColCfg^.Option);
        inc(OptCnt);
      end;
    end;
  end;
  MiShow.Enabled    := bEnable;
  MiRename.Enabled  := bEnable;
  MiUp.Enabled      := bEnable;
  MiDn.Enabled      := bEnable;
  MiOptions.Enabled := bEnable and (OptCnt > 0);
end;

procedure TFrmColumnConfig.MiShowClick(Sender: TObject);
begin
  if LvColumns.Selected = nil then exit;
  LvColumns.Selected.Checked := not LvColumns.Selected.Checked;
  MiShow.Checked := LvColumns.Selected.Checked;
end;

procedure TFrmColumnConfig.MiRenameClick(Sender: TObject);
begin
  if LvColumns.Selected <> nil then LvColumns.Selected.EditCaption;
end;

procedure TFrmColumnConfig.MiOptionClick(Sender: TObject);
var pColCfg: PColumnConfig;
begin
  if LvColumns.Selected = nil then exit;
  pColCfg := LvColumns.Selected.Data;
  pColCfg^.Option := (Sender as TMenuItem).Tag;
  SetListViewItem(LvColumns.Selected);
end;

procedure TFrmColumnConfig.BtCancelClick(Sender: TObject);
begin
  Close;
end;

procedure TFrmColumnConfig.BtResetClick(Sender: TObject);
var
  TmpList: TList;
  i:       Integer;
  pColCfg: PColumnConfig;
begin
  if MessageDlg('Reset columns to default settings?', mtConfirmation, [mbYes,mbNo], 0) <> mrYes then exit;
  TmpList := TList.Create;
  try
    for i := Low(DefaultColumnConfig) to High(DefaultColumnConfig) do begin
      if DefaultColumnConfig[i].InsQueue = FInsQueue then begin
        New(pColCfg);
        pColCfg^ := DefaultColumnConfig[i];
        TmpList.Add(pColCfg);
      end;
    end;
    SetWorkList(TmpList);
  finally
    while TmpList.Count > 0 do begin Dispose(TmpList.Items[0]); TmpList.Delete(0); end;
    TmpList.Free;
  end;
end;

procedure TFrmColumnConfig.SetAnchors;
begin
  // Set anchors for controls that stick to the right or bottom of their parent.
  // Normally this would be done at design time, but D7 then saves .DesignSize,
  // breaking compatibility with earlier Delphi versions. So do it at runtime.
  with BtReset   do Anchors := [akTop,akRight];
  with BtCancel  do Anchors := [akTop,akRight];
end;

initialization

  InitDefaultColumnConfig;

finalization

end.
