unit BaseFormUnit;

// *****************************************************************************
// * Copyright 2003-2006 mxbee                                                 *
// *****************************************************************************
// * This program is free software; you can redistribute it and/or modify      *
// * it under the terms of the GNU General Public License as published by      *
// * the Free Software Foundation; either version 2 of the License, or         *
// * (at your option) any later version.                                       *
// *                                                                           *
// * This program is distributed in the hope that it will be useful,           *
// * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
// * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
// * GNU General Public License for more details.                              *
// *                                                                           *
// * You should have received a copy of the GNU General Public License         *
// * along with this program; if not, write to the Free Software               *
// * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
// *****************************************************************************

{$INCLUDE CompilerOpts.pas}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs;

type
  TBaseForm = class(TForm)
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
  private
    FOriginalOnCreate: TNotifyEvent;
    procedure BaseFormCreated(Sender: TObject);
  protected
    procedure Loaded; override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  end;

implementation

uses StdCtrls;

{$R *.dfm}

var gFormList: TList = nil;

procedure FixDPI(f: TForm; DesignDPI: integer); 
{
  Small/Large system font solution
  Have a TForm's properties Scaled and AutoScroll set to false
  and after creating your form call this procedure like:
          FixDPI (TForm1, 96) // If you designed in small fonts

  Author: Tomislav Kardas
  Platform: Delphi 4 C/S
}
var ScaleM, ScaleD: integer;

  function Scale(x: longint): longint;
  begin
    Result := (x*ScaleM + ScaleD div 2) div ScaleD;
  end;

  procedure FixControl(c: TControl);
  var
    x: integer;
    p: TWinControl;
    fixheight: boolean;
  begin
    p := c.Parent;
    if c.Align <> alNone then begin
      // Fixing width
      if ((c.Align = alLeft ) and (akRight in c.Anchors))
      or ((c.Align = alRight) and (akLeft  in c.Anchors)) then
        c.Width := p.ClientWidth - Scale(p.ClientWidth - c.Width)
      else if (c.Align = alLeft) or (c.Align = alRight) then
        c.Width := Scale(c.Width);
      // Fixing height
      if ((c.Align = alTop   ) and (akBottom in c.Anchors))
      or ((c.Align = alBottom) and (akTop    in c.Anchors)) then
        c.Height := p.ClientHeight - Scale(p.ClientHeight - c.Height)
      else if (c.Align = alTop) or (c.Align = alBottom) then
        c.Height := Scale(c.Height);
    end else begin
      // Fixing width
      x := p.ClientWidth - c.Width - c.Left;
      if akLeft in c.Anchors then begin
        c.Left := Scale(c.Left);
        if akRight in c.Anchors then
          c.Width := p.ClientWidth - c.Left - Scale(x)
        else
          c.Width := Scale(c.Width);
      end else if akRight in c.Anchors then begin
        c.Width := Scale(c.Width);
        c.Left  := p.ClientWidth - c.Width - Scale(x);
      end else begin
        c.Left  := Scale(c.Left);
        c.Width := Scale(c.Width);
      end;
      // Fixing height
      fixheight := true;
      if (c is TCustomEdit) and not (c is TCustomMemo) then
        fixheight := false;

      x := p.ClientHeight - c.Height - c.Top;
      if akTop in c.Anchors then begin
        c.Top := Scale(c.Top);
        if fixheight then begin
          if akBottom in c.Anchors then
            c.Height := p.ClientHeight - c.Top - Scale(x)
          else
            c.Height := Scale(c.Height);
        end;
      end else if akBottom in c.Anchors then begin
        if fixheight then
          c.Height := Scale(c.Height);
        c.Top := p.ClientHeight - c.Height - Scale(x);
      end else begin
        c.Top := Scale(c.Top);
        if fixheight then
          c.Height := Scale(c.Height);
      end;
    end;
  end;

  procedure FixControls(c: TWinControl);
  var i: integer;
  begin
    for i := 0 to c.ControlCount - 1 do
      if c.Controls[i].Owner = f then begin
        FixControl(c.Controls[i]);
        if c.Controls[i] is TWinControl then
          FixControls(TWinControl(c.Controls[i]));
      end;
  end;

begin
  if DesignDPI <> Screen.PixelsPerInch then begin
    ScaleM := Screen.PixelsPerInch;
    ScaleD := DesignDPI;
    f.ClientWidth  := Scale(f.ClientWidth);
    f.ClientHeight := Scale(f.ClientHeight);
    FixControls(f);
  end;
end;

procedure TBaseForm.Loaded;
begin
  inherited;
  if csDesigning in ComponentState then exit;
  FOriginalOnCreate := OnCreate;
  OnCreate := BaseFormCreated;
end;

procedure TBaseForm.BaseFormCreated(Sender: TObject);
begin
  FixDPI(Self, 96);
  if Assigned(FOriginalOnCreate) then FOriginalOnCreate(Self);
end;


procedure TBaseForm.FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
var
  frm:      TForm;
  idx,i,d:  Integer;
begin
  if (Key = VK_TAB) and (ssCtrl in Shift) then begin
    // Activate next/previous window
    Key := 0;
    if (fsModal in Self.FormState) then begin
      // ShowMessage('sorry, modal');
      Beep;
      exit;
    end;

    idx := gFormList.IndexOf(Self);
    if idx < 0 then begin
      // ShowMessage('sorry, self not found');
      Beep;
      exit;
    end;
    if (ssShift in Shift) then d := -1 else d := 1;

    i := idx;
    repeat
      i := i + d;
      if i < 0 then i := gFormList.Count-1;
      if i >= gFormList.Count then i := 0;
      if i <> idx then begin
        frm := gFormList.Items[i];
        if frm.Visible then begin
          frm.BringToFront;
          break;
        end;
      end;
    until i = idx;
  end;
end;

constructor TBaseForm.Create(AOwner: TComponent);
begin
  if not Assigned(gFormList) then gFormList := TList.Create;
  gFormList.Add(Self);
  inherited Create(AOwner);
end;

destructor TBaseForm.Destroy;
var idx: Integer;
begin
  if Assigned(gFormList) then begin
    idx := gFormList.IndexOf(Self);
    if idx >= 0 then gFormList.Delete(idx);
    if gFormList.Count = 0 then begin
      gFormList.Free; gFormList := nil;
    end;
  end;
  inherited Destroy;
end;

end.
