unit AskFreenetVersion;

// *****************************************************************************
// * Copyright 2003-2006 mxbee                                                 *
// *****************************************************************************
// * This program is free software; you can redistribute it and/or modify      *
// * it under the terms of the GNU General Public License as published by      *
// * the Free Software Foundation; either version 2 of the License, or         *
// * (at your option) any later version.                                       *
// *                                                                           *
// * This program is distributed in the hope that it will be useful,           *
// * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
// * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
// * GNU General Public License for more details.                              *
// *                                                                           *
// * You should have received a copy of the GNU General Public License         *
// * along with this program; if not, write to the Free Software               *
// * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
// *****************************************************************************

{$INCLUDE CompilerOpts.pas}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, BaseFormUnit, StdCtrls;

type
  TFrmAskFreenetVersion = class(TBaseForm)
    Label1: TLabel;
    Label2: TLabel;
    LbOperation: TLabel;
    Button1: TButton;
    Button2: TButton;
  private
  public
  end;


function AskDot7(Operation: String): Boolean;

implementation

uses Settings;

{$R *.dfm}

function AskDot7(Operation: String): Boolean;
var
  frm: TFrmAskFreenetVersion;
  mr:  TModalResult;
begin
  if GlobalSettings.EnableFNNew and not GlobalSettings.EnableFNOld then begin Result := True;  exit; end;
  if GlobalSettings.EnableFNOld and not GlobalSettings.EnableFNNew then begin Result := False; exit; end;

  frm := TFrmAskFreenetVersion.Create(Application);
  try
    frm.LbOperation.Caption := Operation;
    repeat
      mr := frm.ShowModal;
    until mr in [mrYes,mrNo];
    Result := (mr = mrYes);
  finally
    frm.Free;
  end;
end;

end.
 