unit AskBaseKey;

// *****************************************************************************
// * Copyright 2003-2006 mxbee                                                 *
// *****************************************************************************
// * This program is free software; you can redistribute it and/or modify      *
// * it under the terms of the GNU General Public License as published by      *
// * the Free Software Foundation; either version 2 of the License, or         *
// * (at your option) any later version.                                       *
// *                                                                           *
// * This program is distributed in the hope that it will be useful,           *
// * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
// * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
// * GNU General Public License for more details.                              *
// *                                                                           *
// * You should have received a copy of the GNU General Public License         *
// * along with this program; if not, write to the Free Software               *
// * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
// *****************************************************************************

{$INCLUDE CompilerOpts.pas}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, BaseFormUnit;

type
  TFrmAskBaseKey = class(TBaseForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    EdBaseKey: TEdit;
    BtOk: TButton;
    BtCancel: TButton;
    BtIgnore: TButton;
    procedure EdBaseKeyChange(Sender: TObject);
    procedure BtOkClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
  public
  end;

function  AskForBaseKey(var BaseKey: String): TModalResult;

implementation

{$R *.dfm}

function  AskForBaseKey(var BaseKey: String): TModalResult;
var frm: TFrmAskBaseKey;
begin
  frm := TFrmAskBaseKey.Create(Application);
  try
    frm.EdBaseKey.Text := BaseKey;
    Result := frm.ShowModal;
    if Result = mrOk then
      BaseKey := Trim(frm.EdBaseKey.Text)
    else
      BaseKey := '';
  finally
    frm.Free;
  end;
end;

procedure TFrmAskBaseKey.FormShow(Sender: TObject);
begin
  EdBaseKeyChange(nil);
end;

procedure TFrmAskBaseKey.EdBaseKeyChange(Sender: TObject);
begin
  BtOk.Enabled := Trim(EdBaseKey.Text) <> '';
end;

procedure TFrmAskBaseKey.BtOkClick(Sender: TObject);
var s: String;
begin
  s := Trim(EdBaseKey.Text);
  if s = '' then begin
    MessageDlg('No base URI specified', mtError, [mbOk], 0);
    exit;
  end;
  if Copy(s,Length(s),1) <> '/' then begin
    if MessageDlg('Base URI looks incorrect (does not end with a slash). Use anyway?', mtWarning, [mbYes,mbNo], 0) <> mrYes then
      exit;
  end;
  ModalResult := mrOk;
end;

end.
