//PROFILE-NO
unit AddSingleKey;

// *****************************************************************************
// * Copyright 2003-2006 mxbee                                                 *
// *****************************************************************************
// * This program is free software; you can redistribute it and/or modify      *
// * it under the terms of the GNU General Public License as published by      *
// * the Free Software Foundation; either version 2 of the License, or         *
// * (at your option) any later version.                                       *
// *                                                                           *
// * This program is distributed in the hope that it will be useful,           *
// * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
// * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
// * GNU General Public License for more details.                              *
// *                                                                           *
// * You should have received a copy of the GNU General Public License         *
// * along with this program; if not, write to the Free Software               *
// * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
// *****************************************************************************

{$INCLUDE CompilerOpts.pas}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, BaseFormUnit;

type
  TFrmAddSingleKey = class(TBaseForm)
    Label1: TLabel;
    EdKey: TEdit;
    Label2: TLabel;
    EdComment: TEdit;
    Ok: TButton;
    Cancel: TButton;
    CbFrozen: TCheckBox;
    Label3: TLabel;
    ComboGroup: TComboBox;
    CbAutoSave: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ComboGroupClick(Sender: TObject);
  private
    FGroupList: TList;
    procedure Init(Key,Comment: String; Freeze: Boolean; GroupID: Integer; AutoSave: Boolean);
    procedure GetResults(var Key,Comment: String; var Freeze: Boolean; var GroupID: Integer; var AutoSave: Boolean);
  public
  end;

function AskSingleKey(var sKey, sComment: String; var bFrozen,bAutoSave: Boolean; var iGroupID: Integer): Boolean;

implementation

uses Settings;

{$R *.dfm}

function AskSingleKey(var sKey, sComment: String; var bFrozen,bAutoSave: Boolean; var iGroupID: Integer): Boolean;
var Form: TFrmAddSingleKey;
begin
  Form := TFrmAddSingleKey.Create(Application);
  try
    Form.Init(sKey,sComment,bFrozen,iGroupID,bAutoSave);
    Result := (Form.ShowModal = mrOk);
    if Result then begin
      Form.GetResults(sKey,sComment,bFrozen,iGroupID,bAutoSave);
    end else begin
      sKey      := '';
      sComment  := '';
      bFrozen   := False;
      iGroupID  := GROUP_NOGROUP;
      bAutoSave := False;
    end;
  finally
    Form.Free;
  end;
end;

procedure TFrmAddSingleKey.FormCreate(Sender: TObject);
begin
  inherited;
  FGroupList := TList.Create;
  StringToGroupList(GlobalSettings.Groups, FGroupList);
end;

procedure TFrmAddSingleKey.Init(Key,Comment: String; Freeze: Boolean; GroupID: Integer; AutoSave: Boolean);
var
  i,idx: Integer;
  p:     PGroupEntry;
begin
  EdKey.Text         := Key;
  EdComment.Text     := Comment;
  CbFrozen.Checked   := Freeze;
  CbAutoSave.Checked := AutoSave;

  // init group combo
  idx := 0;
  ComboGroup.Items.BeginUpdate;
  try
    ComboGroup.Items.Clear;
    ComboGroup.Items.AddObject('(no group)', nil);
    for i := 0 to FGroupList.Count-1 do begin
      p := FGroupList.Items[i];
      if p^.Get then begin
        ComboGroup.Items.AddObject(p^.GroupName, Pointer(p));
        if p^.ID = GroupID then idx := ComboGroup.Items.Count-1;
      end;
    end;
  finally
    ComboGroup.Items.EndUpdate;
  end;
  ComboGroup.ItemIndex := idx;
  ComboGroupClick(nil);
end;

procedure TFrmAddSingleKey.GetResults(var Key, Comment: String; var Freeze: Boolean; var GroupID: Integer; var AutoSave: Boolean);
var p:  PGroupEntry;
begin
  Key      := EdKey.Text;
  Comment  := EdComment.Text;
  Freeze   := CbFrozen.Checked;
  AutoSave := CbAutoSave.Checked and CbAutoSave.Enabled;
  GroupID  := GROUP_NOGROUP;
  if ComboGroup.ItemIndex >= 0 then begin
    p := PGroupEntry(ComboGroup.Items.Objects[ComboGroup.ItemIndex]);
    if Assigned(p) then GroupID := p^.ID;
  end;
end;

procedure TFrmAddSingleKey.FormDestroy(Sender: TObject);
begin
  inherited;
  ClearGroupList(FGroupList, True);
end;

procedure TFrmAddSingleKey.ComboGroupClick(Sender: TObject);
var
  i:  Integer;
  p:  PGroupEntry;
  ok: Boolean;
begin
  ok := False;
  i := ComboGroup.ItemIndex;
  if i >= 0 then begin
    p := PGroupEntry(ComboGroup.Items.Objects[i]);
    if Assigned(p) and (p^.Folder <> '') then begin
      ok := True;
      CbAutoSave.Hint := 'Don''t ask, save directly to: ' + p^.Folder;
    end;
  end;
  CbAutoSave.Enabled := ok;
  if not ok then CbAutoSave.Hint := 'Group has no default folder';
end;

end.
