//PROFILE-NO
unit PrepFileDetails;

// *****************************************************************************
// * Copyright 2003-2005 mxbee                                                 *
// *****************************************************************************
// * This program is free software; you can redistribute it and/or modify      *
// * it under the terms of the GNU General Public License as published by      *
// * the Free Software Foundation; either version 2 of the License, or         *
// * (at your option) any later version.                                       *
// *                                                                           *
// * This program is distributed in the hope that it will be useful,           *
// * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
// * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
// * GNU General Public License for more details.                              *
// *                                                                           *
// * You should have received a copy of the GNU General Public License         *
// * along with this program; if not, write to the Free Software               *
// * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
// *****************************************************************************

{$INCLUDE CompilerOpts.pas}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls, QueueFile;

type
  TFrmPrepFileDetails = class(TForm)
    Panel1: TPanel;
    Label1: TLabel;
    LbPrepbasename: TLabel;
    Panel2: TPanel;
    LvBlocks: TListView;
    BtUpdate: TButton;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BtUpdateClick(Sender: TObject);
    procedure LvBlocksKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    FUniqueID: Integer;
    procedure UpdateList;
  public
    { Public declarations }
  end;

procedure ShowPrepFileDetails(p: TQueueFile);

implementation

uses FreenetUtils, Main;

{$R *.DFM}

procedure ShowPrepFileDetails(p: TQueueFile);
var
  Form: TFrmPrepFileDetails;
  s:    String;
begin
  Form := TFrmPrepFileDetails.Create(Application);
  Form.FUniqueID := p.UniqueID;
  if p is TInsQueueFile then
    s := ExtractFilename((p as TInsQueueFile).OrgFilename)
  else
    s := ExtractFilename((p as TGetQueueFile).SavFilename);
  Form.Caption := Form.Caption + ' (' + s + ')';
  Form.Show;
end;

{ TFrmPrepFileDetails }

procedure TFrmPrepFileDetails.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TFrmPrepFileDetails.UpdateList;
var
  p:  TQueueFile;
  PrepFile: TPreparedFile;
  i:        Integer;
  item:     TListItem;
  iSeg:     Cardinal;
  sType,s:  String;
  SegStart,NumData,NumCheck: Cardinal;
begin
  LvBlocks.Items.BeginUpdate;
  try
    LvBlocks.Items.Clear;

    if FrmMain.LockTicker then
      try
        p := FrmMain.FindAnyQueueFileByUniqueID(FUniqueID);
        if p.PrepBasename <> '' then begin
          LbPrepBasename.Caption := ExtractFilename(p.PrepBasename);
          PrepFile := TPreparedFile.Create((p is TInsQueueFile), p.PrepBasename);
          try
            PrepFile.ReadHeader;
            iSeg := 0; PrepFile.GetSegmentBlockInfo(iSeg, SegStart, NumData, NumCheck);
            for i := 0 to PrepFile.NumBlocks-1 do begin
              if Cardinal(i) >= (SegStart + NumData + NumCheck) then begin
                inc(iSeg); PrepFile.GetSegmentBlockInfo(iSeg, SegStart, NumData, NumCheck);
              end;
              Assert((Cardinal(i) >= SegStart) and (Cardinal(i) < (SegStart + NumData + NumCheck)));
              if Cardinal(i) < (SegStart + NumData) then
                sType := 'Data.' + Hex(Cardinal(i) - SegStart + 1)
              else
                sType := 'Check.' + Hex(Cardinal(i) - SegStart - NumData + 1);
              item := LvBlocks.Items.Add;
              item.Data := Pointer(i);
              item.Caption := IntToStr(i);
              if PrepFile.BlockWorking[i] then item.Subitems.Add('WORK') else item.Subitems.Add('');
              if PrepFile.BlockDone[i]    then item.Subitems.Add('DONE') else item.Subitems.Add('');
              item.Subitems.Add(IntToStr(PrepFile.BlockTries[i]));
              item.Subitems.Add(sType);
              item.Subitems.Add(IntToStr(iSeg + 1));
              s := PrepFile.Key[i];
              if CompareText(Copy(s,1,Length('freenet:')), 'freenet:') = 0 then Delete(s,1,Length('freenet:'));
              item.Subitems.Add(s);
            end;
          finally
            PrepFile.Free;
          end;
        end else
          LbPrepBasename.Caption := '(none)';
      finally
        FrmMain.UnlockTicker;
      end;

  finally
    LvBlocks.Items.EndUpdate;
  end;
end;

procedure TFrmPrepFileDetails.BtUpdateClick(Sender: TObject);
begin
  UpdateList;
end;

procedure TFrmPrepFileDetails.LvBlocksKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
var
  p:  TQueueFile;
  PrepFile: TPreparedFile;
  i,cnt:    Integer;
begin
  if (Key = VK_DELETE) and (ssCtrl in Shift) then begin
    Key := 0;
    if MessageDlg('Mark selected blocks as unretrieved?', mtConfirmation, [mbYes,mbNo], 0) <> mrYes then exit;

    if FrmMain.LockTicker then
      try
        p := FrmMain.FindAnyQueueFileByUniqueID(FUniqueID);
        if p.PrepBasename <> '' then begin
          PrepFile := TPreparedFile.Create((p is TInsQueueFile), p.PrepBasename);
          try
            PrepFile.ReadHeader;
            cnt := 0;
            for i := 0 to LvBlocks.Items.Count-1 do begin
              if LvBlocks.Items[i].Selected then begin
                PrepFile.BlockDone[i] := False;
                PrepFile.BlockOffset[i] := $FFFFFFFF;
                inc(cnt);
              end;
            end;
            if cnt > 0 then PrepFile.WriteHeader;

            MessageDlg(IntToStr(cnt) + ' blocks marked unretrieved.', mtInformation, [mbOk], 0);
          finally
            PrepFile.Free;
          end;
        end;
      finally
        FrmMain.UnlockTicker;
      end;

  end;
end;

end.
