//PROFILE-NO
unit Main;

// *****************************************************************************
// * Copyright 2003-2005 mxbee                                                 *
// *****************************************************************************
// * This program is free software; you can redistribute it and/or modify      *
// * it under the terms of the GNU General Public License as published by      *
// * the Free Software Foundation; either version 2 of the License, or         *
// * (at your option) any later version.                                       *
// *                                                                           *
// * This program is distributed in the hope that it will be useful,           *
// * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
// * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
// * GNU General Public License for more details.                              *
// *                                                                           *
// * You should have received a copy of the GNU General Public License         *
// * along with this program; if not, write to the Free Software               *
// * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
// *****************************************************************************

{$INCLUDE CompilerOpts.pas}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Menus, Settings, ComCtrls, FreenetUtils, Log, ColumnConfig,
  QueueFile, CustomOpenDialog;

const
  APPNAME       = 'Fuqid';
  APPDESC       = 'Freenet Utility for Queued Inserts and Downloads';
  VERSIONSTRING = '1.5.8';
  PAGEEDITION   = 12;  // the edition number THIS version is published on

  CHECKUPDATEKEY_BASE      = 'SSK@CKesZYUJWn2GMvoif1R4SDbujIgPAgM/fuqid/';
  CHECKUPDATEKEY_NUM       = PAGEEDITION + 1;
  CHECKUPDATEKEY_LOOKAHEAD = 1;

  WMFUQID_TRAYICON = WM_USER + 1;

type
  TNumThreadsInfo = record
    NumInsThreads: Integer;
    NumGetThreads: Integer;
    NumDecThreads: Integer;
    NumChkThreads: Integer;
    NumPrpThreads: Integer;
    NumUpdThreads: Integer;
  end;

  TQueueType = (qtInsQueue, qtGetQueue);
  TQueueTypes = Set of TQueueType;

  TTrayAnim = (taActive, taSleep, taStop, taGlow);

  TTickerTask = (ttAnimateTrayIcon, ttHandleQueueFiles);
  TTickerTasks = Set of TTickerTask;

  TFrmMain = class(TForm)
    PanelCtrl: TPanel;
    PanelInsQueue: TPanel;
    BtSettings: TButton;
    BtAbort: TButton;
    LvInsQueue: TListView;
    Label1: TLabel;
    PopupInsQueue: TPopupMenu;
    MiInsQueueAddFiles: TMenuItem;
    MiInsQueueRemove: TMenuItem;
    BtInsQueueMoveUp: TButton;
    BtInsQueueMoveDown: TButton;
    BtInsQueueAddFiles: TButton;
    MiInsQueueMoveUp: TMenuItem;
    MiInsQueueMoveDown: TMenuItem;
    N1: TMenuItem;
    MiInsQueueFreeze: TMenuItem;
    MiInsQueueUnfreeze: TMenuItem;
    BtStart: TButton;
    PanelCurrentFile: TPanel;
    BtShowLog: TButton;
    N2: TMenuItem;
    MiInsQueueCopyKeys: TMenuItem;
    MiInsQueueCopyFilesAndKeys: TMenuItem;
    MiInsQueuePrepare: TMenuItem;
    TimerTicker: TTimer;
    BtStop: TButton;
    MiInsQueueUnprepare: TMenuItem;
    LbActiveInsertThreads: TLabel;
    MiDebug1: TMenuItem;
    FCPconsole1: TMenuItem;
    MiInsQueueUninsert: TMenuItem;
    Label2: TLabel;
    Label3: TLabel;
    LbActiveDownloadThreads: TLabel;
    PanelGetQueue: TPanel;
    Label4: TLabel;
    LvGetQueue: TListView;
    BtGetQueueMoveUp: TButton;
    BtGetQueueMoveDown: TButton;
    BtGetQueueAddKey: TButton;
    Splitter1: TSplitter;
    PopupGetQueue: TPopupMenu;
    MiGetQueueAddKey: TMenuItem;
    MiGetQueueRemove: TMenuItem;
    MiGetQueueFreeze: TMenuItem;
    MiGetQueueUnfreeze: TMenuItem;
    MiGetQueueUnget: TMenuItem;
    MenuItem8: TMenuItem;
    MiGetQueueMoveUp: TMenuItem;
    MiGetQueueMoveDown: TMenuItem;
    SaveDlgGetQueue: TSaveDialog;
    LbActive: TLabel;
    LbAborting: TLabel;
    LbDecodeThreadActive: TLabel;
    MiDebug2: TMenuItem;
    MiGetQueueSelectAll: TMenuItem;
    MiInsQueueSelectAll: TMenuItem;
    MiGetQueueOpenFile: TMenuItem;
    LbChecksumThreadActive: TLabel;
    MiInsQueueCopyInfo: TMenuItem;
    MiGetQueueRetry: TMenuItem;
    Dontdeleteprepfiles1: TMenuItem;
    Bevel1: TBevel;
    Settickerinterval1: TMenuItem;
    CbInsAutoRemove: TCheckBox;
    CbGetAutoRemove: TCheckBox;
    BtAbout: TButton;
    N3: TMenuItem;
    MiDebugMisc: TMenuItem;
    LbPrepareThreadActive: TLabel;
    MiGetQueueAbort: TMenuItem;
    MiInsQueueAbort: TMenuItem;
    MiInsQueueCopyFrost: TMenuItem;
    MiInsQueueCopy: TMenuItem;
    MiGetQueueCopy: TMenuItem;
    MiGetQueueCopyFrost: TMenuItem;
    MiGetQueueCopyInfo: TMenuItem;
    MiGetQueueCopyKeys: TMenuItem;
    MiGetQueueCopyFilesAndKeys: TMenuItem;
    MiGetQueueOldStyleDisplay: TMenuItem;
    MiGetQueuePriority: TMenuItem;
    MiGetQueuePriorityLowest: TMenuItem;
    MiGetQueuePriorityLow: TMenuItem;
    MiGetQueuePriorityNormal: TMenuItem;
    MiGetQueuePriorityHigh: TMenuItem;
    MiGetQueuePriorityHighest: TMenuItem;
    MiGetQueueGraphStyle: TMenuItem;
    MiGetQueueNewStyleDisplay: TMenuItem;
    MiGetQueueNoDisplay: TMenuItem;
    LbBugDetected: TLabel;
    PopupBugDetected: TPopupMenu;
    MiHideBugDetected: TMenuItem;
    SHA11: TMenuItem;
    MiInsQueueReinsertHeader: TMenuItem;
    MiInsQueueCopyHTML: TMenuItem;
    MiGetQueueCopyHTML: TMenuItem;
    BtInsLog: TButton;
    LbUpdateThreadActive: TLabel;
    BtCheckUpdate: TButton;
    LbUpdateFound: TLabel;
    MiInsQueueFileDetails: TMenuItem;
    MiGetQueueFileDetails: TMenuItem;
    MiInsQueueCopyCustomStart: TMenuItem;
    MiGetQueueCopyCustomStart: TMenuItem;
    Fakeinsertsonlycalckey1: TMenuItem;
    Label5: TLabel;
    LbStatsBytesUp: TLabel;
    LbStatsSpeedUp: TLabel;
    Label6: TLabel;
    LbStatsBytesDn: TLabel;
    LbStatsSpeedDn: TLabel;
    MiGetQueueChangeFolder: TMenuItem;
    LbStatsAvgSpUp: TLabel;
    LbStatsAvgSpDn: TLabel;
    PopupStats: TPopupMenu;
    MiClearSpeedStats: TMenuItem;
    PopupAddKey: TPopupMenu;
    MiFindKeysInFiles: TMenuItem;
    OpenDlgKeyFiles: TOpenDialog;
    PopupAddFiles: TPopupMenu;
    MiAddFilesAdvanced: TMenuItem;
    MiInsQueueAddFilesAdvanced: TMenuItem;
    MiGetQueueSaveIncomplete: TMenuItem;
    MiGetQueueVerifyBlocks: TMenuItem;
    MiGetQueueDebugGetAll: TMenuItem;
    ZipTest1: TMenuItem;
    MiWriteFCPlogOnErrors: TMenuItem;
    MiCalcCHK: TMenuItem;
    MiInsQueueConfigColumns: TMenuItem;
    MiGetQueueConfigColumns: TMenuItem;
    Statistics1: TMenuItem;
    MiGetQueueClearSessionStats: TMenuItem;
    MiGetQueueSetToOverallStats: TMenuItem;
    Statistics2: TMenuItem;
    MiInsQueueSetToOverallStats: TMenuItem;
    MiInsQueueClearSessionStats: TMenuItem;
    MiInsQueueRefreshList: TMenuItem;
    MiGetQueueRefreshList: TMenuItem;
    MiFrostSearch: TMenuItem;
    OpenDlgFrostFiles: TOpenDialog;
    BtGetLog: TButton;
    MiClearFileStats: TMenuItem;
    MiClearAllStats: TMenuItem;
    MiResetFileStats: TMenuItem;
    TimerRestoreCaption: TTimer;
    Setthreadspertick1: TMenuItem;
    MiGetQueueExplorerMenu: TMenuItem;
    MiInsQueueExplorerMenu: TMenuItem;
    MiInsQueueOpenFile: TMenuItem;
    MiFindKeysInClipboard: TMenuItem;
    N4: TMenuItem;
    N5: TMenuItem;
    MiGetQueueEditComment: TMenuItem;
    MiInsQueueEditComment: TMenuItem;
    N6: TMenuItem;
    N7: TMenuItem;
    PopupColumns: TPopupMenu;
    MiColumnsConfigColumns: TMenuItem;
    BtFrostSearch: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure BtSettingsClick(Sender: TObject);
    procedure MiInsQueueAddFilesClick(Sender: TObject);
    procedure MiInsQueueRemoveClick(Sender: TObject);
    procedure MiAnyQueueMoveClick(Sender: TObject);
    procedure MiAnyQueueFreezeClick(Sender: TObject);
    procedure BtStartClick(Sender: TObject);
    procedure StatusCallback(Sender: TObject; Msg: String; Level: Integer = LOGLVL_NORMAL);
    procedure BtAbortClick(Sender: TObject);
    procedure BtShowLogClick(Sender: TObject);
    procedure MiAnyQueueCopyClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure BtStopClick(Sender: TObject);
    procedure TimerTickerTimer(Sender: TObject);
    procedure MiInsQueueUnprepareClick(Sender: TObject);
    procedure FCPconsole1Click(Sender: TObject);
    procedure MiInsQueueUninsertClick(Sender: TObject);
    procedure MiGetQueueAddKeyClick(Sender: TObject);
    procedure MiGetQueueRemoveClick(Sender: TObject);
    procedure MiGetQueueUngetClick(Sender: TObject);
    procedure MiAnyQueueSelectAllClick(Sender: TObject);
    procedure MiAnyQueueOpenFileClick(Sender: TObject);
    procedure MiGetQueueRetryClick(Sender: TObject);
    procedure Dontdeleteprepfiles1Click(Sender: TObject);
    procedure Settickerinterval1Click(Sender: TObject);
    procedure CbAutoRemoveClick(Sender: TObject);
    procedure BtAboutClick(Sender: TObject);
    procedure MiAnyQueueAbortClick(Sender: TObject);
    procedure MiGetQueueGraphStyleClick(Sender: TObject);
    procedure MiGetQueuePriorityClick(Sender: TObject);
    procedure MiHideBugDetectedClick(Sender: TObject);
    procedure LvAnyQueueColumnClick(Sender: TObject; Column: TListColumn);
    procedure LvInsQueueCompare(Sender: TObject; Item1, Item2: TListItem; Data: Integer; var Compare: Integer);
    procedure LvGetQueueCompare(Sender: TObject; Item1, Item2: TListItem; Data: Integer; var Compare: Integer);
    procedure SHA11Click(Sender: TObject);
    procedure BtInsOrGetLogClick(Sender: TObject);
    procedure BtCheckUpdateClick(Sender: TObject);
    procedure LbUpdateFoundDblClick(Sender: TObject);
    procedure MiDebugMiscClick(Sender: TObject);
    procedure MiAnyQueueFileDetailsClick(Sender: TObject);
    procedure Fakeinsertsonlycalckey1Click(Sender: TObject);
    procedure MiGetQueueChangeFolderClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure MiClearStatsClick(Sender: TObject);
    procedure MiFindKeysInFilesClick(Sender: TObject);
    procedure MiGetQueueSaveIncompleteClick(Sender: TObject);
    procedure MiGetQueueVerifyBlocksClick(Sender: TObject);
    procedure MiGetQueueDebugGetAllClick(Sender: TObject);
    procedure PopupGetQueuePopup(Sender: TObject);
    procedure ZipTest1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure MiWriteFCPlogOnErrorsClick(Sender: TObject);
    procedure MiCalcCHKClick(Sender: TObject);
    procedure MiAnyQueueConfigColumnsClick(Sender: TObject);
    procedure MiAnyQueueStatsClick(Sender: TObject);
    procedure MiAnyQueueRefreshListClick(Sender: TObject);
    // procedure MiFindKeysInFrostClick(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure TimerRestoreCaptionTimer(Sender: TObject);
    procedure Setthreadspertick1Click(Sender: TObject);
    procedure LvAnyQueueMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure MiAnyQueueExplorerMenuClick(Sender: TObject);
    procedure MiFindKeysInClipboardClick(Sender: TObject);
    procedure MiAnyQueueEditCommentClick(Sender: TObject);
    procedure MiFrostSearchClick(Sender: TObject);
    procedure FrostSearchCallback(Sender: TObject);
    procedure LvAnyQueueContextPopup(Sender: TObject; MousePos: TPoint; var Handled: Boolean);
    procedure LvAnyQueueColumnRightClick(Sender: TObject; Column: TListColumn; Point: TPoint);
  private
    FInsertQueue: TList;
    FGetQueue:    TList;
    FActive:      Boolean;
    FAbort:       Boolean;
    FThreadPool:  TList;
    FDebugKeepPrepFiles: Boolean;
    FTickerLock:   record
                     Locked:        Boolean;
                     DisabledTimer: Boolean;
                   end;
    FDoAutoRemGet: Boolean;
    FDoAutoRemIns: Boolean;
    FLastInsDir:   String;
    FLastGetDir:   String;
    FGraphStyle:   Integer;
    FGetPrioList:  TStringList;
    FQueueInfo:    Array [TQueueType] of record
                     ListView:     TListView;
                     QueueList:    TList;
                     SortColumn:   Integer; // -1 here means manually sorted
                     SortInverted: Boolean;
                   end;
    FFileLogForm: TFrmLog;
    FUpdateKey:  String;
    FClipList:   TList;
    FDebugFakeInserts: Boolean;
    FLastUpdateCheck:  TDateTime;
    FStats:            record
                         BytesUp, BytesDn:    Int64;
                         UpDownloadStatsList: TList;
                         Changed:             Boolean;
                         SpeedUp, SpeedDn:    Int64;
                         AvgSpUp, AvgSpDn:    Int64;
                         AvgStartTime:        TDateTime;
                       end;
    FDidOnShow:        Boolean;
    FTrayIcons:        Array [0..4] of HICON;
    FCurrentTrayIcon:  HICON;
    FTrayAnim:         TTrayAnim;
    FTrayAnimCount:    Integer;
    FTrayIconVisible:  Boolean;

    FLVInsOrigWindowProc: TWndMethod;
    FLVGetOrigWindowProc: TWndMethod;
    FColumnConfigList:    TList;
    FColumnConfigForm:    Array [TQueueType] of TFrmColumnConfig;

    FNeedPermanentRefresh: Array [TQueueType] of Boolean;

    FNodeUp:               record
                             IsUp:      Boolean;
                             LastCheck: TDateTime;
                           end;

    FEndSession:           Boolean;
    FTickerTasks:          TTickerTasks;
    FShowInfoTip:          Boolean;
    FFormCaption:          String;
    FFlushError:           Boolean;
    FMaxThreadsPerTick:    Integer;

    FColumnRightClicked:   Boolean;

    FFrostSearch:          record
                             Keys:    Boolean;
                             Text:    String;
                             CheckSubject,CheckPoster,CheckBody,CheckFiles: Boolean;
                             MsgResults: TList;
                             KeyResults: TStringList;
                             TmpStrLst:  TStringList;
                           end;

    OpenDlgInsQueue: TFuqidOpenDialog;

    procedure SetInsQueueListItem(item: TListItem; AddToNumThreads: Integer = 0);
    procedure SetGetQueueListItem(item: TListItem; AddToNumThreads: Integer = 0);
    procedure SetAnyQueueListItem(qt: TQueueType; item: TListItem; AddToNumThreads: Integer = 0);
    procedure UpdateQueue(ListView: TListView; QueueList: TList; TickerAlreadyLocked: Boolean);
    procedure UpdateInsertQueue(TickerAlreadyLocked: Boolean);
    procedure UpdateGetQueue(TickerAlreadyLocked: Boolean);
    procedure Log(LogMsg: String);
    procedure MainLog(LogMsg: String; p: TQueueFile = nil; Level: Integer = LOGLVL_NORMAL);
    procedure LogFinishedInsert(p: TInsQueueFile);
    procedure LogFinishedGet(p: TGetQueueFile);
    procedure SaveQueues(TickerAlreadyLocked: Boolean; IsFinalSave: Boolean = False);
    procedure LoadQueues;
    procedure ClearQueue(ListView: TListView; QueueList: TList);
    procedure ClearInsQueue;
    procedure ClearGetQueue;
    function  GetUniquePrepareName(ForInsert: Boolean): String;
    procedure DeleteInsQueueItem(item: TListItem);
    procedure DeleteGetQueueItem(item: TListItem);
    procedure DoDuty;
    procedure ThreadTerminated(Sender: TObject);
    procedure UpdateThreadDisplay;
    procedure UpdateStatsDisplay;
    function  NumInsThreads: Integer;
    function  NumGetThreads: Integer;
    function  NumHighDutyThreads: Integer;
    function  GetNumberOfThreads: TNumThreadsInfo;
    function  RemoveFreenetPrefix(const sKey: String): String;
    procedure GenerateHealInsert(CalledFromTicker: Boolean; Descript: String; PrepFile: TPreparedFile; HealBlocks: String; Style: TInsertStyle);
    procedure AddToInsQueue(IsHeal, IsDirect: Boolean; Filename,Basename: String; Size: DWord; Style: TInsertStyle; AddFrozen: Boolean; Comment: String);
    function  GetKeyPart(sFullKey: String): String;
    procedure AutoRemoveIns;
    procedure AutoRemoveGet;
    procedure AppMinimized(Sender: TObject);
    procedure AppRestored(Sender: TObject);
    procedure RestoreApp;
    procedure MinimizeApp(ForceToTray: Boolean);
    procedure TrayIconMessage(var M: TMessage); message WMFUQID_TRAYICON;
    procedure CheckAbortedEntries;
    procedure RescheduleDownload(pG: TGetQueueFile; LogMsg: String = '');
    function  UserInputToKey(Input: String; var Filename,Comment: String; AutoMode: Boolean): String;
    function  FindQueueType(Sender: TObject; out qt: TQueueType): Boolean;
    procedure AddKeysToGetQueue(KeyList,FilenameList,CommentList: TStringList);
    procedure AddKeys(ClipboardText: String);
    function  FindInsQueueFileByUniqueID(ID: Int64): TInsQueueFile;
    function  FindGetQueueFileByUniqueID(ID: Int64): TGetQueueFile;
    procedure InitClipboardFormats;
    procedure SettingsChanged;
    procedure AddToStats(const UDStats: TUpDownloadStats);
    procedure CalcStats;
    procedure UpdateFileStats(pQ: TQueueFile; Succeeded: Boolean; FailReason: TFreenetThreadFailReason);
    function  NumBytesToStr(n: Int64): String;
    procedure SetAnchors;
    procedure FindKeysInFiles(FileList: TStringList; CommentList: TStringList = nil);
    function  ExtractKeysFromString(sLine: String; KeyList: TStringList): Integer;
    function  ExtractLinksFromString(sLine: String; KeyList: TStringList): Integer;
{$IFDEF DELPHI_7_OR_HIGHER}
    procedure LvAnyQueueInfoTip(Sender: TObject; Item: TListItem; var InfoTip: String);
{$ENDIF}
    function  MyTimeToString(dt: TDateTime; Mode: Integer): String;
    procedure LVInsWindowProc(var Msg: TMessage);
    procedure LVGetWindowProc(var Msg: TMessage);
    procedure LVAllWindowProc(var Msg: TMessage; IsLvIns: Boolean; OrigHandler: TWndMethod);
    procedure LVGetDrawProgressOnHDC(LvHDC: HDC; Item: TListItem; BGColor: TColor; BlocksColumnIndex: Integer);
    procedure SetListViewColumns(TickerAlreadyLocked: Boolean; Queues: TQueueTypes);
    procedure ColumnConfigApply(Sender: TObject);
    procedure ColumnConfigClosing(Sender: TObject);
    procedure GetCurrentColumnWidths(Queues: TQueueTypes);
    procedure CheckNodeUp;
    procedure Msg_QUERYENDSESSION(var M: TMessage); message WM_QUERYENDSESSION;
    procedure Msg_ENDSESSION(var M: TMessage); message WM_ENDSESSION;
    function  SetTrayIcon(Icon: HICON; Force: Boolean = False): Boolean;
    procedure SetTrayIconAnim(Anim: TTrayAnim);
    procedure AnimateTrayIcon;
    procedure InsFinishedNotification;
    procedure GetFinishedNotification;
    procedure SetShowInfoTip(const Value: Boolean);

    property  ShowInfoTip: Boolean read FShowInfoTip write SetShowInfoTip;
  public
    procedure GetAllGetFilenames(FilenameList: TStringList);
    property  LastGetDir: String read FLastGetDir write FLastGetDir;
    procedure LogFormClosing(Sender: TObject; var Action: TCloseAction);
    function  FindAnyQueueFileByUniqueID(ID: Int64): TQueueFile;
    function  LockTicker(ForLongOperation: Boolean = False; TimeoutMillis: Integer = 1000): Boolean;
    procedure UnLockTicker;
    property  ThreadPool: TList read FThreadPool;
  end;

var
  FrmMain: TFrmMain;

implementation

// avoid FileCtrl / faVolumeID is platform specific warning
{$IFDEF DELPHI_6_OR_HIGHER} {$WARN UNIT_PLATFORM OFF} {$WARN SYMBOL_PLATFORM OFF} {$ENDIF}

uses Winsock, Clipbrd, IniFiles, FileCtrl, ShellAPI, FCPConsole, CommCtrl,
  SHA1, AddMultipleKeys, PrepFileDetails, Misc, ClipboardFormats,
  InsertOptions, AskBaseKey, CryptUtils, Unzip, ziputils,
  FreenetWinLauncherUtils, ScanFrost, MMSystem, WaitForThread, ActiveX,
  IncompleteFile, AddSingleKey, FrostSearchProgress, FrostSearchResults;

{$R *.DFM}

const
  TRAYICON_NORMAL = 0;
  TRAYICON_SLEEP  = 1;
  TRAYICON_STOP   = 2;
  TRAYICON_GLOW   = 3;
  TRAYICON_SLEEP2 = 4;

  // Animation sequence
  TRAYANIM_SEQUENCE: Array [TTrayAnim] of record MaxCnt: Integer; IconNum: Array [0..2] of Integer; end = (
                       {taActive} (MaxCnt: 0; IconNum: (TRAYICON_NORMAL, -1,              -1); ),
                       {taSleep}  (MaxCnt: 1; IconNum: (TRAYICON_SLEEP,  TRAYICON_SLEEP2, -1); ),
                       {taStop}   (MaxCnt: 1; IconNum: (TRAYICON_STOP,   TRAYICON_NORMAL, -1); ),
                       {taGlow}   (MaxCnt: 1; IconNum: (TRAYICON_GLOW,   TRAYICON_NORMAL, -1); )
                     );

  CLIPBOARD_FILE_NAME = '**CLIPBOARD**'; // pseudo filename for scanning clipboard for keys
  COMMENT_TAG = '?COMMENT='; // comment tag appendable to keys

{ Misc }
function ExtractCommentFromKey(var AKey: String): String;
var iPos: Integer;
begin
  iPos := Pos(COMMENT_TAG, UpperCase(AKey));
  if iPos = 0 then
    Result := ''
  else begin
    Result := Copy(AKey, iPos + Length(COMMENT_TAG), Length(AKey));
    Delete(AKey, iPos, Length(AKey));
  end;
end;


{ TFrmMain }

procedure TFrmMain.FormCreate(Sender: TObject);
var
  WSData:   TWSAData;
  menuitem: TMenuItem;
  i:        Integer;
  bDebug:   Boolean;
  pColCfg:  PColumnConfig;
  pDummy:   Pointer;
begin
  Randomize;

  // init COM library
  pDummy := nil;
  OleInitialize(pDummy);

  FFormCaption := APPNAME + ' ' + VERSIONSTRING + ' - ' + APPDESC;
  Caption := FFormCaption;

  FInsertQueue := TList.Create;
  FGetQueue    := TList.Create;
  FThreadPool  := TList.Create;
  FGetPrioList := TStringList.Create;
  FClipList    := TList.Create;

  // create cached file list
  gCachedFiles := TCachedFileList.Create;

  // create custom open dialogs
  OpenDlgInsQueue := TFuqidOpenDialog.CreateWithExtensions(Self);
  OpenDlgInsQueue.Options := OpenDlgInsQueue.Options + [ofAllowMultiSelect, ofPathMustExist, ofFileMustExist];
  OpenDlgInsQueue.Title   := 'Select file(s) to add to queue';

  // init ListView columns list
  FColumnConfigList := TList.Create;
  for i := Low(DefaultColumnConfig) to High(DefaultColumnConfig) do begin
    New(pColCfg);
    pColCfg^ := DefaultColumnConfig[i];
    FColumnConfigList.Add(pColCfg);
  end;

  FStats.BytesUp := 0;
  FStats.BytesDn := 0;
  FStats.UpDownloadStatsList := TList.Create;
  FStats.AvgStartTime := 0; // start counting on first activation
  FStats.Changed := True;

  FQueueInfo[qtInsQueue].ListView   := LvInsQueue;
  FQueueInfo[qtGetQueue].ListView   := LvGetQueue;
  FQueueInfo[qtInsQueue].QueueList  := FInsertQueue;
  FQueueInfo[qtGetQueue].QueueList  := FGetQueue;
  FQueueInfo[qtInsQueue].SortColumn := -1;
  FQueueInfo[qtGetQueue].SortColumn := -1;

  FMaxThreadsPerTick := 1;

  FreenetUtils.DEFAULT_FEC_DESCRIPTION := 'Onion FEC v1.2 file inserted by ' + APPNAME;

  bDebug := False;
  if CommandLineOption('-debug') then bDebug := True;

  MiDebug1.Enabled := bDebug; MiDebug1.Visible := bDebug;
  MiDebug2.Enabled := bDebug; MiDebug2.Visible := bDebug;

  // activate default graph style
  for i := 0 to MiGetQueueGraphStyle.Count-1 do begin
    menuitem := MiGetQueueGraphStyle.Items[i];
    if menuitem.Checked then begin
      FGraphStyle := menuitem.Tag;
      break;
    end;
  end;

  // load tray icons
  FTrayIcons[TRAYICON_NORMAL] := LoadImage(HInstance, 'MAINICON',     IMAGE_ICON, 16, 16, LR_SHARED);
  FTrayIcons[TRAYICON_SLEEP]  := LoadImage(HInstance, 'XICON_SLEEP',  IMAGE_ICON, 16, 16, LR_SHARED);
  FTrayIcons[TRAYICON_SLEEP2] := LoadImage(HInstance, 'XICON_SLEEP2', IMAGE_ICON, 16, 16, LR_SHARED);
  FTrayIcons[TRAYICON_STOP]   := LoadImage(HInstance, 'XICON_STOP',   IMAGE_ICON, 16, 16, LR_SHARED);
  FTrayIcons[TRAYICON_GLOW]   := LoadImage(HInstance, 'XICON_GLOW',   IMAGE_ICON, 16, 16, LR_SHARED);

  // display tray icon
  SetTrayIconAnim(taSleep);

  SetAnchors; // before LoadQueues!

  SetListViewColumns(False, [qtInsQueue,qtGetQueue]); // before LoadQueues, because items already get set there
  LoadQueues;  // not listview items get set there now
  SetListViewColumns(False, [qtInsQueue,qtGetQueue]); // again after LoadQueues, because config has been loaded
  // only now (after applying the column config) we must set listview items!
  UpdateInsertQueue(False);
  UpdateGetQueue(False);

  // init WinSock
  if WSAStartup($0101,WSData) <> 0 then begin
    MessageDlg('Cannot initialize Winsock.',mtError,[mbOk],0);
    Application.Terminate;
  end;

  Application.OnMinimize    := AppMinimized;
  Application.OnRestore     := AppRestored;
  Application.HintPause     := 300;
  Application.HintHidePause := 10000;

{$IFDEF DELPHI_7_OR_HIGHER}
  LvInsQueue.OnInfoTip := LvAnyQueueInfoTip;
  LvGetQueue.OnInfoTip := LvAnyQueueInfoTip;
  ShowInfoTip := True;
{$ELSE}
  ShowInfoTip := False;
{$ENDIF}

  FLVInsOrigWindowProc := LvInsQueue.WindowProc;
  FLVGetOrigWindowProc := LvGetQueue.WindowProc;
  LvInsQueue.WindowProc := LVInsWindowProc;
  LvGetQueue.WindowProc := LVGetWindowProc;

  UpdateThreadDisplay;
  InitClipboardFormats;
  CheckSettings;
  SettingsChanged;
end;

procedure TFrmMain.FormShow(Sender: TObject);
begin
  if FDidOnShow then exit;
  FDidOnShow := True;

  // init ticker
  FTickerTasks := [ttAnimateTrayIcon];
  TimerTicker.Enabled := True;

  if GlobalSettings.AutoActive or CommandLineOption('-active') then
    BtStart.Click;

  if GlobalSettings.StartMini then
    Application.Minimize;

  if GlobalSettings.ClearStats then
    MiClearFileStats.Click;
end;

procedure TFrmMain.FormClose(Sender: TObject; var Action: TCloseAction);
var bRetry: Boolean;
begin
  TimerTicker.Enabled := False;
  repeat
    bRetry := False;
    try
      gCachedFiles.CloseAll(True);
    except
      on E: Exception do begin
        if MessageDlg(
               'An error occured while flushing cached data to disk:'#13
             + E.ClassName + ': ' + E.Message + #13#13
             + 'The most common reason is that the disk where Fuqid resides is full.'#13
             + 'If that is the case, free some disk space and retry.'#13#13
             + 'Retry now? (Warning: Selecting No will quit without saving)',
             mtError,
             [mbYes,mbNo],
             0
           ) = mrYes then bRetry := True;
      end;
    end;
    if bRetry then continue;

    try
      SaveQueues(False, True);
    except
      on E: Exception do begin
        if MessageDlg(
               'An error occured while saving your queues:'#13
             + E.ClassName + ': ' + E.Message + #13#13
             + 'The most common reason is that the disk where Fuqid resides is full.'#13
             + 'If that is the case, free some disk space and retry.'#13#13
             + 'Retry saving the queues now? (Warning: Selecting No will quit without saving)',
             mtError,
             [mbYes,mbNo],
             0
           ) = mrYes then bRetry := True;
      end;
    end;
  until not bRetry;
end;

procedure TFrmMain.FormDestroy(Sender: TObject);
begin
  ClearInsQueue;
  FInsertQueue.Free;
  ClearGetQueue;
  FGetQueue.Free;
  FGetPrioList.Free;
  ClipFormats_FreeList(FClipList);

  gCachedFiles.Free; gCachedFiles := nil;

  while FColumnConfigList.Count > 0 do begin
    Dispose(FColumnConfigList.Items[0]);
    FColumnConfigList.Delete(0);
  end;
  FColumnConfigList.Free;

  if FStats.UpDownloadStatsList <> nil then
    while FStats.UpDownloadStatsList.Count > 0 do begin
      Dispose(FStats.UpDownloadStatsList.Items[0]);
      FStats.UpDownloadStatsList.Delete(0);
    end;
  FStats.UpDownloadStatsList.Free;

  FThreadPool.Free;

  // shutdown WinSock
  WSACleanup();

  LvInsQueue.WindowProc := FLVInsOrigWindowProc;
  LvGetQueue.WindowProc := FLVGetOrigWindowProc;

  // free TrayIcon
  SetTrayIcon(0);

  // uninit COM library
  OleUninitialize();
end;

procedure TFrmMain.BtSettingsClick(Sender: TObject);
var OldSettings: TSettings;
begin
  OldSettings := GlobalSettings;
  TFrmSettings.Create(Self).ShowModal;
  UpdateThreadDisplay;
  if GlobalSettings.GetSpread <> OldSettings.GetSpread then UpdateGetQueue(False);
  if GlobalSettings.ClipFmts  <> OldSettings.ClipFmts  then InitClipboardFormats;
  SettingsChanged;
end;

procedure TFrmMain.MiInsQueueAddFilesClick(Sender: TObject);
var
  i:     Integer;
  Str:   TFileStream;
  Size:  DWord;
  Filename: String;
  Style: TInsertStyle;
  bAskOpts: Boolean;
  bFreeze:  Boolean;
  sComment: String;
begin
  bAskOpts := (Sender = MiAddFilesAdvanced) or (Sender = MiInsQueueAddFilesAdvanced);

  OpenDlgInsQueue.UseExtensions := True;
  if not OpenDlgInsQueue.Execute then exit;
  Style    := InsertStyle_Fuqid;
  bFreeze  := OpenDlgInsQueue.Freeze;
  sComment := OpenDlgInsQueue.Comment;
  if bAskOpts then begin
    if not AskInsertOptions(Style, bFreeze, sComment) then exit; // ask only once for all files
  end;
  for i := 0 to OpenDlgInsQueue.Files.Count-1 do begin
    Filename := OpenDlgInsQueue.Files.Strings[i];
    FLastInsDir := ExtractFilePath(Filename);
    OpenDlgInsQueue.InitialDir := '';
    try
      Str := CreateFileStream(Filename, fmOpenRead or fmShareDenyNone);
      try
        Size := Str.Size;
      finally
        Str.Free;
      end;
    except
      Size := 0;
    end;
    AddToInsQueue(False, False, Filename, '', Size, Style, bFreeze, sComment);
  end;
  UpdateInsertQueue(False);
  SaveQueues(False);
end;

procedure TFrmMain.AddToInsQueue(IsHeal, IsDirect: Boolean; Filename, Basename: String; Size: DWord; Style: TInsertStyle; AddFrozen: Boolean; Comment: String);
var
  p:     TInsQueueFile;
begin
  if IsDirect then Assert(Basename <> '');
  if IsHeal   then Assert(IsDirect);

  p := TInsQueueFile.Create;
  try
    if Basename <> '' then p.Status := ifsReady else p.Status := ifsUnprepared;
    p.OrgFilename   := Filename;
    p.PrepBasename  := Basename;
    p.Size          := Size;
    p.DateAdded     := Now;
    p.Freeze        := AddFrozen;
    p.Key           := '';
    p.Progress      := '';
    p.IsHeal        := IsHeal;
    p.IsDirect      := IsDirect;
    p.InsertStyle   := Style;
    p.HeaderInserts := 0;
    p.Comment       := Comment;
    FInsertQueue.Add(p);
  except
    p.Free; raise;
  end;
end;

function TFrmMain.UserInputToKey(Input: String; var Filename,Comment: String; AutoMode: Boolean): String;

  function LooksLikeFreenetKey(s: String): Boolean;
  begin
    Result := (CompareText(Copy(s,1,4), 'KSK@') = 0)
           or (CompareText(Copy(s,1,4), 'SSK@') = 0)
           or (CompareText(Copy(s,1,4), 'CHK@') = 0)
           or (CompareText(Copy(s,1,4), 'SVK@') = 0);
  end;

const
  HEXDIGS = ['0'..'9','A'..'F','a'..'f'];
  INVCHARS = [':','\','/','<','>','*','?'];
var
  sKey,s,sF: String;
  i:      Integer;
begin
  Filename := ''; Result := ''; Comment := '';

  sKey := Trim(Input);
  if (Pos(#10,sKey) <> 0) then Delete(sKey,Pos(#10,sKey),Length(sKey));
  if (Pos(#13,sKey) <> 0) then Delete(sKey,Pos(#13,sKey),Length(sKey));
  sKey := Trim(sKey);
  if sKey = '' then exit;

  s := 'http://'; // remove standard fproxy prefix if present
  if CompareText(Copy(sKey,1,Length(s)),s) = 0 then begin
    Delete(sKey,1,Length(s)); Delete(sKey,1,Pos('/',sKey));
  end else begin
    // for saved freenet pages:
    s := 'file://'; // remove standard fproxy prefix if present
    if CompareText(Copy(sKey,1,Length(s)),s) = 0 then begin
      Delete(sKey,1,Length(s)); Delete(sKey,1,Pos('/',sKey));
    end;
  end;
  sKey := RemoveFreenetPrefix(sKey); // remove freenet: prefix

  // convert Frost attachment format (copied from frost filelist)
  if  (CompareText(Copy(sKey,1,10),'<attached>') = 0)
  and (CompareText(Copy(sKey,Length(sKey)-11+1,11),'</attached>') = 0)
  and (Pos(' * ', sKey) <> 0) then begin
    Delete(sKey,1,10); Delete(sKey,Length(sKey)-11+1,11);
    s := Copy(sKey, Pos(' * ', sKey)+3, Length(sKey));
    Delete(sKey, Pos(' * ', sKey), Length(sKey));
    sKey := Trim(s) + '/' + Trim(sKey);
  end else if Pos(#9, sKey) <> 0 then begin
    // convert frost attachment copied from a frost message
    s := Trim(Copy(sKey,Pos(#9,sKey)+1,Length(sKey)));
    sF := Trim(Copy(sKey,1,Pos(#9,sKey)-1));
    if LooksLikeFreenetKey(s) then begin
      sKey := s + '/' + sF;
    end;
  end;


  // decode uri-encoded chars
  s := sKey; sKey := '';
  while Pos('%',s) <> 0 do begin
    sKey := sKey + Copy(s,1,Pos('%',s)-1); Delete(s,1,Pos('%',s));
    if (Length(s) < 2) or (not (s[1] in HEXDIGS)) or (not (s[2] in HEXDIGS)) then
      sKey := sKey + '%'
    else begin
      sKey := sKey + Chr(StrToInt('$'+Copy(s,1,2)));
      Delete(s,1,2);
    end;
  end;
  sKey := Trim(sKey + s);

  Comment := ExtractCommentFromKey(sKey);

  // does it look like a freenet key?
  if not LooksLikeFreenetKey(sKey) then begin
    if AutoMode then raise EAbort.Create('Not a valid freenet key');
    case MessageDlg('The requested Key '+sKey+'doesn''t look like a freenet key.'#13
                    +'Freenet Keys begin with KSK@, SSK@, CHK@ or SVK@.'#13#13
                    +'Press Retry to enter a different key or Ignore to try to retrieve the key anyway.',
                    mtWarning, [mbRetry,mbIgnore,mbAbort], 0
                   ) of
      mrRetry: exit;
      mrAbort: raise EAbort.Create('Not a valid freenet key');
    end;
  end;

  s := sKey;
  while Pos('/',s) <> 0 do Delete(s,1,Pos('/',s));
  for i := 1 to Length(s) do
    if s[i] in INVCHARS then s[i] := '_'; // save dialog won't show with invalid filename!
  Filename := s;
  Result := sKey;
end;


procedure TFrmMain.MiGetQueueAddKeyClick(Sender: TObject);
begin
  AddKeys(Clipboard.AsText);
end;

procedure TFrmMain.AddKeys(ClipboardText: String);
var
  KeyList,FileList,CommentList: TStringList;

  procedure MergeItems(ItemToRemove,ItemToRemain: Integer);
  begin
    if CommentList.Strings[ItemToRemain] = '' then
      CommentList.Strings[ItemToRemain] := CommentList.Strings[ItemToRemove];
    KeyList.Delete(ItemToRemove);
    FileList.Delete(ItemToRemove);
    CommentList.Delete(ItemToRemove);
  end;

var
  sKey,s,sMore: String;
  p:      TGetQueueFile;
  i,j,iPos: Integer;
  ok:     Boolean;
  sComment,sDummy: String;
  bFreeze:         Boolean;
begin
  KeyList := nil; FileList := nil; CommentList := nil;
  try
    KeyList     := TStringList.Create;
    FileList    := TStringList.Create;
    CommentList := TStringList.Create;

//    try sKey := Trim(Clipboard.AsText); except sKey := ''; end;
//    if (Pos(#10,sKey) <> 0) then Delete(sKey,Pos(#10,sKey),Length(sKey));
//    if (Pos(#13,sKey) <> 0) then Delete(sKey,Pos(#13,sKey),Length(sKey));
//    sKey := Trim(sKey);

    try sMore := Trim(ClipboardText); except sMore := ''; end;
    // replace CRLF by LF
    while Pos(#13#10,sMore) <> 0 do Delete(sMore, Pos(#13#10,sMore), 1);
    // replace CR by LF
    while Pos(#13,sMore) <> 0 do sMore[Pos(#13,sMore)] := #10;
    // // replace TAB by LF
    // while Pos(#9,sMore) <> 0 do sMore[Pos(#9,sMore)] := #10;
    // remove consecutive LFs
    while Pos(#10#10,sMore) <> 0 do Delete(sMore, Pos(#10#10,sMore), 1);

    while sMore <> '' do begin
      iPos := Pos(#10,sMore);
      if iPos > 0 then begin
        sKey := Trim(Copy(sMore,1,iPos-1)); Delete(sMore,1,iPos);
      end else begin
        sKey := sMore; sMore := '';
      end;
      try
        if sKey <> '' then sKey := UserInputToKey(sKey, s, sComment, True); // no dialogs
      except
        sKey := '';
      end;
      if sKey <> '' then begin
        KeyList.Add(sKey); FileList.Add(FLastGetDir + s); CommentList.Add(sComment);
      end;
    end;

    // remove duplicate keys
    i := 0;
    while i < KeyList.Count do begin
      j := i+1;
      while j < KeyList.Count do begin
        if KeyList.Strings[j] = KeyList.Strings[i] then
          MergeItems(j,i)
        else
          inc(j);
      end;
      inc(i);
    end;

    // remove simple keys (without filename) if we have the same key with filename
    i := 0;
    while i < KeyList.Count do begin
      ok := True;
      if Pos('/', KeyList.Strings[i]) = 0 then begin
        for j := 0 to KeyList.Count-1 do begin
          if (j <> i) and (Copy(KeyList.Strings[j], 1, Length(KeyList.Strings[i])) = KeyList.Strings[i]) then begin
            ok := False;
            MergeItems(i,j);
            break;
          end;
        end;
      end;
      if ok then inc(i);
    end;


    if KeyList.Count > 1 then begin

      if not AskKeys(KeyList,FileList,CommentList) then exit;
      if KeyList.Count = 0 then exit;

    end else begin

      if KeyList.Count > 0 then begin
        sKey     := KeyList.Strings[0];
        sComment := CommentList.Strings[0];
      end else begin
        sKey := ''; sComment := '';
      end;

      repeat
        // if not InputQuery('Add to download queue','Key to retrieve:',sKey) then exit;
        if not AskSingleKey(sKey, sComment, bFreeze) then exit;
        if sKey = '' then exit;

        try
          sKey := UserInputToKey(sKey, s, sDummy, False);
        except
          on EAbort do exit
          else raise;
        end;
      until sKey <> '';

      repeat
        SaveDlgGetQueue.FileName := ExtractFilePath(FLastGetDir) + s;
        if not ExecuteSaveDialogSafely(SaveDlgGetQueue) then exit;
        FLastGetDir := ExtractFilePath(SaveDlgGetQueue.FileName);
        SaveDlgGetQueue.InitialDir := '';
        s := SaveDlgGetQueue.FileName;

        // check if the same filename is already used in download queue
        ok := True;
        if not FileExists(s) then begin
          if LockTicker then
            try
              for i := 0 to FGetQueue.Count-1 do begin
                p := FGetQueue.Items[i];
                if CompareText(p.SavFilename,s) = 0 then begin
                  MessageDlg('You already use the same filename for another entry in your download queue!',mtError,[mbOk],0);
                  ok := False; break;
                end;
              end;
            finally
              UnlockTicker;
            end;
        end;
      until ok;

      KeyList.Clear; FileList.Clear; CommentList.Clear;
      KeyList.AddObject(sKey, Pointer(bFreeze));
      FileList.Add(SaveDlgGetQueue.FileName);
      CommentList.Add(sComment);

    end;

    AddKeysToGetQueue(KeyList,FileList,CommentList);

  finally
    KeyList.Free;
    FileList.Free;
    CommentList.Free;
  end;
end;

procedure TFrmMain.AddKeysToGetQueue(KeyList,FilenameList,CommentList: TStringList);
// if object of KeyList <> nil: Freeze
var
  i: Integer;
  p: TGetQueueFile;
begin
  Assert(KeyList.Count = FilenameList.Count);
  if not LockTicker then exit;
  try
    for i := 0 to KeyList.Count-1 do begin
      p := TGetQueueFile.Create;
      p.Status       := gfsReady;
      p.SavFilename  := FilenameList.Strings[i];
      p.PrepBasename := '';
      p.Size         := 0;
      p.DateAdded    := Now;
      p.Freeze       := (KeyList.Objects[i] <> nil);
      p.Key          := KeyList.Strings[i];
      p.Comment      := CommentList.Strings[i];
      p.Activekey    := p.Key;
      p.Progress     := '';
      p.CheckSum     := '';
      p.Retry        := 0;
      p.BlockStat    := '';
      p.RestartAt    := 0;
      p.Priority     := 0;
      FGetQueue.Add(p);
    end;
    UpdateGetQueue(True);
    SaveQueues(True);
  finally
    UnlockTicker;
  end;
end;


procedure TFrmMain.UpdateQueue(ListView: TListView; QueueList: TList; TickerAlreadyLocked: Boolean);
var
  i:    Integer;
  item: TListItem;
  OrgOrder: TList;
  p:        Pointer;
begin
  if not TickerAlreadyLocked then begin
    if not LockTicker then exit;
  end;
  try
    OrgOrder := nil;
    ListView.Items.BeginUpdate;
    try
      OrgOrder := TList.Create;
      for i := 0 to ListView.Items.Count-1 do begin
        p := ListView.Items[i].Data;
        if QueueList.IndexOf(p) >= 0 then OrgOrder.Add(p);
      end;

      ListView.Items.Clear;

      for i := 0 to OrgOrder.Count-1 do begin
        item := ListView.Items.Add;
        item.Data := OrgOrder.Items[i];
        if ListView = LvInsQueue then
          SetInsQueueListItem(item)
        else
          SetGetQueueListItem(item);
      end;

      // now add added items
      for i := 0 to QueueList.Count-1 do begin
        if OrgOrder.IndexOf(QueueList.Items[i]) < 0 then begin
          item := ListView.Items.Add;
          item.Data := QueueList.Items[i];
          if ListView = LvInsQueue then
            SetInsQueueListItem(item)
          else
            SetGetQueueListItem(item);
        end;
      end;
    finally
      ListView.Items.EndUpdate;
      OrgOrder.Free;
    end;
  finally
    if not TickerAlreadyLocked then UnlockTicker;
  end;
end;

procedure TFrmMain.UpdateInsertQueue(TickerAlreadyLocked: Boolean);
begin
  UpdateQueue(LvInsQueue, FInsertQueue, TickerAlreadyLocked);
end;

procedure TFrmMain.UpdateGetQueue(TickerAlreadyLocked: Boolean);
begin
  UpdateQueue(LvGetQueue, FGetQueue, TickerAlreadyLocked);
end;


procedure TFrmMain.SetInsQueueListItem(item: TListItem; AddToNumThreads: Integer);
var
  p: TInsQueueFile;
  s: String;
  n,cnt: Integer;
  col: TInsColumn;
  i:   Integer;
  pColCfg: PColumnConfig;
begin
  p := item.Data;
  n := p.NumActiveThreads + AddToNumThreads;
  for col := Low(TInsColumn) to High(TInsColumn) do begin
    case col of
      inscol_STATUS:
        begin
          case p.Status of
            ifsUnprepared: s := 'Unprepared';
            ifsPreparing:  s := 'Preparing';
            ifsReady:      s := 'Ready';
            ifsInserting:  if n > 0 then
                             s := 'Inserting'
                           else
                             s := 'Waiting';
            ifsDone:       s := 'Done';
            ifsError:      s := 'ERROR';
            ifsAborting:   s := 'Aborting';
            else           s := 'Unknown';
          end;
          if p.Freeze then Insert('[Frozen] ',s,1);
        end;

      inscol_FILE:
        s := ExtractFileName(p.OrgFilename);

      inscol_SIZE:
        if p.Size = 0 then s := '' else s := Format('%.2f',[p.Size / (1024*1024)]);

      inscol_DATE:
        begin
          pColCfg := GetColumnConfigForColumn(FColumnConfigList, col);
          if p.DateAdded = 0 then s := '' else s := MyTimeToString(p.DateAdded, pColCfg^.Option);
        end;

      inscol_KEY:
        s := p.Key;

      inscol_THREADS:
        if n > 0 then s := IntToStr(n) else s := '';

      inscol_PROGRESS:
        s := p.Progress;

      inscol_NUMSUCC:
        s := IntToStr(p.Stats[fstSession].SuccCount);

      inscol_LASTSUCC:
        begin
          pColCfg := GetColumnConfigForColumn(FColumnConfigList, col);
          if p.Stats[fstSession].LastSucc = 0 then s := '' else s := MyTimeToString(p.Stats[fstSession].LastSucc, pColCfg^.Option);
        end;

      inscol_NUMFAIL:
        s := IntToStr(p.Stats[fstSession].FailCountTotal);

      inscol_LASTFAIL:
        begin
          pColCfg := GetColumnConfigForColumn(FColumnConfigList, col);
          if p.Stats[fstSession].LastFail = 0 then s := '' else s := MyTimeToString(p.Stats[fstSession].LastFail, pColCfg^.Option);
        end;

      inscol_COMMENT:
        s := p.Comment;

      else
        continue;
    end;
    p.DisplayColumns[col] := s;
  end;


  // adjust number of subitems
  cnt := 0;
  for i := 0 to FColumnConfigList.Count-1 do begin
    pColCfg := FColumnConfigList.Items[i];
    if pColCfg^.InsQueue and pColCfg^.Visible and (pColCfg^.Index > 0) then inc(cnt);
  end;
  while item.SubItems.Count > cnt do item.SubItems.Delete(0);
  while item.SubItems.Count < cnt do item.SubItems.Add('');

  for i := 0 to FColumnConfigList.Count-1 do begin
    pColCfg := FColumnConfigList.Items[i];
    if pColCfg^.InsQueue and pColCfg^.Visible then begin
      s := p.DisplayColumns[TInsColumn(pColCfg^.Column)];
      if pColCfg^.Index = 0 then begin
        if (item.Caption <> s) or p.FullRepaint then item.Caption := s;
      end else begin
        if (item.SubItems[pColCfg^.Index-1] <> s) or p.FullRepaint then item.SubItems[pColCfg^.Index-1] := s;
      end;
    end;
  end;
end;

procedure TFrmMain.SetGetQueueListItem(item: TListItem; AddToNumThreads: Integer);
var
  p:   TGetQueueFile;
  s:   String;
  col: TGetColumn;
  n,cnt,i: Integer;
  pColCfg: PColumnConfig;
begin
  p  := item.Data;
  n  := p.NumActiveThreads + AddToNumThreads;

  for col := Low(TGetColumn) to High(TGetColumn) do begin
    case col of
      getcol_STATUS:
        begin
          case p.Status of
            gfsReady:      s := 'Ready';
            gfsGetting:    begin
                             if n > 0 then
                               s := 'Downloading'
                             else
                               s := 'Waiting';
                           end;
            gfsDecoding:   s := 'Decoding';
            gfsDecoded:    s := 'Unvalidated';
            gfsValidating: s := 'Validating';
            gfsDone:       s := 'Done';
            gfsError:      s := 'ERROR';
            gfsAborting:   s := 'Aborting';
            else           s := 'Unknown';
          end;
          if p.Freeze then Insert('[Frozen] ',s,1);
        end;

      getcol_PRI:
        begin
          if GlobalSettings.GetSpread then
            case p.Priority of
              -2:  s := 'Lowest';
              -1:  s := 'Low';
               1:  s := 'High';
               2:  s := 'Highest';
              else s := 'Normal';
            end
          else
            s := '-';
        end;

      getcol_DIR:
        s := ExtractFilePath(p.SavFilename);

      getcol_FILE:
        s := ExtractFileName(p.SavFilename);

      getcol_SIZE:
        if p.Size = 0 then s := '' else s := Format('%.2f',[p.Size / (1024*1024)]);

      getcol_DATE:
        begin
          pColCfg := GetColumnConfigForColumn(FColumnConfigList, col);
          if p.DateAdded = 0 then s := '' else s := MyTimeToString(p.DateAdded, pColCfg^.Option);
        end;

      getcol_KEY:
        s := p.Key;

      getcol_THREADS:
        if n > 0 then s := IntToStr(n) else s := '';

      getcol_PROGRESS:
        s := p.Progress;

      getcol_BLOCKS:
        s := p.BlockStat;

      getcol_NUMSUCC:
        s := IntToStr(p.Stats[fstSession].SuccCount);

      getcol_LASTSUCC:
        begin
          pColCfg := GetColumnConfigForColumn(FColumnConfigList, col);
          if p.Stats[fstSession].LastSucc = 0 then s := '' else s := MyTimeToString(p.Stats[fstSession].LastSucc, pColCfg^.Option);
        end;

      getcol_NUMFAIL:
        s := IntToStr(p.Stats[fstSession].FailCountTotal);

      getcol_LASTFAIL:
        begin
          pColCfg := GetColumnConfigForColumn(FColumnConfigList, col);
          if p.Stats[fstSession].LastFail = 0 then s := '' else s := MyTimeToString(p.Stats[fstSession].LastFail, pColCfg^.Option);
        end;

      getcol_COMMENT:
        s := p.Comment;

      else
        continue;
    end;
    p.DisplayColumns[col] := s;
  end;

  // adjust number of subitems
  cnt := 0;
  for i := 0 to FColumnConfigList.Count-1 do begin
    pColCfg := FColumnConfigList.Items[i];
    if (not pColCfg^.InsQueue) and pColCfg^.Visible and (pColCfg^.Index > 0) then inc(cnt);
  end;
  while item.SubItems.Count > cnt do item.SubItems.Delete(0);
  while item.SubItems.Count < cnt do item.SubItems.Add('');

  for i := 0 to FColumnConfigList.Count-1 do begin
    pColCfg := FColumnConfigList.Items[i];
    if (not pColCfg^.InsQueue) and pColCfg^.Visible then begin
      s := p.DisplayColumns[TGetColumn(pColCfg^.Column)];
      if pColCfg^.Index = 0 then begin
        if (item.Caption <> s) or p.FullRepaint then item.Caption := s;
      end else begin
        if (item.SubItems[pColCfg^.Index-1] <> s) or p.FullRepaint then item.SubItems[pColCfg^.Index-1] := s;
      end;
    end;
  end;
end;

procedure TFrmMain.SetAnyQueueListItem(qt: TQueueType; item: TListItem; AddToNumThreads: Integer);
begin
  if qt = qtInsQueue then
    SetInsQueueListItem(item, AddToNumThreads)
  else
    SetGetQueueListItem(item, AddToNumThreads);
end;

procedure TFrmMain.MiInsQueueRemoveClick(Sender: TObject);
var
  RemList: TList;
  i:       Integer;
  item:    TListItem;
  p:       TInsQueueFile;
  Cnt:     Integer;
  Lck:     Boolean;
begin
  RemList := nil; Cnt := 0; Lck := False;
  LvInsQueue.Items.BeginUpdate;
  try
    Lck := LockTicker; if not Lck then exit;
    RemList := TList.Create;
    for i := 0 to LvInsQueue.Items.Count-1 do
      if LvInsQueue.Items[i].Selected then
        RemList.Add(LvInsQueue.Items[i]);
    for i := 0 to RemList.Count-1 do begin
      item := RemList.Items[i];
      p := item.Data;
      if p.Status in [ifsInserting,ifsPreparing,ifsAborting] then
        Cnt := Cnt + 1
      else
        DeleteInsQueueItem(item)
    end;
  finally
    if Lck then UnlockTicker;
    LvInsQueue.Items.EndUpdate;
    RemList.Free;
  end;
  SaveQueues(False);
  if Cnt > 0 then MessageDlg(Format('%d file(s) not removed, because they are being inserted or prepared right now.',[Cnt]),mtInformation,[mbOk],0);
end;

procedure TFrmMain.MiGetQueueRemoveClick(Sender: TObject);
var
  RemList: TList;
  i:       Integer;
  item:    TListItem;
  p:       TGetQueueFile;
  Cnt:     Integer;
  Lck:     Boolean;
begin
  RemList := nil; Cnt := 0; Lck := False;
  LvGetQueue.Items.BeginUpdate;
  try
    Lck := LockTicker; if not Lck then exit;
    RemList := TList.Create;
    for i := 0 to LvGetQueue.Items.Count-1 do
      if LvGetQueue.Items[i].Selected then
        RemList.Add(LvGetQueue.Items[i]);
    for i := 0 to RemList.Count-1 do begin
      item := RemList.Items[i];
      p := item.Data;
      if p.Status in [gfsGetting,gfsDecoding,gfsValidating,gfsAborting] then
        Cnt := Cnt + 1
      else
        DeleteGetQueueItem(item)
    end;
  finally
    if Lck then UnlockTicker;
    LvGetQueue.Items.EndUpdate;
    RemList.Free;
  end;
  SaveQueues(False);
  if Cnt > 0 then MessageDlg(Format('%d file(s) not removed, because they are being downloaded or decoded right now.',[Cnt]),mtInformation,[mbOk],0);
end;

procedure TFrmMain.MiGetQueueChangeFolderClick(Sender: TObject);
var
  i,j:     Integer;
  item:    TListItem;
  p,p2:    TGetQueueFile;
  Cnt:     Array [1..3] of Integer;
  sOldTit: String;
  sOldOpt: TOpenOptions;
  sNewPath: String;
  sNewName: String;
  ok:       Boolean;
  s:        String;
begin
  if LvGetQueue.SelCount = 0 then exit;

  sOldTit := SaveDlgGetQueue.Title;
  sOldOpt := SaveDlgGetQueue.Options;
  try
    SaveDlgGetQueue.Title   := 'Go into download dir and press Ok';
    SaveDlgGetQueue.Options := sOldOpt - [ofOverwritePrompt];
    SaveDlgGetQueue.FileName := '(Dummy-File, leave this alone)';
    if not SaveDlgGetQueue.Execute then exit;
    sNewPath := ExtractFilePath(SaveDlgGetQueue.FileName);
    if sNewPath = '' then exit;
  finally
    SaveDlgGetQueue.Title   := sOldTit;
    SaveDlgGetQueue.Options := sOldOpt;
  end;

  for i := Low(Cnt) to High(Cnt) do Cnt[i] := 0;
  if not LockTicker then exit;
  try
    for i := 0 to LvGetQueue.Items.Count-1 do begin
      if LvGetQueue.Items[i].Selected then begin
        item := LvGetQueue.Items[i];
        p := item.Data;
        sNewName := sNewPath + ExtractFilename(p.SavFilename);
        if CompareText(p.SavFilename, sNewName) = 0 then continue;
        if p.Status = gfsDone then
          inc(Cnt[1])
        else if FileExists(sNewName) then
          inc(Cnt[2])
        else begin
          ok := True;
          for j := 0 to LvGetQueue.Items.Count-1 do begin
            if j = i then continue;
            p2 := LvGetQueue.Items[j].Data;
            if CompareText(p2.SavFilename, sNewName) = 0 then begin
              inc(Cnt[3]); ok := False; break;
            end;
          end;
          if ok then begin
            p.SavFilename := sNewName;
            SetGetQueueListItem(item);
          end;
        end;
      end;
    end;
  finally
    UnlockTicker;
  end;
  SaveQueues(False);
  s := '';
  if Cnt[1] <> 0 then s := s + #13 + Format('%d file(s) have already been saved (status Done).',[Cnt[1]]);
  if Cnt[2] <> 0 then s := s + #13 + Format('%d file(s) already exist in the chosen save folder.',[Cnt[2]]);
  if Cnt[3] <> 0 then s := s + #13 + Format('%d file(s) already are in the download queue with the new savename.',[Cnt[3]]);
  if s <> '' then
    MessageDlg('Some file(s) not changed:'#13 + s,mtInformation,[mbOk],0);
end;


procedure TFrmMain.MiGetQueueRetryClick(Sender: TObject);
var
  i,j: Integer;
  pG: TGetQueueFile;
  PrepFile: TPreparedFile;
  bActiveGets: Boolean;
begin
  bActiveGets := False;
  if not LockTicker then exit;
  try
    for i := 0 to LvGetQueue.Items.Count-1 do begin
      if LvGetQueue.Items[i].Selected then begin
        pG := LvGetQueue.Items[i].Data;
        if not (pG.Status in [gfsGetting,gfsError]) then continue;

        if (pG.Status = gfsGetting) and (pG.NumActiveThreads > 0) then begin
          bActiveGets := True;
          continue;
        end;

        if pG.PrepBasename <> '' then begin
          PrepFile := TPreparedFile.CreateDownload(pG.PrepBasename);
          try
            // reset try count for all unfinished blocks
            PrepFile.ReadHeader;
            for j := 0 to PrepFile.NumBlocks-1 do
              if not PrepFile.BlockDone[j] then begin
                PrepFile.BlockTries[j] := 0;
                PrepFile.BlockWorking[j] := False;
              end;
            PrepFile.WriteHeader; // ok, no active threads
            pG.BlockStat := PrepFile.GetBlockStatusString;
          finally
            PrepFile.Free;
          end;
          pG.Status := gfsGetting; // Splitfile and got metadata
        end else
          pG.Status := gfsReady; // not got metadata yet
        pG.Retry := 0;
        pG.RestartAt := 0;
        SetGetQueueListItem(LvGetQueue.Items[i]);
      end;
    end;
    SaveQueues(True);
  finally
    UnlockTicker;
  end;

  if bActiveGets then
    MessageDlg('One or more of the selected items have running threads associated and cannot be retried now.',mtInformation,[mbOk],0);
end;


function AnyQueueMoveCompare(lParam1, lParam2, lParamSort: Integer): Integer stdcall;
begin
  Result := TList(lParamSort).IndexOf(Pointer(lParam1))
          - TList(lParamSort).IndexOf(Pointer(lParam2));
end;

procedure TFrmMain.MiAnyQueueMoveClick(Sender: TObject);
var
  SortList:   TList;
  i:          Integer;
  MoveUp:     Boolean;
  item,item2: TListItem;
  idxS,idxE,incr: Integer;
  ListView:   TListView;
begin
  MoveUp := (Sender = BtInsQueueMoveUp) or (Sender = MiInsQueueMoveUp)
         or (Sender = BtGetQueueMoveUp) or (Sender = MiGetQueueMoveUp);
  ListView := nil;
  if (Sender = BtInsQueueMoveUp) or (Sender = BtInsQueueMoveDown)
  or (Sender = MiInsQueueMoveUp) or (Sender = MiInsQueueMoveDown) then ListView := LvInsQueue;
  if (Sender = BtGetQueueMoveUp) or (Sender = BtGetQueueMoveDown)
  or (Sender = MiGetQueueMoveUp) or (Sender = MiGetQueueMoveDown) then ListView := LvGetQueue;
  if (ListView = nil) or (ListView.Items.Count < 2) then exit;

  SortList := nil;
  if not LockTicker then exit;
  try
    SortList := TList.Create;

    for i := 0 to ListView.Items.Count-1 do SortList.Add(ListView.Items[i]);
    if MoveUp then begin
      idxS := 1; idxE := SortList.Count; incr := 1;
    end else begin
      idxS := SortList.Count-2; idxE := -1; incr := -1;
    end;
    i := idxS;
    while i <> idxE do begin
      item  := SortList.Items[i];
      item2 := SortList.Items[i-incr];
      if item.Selected and (not item2.Selected) then begin
        SortList.Items[i]      := item2;
        SortList.Items[i-incr] := item;
      end;
      inc(i,incr);
    end;
    ListView.CustomSort(AnyQueueMoveCompare, Integer(SortList));
  finally
    UnlockTicker;
    SortList.Free;
  end;
end;

function  ProgressStringSortValue(S: String): Integer;
// sort order:
// Header(try..) - Redirect(try) - 0% .. 100% - others
var iPos: Integer;
begin
  if s = '' then
    Result := -2000
  else if (CompareText(Copy(S,1,6),'Header') = 0) or (CompareText(Copy(S,1,8),'Redirect') = 0) then begin
    if (CompareText(Copy(S,1,6),'Header') = 0) then Result := -1000 else Result := -500;
    iPos := Pos('(try',S);
    if iPos <> 0 then begin
      Delete(S,1,iPos+3);
      iPos := Pos(')',S);
      if iPos <> 0 then begin
        Result := Result + StrToIntDef(Trim(Copy(S,1,iPos-1)),0);
      end;
    end;
  end else if S[1] in ['0'..'9'] then begin
    iPos := 2; while (iPos <= Length(S)) and (S[iPos] in ['0'..'9']) do inc(iPos);
    Result := StrToIntDef(Copy(S,1,iPos-1),0);
  end else
    Result := 1000;
end;

procedure TFrmMain.LvInsQueueCompare(Sender: TObject; Item1,Item2: TListItem; Data: Integer; var Compare: Integer);
const qt = qtInsQueue;
var
  s1,s2: String;
  p1,p2: TInsQueueFile;
begin
  Compare := 0;
  p1 := Item1.Data; p2 := Item2.Data;
  if (FQueueInfo[qt].SortColumn < Ord(Low(TInsColumn))) or (FQueueInfo[qt].SortColumn > Ord(High(TInsColumn))) then exit;
  s1 := p1.DisplayColumns[TInsColumn(FQueueInfo[qt].SortColumn)];
  s2 := p2.DisplayColumns[TInsColumn(FQueueInfo[qt].SortColumn)];
  case FQueueInfo[qt].SortColumn of
    Ord(inscol_SIZE):
      if p1.Size < p2.Size then Compare := -1 else if p1.Size > p2.Size then Compare := 1;
    Ord(inscol_DATE):
      if p1.DateAdded < p2.DateAdded then Compare := -1 else if p1.DateAdded > p2.DateAdded then Compare := 1;
    Ord(inscol_THREADS),
    Ord(inscol_NUMSUCC),
    Ord(inscol_NUMFAIL):
      Compare := StrToIntDef(s1,0) - StrToIntDef(s2,0);
    Ord(inscol_PROGRESS):
      begin
        Compare := ProgressStringSortValue(s1) - ProgressStringSortValue(s2);
        if Compare = 0 then Compare := AnsiCompareText(s2,s2);
      end;
    Ord(inscol_LASTSUCC):
      if p1.Stats[fstSession].LastSucc < p2.Stats[fstSession].LastSucc then Compare := -1 else if p1.Stats[fstSession].LastSucc > p2.Stats[fstSession].LastSucc then Compare := 1;
    Ord(inscol_LASTFAIL):
      if p1.Stats[fstSession].LastFail < p2.Stats[fstSession].LastFail then Compare := -1 else if p1.Stats[fstSession].LastFail > p2.Stats[fstSession].LastFail then Compare := 1;
    else
      Compare := AnsiCompareText(s1,s2);
  end;
  if FQueueInfo[qt].SortInverted then Compare := -Compare;
end;

procedure TFrmMain.LvGetQueueCompare(Sender: TObject; Item1,Item2: TListItem; Data: Integer; var Compare: Integer);
const qt = qtGetQueue;
var
  s1,s2: String;
  p1,p2: TGetQueueFile;
begin
  Compare := 0;
  p1 := Item1.Data; p2 := Item2.Data;
  if (FQueueInfo[qt].SortColumn < Ord(Low(TGetColumn))) or (FQueueInfo[qt].SortColumn > Ord(High(TGetColumn))) then exit;
  s1 := p1.DisplayColumns[TGetColumn(FQueueInfo[qt].SortColumn)];
  s2 := p2.DisplayColumns[TGetColumn(FQueueInfo[qt].SortColumn)];
  case FQueueInfo[qt].SortColumn of
    Ord(getcol_PRI):
      Compare := Ord(p1.Priority) - Ord(p2.Priority);
    Ord(getcol_SIZE):
      if p1.Size < p2.Size then Compare := -1 else if p1.Size > p2.Size then Compare := 1;
    Ord(getcol_DATE):
      if p1.DateAdded < p2.DateAdded then Compare := -1 else if p1.DateAdded > p2.DateAdded then Compare := 1;
    Ord(getcol_THREADS),
    Ord(getcol_NUMSUCC),
    Ord(getcol_NUMFAIL):
      Compare := StrToIntDef(s1,0) - StrToIntDef(s2,0);
    Ord(getcol_PROGRESS):
      begin
        Compare := ProgressStringSortValue(s1) - ProgressStringSortValue(s2);
        if Compare = 0 then Compare := AnsiCompareText(s1,s2);
      end;
    Ord(getcol_LASTSUCC):
      if p1.Stats[fstSession].LastSucc < p2.Stats[fstSession].LastSucc then Compare := -1 else if p1.Stats[fstSession].LastSucc > p2.Stats[fstSession].LastSucc then Compare := 1;
    Ord(getcol_LASTFAIL):
      if p1.Stats[fstSession].LastFail < p2.Stats[fstSession].LastFail then Compare := -1 else if p1.Stats[fstSession].LastFail > p2.Stats[fstSession].LastFail then Compare := 1;
    else
      Compare := AnsiCompareText(s1,s2);
  end;
  if FQueueInfo[qt].SortInverted then Compare := -Compare;
end;

procedure TFrmMain.LvAnyQueueColumnClick(Sender: TObject; Column: TListColumn);
var
  qt:           TQueueType;
  NewSortCol,i: Integer;
  pColCfg:      PColumnConfig;
begin
  if not LockTicker then exit;
  try
    if not FindQueueType(Sender, qt) then exit;

    NewSortCol := -1;
    for i := 0 to FColumnConfigList.Count-1 do begin
      pColCfg := FColumnConfigList.Items[i];
      if (pColCfg^.InsQueue = (qt = qtInsQueue)) and pColCfg^.Visible and (pColCfg^.Index = Column.Index) then begin
        NewSortCol := pColCfg^.Column;
        break;
      end;
    end;

    if NewSortCol = FQueueInfo[qt].SortColumn then
      FQueueInfo[qt].SortInverted := not FQueueInfo[qt].SortInverted
    else begin
      FQueueInfo[qt].SortColumn   := NewSortCol;
      FQueueInfo[qt].SortInverted := False;
    end;
    FQueueInfo[qt].ListView.CustomSort(nil,0);
  finally
    UnlockTicker;
  end;
end;


procedure TFrmMain.MiAnyQueueFreezeClick(Sender: TObject);
var
  i:                 Integer;
  item:              TListItem;
  pI:                TInsQueueFile;
  pG:                TGetQueueFile;
  bDoFreeze:         Boolean;
  ListView:          TListView;
begin
  bDoFreeze := (Sender = MiInsQueueFreeze) or (Sender = MiGetQueueFreeze);
  ListView := nil;
  if (Sender = MiInsQueueFreeze) or (Sender = MiInsQueueUnfreeze) then ListView := LvInsQueue;
  if (Sender = MiGetQueueFreeze) or (Sender = MiGetQueueUnfreeze) then ListView := LvGetQueue;
  if ListView = nil then exit;
  if not LockTicker then exit;
  try
    for i := 0 to ListView.Items.Count-1 do begin
      item := ListView.Items[i];
      if item.Selected then begin
        if ListView = LvInsQueue then begin
          pI := item.Data;
          pI.Freeze := bDoFreeze;
          SetInsQueueListItem(item);
        end else begin
          pG := item.Data;
          pG.Freeze := bDoFreeze;
          SetGetQueueListItem(item);
        end;
      end;
    end;
    SaveQueues(True);
  finally
    UnlockTicker;
  end;
end;

procedure TFrmMain.MiAnyQueueSelectAllClick(Sender: TObject);
var
  ListView: TListView;
  i:        Integer;
begin
  ListView := nil;
  if (Sender = MiInsQueueSelectAll) then ListView := LvInsQueue;
  if (Sender = MiGetQueueSelectAll) then ListView := LvGetQueue;
  if ListView = nil then exit;
  for i := 0 to ListView.Items.Count-1 do ListView.Items[i].Selected := True;
end;


procedure TFrmMain.StatusCallback(Sender: TObject; Msg: String; Level: Integer);
var s: String;
const LastID: Cardinal = 0;
begin
  if Msg = '' then begin // empty messages are only sent to increase responsiveness
    Application.ProcessMessages;
    exit;
  end;

  if Level < GlobalSettings.LogLevel then exit;

  if Sender is TFreenetThread then begin
    // prevent double-logs caused by FixedThread retrying SendMessage
    if (Sender as TFreenetThread).StatusMsgID = LastID then exit;
    LastID := (Sender as TFreenetThread).StatusMsgID;
    s := '{' + (Sender as TFreenetThread).ID + '} ';
  end else
    s := '';
  Log(s+Msg);
end;

procedure TFrmMain.MainLog(LogMsg: String; p: TQueueFile; Level: Integer);
var s: String;
begin
  if Level < GlobalSettings.LogLevel then exit;
  try
    if p = nil then
      s := '{' + MakeThreadID('System message', 'System') + '} '
    else
      s := '{' + MakeThreadID(p.GetFilename, 'System') + '} ';
  except
    s := ''; // just in case p is an invalid pointer...
  end;
  Log(s+LogMsg);
end;

procedure TFrmMain.Log(LogMsg: String);
var
  F:        TextFile;
  FileName: String;
begin
  Insert(FormatDateTime('[yyyy-mm-dd hh:nn:ss] ', Now), LogMsg, 1);
  try FrmLog.Log(LogMsg); except end;
  if GlobalSettings.LogToFile then
    try
      FileName := LOGFILENAME;
      AssignFile(F, FileName);
      if FileExists(FileName) then Append(F) else Rewrite(F);
      try
        WriteLn(F, LogMsg);
      finally
        CloseFile(F);
      end;
    except
    end;
  Application.ProcessMessages;
end;

procedure TFrmMain.LogFinishedInsert(p: TInsQueueFile);
var
  F:        TextFile;
  FileName: String;
begin
  MainLog('**** Finished insert of ' + ExtractFileName(p.OrgFilename), p, LOGLVL_IMPORTANT);
  InsFinishedNotification;
  if GlobalSettings.LogKeys and (not p.IsDirect) then
    try
      FileName := KEYFILENAME;
      AssignFile(F, FileName);
      if FileExists(FileName) then Append(F) else Rewrite(F);
      try
        WriteLn(F, p.Key + '/' + ExtractFileName(p.OrgFilename) );
      finally
        CloseFile(F);
      end;
    except
    end;
end;

procedure TFrmMain.LogFinishedGet(p: TGetQueueFile);
var
  F:        TextFile;
  FileName: String;
begin
  MainLog('**** Finished download of ' + ExtractFileName(p.SavFilename), p, LOGLVL_IMPORTANT);
  GetFinishedNotification;
  if GlobalSettings.LogGetKeys then
    try
      FileName := GETKEYFILENAME;
      AssignFile(F, FileName);
      if FileExists(FileName) then Append(F) else Rewrite(F);
      try
        WriteLn(F, p.Key );
      finally
        CloseFile(F);
      end;
    except
    end;
end;


procedure TFrmMain.BtAbortClick(Sender: TObject);
var
  i: Integer;
  AThread: TFreenetThread;
begin
  if (FThreadPool.Count = 0) then begin
    if Sender <> nil then MessageDlg('There are no active tasks.', mtInformation, [mbOk], 0);
    exit;
  end;
  if (Sender = nil) or (MessageDlg('Stop all tasks?', mtConfirmation, [mbYes,mbNo], 0) = mrYes) then begin
    LbAborting.Visible := True; LbAborting.Update;

    BtStopClick(nil); // stop inserting

    FAbort := True;
    BtAbort.Enabled := False;

    try
      Exclude(FTickerTasks, ttHandleQueueFiles);
      // terminate all threads
      for i := 0 to FThreadPool.Count-1 do begin
        AThread := FThreadPool.Items[i];
        AThread.Unnecessary := True;
        AThread.Terminate;
      end;
    finally
      Include(FTickerTasks, ttHandleQueueFiles);
    end;
  end;
end;

procedure TFrmMain.BtShowLogClick(Sender: TObject);
begin
  if FrmLog.Visible then FrmLog.BringToFront else FrmLog.Show;
end;

procedure TFrmMain.BtInsOrGetLogClick(Sender: TObject);
var
  Logs:  TStringList;
  sFile: String;
begin
  if      Sender = BtInsLog then sFile := KEYFILENAME
  else if Sender = BtGetLog then sFile := GETKEYFILENAME
  else exit;

  Logs := TStringList.Create;
  try
    try
      Logs.LoadFromFile(sFile);
      if not Assigned(FFileLogForm) then FFileLogForm := TFrmLog.Create(Self);
      FFileLogForm.SetContents(ExtractFileName(sFile), Logs);
      if FFileLogForm.Visible then FFileLogForm.BringToFront else FFileLogForm.Show; 
    except
      on E: Exception do MessageDlg('Failed to load ' + ExtractFilename(sFile) + ': ' + E.Message, mtError, [mbOk], 0);
    end;
  finally
    Logs.Free;
  end;
end;


procedure TFrmMain.MiAnyQueueCopyClick(Sender: TObject);
var
  s: String;
  i: Integer;
  p:  TQueueFile;
  CopyFilenames,CopyInfo,CopyFrost,CopyHTML: Boolean;
  sKey,sNam,sSize: String;
  cf: TClipboardFormat;
  uri: TFreenetURI;
  UriList, SizeList: TList;
  CommentList:       TStringList;
  pClip: PClipFormatShort;
  qt:    TQueueType;
  bDblSlash: Boolean;
begin
  if not LockTicker then exit;
  try
    CopyFilenames := (Sender = MiInsQueueCopyFilesAndKeys) or (Sender = MiGetQueueCopyFilesAndKeys);
    CopyInfo      := (Sender = MiInsQueueCopyInfo)         or (Sender = MiGetQueueCopyInfo);
    CopyFrost     := (Sender = MiInsQueueCopyFrost)        or (Sender = MiGetQueueCopyFrost);
    CopyHTML      := (Sender = MiInsQueueCopyHTML)         or (Sender = MiGetQueueCopyHTML);

    if not FindQueueType(Sender, qt) then
      raise Exception.Create('Could not determine queue type!');

    // custom defined format?
    if (Sender is TMenuItem) and ((Sender as TMenuItem).Tag <> 0) then begin

      cf := nil; uri := nil; UriList := nil; SizeList := nil; CommentList := nil;
      try
        i := (Sender as TMenuItem).Tag - 1;
        if (i < 0) or (i >= FClipList.Count) then exit;
        pClip := FClipList.Items[i];

        UriList  := TList.Create;
        SizeList := TList.Create;
        CommentList := TStringList.Create;

        for i := 0 to FQueueInfo[qt].ListView.Items.Count-1 do begin
          if FQueueInfo[qt].ListView.Items[i].Selected then begin
            p := FQueueInfo[qt].ListView.Items[i].Data;
            uri := TFreenetURI.Create;
            uri.SetURI(p.Key);
            if uri.DocumentName = '' then uri.DocumentName := p.GetFilename;
            UriList.Add(uri); uri := nil;
            SizeList.Add(Pointer(Cardinal(p.Size)));
            CommentList.Add(p.Comment);
          end;
        end;

        cf := TClipboardFormat.Create;
        cf.Init(pClip^.Description, pClip^.FormatString);
        s := cf.FormatKeys(UriList, SizeList, CommentList);

      finally
        cf.Free;
        if (UriList <> nil) and (UriList.IndexOf(uri) < 0) then uri.Free;
        while UriList.Count > 0 do begin
          TFreenetURI(UriList.Items[0]).Free;
          UriList.Delete(0);
        end;
        UriList.Free;
        SizeList.Free;
        CommentList.Free;
      end;

    end else begin

      s := '';
      for i := 0 to FQueueInfo[qt].ListView.Items.Count-1 do begin
        if FQueueInfo[qt].ListView.Items[i].Selected then begin
          p := FQueueInfo[qt].ListView.Items[i].Data;
          sNam := p.GetFilename;
          if p.Size <> 0 then sSize := IntToStr(p.Size) else sSize := '';
          sKey := GetKeyPart(p.Key);
          bDblSlash := Pos('//',p.Key) <> 0;

          if CopyInfo then begin
            if s <> '' then s := s + #13#10;
            s := s + 'File:  ' + sNam  + #13#10
                   + 'Key:   ' + sKey  + #13#10
                   + 'Bytes: ' + sSize + #13#10;
          end else begin
            if sKey <> '' then begin
              if s <> '' then s := s + #13#10;
              if CopyFrost then begin
                s := s + Format('<attached>%s * %s</attached>',[sNam,sKey]);
              end else if CopyHTML then begin
                s := s + Format('<A HREF="/%s">%s</A>',[sKey,sNam]);
              end else begin
                s := s + sKey;
                if CopyFilenames then begin
                  if bDblSlash then s := s + '//' + sNam else s := s + '/' + sNam;
                end;
              end;
            end;
          end;
        end;
      end;

    end;
    Clipboard.AsText := s;
  finally
    UnlockTicker;
  end;
end;

procedure TFrmMain.SaveQueues(TickerAlreadyLocked: Boolean; IsFinalSave: Boolean);
var
  ini: TSafeSaveMemIniFile;
  i:   Integer;
  pI:  TInsQueueFile;
  pG:  TGetQueueFile;
  pColCfg: PColumnConfig;
  sSection: String;
  sl:       TStringList;
begin
  ini := nil;
  if not TickerAlreadyLocked then begin
    if not LockTicker then exit;
  end;
  try
    ini := TSafeSaveMemIniFile.Create(ChangeFileExt(Application.ExeName, '.ini'));
    if IsFinalSave then begin
      ini.WriteString ('General', 'OpenDir', FLastInsDir);
      ini.WriteString ('General', 'SaveDir', FLastGetDir);

      if FLastUpdateCheck = 0 then
        ini.DeleteKey('General', 'LastUpdateCheck')
      else
        ini.WriteDateTime('General', 'LastUpdateCheck', FLastUpdateCheck);

      ini.WriteInteger('General', 'WinPosX', Left);
      ini.WriteInteger('General', 'WinPosY', Top);
      ini.WriteInteger('General', 'WinDimX', Width);
      ini.WriteInteger('General', 'WinDimY', Height);

      ini.WriteInteger('General', 'InsertH', PanelInsQueue.Height);

      // column config
      GetCurrentColumnWidths([qtInsQueue,qtGetQueue]);
      for i := 0 to FColumnConfigList.Count-1 do begin
        pColCfg := FColumnConfigList.Items[i];
        if pColCfg^.InsQueue then
          sSection := InsColSaveName[TInsColumn(pColCfg^.Column)]
        else
          sSection := GetColSaveName[TGetColumn(pColCfg^.Column)];
        ini.WriteString (sSection, 'Txt', pColCfg^.Caption);
        ini.WriteBool   (sSection, 'Vis', pColCfg^.Visible);
        ini.WriteInteger(sSection, 'Pos', pColCfg^.Position);
        ini.WriteInteger(sSection, 'Wid', pColCfg^.Width);
        if pColCfg^.Options <> '' then
          ini.WriteInteger(sSection, 'Opt', pColCfg^.Option);
      end;

      // frost settings
      ini.WriteString ('Frost', 'Dir',      FrostScanSettings.FrostDir);
      ini.WriteBool   ('Frost', 'TreeView', FrostScanSettings.TreeView);
      ini.WriteInteger('Frost', 'MinDat',   Trunc(FrostScanSettings.MinDat));
      ini.WriteInteger('Frost', 'MaxDat',   Trunc(FrostScanSettings.MaxDat));
      ini.WriteBool   ('Frost', 'DoKeys',   FrostScanSettings.SearchKeys);
      ini.WriteString ('Frost', 'InText',   FrostScanSettings.SearchText);
      ini.WriteBool   ('Frost', 'InSubj',   FrostScanSettings.SearchSubject);
      ini.WriteBool   ('Frost', 'InFrom',   FrostScanSettings.SearchPoster);
      ini.WriteBool   ('Frost', 'InBody',   FrostScanSettings.SearchBody);
      ini.WriteBool   ('Frost', 'InFiles',  FrostScanSettings.SearchFiles);
      // selected boards
      sl := TStringList.Create;
      try
        sl.Text := FrostScanSettings.SelBoards;
        ini.WriteInteger('Frost', 'NumBoards', sl.Count);
        for i := 0 to sl.Count-1 do begin
          ini.WriteString ('Frost', 'Board_' + IntToStr(i), sl.Strings[i]);
        end;
      finally
        sl.Free;
      end;
    end;
    try ini.EraseSection('InsertQueue'); except end;
    try ini.EraseSection('DownloadQueue'); except end;
    ini.QuickWriteBegin('InsertQueue');
    ini.WriteInteger('InsertQueue', 'Count',  LvInsQueue.Items.Count);
    for i := 0 to LvInsQueue.Items.Count-1 do begin
      pI := LvInsQueue.Items[i].Data;
      pI.WriteToIniFile('InsertQueue', '_' + IntToStr(i), ini);
    end;
    ini.QuickWriteNewSection('DownloadQueue');
    ini.WriteInteger('DownloadQueue', 'Count',  LvGetQueue.Items.Count);
    for i := 0 to LvGetQueue.Items.Count-1 do begin
      pG := LvGetQueue.Items[i].Data;
      pG.WriteToIniFile('DownloadQueue', '_' + IntToStr(i), ini);
    end;
    ini.QuickWriteEnd;
    ini.UpdateFile;
  finally
    if not TickerAlreadyLocked then UnlockTicker;
    ini.Free;
  end;
end;

procedure TFrmMain.LoadQueues;
var
  ini: TSafeSaveMemIniFile;
  n,i: Integer;
  pI:  TInsQueueFile;
  pG:  TGetQueueFile;
  PrepFile: TPreparedFile;
  iBlock: DWord;
  bChanged: Boolean;
  sDir:     String;
  SearchRec: TSearchRec;
  slFiles:   TStringList;
  bFound:    Boolean;
  WinPos,WinDim: TPoint;
  InsHeight:     Integer;
  pColCfg: PColumnConfig;
  sSection: String;
  sl: TStringList;
  s:  String;
begin
  if not LockTicker then exit;
  try
    ini := nil;
    ClearInsQueue;
    ClearGetQueue;
    try
      ini := TSafeSaveMemIniFile.Create(ChangeFileExt(Application.ExeName, '.ini'));

      FLastInsDir := ini.ReadString('General', 'OpenDir', '');
      FLastGetDir := ini.ReadString('General', 'SaveDir', '');
      if DirectoryExists(FLastInsDir) then OpenDlgInsQueue.InitialDir := FLastInsDir;
      if DirectoryExists(FLastGetDir) then SaveDlgGetQueue.InitialDir := FLastGetDir;

      FLastUpdateCheck := ini.ReadDateTime('General', 'LastUpdateCheck', 0);

      WinDim    := Point(Width,Height);
      WinPos    := Point((Screen.Width - WinDim.X) div 2, (Screen.Height - WinDim.Y) div 2);
      InsHeight := PanelInsQueue.Height;
      WinPos.X  := ini.ReadInteger('General', 'WinPosX', WinPos.X);
      WinPos.Y  := ini.ReadInteger('General', 'WinPosY', WinPos.Y);
      WinDim.X  := ini.ReadInteger('General', 'WinDimX', WinDim.X);
      WinDim.Y  := ini.ReadInteger('General', 'WinDimY', WinDim.Y);
      InsHeight := ini.ReadInteger('General', 'InsertH', InsHeight);
      if WinPos.X < Screen.DesktopLeft then WinPos.X := Screen.DesktopLeft;
      if WinPos.X >= (Screen.DesktopWidth - 32) then WinPos.X := Screen.DesktopWidth - 32;
      if WinPos.Y < Screen.DesktopTop then WinPos.Y := Screen.DesktopTop;
      if WinPos.Y >= (Screen.DesktopHeight - 32) then WinPos.Y := Screen.DesktopHeight - 32;
      Left := WinPos.X; Top := WinPos.Y; Width := WinDim.X; Height := WinDim.Y;
      if InsHeight <= 0 then InsHeight := 1;
      PanelInsQueue.Height := InsHeight;
      
      // Note: Form must have Position = poDesigned, else assigning Left/Top
      // doesn't work from the OnCreate-Event

      // column config
      for i := 0 to FColumnConfigList.Count-1 do begin
        pColCfg := FColumnConfigList.Items[i];
        if pColCfg^.InsQueue then
          sSection := InsColSaveName[TInsColumn(pColCfg^.Column)]
        else
          sSection := GetColSaveName[TGetColumn(pColCfg^.Column)];
        pColCfg^.Caption  := ini.ReadString (sSection, 'Txt', pColCfg^.Caption);
        pColCfg^.Visible  := ini.ReadBool   (sSection, 'Vis', pColCfg^.Visible);
        pColCfg^.Position := ini.ReadInteger(sSection, 'Pos', pColCfg^.Position);
        pColCfg^.Width    := ini.ReadInteger(sSection, 'Wid', pColCfg^.Width);
        if pColCfg^.Options <> '' then
          pColCfg^.Option := ini.ReadInteger(sSection, 'Opt', pColCfg^.Option);
      end;
      // NOTE: Do NOT add any items to listviews until the config has been applied!!

      // frost settings
      FrostScanSettings.FrostDir      := ini.ReadString ('Frost', 'Dir',      FrostScanSettings.FrostDir);
      FrostScanSettings.TreeView      := ini.ReadBool   ('Frost', 'TreeView', FrostScanSettings.TreeView);
      FrostScanSettings.MinDat        := ini.ReadInteger('Frost', 'MinDat',   Trunc(FrostScanSettings.MinDat));
      FrostScanSettings.MaxDat        := ini.ReadInteger('Frost', 'MaxDat',   Trunc(FrostScanSettings.MaxDat));
      FrostScanSettings.SearchKeys    := ini.ReadBool   ('Frost', 'DoKeys',   FrostScanSettings.SearchKeys);
      FrostScanSettings.SearchText    := ini.ReadString ('Frost', 'InText',   FrostScanSettings.SearchText);
      FrostScanSettings.SearchSubject := ini.ReadBool   ('Frost', 'InSubj',   FrostScanSettings.SearchSubject);
      FrostScanSettings.SearchPoster  := ini.ReadBool   ('Frost', 'InFrom',   FrostScanSettings.SearchPoster);
      FrostScanSettings.SearchBody    := ini.ReadBool   ('Frost', 'InBody',   FrostScanSettings.SearchBody);
      FrostScanSettings.SearchFiles   := ini.ReadBool   ('Frost', 'InFiles',  FrostScanSettings.SearchFiles);
      // selected boards
      sl := TStringList.Create;
      try
        n := ini.ReadInteger('Frost', 'NumBoards', 0);
        for i := 0 to n-1 do begin
          s := ini.ReadString('Frost', 'Board_' + IntToStr(i), '');
          if s <> '' then sl.Add(AnsiUpperCase(s));
        end;
        FrostScanSettings.SelBoards := sl.Text;
      finally
        sl.Free;
      end;

      ini.QuickReadBegin('InsertQueue');
      try
        n := ini.ReadInteger('InsertQueue', 'Count', 0);
        for i := 0 to n-1 do begin
          pI := TInsQueueFile.Create;
          try
            pI.ReadFromIniFile('InsertQueue', '_' + IntToStr(i), ini);
            FInsertQueue.Add(pI);
          except
            pI.Free; raise;
          end;

          if pI.PrepBasename <> '' then begin
            PrepFile := TPreparedFile.CreateInsert(pI.PrepBasename);
            try
              try
                PrepFile.ReadHeader;
                if PrepFile.AllDone then begin
                  pI.Progress := 'Finished';
                  if pI.Status = ifsInserting then pI.Status := ifsDone;
                end else begin
                  if pI.Status = ifsInserting then pI.Status := ifsReady;
                  pI.Progress := PrepFile.GetProgressString;
                  // check if any block is in state "inserting"
                  bChanged := False;
                  for iBlock := 0 to PrepFile.NumBlocks-1 do
                    if PrepFile.BlockWorking[iBlock] then begin
                      PrepFile.BlockWorking[iBlock] := False;
                      bChanged := True;
                    end;
                  if bChanged then PrepFile.WriteHeader; // ok, no active threads
                end;
              except
                if MessageDlg('Prepared data for file "' + pI.OrgFileName + '" is corrupt.'#13'Mark file as unprepared?', mtWarning, [mbYes,mbNo], 0) = mrYes then begin
                  PrepFile.DeleteFiles;
                  pI.PrepBasename := '';
                  if pI.Status <> ifsError then pI.Status := ifsUnprepared;
                end;
              end;
            finally
              PrepFile.Free;
            end;
          end;
        end;
      except
        ClearInsQueue;
      end;

      ini.QuickReadNewSection('DownloadQueue');
      try
        n := ini.ReadInteger('DownloadQueue', 'Count', 0);
        for i := 0 to n-1 do begin
          pG := TGetQueueFile.Create;
          try
            pG.ReadFromIniFile('DownloadQueue', '_' + IntToStr(i), ini);
            FGetQueue.Add(pG);
          except
            pG.Free; raise;
          end;

          if pG.PrepBasename <> '' then begin
            PrepFile := TPreparedFile.CreateDownload(pG.PrepBasename);
            try
              try
                PrepFile.ReadHeader;
                if pG.Status = gfsDecoding   then pG.Status := gfsGetting;
                if pG.Status = gfsValidating then pG.Status := gfsDecoded;
                pG.Progress := PrepFile.GetProgressString(GlobalSettings.GetRetries);
                // check if any block is in state "downloading"
                bChanged := False;
                for iBlock := 0 to PrepFile.NumBlocks-1 do
                  if PrepFile.BlockWorking[iBlock] then begin
                    PrepFile.BlockWorking[iBlock] := False;
                    bChanged := True;
                  end;
                pG.BlockStat := PrepFile.GetBlockStatusString;
                if bChanged then PrepFile.WriteHeader; // ok, no active threads
              except
                if MessageDlg('Temporary data for file "' + pG.SavFilename + '" is corrupt.'#13'Mark file as unretreived?', mtWarning, [mbYes,mbNo], 0) = mrYes then begin
                  PrepFile.DeleteFiles;
                  pG.PrepBasename := '';
                  if pG.Status <> gfsError then pG.Status := gfsReady;
                end;
              end;
            finally
              PrepFile.Free;
            end;
          end else begin
            // if in state getting, but not got header yet -> reset to ready
            if pG.Status = gfsGetting then pG.Status := gfsReady;
          end;
        end;
      except
        ClearGetQueue;
      end;

      ini.QuickReadEnd;

      ini.UpdateFile;
    finally
      ini.Free;
    end;
    // NOTE: we must NOT call Update..Queue here, because the ColumnConfig has been loaded but not yet applied!
    // UpdateInsertQueue(True);
    // UpdateGetQueue(True);

    // check for orphaned files
    sDir := ExtractFilePath(Application.ExeName) + 'Data\';
    slFiles := TStringList.Create;
    try
      if 0 = FindFirst(sDir + '*.*', faAnyFile and not (faVolumeID or faDirectory), SearchRec) then
        try
          repeat
            bFound := False;
            for i := 0 to FInsertQueue.Count-1 do begin
              pI := FInsertQueue.Items[i];
              if CompareText(ExtractFilename(pI.PrepBasename), ChangeFileExt(SearchRec.Name, '')) = 0 then begin
                bFound := True; break;
              end;
            end;
            if not bFound then begin
              for i := 0 to FGetQueue.Count-1 do begin
                pG := FGetQueue.Items[i];
                if CompareText(ExtractFilename(pG.PrepBasename), ChangeFileExt(SearchRec.Name, '')) = 0 then begin
                  bFound := True; break;
                end;
              end;
            end;
            if not bFound then slFiles.Add(SearchRec.Name);
          until 0 <> FindNext(SearchRec);
        finally
          FindClose(SearchRec);
        end;

      if slFiles.Count > 0 then begin
        if MessageDlg(
             'There are ' + IntToStr(slFiles.Count) + ' files in the data directory that are not used by ' + APPNAME + ':'#13#13 +
             slFiles.Text + #13 + 'Keep those files? (select "No" to delete them)',
             mtConfirmation, [mbYes,mbNo], 0
           ) = mrNo then begin
           if MessageDlg('Are you sure you want to delete ' + IntToStr(slFiles.Count) + ' files?', mtWarning, [mbYes,mbNo], 0) = mrYes then
             for i := 0 to slFiles.Count-1 do DeleteFile(sDir + slFiles.Strings[i]);
        end;
      end;
    finally
      slFiles.Free;
    end;
  finally
    UnlockTicker;
  end;
end;

procedure TFrmMain.ClearQueue(ListView: TListView; QueueList: TList);
var p: TQueueFile;
begin
  ListView.Items.Clear;
  while QueueList.Count > 0 do begin
    p := QueueList.Items[0]; QueueList.Delete(0);
    p.Free;
  end;
end;

procedure TFrmMain.ClearInsQueue;
begin
  ClearQueue(LvInsQueue, FInsertQueue);
end;

procedure TFrmMain.ClearGetQueue;
begin
  ClearQueue(LvGetQueue, FGetQueue);
end;

procedure TFrmMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  if FEndSession then begin
    CanClose := True;
  end else if FActive then begin
    MessageDlg('Still active.. deactivate before exiting', mtError, [mbOk], 0);
    CanClose := False;
  end else if (FThreadPool.Count > 0) then begin
    CanClose := False;
    if FAbort then begin
      if MessageDlg(
          'Stopping all tasks can take a little time. ' +
          'It is recommended that you wait until everything is gracefully finished.'#13 +
          'Select "Retry" to keep waiting or "Abort" to exit now.',
          mtWarning, [mbRetry,mbAbort], 0
        ) = mrAbort then HALT(10);
    end else begin
      MessageDlg('There are still active tasks. Wait for them to finish or abort all tasks before exiting.', mtError, [mbOk], 0);
    end;
  end else
    CanClose := True;
end;

function TFrmMain.GetUniquePrepareName(ForInsert: Boolean): String;
var
  sDir:  String;
  PrepFile: TPreparedFile;
begin
  sDir := ExtractFilePath(Application.ExeName) + 'Data\';
  if not DirectoryExists(sDir) then CreateDir(sDir);
  Assert(DirectoryExists(sDir), 'Failed to create data directory');

  PrepFile := TPreparedFile.Create(ForInsert);
  try
    repeat
      PrepFile.Basename := sDir + IntToHex(Random($10000),4) + IntToHex(Random($10000),4);
    until not (FileExists(PrepFile.HeaderFilename) or FileExists(PrepFile.DataFilename));
    Result := PrepFile.Basename;
  finally
    PrepFile.Free;
  end;
end;

procedure TFrmMain.DeleteInsQueueItem(item: TListItem);
var
  idx:      Integer;
  p:        TInsQueueFile;
  PrepFile: TPreparedFile;
begin
  p := item.Data;
  Assert(not (p.Status in [ifsInserting,ifsPreparing,ifsAborting]));
  if p.PrepBasename <> '' then begin
    PrepFile := TPreparedFile.CreateInsert(p.PrepBasename);
    try
      PrepFile.DeleteFiles;
    finally
      PrepFile.Free;
    end;
  end;
  item.Delete;
  idx := FInsertQueue.IndexOf(p);
  if idx >= 0 then FInsertQueue.Delete(idx);
  p.Free;
end;

procedure TFrmMain.DeleteGetQueueItem(item: TListItem);
var
  idx:      Integer;
  p:        TGetQueueFile;
  PrepFile: TPreparedFile;
begin
  p := item.Data;
  Assert(not (p.Status in [gfsGetting,gfsDecoding,gfsValidating,gfsAborting]));
  if p.PrepBasename <> '' then begin
    PrepFile := TPreparedFile.CreateDownload(p.PrepBasename);
    try
      PrepFile.DeleteFiles;
    finally
      PrepFile.Free;
    end;
  end;
  item.Delete;
  idx := FGetQueue.IndexOf(p);
  if idx >= 0 then FGetQueue.Delete(idx);
  p.Free;
end;

procedure TFrmMain.MiInsQueueUnprepareClick(Sender: TObject);
var
  i:    Integer;
  item: TListItem;
  p:    TInsQueueFile;
  PrepFile: TPreparedFile;
  Cnt:      Integer;
begin
  Cnt := 0;
  if not LockTicker then exit;
  try
    for i := 0 to LvInsQueue.Items.Count-1 do begin
      item := LvInsQueue.Items[i];
      if item.Selected then begin
        p := item.Data;
        if p.IsDirect then continue;
        if p.NumActiveThreads > 0 then begin
          inc(Cnt); continue;
        end;
        if (p.PrepBasename <> '') then begin
          PrepFile := TPreparedFile.CreateInsert(p.PrepBasename);
          try
            PrepFile.DeleteFiles;
          finally
            PrepFile.Free;
          end;
          p.PrepBasename := '';
          p.Progress := '';
        end;
        p.Status := ifsUnprepared;
        p.HeaderInserts := 0;
        SetInsQueueListItem(item);
      end;
    end;
    SaveQueues(True);
  finally
    UnlockTicker;
  end;
  if Cnt > 0 then MessageDlg(Format('%d entries were not changed, because they have active tasks.',[Cnt]),mtInformation,[mbOk],0);
end;

procedure TFrmMain.MiInsQueueUninsertClick(Sender: TObject);
var
  i,j:  Integer;
  item: TListItem;
  p:    TInsQueueFile;
  PrepFile: TPreparedFile;
  bHeadOnly: Boolean;
begin
  bHeadOnly := (Sender = MiInsQueueReinsertHeader);
  
  if not LockTicker then exit;
  try
    for i := 0 to LvInsQueue.Items.Count-1 do begin
      item := LvInsQueue.Items[i];
      if item.Selected then begin
        p := item.Data;
        if p.Status in [ifsReady,ifsInserting, ifsDone, ifsError] then begin
          if bHeadOnly and p.IsDirect then continue;
          p.Status := ifsReady;
          p.Progress := '';
          if p.PrepBasename <> '' then begin
            PrepFile := TPreparedFile.CreateInsert(p.PrepBasename);
            try
              PrepFile.ReadHeader;
              if bHeadOnly then begin
                j := PrepFile.MainBlock;
                PrepFile.BlockWorking[j] := False;
                PrepFile.BlockDone   [j] := False;
                PrepFile.BlockTries  [j] := 0;
              end else begin
                for j := 0 to PrepFile.NumBlocks-1 do begin
                  PrepFile.BlockWorking[j] := False;
                  PrepFile.BlockDone   [j] := False;
                  PrepFile.BlockTries  [j] := 0;
                end;
                p.HeaderInserts := 0;
              end;
              PrepFile.WriteHeader; // CHECK - possibility for race condition?
            finally
              PrepFile.Free;
            end;
          end else
            p.Status := ifsUnprepared;
          SetInsQueueListItem(item);
        end;
      end;
    end;
    SaveQueues(True);
  finally
    UnlockTicker;
  end;
end;

procedure TFrmMain.MiGetQueueUngetClick(Sender: TObject);
var
  i:    Integer;
  item: TListItem;
  p:    TGetQueueFile;
  PrepFile: TPreparedFile;
  Cnt:  Integer;
begin
  if MessageDlg(Format('Mark %d file(s) as unretrieved, deleting all blocks that have been retrieved for them so far?',[LvGetQueue.SelCount]), mtConfirmation, [mbYes,mbNo], 0) <> mrYes then
    exit;
  Cnt := 0;
  if not LockTicker then exit;
  try
    for i := 0 to LvGetQueue.Items.Count-1 do begin
      item := LvGetQueue.Items[i];
      if item.Selected then begin
        p := item.Data;
        if p.NumActiveThreads > 0 then
          inc(Cnt)
        else begin
          if p.PrepBasename <> '' then begin
            PrepFile := TPreparedFile.CreateDownload(p.PrepBasename);
            try
              PrepFile.DeleteFiles;
            finally
              PrepFile.Free;
            end;
          end;
          p.Status       := gfsReady;
          p.PrepBasename := '';
          p.Progress     := '';
          p.Retry        := 0;
          p.BlockStat    := '';
          p.Activekey    := p.Key;
          SetGetQueueListItem(item);
        end;
      end;
    end;
    SaveQueues(True);
  finally
    UnlockTicker;
  end;
  if Cnt > 0 then MessageDlg(Format('%d entries were not changed, because they have active tasks.',[Cnt]),mtInformation,[mbOk],0);
end;

procedure TFrmMain.MiGetQueuePriorityClick(Sender: TObject);
var
  i,pri: Integer;
  item:  TListItem;
  p:     TGetQueueFile;
begin
  if not (Sender is TMenuItem) then exit;
  pri := (Sender as TMenuItem).Tag;
  Assert(Abs(pri) <= 2);
  
  if not LockTicker then exit;
  try
    for i := 0 to LvGetQueue.Items.Count-1 do begin
      item := LvGetQueue.Items[i];
      if item.Selected then begin
        p := item.Data;
        if p.Priority <> pri then begin
          p.Priority := pri;
          SetGetQueueListItem(item);
        end;
      end;
    end;
    SaveQueues(True);
  finally
    UnlockTicker;
  end;
end;

procedure TFrmMain.MiAnyQueueAbortClick(Sender: TObject);
var
  i:    Integer;
  item: TListItem;
  p:    TQueueFile;
  pG:   TGetQueueFile;
  pI:   TInsQueueFile;
  ListView: TListView;
  bInsQ: Boolean;
begin
  if      (Sender = MiInsQueueAbort) then bInsQ := True
  else if (Sender = MiGetQueueAbort) then bInsQ := False
  else exit;

  if bInsQ then ListView := LvInsQueue else ListView := LvGetQueue;

  if not LockTicker then exit;
  try
    for i := 0 to ListView.Items.Count-1 do begin
      item := ListView.Items[i];
      if item.Selected then begin
        p := item.Data;
        if bInsQ then begin
          pI := p as TInsQueueFile;
          if pI.Status = ifsAborting then continue; // already aborting
          pI.Status := ifsAborting;
        end else begin
          pG := p as TGetQueueFile;
          if pG.Status = gfsAborting then continue; // already aborting
          pG.Status := gfsAborting;
        end;
        p.AbortAllThreads;
        p.Progress     := 'Aborting';
        if bInsQ then SetInsQueueListItem(item) else SetGetQueueListItem(item);
      end;
    end;
    CheckAbortedEntries; // clean up entries that are successfully aborted
  finally
    UnlockTicker;
  end;
end;

procedure TFrmMain.BtStartClick(Sender: TObject);
begin
  FFlushError := False; // reset, so we try to flush cached files again!
  BtStart.Enabled := False; BtStop.Enabled := True; BtAbort.Enabled := True;
  FActive := True; LbActive.Visible := True;
  SetTrayIconAnim(taActive);
  if FStats.AvgStartTime = 0 then FStats.AvgStartTime := Now;
  CheckNodeUp;
  Include(FTickerTasks, ttHandleQueueFiles);
  TimerTicker.OnTimer(TimerTicker);
end;

procedure TFrmMain.BtStopClick(Sender: TObject);
begin
  BtStop.Enabled := False; BtStart.Enabled := True;
  FActive := False; // LbActive.Visible := False;
  SetTrayIconAnim(taSleep);
end;

procedure TFrmMain.DoDuty;
  function RevStr(const S: String): String;
  var i,len: Integer;
  begin
    Result := ''; len := Length(S);
    for i := 0 to len-1 do Result := Result + S[len-i];
  end;

const
  TIME_CHECK_NODE_WHEN_UP   = 180 / (24*60*60); // check every 3 minutes if node was up
  TIME_CHECK_NODE_WHEN_DOWN =  30 / (24*60*60); // check twice a minute if node was down

const
  Count: Integer = 0;
  TickCounter: DWord = 0;
var
  i,j,PriFac: Integer;
  iBlock:    DWord;
  InsThread: TInsertThread;
  PrpThread: TPrepareThread;
  GetThread: TDownloadThread;
  DecThread: TFECDecodeThread;
  ChkThread: TChecksumThread;
  AnyThread: TFreenetThread;
  PrepFile:  TPreparedFile;
  item:      TListItem;
  pI:        TInsQueueFile;
  pG:        TGetQueueFile;
  pData:     PChar;
  DataLen:   DWord;
  sMetadata: String;
  GetHTL:    Integer;
  InsHTL:    Integer;
  s:         String;
  NumRetries: Integer;
  ok:        Boolean;
  iLimit,iPri: Integer;
  PriCount:    Array [-2..2] of Integer;
  PreferItem:  TListItem;
  ThreadStartCount: Integer;
label
  DoDutyOnceMore;
begin
  // check if Node is up
  if FActive then begin
    if (      FNodeUp.IsUp  and ((Now - FNodeUp.LastCheck) > TIME_CHECK_NODE_WHEN_UP  ) )
    or ( (not FNodeUp.IsUp) and ((Now - FNodeUp.LastCheck) > TIME_CHECK_NODE_WHEN_DOWN) )
    then
      CheckNodeUp;
  end;

  // cycle Active label, set color
  if not FNodeUp.IsUp then begin
    case Count of
      1:   s := 'NODE DOWN';
      2:   s := 'OR';
      3:   s := 'OVERLOADED';
      else s := '*NODE DOWN*';
    end;
    LbActive.Caption := s;
  end else begin
    case Count of
      0: s := '*  ';
      1: s := ' * ';
      2: s := '  *';
      3: s := ' * ';
      else s := '?';
    end;
    LbActive.Caption := s + ' ACTIVE ' + RevStr(s);
  end;
  Count := (Count + 1) mod 4;
  if FActive and FNodeUp.IsUp then
    LbActive.Color := clGreen
  else if FActive then
    LbActive.Color := clOlive
  else
    LbActive.Color := clMaroon;

  // check if any thread is done
  i := 0;
  while i < FThreadPool.Count do begin
    AnyThread := FThreadPool.Items[i];
    if AnyThread.Done then begin
      // wait until it is really terminated
      AnyThread.WaitFor;
      ThreadTerminated(AnyThread);
      if (i < FThreadPool.Count) and (FThreadPool.Items[i] = AnyThread) then
        inc(i) // failed to remove thread from pool ??? should never happen!
    end else
      inc(i);
  end;

  if not FActive then exit; // has insertion/download been stopped ?
  if not FNodeUp.IsUp then exit; // node not contactable?

  if TickCounter < $FFFFFFFF then inc(TickCounter) else TickCounter := 0;

  // activate automatic update check
  if  GlobalSettings.ChkUpdate
  and (Now > (FLastUpdateCheck + GlobalSettings.ChkUpdateInt / 24))
  and (GetNumberOfThreads.NumUpdThreads = 0)
  then begin
    BtCheckUpdateClick(nil);
  end;


  ThreadStartCount := 0;
  
DoDutyOnceMore:

  PrpThread := nil; InsThread := nil;
  GetThread := nil; DecThread := nil; ChkThread := nil;

  // see if there's something to prepare
  for i := 0 to LvInsQueue.Items.Count-1 do begin
    if NumHighDutyThreads > 0 then break;
    item := LvInsQueue.Items[i];
    pI := item.Data;
    if pI.Freeze then continue;
    if pI.Status = ifsUnprepared then begin
      PrpThread := TPrepareThread.Create(
                     MakeThreadID(ExtractFileName(pI.OrgFilename), 'Prepare'),
                     GlobalSettings.FCPAddr, GlobalSettings.FCPPort,
                     pI.OrgFilename, GetUniquePrepareName(True),
                     True, // always with checksum
                     GlobalSettings.MetaFirst,
                     GlobalSettings.InsUseOrgFile,
                     pI.InsertStyle,
                     StatusCallback,
                     pI, pI.UniqueID, // user data is pI
                     True // create suspended
                   );
      // update item
      pI.Status := ifsPreparing;
      pI.Progress := 'Preparing';
      SetInsQueueListItem(item, 1);

      break; // break in every case (wait for next tick for a new thread)
    end;
  end;

  // see if there's something to insert
  for i := 0 to LvInsQueue.Items.Count-1 do begin
    if NumInsThreads >= GlobalSettings.InsThreads then break;
    item := LvInsQueue.Items[i];
    pI := item.Data;
    if pI.Freeze then continue;
    if pI.Status in [ifsReady,ifsInserting] then begin
      // just make sure...
      if pI.PrepBasename = '' then begin
        MainLog(Format('!! Internal error: Status = %d, but file is unprepared. File: %s',[Ord(pI.Status), pI.OrgFilename]), pI, LOGLVL_IMPORTANT);
        pI.Status := ifsUnprepared;
        continue;
      end;
      // find undone blocks to insert
      PrepFile := TPreparedFile.CreateInsert(pI.PrepBasename);
      try
        PrepFile.ReadHeader;
        for iBlock := 0 to PrepFile.NumBlocks-1 do begin
          if not (PrepFile.BlockDone[iBlock] or PrepFile.BlockWorking[iBlock]) then begin
            PrepFile.GetData(iBlock, pData, DataLen, sMetadata);
            // may need to calc metadata; only possible if all other blocks are done
            if (iBlock = PrepFile.MainBlock) and (pData = nil) and (sMetadata = '') then begin
              if PrepFile.NumDone < (PrepFile.NumBlocks-1) then continue; // cannot calc meta yet
              //TODO: catch exceptions! - unexpected message bug here?
              sMetadata := PrepFile.CalcSplitFileMetadata(GlobalSettings.FCPAddr,GlobalSettings.FCPPort,pI.InsertStyle);
              // PrepFile.WriteData(iBlock, nil, 0, sMetadata); // NO!
              // Metadatablock stays empty!
            end;
            if pI.IsHeal then begin
              NumRetries := 0;
              InsHTL     := GlobalSettings.GetHealHTL;
            end else begin
              NumRetries := 0; // -1;
              InsHTL     := GlobalSettings.InsHTL;
              if  GlobalSettings.InsUseHeadHTL   // specific HTL for headers?
              and (iBlock = PrepFile.MainBlock)
              and ((PrepFile.NumBlocks > 1) or GlobalSettings.InsSingleHead)
              and (not pI.IsDirect) then
                InsHTL := GlobalSettings.InsHeadHTL;
            end;
            InsThread := TInsertThread.Create(
                           MakeThreadID(ExtractFileName(pI.OrgFilename), Format('%3d/%3d',[iBlock+1,PrepFile.NumBlocks])),
                           GlobalSettings.FCPAddr, GlobalSettings.FCPPort,
                           pData, DataLen, sMetadata,
                           InsHTL,
                           GlobalSettings.SkipLocal or pI.IsDirect, // always direct-insert heal-blocks
                           NumRetries,
                           iBlock,
                           False,False, // irrelevant here (isdata,ischeck)
                           (iBlock = PrepFile.MainBlock),
                           True, // free data on exit
                           pI.InsertStyle,
                           StatusCallback,
                           GlobalSettings.InsTimeoutMin,
                           pI, pI.UniqueID, // user data is pI
                           True // create suspended
                         );
            if FDebugFakeInserts then InsThread.Debug_FakeInsert := True;
            // InsThread.OnTerminate := ThreadTerminated; // NO! call that myself from ticker!
            // mark block as taken
            PrepFile.BlockWorking[iBlock] := True;
            PrepFile.WriteHeader; // should be ok here
            // update item
            if pI.Status <> ifsInserting then pI.Status := ifsInserting;
            pI.Progress := PrepFile.GetProgressString;
            SetInsQueueListItem(item, 1);

            break; // break in every case (wait for next tick for a new thread)
          end;
        end;
      finally
        PrepFile.Free;
      end;
    end;

    if InsThread <> nil then break;
  end;

  // build priority list and reenable scheduled entries
  PreferItem := nil;
  FGetPrioList.Clear; for i := -2 to 2 do PriCount[i] := 0;
  for i := 0 to LvGetQueue.Items.Count-1 do begin
    item := LvGetQueue.Items[i]; pG := item.Data;
    if pG.Freeze then continue;

    // scheduled for retry?
    if (pG.Status = gfsError) and (pG.RestartAt <> 0) and (Now >= pG.RestartAt) and (pG.NumActiveThreads = 0) then begin
      MainLog('Restarting download ' + ExtractFilename(pG.SavFilename), pG, LOGLVL_DEBUG);
      ok := True;
      if pG.PrepBasename <> '' then begin
        try
          PrepFile := TPreparedFile.CreateDownload(pG.PrepBasename);
          try
            // reset try count for all unfinished blocks
            PrepFile.ReadHeader;
            for j := 0 to PrepFile.NumBlocks-1 do
              if not PrepFile.BlockDone[j] then begin
                PrepFile.BlockTries[j] := 0;
                PrepFile.BlockWorking[j] := False;
              end;
            PrepFile.WriteHeader; // ok, no active threads
            pG.BlockStat := PrepFile.GetBlockStatusString;
          finally
            PrepFile.Free;
          end;
          pG.Status := gfsGetting; // Splitfile and got metadata
        except
          on E: Exception do begin
            MainLog('*** Permanent ERROR: reading/writing temp file: ' + E.ClassName + ': ' + E.Message, pG, LOGLVL_IMPORTANT);
            ok := False;
          end;
        end;
      end else
        pG.Status := gfsReady; // not got metadata yet
      if ok then begin
        pG.Progress := '';
        pG.RestartAt := 0;
        pG.Retry := 0;
      end else begin
        pG.Status := gfsError;
        pG.Progress := '';
        pG.RestartAt := 0;
      end;
      SetGetQueueListItem(item);
    end;

    // ready for decode/validation?
    if pG.PriorityBoost then begin
      if pG.Status in [gfsGetting,gfsDecoded] then begin
        if (PreferItem = nil) then PreferItem := item;
      end else begin
        pG.PriorityBoost := False; // could happen if decoding fails
      end;
    end;

    // add to priority list
    if pG.Status in [gfsReady,gfsGetting,gfsDecoded] then begin
      if GlobalSettings.GetSpread then begin
        PriFac := 1;
        if      pG.Priority <= -2 then s := 'C' // lowest pri, always do these last
        else if pG.Priority >=  2 then s := 'A' // highest pri, always do these first
        else begin
          s := 'B'; PriFac := 1 shl (1 - pG.Priority); // low:4 norm:2 high:1
        end;
        s := s
           + IntToHex((pG.NumActiveThreads + 1) * PriFac, 4)
           + IntToHex(pG.LastTick, 8)
           + IntToHex(i, 4) // queue position - looks nicer if equal files are handled top to bottom
           ;
        FGetPrioList.AddObject(s, item);
        inc(PriCount[pG.Priority]);
      end else begin
        FGetPrioList.AddObject('', item); // use priority list even when not using priority (just queue order)
      end;
    end;
  end;
  if GlobalSettings.GetSpread then begin
    // priority list is still in queue order - apply max.file limit
    iLimit := GlobalSettings.GetMaxFiles;
    if iLimit > 0 then begin
      for iPri := 2 downto -2 do begin
        if PriCount[iPri] = 0 then continue;
        for i := 0 to FGetPrioList.Count-1 do begin
          item := TListItem(FGetPrioList.Objects[i]);
          pG   := item.Data;
          if pG.Priority <> iPri then continue;
          FGetPrioList.Strings[i] := '!' + FGetPrioList.Strings[i];
          dec(iLimit); dec(PriCount[iPri]);
          if (iLimit = 0) or (PriCount[iPri] = 0) then break;
        end;
        if iLimit = 0 then break;
      end;
    end;
    FGetPrioList.Sort; // sort priority list
  end;

  // if we have a preferred item (decode/validate-ready), move it to the top of the priority list
  if PreferItem <> nil then begin
    i := FGetPrioList.IndexOfObject(PreferItem);
    if i >= 0 then FGetPrioList.Move(i, 0);
  end;

  // see if there's something to download
  for i := 0 to LvGetQueue.Items.Count-1 do begin

    // Note: this should be fixed, so a decode or checksum thread can start immediately
    if (PreferItem = nil) and (NumGetThreads >= GlobalSettings.GetThreads) then break;

    if FGetPrioList.Count = 0 then
      item := nil
    else begin
      item := TListItem(FGetPrioList.Objects[0]);
      FGetPrioList.Delete(0);
    end;

    if item = nil then break;

    // set PreferItem to nil - if we had one, it is the first (and now in item)
    PreferItem := nil;

    pG := item.Data;
    if pG.Freeze then continue;

    if pG.Status = gfsReady then begin
      // start new download
      Assert(GetThread = nil);
      GetHTL := GlobalSettings.GetHTL + pG.Retry * GlobalSettings.GetHTLInc;
      if pG.Activekey = pG.Key then s := 'Header' else s := 'Redirect';
      GetThread := TDownloadThread.Create(
                     MakeThreadID(ExtractFilename(pG.SavFilename), s),
                     GlobalSettings.FCPAddr, GlobalSettings.FCPPort,
                     GetKeyPart(pG.Activekey),
                     GetHTL, GlobalSettings.GetSkipLocal,
                     0, False, False,
                     StatusCallback,
                     GlobalSettings.GetTimeoutMin,
                     pG, pG.UniqueID,
                     True
                   );
      pG.Status := gfsGetting; pG.Progress := s;
      pG.CheckSum := '';
      if pG.Retry > 0 then pG.Progress := pG.Progress + Format('(try %d)',[pG.Retry+1]);
      SetGetQueueListItem(item, 1);
      pG.LastTick := TickCounter;
      break;
    end else if pG.Status = gfsGetting then begin
      // if it's a splitfile and we have parsed the metadata: get next block
      PrepFile := nil;
      try
        if pG.PrepBasename <> '' then begin
          try
            PrepFile := TPreparedFile.CreateDownload(pG.PrepBasename);
            PrepFile.ReadHeader;
            pG.BlockStat := PrepFile.GetBlockStatusString;
          except
            on E: Exception do begin
              MainLog('*** Permanent ERROR: Cannot read temp. file for ' + ExtractFilename(pG.SavFilename) + ': ' + E.ClassName + ': ' + E.Message, pG, LOGLVL_IMPORTANT);
              pG.Status := gfsError;
              SetGetQueueListItem(item);
              PrepFile.Free; PrepFile := nil;
            end;
          end;
        end;
        if PrepFile <> nil then begin
          // are we done?
          if PrepFile.AllDone and (not pG.Debug_GetAll) then begin
            pG.AbortAllGetThreads; // abort all running getthreads for this file

            // ONLY start DecodeThread after ALL GetThreads are cleaned up!
            // Otherwise we have a race condition in accessing the PrepFile!
            if (NumHighDutyThreads = 0) and (pG.NumActiveThreads = 0) then begin
              // start decode thread
              Assert(DecThread = nil);
              DecThread := TFECDecodeThread.Create(
                             MakeThreadID(ExtractFileName(pG.SavFilename), 'Decode'),
                             GlobalSettings.FCPAddr, GlobalSettings.FCPPort,
                             PrepFile.Basename,
                             pG.SavFilename,
                             GlobalSettings.GetHealPerc,
                             psCompleteOnly,
                             StatusCallback,
                             pG, pG.UniqueID,
                             True
                           );
              pG.Status := gfsDecoding; pG.Progress := 'Decoding';
              SetGetQueueListItem(item, 1);
              pG.LastTick := TickCounter;
              SaveQueues(True);
            end;
          end else begin
            // reset the priority boost flag - just in case
            pG.PriorityBoost := False;

            // can we finish the download at all?
            if not GlobalSettings.GetGetAll then begin
              if not PrepFile.IsSuccessPossible(GlobalSettings.GetRetries) then begin
                MainLog('*** Splitfile download failed. Too many blocks failed for ' + ExtractFilename(pG.SavFilename), pG, LOGLVL_IMPORTANT);
                pG.Status := gfsError;
                SetGetQueueListItem(item);
                pG.AbortAllGetThreads; // abort all running threads
                RescheduleDownload(pG);
                SaveQueues(True);
              end;
            end;
            if pG.Status <> gfsError then begin
              // get next block
              if not PrepFile.GetNextDownloadBlock(GlobalSettings.GetRetries, iBlock, pG.Debug_GetAll) then begin
                if PrepFile.NumWorking = 0 then begin
                  MainLog('*** Splitfile download failed. Could not get enough blocks for ' + ExtractFilename(pG.SavFilename), pG, LOGLVL_IMPORTANT);
                  pG.Status := gfsError;
                  SetGetQueueListItem(item);
                  RescheduleDownload(pG);
                  SaveQueues(True);
                end;
                SetGetQueueListItem(item);
              end else begin
                // start new download thread
                Assert(GetThread = nil);
                GetHTL := GlobalSettings.GetHTL + PrepFile.BlockTries[iBlock] * GlobalSettings.GetHTLInc;
                GetThread := TDownloadThread.Create(
                               MakeThreadID(ExtractFileName(pG.SavFilename), Format('%3d/%3d',[iBlock+1,PrepFile.NumBlocks])),
                               GlobalSettings.FCPAddr, GlobalSettings.FCPPort,
                               PrepFile.Key[iBlock],
                               GetHTL, GlobalSettings.GetSkipLocal,
                               iBlock,
                               PrepFile.IsDataBlock[iBlock],
                               PrepFile.IsCheckBlock[iBlock],
                               StatusCallback,
                               GlobalSettings.GetTimeoutMin,
                               pG, pG.UniqueID,
                               True
                             );
                // mark block as working
                PrepFile.BlockWorking[iBlock] := True;
                PrepFile.WriteHeader; // should be ok, no decode thread running
                pG.BlockStat := PrepFile.GetBlockStatusString;

                // update item
                pG.Status := gfsGetting;
                pG.Progress := PrepFile.GetProgressString(GlobalSettings.GetRetries);
                SetGetQueueListItem(item, 1);
                pG.LastTick := TickCounter;
              end;
            end;
          end;
        end;
      finally
        PrepFile.Free;
      end;

      if (GetThread <> nil) or (DecThread <> nil) then break;

    end else if pG.Status = gfsDecoded then begin

      // validate checksum (even launch thread if there is no checksum!)
      if NumHighDutyThreads = 0 then begin
        // start checksum thread
        Assert(ChkThread = nil);
        ChkThread := TChecksumThread.Create(
                       MakeThreadID(ExtractFileName(pG.SavFilename), 'ChkSum'),
                       GlobalSettings.FCPAddr, GlobalSettings.FCPPort,
                       pG.SavFilename,
                       StatusCallback,
                       pG, pG.UniqueID,
                       True
                     );
        if pG.CheckSum = '' then ChkThread.DontCalcChecksum := True;
        pG.Status := gfsValidating; pG.Progress := 'Validating';
        SetGetQueueListItem(item, 1);
        pG.LastTick := TickCounter;
        SaveQueues(True);
        break;
      end;

    end;

  end;

  // if we created a new thread: add to thread pool and start
  if (PrpThread <> nil) or (InsThread <> nil)
  or (GetThread <> nil) or (DecThread <> nil) or (ChkThread <> nil) then begin
    if PrpThread <> nil then begin FThreadPool.Add(PrpThread); PrpThread.Resume; end;
    if InsThread <> nil then begin FThreadPool.Add(InsThread); InsThread.Resume; end;
    if GetThread <> nil then begin FThreadPool.Add(GetThread); GetThread.Resume; end;
    if DecThread <> nil then begin FThreadPool.Add(DecThread); DecThread.Resume; end;
    if ChkThread <> nil then begin FThreadPool.Add(ChkThread); ChkThread.Resume; end;
    UpdateThreadDisplay;
    inc(ThreadStartCount);
    if ThreadStartCount < FMaxThreadsPerTick then goto DoDutyOnceMore;
  end;
end;

procedure TFrmMain.TimerTickerTimer(Sender: TObject);
const
  LastRefresh: Int64 = 0;
  LastFlush:   TDateTime = 0;
  FLUSH_INTERVAL = (5/(24*60));
var
  Lck: Boolean;
  Err: Boolean;
  i:   Integer;
  t:   Int64;
  dt:  TDateTime;
begin
  FDoAutoRemIns := False;
  FDoAutoRemGet := False;
  Lck := False; Err := False;
  TimerTicker.Enabled := False;
  try
    try
      Lck := LockTicker; if not Lck then exit;
      try
        // Flush cached files every five minutes (unless an error occured before)
        if not FFlushError then begin
          dt := Now;
          if ((dt - LastFlush) > FLUSH_INTERVAL) or (dt < LastFlush) then begin
            try
              i := gCachedFiles.FlushAll(True);
              MainLog(Format('Flushed %d temp files',[i]), nil, LOGLVL_DEBUG);
            except
              FFlushError := True;
              raise;
            end;
            LastFlush := Now;
          end;
        end;

        if ttAnimateTrayIcon  in FTickerTasks then begin
          AnimateTrayIcon;
        end;

        if ttHandleQueueFiles in FTickerTasks then begin
          DoDuty;
          UpdateStatsDisplay;

          // update queues if we need continuous refreshing (only once per minute)
          t := GetTickCount(); if t < LastRefresh then t := t + $100000000;
          if (LastRefresh = 0) or ((t - LastRefresh) > 60000) then begin
            LastRefresh := t;
            if FNeedPermanentRefresh[qtInsQueue] then
              for i := 0 to LvInsQueue.Items.Count-1 do SetInsQueueListItem(LvInsQueue.Items[i]);
            if FNeedPermanentRefresh[qtGetQueue] then
              for i := 0 to LvGetQueue.Items.Count-1 do SetGetQueueListItem(LvGetQueue.Items[i]);
          end;
        end;
      except
        // handle unhandled ticker exceptions - this is usually a bug
        on E: Exception do begin
          Err := True;
          Log('*******************************************************');
          Log('* Possible BUG detected - unhandled exception in ticker:');
          Log('* ' + E.ClassName);
          Log('* ' + E.Message);
          Log('*******************************************************');
          Log('* Aborting all tasks...');
          Log('*******************************************************');
          LbBugDetected.Visible := True;
          BtStopClick(nil);
          BtAbortClick(nil);
          SetTrayIconAnim(taStop);
        end;
      end;
    finally
      if Lck then UnlockTicker;
      if FDoAutoRemIns and (not Err) then AutoRemoveIns;
      if FDoAutoRemGet and (not Err) then AutoRemoveGet;
      if ttHandleQueueFiles in FTickerTasks then begin
        if (FThreadPool.Count = 0) and (not FActive) then begin
          Exclude(FTickerTasks, ttHandleQueueFiles);
          UpdateThreadDisplay;
          BtStart.Enabled := True; BtStop.Enabled := False; LbActive.Visible := False;
          BtAbort.Enabled := True; FAbort := False; LbAborting.Visible := False;
        end;
      end;
    end;
  finally
    TimerTicker.Enabled := True;
  end;
end;

procedure TFrmMain.BtCheckUpdateClick(Sender: TObject);
// Sender = nil: called from DoDuty (auto-update check); ticker already locked
var
  UpdThread: TCheckUpdateThread;
  EdNum,Cnt: Integer;
  bIsAutoCheck: Boolean;
begin
  bIsAutoCheck := (Sender = nil);
  if not bIsAutoCheck then begin
    Assert(GetNumberOfThreads.NumUpdThreads = 0, 'Already checking for updates');
    if MessageDlg('Check if a new version of the FUQID site is available?', mtConfirmation, [mbYes,mbNo], 0) <> mrYes then exit;
    if not LockTicker then exit;
  end;
  try
    EdNum := CHECKUPDATEKEY_NUM;
    Cnt   := CHECKUPDATEKEY_LOOKAHEAD;
    repeat
      UpdThread := TCheckUpdateThread.Create(
                     MakeThreadID('Check for update','(ed.' + IntToStr(EdNum) + ')'),
                     GlobalSettings.FCPAddr, GlobalSettings.FCPPort,
                     CHECKUPDATEKEY_BASE + IntToStr(EdNum),
                     25, False,
                     StatusCallback,
                     nil, 0,
                     True
                   );
      FThreadPool.Add(UpdThread); UpdThread.Resume;
      BtCheckUpdate.Enabled := False; BtAbort.Enabled := True; LbActive.Visible := True;
      dec(Cnt); inc(EdNum);
    until Cnt < 0;
    UpdateThreadDisplay;
  finally
    if not bIsAutoCheck then begin
      Include(FTickerTasks, ttHandleQueueFiles); // in case we are inactive
      UnlockTicker;
    end;
  end;
end;


procedure TFrmMain.ThreadTerminated(Sender: TObject);
// note: this procedure is ONLY called from DoDuty
var
  pI:   TInsQueueFile;
  pG:   TGetQueueFile;
  item: TListItem;
  InsThread: TInsertThread;
  GetThread: TDownloadThread;
  DecThread: TFECDecodeThread;
  ChkThread: TChecksumThread;
  PrpThread: TPrepareThread;
  UpdThread: TCheckUpdateThread;
  AnyThread: TFreenetThread;
  idx:       Integer;
  bRes:      Boolean;
  iBlock:    DWord;
  PrepFile:  TPreparedFile;
  Key,SubKey: String;
  pData:     PChar;
  DataLen:   Integer;
  sMeta:     String;
  OutStr:    TFileStream;
  slMeta:    TStringList;
  slMetaHead: TStringList;
  i:         Integer;
  s:         String;
  bFound,ok: Boolean;
  bUnnecessary: Boolean;
  sCheckSum: String;
  sHeal:     String;
  iMetaPass: Integer;
  sPrepName: String;
  bColl:     Boolean;
  iEd1,iEd2: Integer;
  bFoundSubkey: Boolean;
  bIsHeader:    Boolean;
  TmpZipName:   String;
  ZipFile:      unzFile;
  ZippedFileInfo: unz_file_info;
  sZipMeta:     String;
  pZipData:     PChar;
  bZippedOpen:  Boolean;
  slZipMeta:    TStringList;
  FailReason:   TFreenetThreadFailReason;
  qt:           TQueueType;
  bIncTryCount: Boolean;
begin
  // a thread has terminated
  InsThread := nil; GetThread := nil; DecThread := nil; ChkThread := nil; PrpThread := nil; UpdThread := nil;
  if      (Sender is TInsertThread)      then InsThread := Sender as TInsertThread
  else if (Sender is TDownloadThread)    then GetThread := Sender as TDownloadThread
  else if (Sender is TFECDecodeThread)   then DecThread := Sender as TFECDecodeThread
  else if (Sender is TChecksumThread)    then ChkThread := Sender as TChecksumThread
  else if (Sender is TPrepareThread)     then PrpThread := Sender as TPrepareThread
  else if (Sender is TCheckUpdateThread) then UpdThread := Sender as TCheckUpdateThread
  else exit;

  try // ... finally UpdateThreadDisplay

    // thread marked as unnecessary? - just remove it, don't do any processing
    AnyThread := (Sender as TFreenetThread);
    if AnyThread.Unnecessary then begin
      MainLog('Ignoring completion of obsolete thread (' + AnyThread.ID + ')', nil, LOGLVL_DEBUG);

      item := nil; qt := qtInsQueue;
      
      // we need to do *some* processing, i.e. mark blocks as non-working
      try
        if InsThread <> nil then begin
          // insert thread - mark block as not working
          pI := FindInsQueueFileByUniqueID(InsThread.UserID);
          if (pI <> nil) and (pI.PrepBasename <> '') then begin
            PrepFile := TPreparedFile.CreateInsert(pI.PrepBasename);
            try
              PrepFile.ReadHeader;
              PrepFile.BlockWorking[InsThread.BlockNum] := False;
              PrepFile.WriteHeader; // ok?
            finally
              PrepFile.Free;
            end;
            item := LvInsQueue.FindData(0, pI, True, False);
            qt   := qtInsQueue;
          end;
        end;
        if PrpThread <> nil then begin
          // prepare thread - mark as unprepared
          pI := FindInsQueueFileByUniqueID(PrpThread.UserID);
          if (pI <> nil) and (pI.PrepBasename <> '') then begin
            PrepFile := TPreparedFile.CreateInsert(pI.PrepBasename);
            try
              PrepFile.DeleteFiles;
              pI.PrepBasename := '';
            finally
              PrepFile.Free;
            end;
            item := LvInsQueue.FindData(0, pI, True, False);
            qt   := qtInsQueue;
          end;
        end;
        if (GetThread <> nil) then begin
          pG := FindGetQueueFileByUniqueID(GetThread.UserID);
          if pG <> nil then begin
            if (GetThread.IsDataBlock or GetThread.IsCheckBlock) then begin
              // download thread - mark block as not working
              // CAUTION! Race cond. with DecodeThread possible (accesses PrepFile directly)
              // DecodeThread must only be started when all GetThreads are finished!
              if pG.PrepBasename <> '' then begin
                PrepFile := TPreparedFile.CreateDownload(pG.PrepBasename);
                try
                  PrepFile.ReadHeader;
                  PrepFile.BlockWorking[GetThread.BlockNum] := False;
                  PrepFile.WriteHeader;
                  pG.BlockStat := PrepFile.GetBlockStatusString;
                finally
                  PrepFile.Free;
                end;
              end;
            end else begin
              // if in state getting, but not got header yet -> reset to ready
              if (pG.Status = gfsGetting) and (pG.PrepBasename = '') then begin
                pG.Status := gfsReady; pG.Progress := '(retry)';
              end;
            end;
            item := LvGetQueue.FindData(0, pG, True, False);
            qt   := qtGetQueue;
          end;
        end;

      except
        on E: Exception do MainLog('ERROR cleaning up obsolete thread: ' + E.ClassName + ': ' + E.Message, nil, LOGLVL_IMPORTANT);
      end;

      // free thread and remove from threadpool
      idx := FThreadPool.IndexOf(AnyThread);
      if idx >= 0 then FThreadPool.Delete(idx);
      AnyThread.Free;

      CheckAbortedEntries; // clean up entries that are successfully aborted

      // refresh item
      if item <> nil then SetAnyQueueListItem(qt, item);

      exit;
    end;

    // add to statistics
    AddToStats(AnyThread.Statistics);

    // force a node-up-check if a thread failed with ftfrCutoff
    if AnyThread.FailReason = ftfrCutoff then FNodeUp.LastCheck := 0;

    if InsThread <> nil then begin
      bRes   := InsThread.InsertResult;
      pI     := InsThread.UserData;
      iBlock := InsThread.BlockNum;
      Key    := InsThread.InsertKey;
      bColl  := InsThread.KeyCollided;
      FailReason := InsThread.FailReason;

      // free thread and remove from threadpool
      InsThread.Free;
      idx := FThreadPool.IndexOf(InsThread);
      if idx >= 0 then FThreadPool.Delete(idx);

      if bRes and (Key = '') then begin bRes := False; FailReason := ftfrUnknown; end; // should never happen

      UpdateFileStats(pI, bRes, FailReason);

      try
        // just make sure..
        if pI.PrepBasename = '' then begin
          pI.Status := ifsError;
          MainLog(Format('!! Internal error: InsThread terminated,status = %d, but file is unprepared. File: %s',[Ord(pI.Status), pI.OrgFilename]), pI, LOGLVL_IMPORTANT);
          exit;
        end;

        // mark block done/not done, determine progress
        PrepFile := TPreparedFile.CreateInsert(pI.PrepBasename);
        try
          PrepFile.ReadHeader;
          PrepFile.BlockWorking[iBlock] := False;
          if bRes then begin
            PrepFile.BlockDone[iBlock] := True;
            if (PrepFile.Key[iBlock] <> '') and (PrepFile.Key[iBlock] <> Key) then
              MainLog('*** WARNING: Key mismatch. Using newer key.', pI, LOGLVL_NORMAL);
            PrepFile.Key[iBlock] := Key;
            if (iBlock = PrepFile.MainBlock) and (not pI.IsDirect) then begin
              pI.Key := RemoveFreenetPrefix(Key);
              inc(pI.HeaderInserts);
              if  (pI.HeaderInserts <= GlobalSettings.InsRepHead)
              and ((PrepFile.NumBlocks > 1) or GlobalSettings.InsSingleHead) then begin
                MainLog('Auto-reinserting header', pI, LOGLVL_DEBUG);
                PrepFile.BlockDone[iBlock] := False;
              end;
            end;
          end else
            PrepFile.BlockDone[iBlock] := False;
          PrepFile.WriteHeader; // should be ok
          if PrepFile.AllDone then begin
            pI.Status := ifsDone; pI.Progress := 'Finished';
            if (PrepFile.NumBlocks = 1) and bColl then pI.Progress := 'Collided';
            SaveQueues(True);
            LogFinishedInsert(pI);
            // AutoRemoveIns; // do NOT call this from the ticker!!!
            FDoAutoRemIns := True;
          end else
            pI.Progress := PrepFile.GetProgressString;
        finally
          PrepFile.Free;
        end;

      finally
        // update item
        item := LvInsQueue.FindData(0, pI, True, False);
        if item <> nil then SetInsQueueListItem(item);
      end;
    end;

    if PrpThread <> nil then begin
      bRes      := PrpThread.ThreadResult;
      sPrepName := PrpThread.PrepBasename;
      pI        := PrpThread.UserData;
      Key       := RemoveFreenetPrefix(PrpThread.PrecalcedKey);

      // free thread and remove from threadpool
      PrpThread.Free;
      idx := FThreadPool.IndexOf(PrpThread);
      if idx >= 0 then FThreadPool.Delete(idx);

      try
        if bRes then begin
          pI.PrepBasename := sPrepName;
          pI.Status       := ifsInserting;
          pI.Progress     := '';
          if Key <> '' then pI.Key := Key;
          MainLog('Finished preparation of ' + ExtractFileName(pI.OrgFilename), pI, LOGLVL_NORMAL);
        end else begin
          // delete prepfile if it has been created
          try
            PrepFile := TPreparedFile.CreateInsert(sPrepName);
            try
              PrepFile.DeleteFiles;
            finally
              PrepFile.Free;
            end;
          except
          end;
          pI.PrepBasename := '';
          pI.Status       := ifsError;
          pI.Progress     := '';
          MainLog('Preparation of ' + ExtractFileName(pI.OrgFilename) + ' failed', pI, LOGLVL_IMPORTANT);
        end;
        SaveQueues(True);
      finally
        // update item
        item := LvInsQueue.FindData(0, pI, True, False);
        if item <> nil then SetInsQueueListItem(item);
      end;
    end;

    if GetThread <> nil then begin
      slMeta := nil; slMetaHead := nil;
      try
        bRes    := GetThread.DownloadResult;
        pData   := GetThread.DownloadedData; // is freed when thread is freed!
        DataLen := GetThread.DownloadedDataLen;
        sMeta   := GetThread.DownloadedMetadata;
        bUnnecessary := GetThread.Unnecessary;
        FailReason   := GetThread.FailReason;

        // don't increase block-failed-counter for
        // RNFs, unsuccessful FCP connections, aborted downloads
        bIncTryCount := not (FailReason in [ftfrRNF, ftfrCutOff, ftfrAborted]);

        // remove from threadpool, free when data is processed
        idx := FThreadPool.IndexOf(GetThread);
        if idx >= 0 then FThreadPool.Delete(idx);

        if bUnnecessary then begin
          // obsolete, since this condition is catched earlier
          MainLog('Ignoring completion of obsolete download thread', nil, LOGLVL_DEBUG);
          exit;
        end;

        pG := GetThread.UserData;
        try
          UpdateFileStats(pG, bRes, FailReason);

          pG.Status := gfsError; // set status to error in case we except out
          pG.RestartAt := 0;

          if not (GetThread.IsDataBlock or GetThread.IsCheckBlock) then begin
            if not bRes then begin
              if pG.Activekey = pG.Key then s := 'Header' else s := 'Redirect';
              if pG.Retry < GlobalSettings.GetRetries then begin
                MainLog(s + ' download failed.. retrying', pG, LOGLVL_NORMAL);
                if bIncTryCount then inc(pG.Retry);
                pG.Status := gfsReady; pG.Progress := '(retry)';
              end else begin
                if GlobalSettings.GetRetMin = 0 then
                  MainLog('*** Permanent ERROR: ' + s + ' download failed', pG, LOGLVL_IMPORTANT)
                else
                  RescheduleDownload(pG, '*** ERROR: ' + s + ' download failed.');
              end;
              exit;
            end;

            if sMeta = '' then begin
              //Log('*** Permanent ERROR: header block contains no metadata');
              MainLog('Warning: Received a non-standard header block without metadata', pG, LOGLVL_NORMAL);
              bFound := False;

            end else begin

              // metadata block
              slMeta := TStringList.Create; slMetaHead := TStringList.Create;

              // todo : support of redirects, other keys, subkeys

              // split current key into key / subkey part
              Key := pG.Activekey; SubKey := '';
              i := Pos('//',Key);
              if i <> 0 then begin
                SubKey := Copy(Key,i+2,Length(Key)); Delete(Key,i,Length(Key));
              end;

              bFoundSubkey := False;
              for iMetaPass := 1 to 2 do begin
                slMeta.Clear; slMetaHead.Clear;
                FCPMsgToStringList(sMeta, slMeta);

                // move everything up to first part to slMetaHead
                while (slMeta.Count > 0) and (slMeta.Strings[0] <> 'Document') do begin
                  slMetaHead.Add(slMeta.Strings[0]); slMeta.Delete(0);
                end;
                // find part named like Subkey
                i := 0; s := ''; bFound := False;
                while i < slMeta.Count do begin
                  if (Copy(slMeta.Strings[i],1,5) = 'Name=') then begin
                    s := Copy(slMeta.Strings[i],6,Length(slMeta.Strings[i]));
                    inc(i);
                  end else if (slMeta.Strings[i] = 'EndPart') or (slMeta.Strings[i] = 'End') then begin
                    // was this the correct part?
                    if ((iMetaPass = 1) and (CompareText(s,SubKey) = 0)) then bFoundSubkey := True;
                    if bFoundSubkey or ((iMetaPass = 2) and (s = '')) then begin
                      while i < slMeta.Count do slMeta.Delete(i); // delete 'End' and rest of meta
                      if slMeta.Count > 0 then slMeta.Delete(0);  // delete 'Document'
                      bFound := True; break;
                    end else begin
                      // remove this part
                      while i >= 0 do begin slMeta.Delete(0); dec(i); end;
                      i := 0; s := '';
                      if (slMeta.Count > 0) and (slMeta.Strings[0] <> 'Document') then break; // invalid metadata
                    end;
                  end else
                    inc(i);
                end;
                if bFound then begin
                  if (slMeta.IndexOfName('ExtInfo.URI') >= 0)
                  or (slMeta.IndexOfName('ExtInfo.Trailing') >= 0) then begin
                    MainLog('*** Metadata contains ExtInfo - this is not yet supported.', pG, LOGLVL_IMPORTANT);
                    bFound := False;
                  end;
                end;
                if (not bFound) and (SubKey = '') and (DataLen > 0) and (slMeta.Count = 0) then bFound := True; // that's ok

                if bFound then break;

                // retry with default section?
                if (iMetaPass > 1) or (SubKey = '') then begin
                  MainLog('*** Permanent ERROR: invalid metadata, subkey not found or I am too stupid to parse it', pG, LOGLVL_IMPORTANT);
                  exit;
                end;

              end;

              // redirect ?
              if bFound then begin
                s := slMeta.Values['Redirect.Target'];
                if s <> '' then begin
                  pG.Activekey := s;
                  if (SubKey <> '') and (not bFoundSubkey) then pG.Activekey := pG.Activekey + '//' + SubKey;
                  MainLog('*** Metadata-redirect to: ' + pG.Activekey, pG, LOGLVL_DEBUG);
                  pG.Status := gfsReady; // not getting!
                  exit;
                end;

                s := slMeta.Values['DateRedirect.Target'];
                if s <> '' then begin
                  try
                    if SubKey <> '' then s := s + '//' + SubKey;
                    pG.Activekey := GetDateRedirKey(
                                      s,
                                      StrToIntDef('$'+slMeta.Values['DateRedirect.Increment'], $15180),
                                      StrToIntDef('$'+slMeta.Values['DateRedirect.Offset'   ], 0)
                                    );
                    MainLog('*** Metadata-date-redirect to: ' + pG.Activekey, pG, LOGLVL_DEBUG);
                    pG.Status := gfsReady; // not getting!
                    exit;
                  except
                    on E: Exception do begin
                      MainLog('*** Permanent ERROR parsing date-redirect: ' + E.Message, pG, LOGLVL_IMPORTANT);
                      exit;
                    end;
                  end;
                end;

                // it's no redirect - if subkey was specified but not found: zip? - or error
                if (SubKey <> '') and (not bFoundSubkey) then begin
                  // zip Container? -- only very simple handling currently! --
                  if (DataLen <> 0) and (slMeta.Values['Info.Format'] = 'application/zip') then begin
                    // save zip to a temp. file
                    TmpZipName := GetUniquePrepareName(False) + '.zip';
                    OutStr := CreateFileStream(TmpZipName, fmCreate or fmShareExclusive);
                    try
                      try
                        if DataLen <> 0 then OutStr.WriteBuffer(pData^, DataLen);
                      except
                        on E: Exception do begin
                          MainLog('*** Permanent ERROR: Failed to save temp. zip container: ' + E.ClassName + ': ' + E.Message, pG, LOGLVL_IMPORTANT);
                          exit;
                        end;
                      end;
                    finally
                      OutStr.Free;
                    end;
                    ZipFile := nil; pZipData := nil; bZippedOpen := False; slZipMeta := nil;
                    try
                      try
                        // open zip
                        ZipFile := unzOpen(PChar(TmpZipName));
                        if ZipFile = nil then raise EAbort.Create('Failed to open temp. zip container');

                        // look for metadata ('manifest' or 'metadata') - we could skip this and directly look for the file....
                        if (unzLocateFile(ZipFile, 'manifest', 2) <> UNZ_OK) and (unzLocateFile(ZipFile, 'metadata', 2) <> UNZ_OK) then
                          raise EAbort.Create('No metadata found in zip container');
                        if unzGetCurrentFileInfo(ZipFile, @ZippedFileInfo, nil, 0, nil, 0, nil, 0) <> UNZ_OK then
                          raise EAbort.Create('Error reading zip container (metadata)');
                        GetMem(pZipData, ZippedFileInfo.uncompressed_size + 1); FillChar(pZipData^, ZippedFileInfo.uncompressed_size + 1, 0);
                        if unzOpenCurrentFile(ZipFile) <> UNZ_OK then raise EAbort.Create('Error accessing metadata in zip container');
                        bZippedOpen := True;
                        if uLong(unzReadCurrentFile(ZipFile, pZipData, ZippedFileInfo.uncompressed_size)) <> ZippedFileInfo.uncompressed_size then
                          raise EAbort.Create('Error extracting metadata from zip container');
                        sZipMeta := pZipData;
                        bZippedOpen := False;
                        unzCloseCurrentFile(ZipFile);
                        // now look for subkey in metadata
                        slZipMeta := TStringList.Create;
                        slZipMeta.Text := sZipMeta;
                        ok := False;
                        for i := 0 to slZipMeta.Count-1 do begin
                          ok := (slZipMeta.Strings[i] = 'Name='+SubKey);
                          if ok then break;
                        end;
                        if not ok then raise EAbort.Create('subkey "'+SubKey+'" not listed in metadata of zip container');

                        if pZipData <> nil then FreeMem(pZipData);
                        pZipData := nil;

                        // extract the file
                        if unzLocateFile(ZipFile, PChar(SubKey), 2) <> UNZ_OK then raise EAbort.Create('file "'+SubKey+'" not found in zip container'); 
                        if unzGetCurrentFileInfo(ZipFile, @ZippedFileInfo, nil, 0, nil, 0, nil, 0) <> UNZ_OK then
                          raise EAbort.Create('Error reading zip container');
                        GetMem(pZipData, ZippedFileInfo.uncompressed_size);
                        if unzOpenCurrentFile(ZipFile) <> UNZ_OK then raise EAbort.Create('Error accessing data in zip container');
                        bZippedOpen := True;
                        if uLong(unzReadCurrentFile(ZipFile, pZipData, ZippedFileInfo.uncompressed_size)) <> ZippedFileInfo.uncompressed_size then
                          raise EAbort.Create('Error extracting data from zip container');
                        bZippedOpen := False;
                        unzCloseCurrentFile(ZipFile);

                        // save file
                        OutStr := CreateFileStream(pG.SavFilename, fmCreate or fmShareExclusive);
                        try
                          ok := True;
                          try
                            if ZippedFileInfo.uncompressed_size <> 0 then OutStr.WriteBuffer(pZipData^, ZippedFileInfo.uncompressed_size);
                          except
                            on E: Exception do begin
                              MainLog('*** Permanent ERROR: Failed to save output file: ' + E.ClassName + ': ' + E.Message, pG, LOGLVL_IMPORTANT);
                              ok := False;
                            end;
                          end;
                        finally
                          OutStr.Free;
                        end;
                        pG.Size := ZippedFileInfo.uncompressed_size;
                        if not ok then begin
                          pG.Status := gfsError; pG.Progress := '!Save error';
                        end else begin
                          MainLog('Successfully retrieved ' + pG.Key + ' (' + pG.SavFilename + ')', pG, LOGLVL_NORMAL);
                          pG.Status := gfsDone; pG.Progress := '';
                          SaveQueues(True);
                          // AutoRemoveGet; // do NOT call this from the ticker!!!
                          FDoAutoRemGet := True;
                        end;
                        exit;

                      except
                        on E: Exception do begin
                          if E is EAbort then
                            MainLog('*** Permanent ERROR: ' + E.Message, pG, LOGLVL_IMPORTANT)
                          else
                            MainLog('*** Permanent ERROR: ' + E.ClassName + ': ' + E.Message, pG, LOGLVL_IMPORTANT);
                          exit;
                        end;
                      end;
                    finally
                      if bZippedOpen then unzCloseCurrentFile(ZipFile);
                      if ZipFile <> nil then unzClose(ZipFile);
                      if pZipData <> nil then FreeMem(pZipData);
                      slZipMeta.Free;
                      DeleteFile(TmpZipName);
                    end;
                  end;
                  MainLog('*** Permanent ERROR: subkey "'+SubKey+'" not found in metadata or I am too stupid to parse it', pG, LOGLVL_IMPORTANT);
                  exit;
                end;
              end;

              // any better way to detect a splitfile?
              bFound := False;
              for i := 0 to slMeta.Count-1 do
                if Copy(slMeta.Strings[i],1,Length('SplitFile.')) = 'SplitFile.' then begin
                  bFound := True; break;
                end;

            end;

            if not bFound then begin
              // not a splitfile; save data, done
              OutStr := CreateFileStream(pG.SavFilename, fmCreate or fmShareExclusive);
              try
                ok := True;
                try
                  if DataLen <> 0 then OutStr.WriteBuffer(pData^, DataLen);
                except
                  on E: Exception do begin
                    MainLog('*** Permanent ERROR: Failed to save output file: ' + E.ClassName + ': ' + E.Message, pG, LOGLVL_IMPORTANT);
                    ok := False;
                  end;
                end;
              finally
                OutStr.Free;
              end;
              pG.Size := DataLen;
              if not ok then begin
                pG.Status := gfsError; pG.Progress := '!Save error';
              end else begin
                pG.Status := gfsDone; pG.Progress := '';
                SaveQueues(True);
                LogFinishedGet(pG);
                // AutoRemoveGet; // do NOT call this from the ticker!!!
                FDoAutoRemGet := True;
              end;
              exit;
            end;

            // splitfile
            Assert(slMeta <> nil);
            if slMeta.IndexOfName('SplitFile.Size') >= 0 then
              try pG.Size := StrToInt('$'+slMeta.Values['SplitFile.Size']); except end;
            pG.CheckSum := slMeta.Values['Info.Checksum'];
            MainLog('Retrieved splitfile header; starting splitfile download', pG, LOGLVL_NORMAL);
            pG.PrepBasename := GetUniquePrepareName(False);
            ok := True;
            PrepFile := TPreparedFile.CreateDownload(pG.PrepBasename);
            try
              // rebuild valid metadata
              slMeta.Insert(0, 'Document'); slMeta.Add('End');
              for i := slMetaHead.Count-1 downto 0 do slMeta.Insert(0,slMetaHead.Strings[i]);
              try
                PrepFile.InitFromSplitFileMetadata(
                  GlobalSettings.FCPAddr, GlobalSettings.FCPPort,
                  StringListToFCPMsg(slMeta, '')
                );
              except
                on E: Exception do begin
                  MainLog('*** Permanent ERROR: Failed to init splitfile download: ' + E.ClassName + ': ' + E.Message, pG, LOGLVL_IMPORTANT);
                  ok := False;
                end;
              end;
              if ok then PrepFile.WriteHeader; // should be ok
            finally
              PrepFile.Free;
            end;

            if not ok then begin
              pG.Status := gfsError; pG.Progress := '!Init error';
              pG.PrepBasename := '';
            end else begin
              pG.Status := gfsGetting;
              SaveQueues(True);
            end;
            
          end else begin
            // it's a splitfile block
            iBlock  := GetThread.BlockNum;

            // just make sure..
            if pG.PrepBasename = '' then begin
              pG.Status := gfsError;
              MainLog(Format('!! Internal error: GetThread terminated,status = %d, but file is unprepared. File: %s',[Ord(pG.Status) ,pG.SavFilename]), pG, LOGLVL_IMPORTANT);
              exit;
            end;

            // mark block done/not done, increase try count, save data, determine progress
            PrepFile := TPreparedFile.CreateDownload(pG.PrepBasename);
            try
              PrepFile.ReadHeader;

              // detect Fuqid 1.2 insert bug
              if bRes and GetThread.IsDataBlock then begin
                if PrepFile.FixLastDatablockPadding(iBlock, pData, DataLen) then
                  MainLog('Fuqid 1.2 insert bug detected and fixed!', pG, LOGLVL_IMPORTANT);
              end;

              PrepFile.BlockWorking[iBlock] := False;
              PrepFile.BlockDone   [iBlock] := bRes;
              if bIncTryCount then PrepFile.BlockTries[iBlock] := PrepFile.BlockTries[iBlock]+1;
              if bRes then PrepFile.WriteData(iBlock,pData,DataLen,sMeta);
              PrepFile.WriteHeader; // should be ok, after WriteData!
              pG.Status := gfsGetting;  pG.Progress := PrepFile.GetProgressString(GlobalSettings.GetRetries);
              pG.BlockStat := PrepFile.GetBlockStatusString;
              pG.PriorityBoost := (PrepFile.AllDone and (not pG.Debug_GetAll)); // flag it as decode-ready
            finally
              PrepFile.Free;
            end;
          end;

        finally
          // update item
          item := LvGetQueue.FindData(0, pG, True, False);
          if item <> nil then SetGetQueueListItem(item);
        end;
      finally
        slMeta.Free;
        slMetaHead.Free;
        GetThread.Free;
      end;
    end;

    if DecThread <> nil then begin
      bRes    := DecThread.DecodeResult;
      pG      := DecThread.UserData;
      //sHeal   := DecThread.HealBlocks;

      // free thread and remove from threadpool
      DecThread.Free;
      idx := FThreadPool.IndexOf(DecThread);
      if idx >= 0 then FThreadPool.Delete(idx);

      try
        pG.Status := gfsError; pG.Progress := '';
        if bRes then begin
          // just make sure..
          if pG.PrepBasename = '' then begin
            pG.Status := gfsError;
            MainLog(Format('!! Internal error: DecThread terminated,status = %d, but file is unprepared. File: %s',[Ord(pG.Status), pG.SavFilename]), pG, LOGLVL_IMPORTANT);
            exit;
          end;
          pG.Status := gfsDecoded; // file is now saved in decode thread
          pG.PriorityBoost := True;
          {
          // save output file
          PrepFile := TPreparedFile.CreateDownload(pG.PrepBasename);
          try
            PrepFile.ReadHeader;
            try
              PrepFile.SaveOutputFile(pG.SavFilename);
              pG.Status := gfsDecoded;
            except
              on E: Exception do begin
                MainLog('*** Permanent ERROR: Failed to save output file: ' + E.ClassName + ': ' + E.Message, pG, LOGLVL_IMPORTANT);
                pG.Progress := '!Save error';
              end;
            end;
          finally
            PrepFile.Free;
          end;
          }
        end else begin
          MainLog('*** Permanent ERROR: Decode & save failed.', pG, LOGLVL_IMPORTANT);
          pG.Status := gfsError; pG.Progress := 'Decode failed';
        end;
        SaveQueues(True);
      finally
        // update item
        item := LvGetQueue.FindData(0, pG, True, False);
        if item <> nil then SetGetQueueListItem(item);
      end;
    end;

    if ChkThread <> nil then begin
      bRes      := ChkThread.ThreadResult;
      pG        := ChkThread.UserData;
      sChecksum := ChkThread.Checksum;

      // free thread and remove from threadpool
      ChkThread.Free;
      idx := FThreadPool.IndexOf(ChkThread);
      if idx >= 0 then FThreadPool.Delete(idx);

      try
        if bRes and (CompareText(pG.CheckSum,sChecksum) = 0) then begin
          pG.Status := gfsDone;
          pG.Progress := '';
          if pG.CheckSum <> '' then
            MainLog('**** Validated checksum of ' + ExtractFileName(pG.SavFilename), pG, LOGLVL_NORMAL)
          else
            MainLog('**** Checksum not available, assuming file is valid: ' + ExtractFileName(pG.SavFilename), pG, LOGLVL_NORMAL);
        end else begin
          pG.Status := gfsError;
          if bRes then begin
            pG.Progress := '!Checksum mismatch!';
            MainLog('**** ERROR: Checksum mismatch for ' + ExtractFileName(pG.SavFilename), pG, LOGLVL_IMPORTANT);
          end else begin
            pG.Progress := '!Checksum error!';
            MainLog('**** ERROR: Error calculating checksum for ' + ExtractFileName(pG.SavFilename), pG, LOGLVL_IMPORTANT);
          end;
        end;

        if pG.Status = gfsDone then begin
          LogFinishedGet(pG);

          // just make sure..
          if pG.PrepBasename = '' then begin
            // pG.Status := gfsError; // don't set to error here
            MainLog(Format('!! Internal error: DecThread terminated,status = %d, but file is unprepared. File: %s',[Ord(pG.Status), pG.SavFilename]), pG, LOGLVL_IMPORTANT);
            exit;
          end;

          // make heal blocks and delete prepfile
          PrepFile := TPreparedFile.CreateDownload(pG.PrepBasename);
          try
            PrepFile.ReadHeader;
            sHeal := PrepFile.GetHealBlocks(GlobalSettings.GetHealPerc);
            if sHeal <> '' then
              try
                MainLog('Adding heal blocks to insert queue: ' + sHeal, pG, LOGLVL_NORMAL);
                GenerateHealInsert(True, 'Heal blocks for ' + ExtractFilename(pG.SavFilename), PrepFile, sHeal, InsertStyle_Fuqid);
              except
                on E: Exception do begin
                  MainLog('**** Error creating heal blocks for ' + ExtractFileName(pG.SavFilename) + ': ' + E.ClassName + ': ' + E.Message, pG, LOGLVL_IMPORTANT);
                end;
              end;

            if not FDebugKeepPrepFiles then begin
              PrepFile.DeleteFiles;
              pG.PrepBasename := '';
            end;
          finally
            PrepFile.Free;
          end;

          SaveQueues(True);
          // AutoRemoveGet; // do NOT call this from the ticker!!!
          FDoAutoRemGet := True;
        end;

      finally
        // update item
        item := LvGetQueue.FindData(0, pG, True, False);
        if item <> nil then SetGetQueueListItem(item);
      end;

    end;

    if UpdThread <> nil then begin
      bRes      := UpdThread.UpdateFound;
      Key       := UpdThread.UpdateKey;

      if UpdThread.ThreadResult then FLastUpdateCheck := Now;

      // free thread and remove from threadpool
      UpdThread.Free;
      idx := FThreadPool.IndexOf(UpdThread);
      if idx >= 0 then FThreadPool.Delete(idx);


      if bRes then begin
        if FUpdateKey <> '' then begin
          s := FUpdateKey;
          while Pos('/',s) <> 0 do Delete(s,1,Pos('/',s));
          iEd1 := StrToIntDef(s, 0);
          s := Key;
          while Pos('/',s) <> 0 do Delete(s,1,Pos('/',s));
          iEd2 := StrToIntDef(s, 0);
          if iEd2 > iEd1 then FUpdateKey := Key;
        end else
          FUpdateKey := Key;

        // abort all other running update threads
        for i := 0 to FThreadPool.Count-1 do begin
          if TFreenetThread(FThreadPool.Items[i]) is TCheckUpdateThread then begin
            UpdThread := TFreenetThread(FThreadPool.Items[i]) as TCheckUpdateThread;
            UpdThread.Unnecessary := True;
            UpdThread.Terminate;
          end;
        end;
      end;
    end;

  finally
    // update thread display
    UpdateThreadDisplay;
  end;
end;

procedure TFrmMain.UpdateThreadDisplay;
var inf: TNumThreadsInfo;
begin
  inf := GetNumberOfThreads;
  LbActiveInsertThreads.Caption   := Format('%d/%d', [inf.NumInsThreads, GlobalSettings.InsThreads]);
  LbActiveDownloadThreads.Caption := Format('%d/%d', [inf.NumGetThreads, GlobalSettings.GetThreads]);
  LbDecodeThreadActive.Visible    := (inf.NumDecThreads > 0);
  LbChecksumThreadActive.Visible  := (inf.NumChkThreads > 0);
  LbPrepareThreadActive.Visible   := (inf.NumPrpThreads > 0);
  LbUpdateThreadActive.Visible    := (inf.NumUpdThreads > 0);
  LbActiveInsertThreads.Update;
  LbActiveDownloadThreads.Update;
  LbDecodeThreadActive.Update;
  LbChecksumThreadActive.Update;
  LbPrepareThreadActive.Update;
  LbUpdateThreadActive.Update;
  // Update check stuff
  if FUpdateKey <> '' then begin
    LbUpdateFound.Visible := True;
    BtCheckUpdate.Visible := False;
  end else begin
    LbUpdateFound.Visible := False;
    BtCheckUpdate.Visible := True;
    BtCheckUpdate.Enabled := (inf.NumUpdThreads = 0);
  end;
  // update stats
  UpdateStatsDisplay;
end;

procedure TFrmMain.UpdateStatsDisplay;
begin
  // update stats
  CalcStats;
  LbStatsBytesUp.Caption := NumBytesToStr(FStats.BytesUp);
  LbStatsBytesDn.Caption := NumBytesToStr(FStats.BytesDn);
  LbStatsSpeedUp.Caption := Format('%.1n k/s', [FStats.SpeedUp / 1024]);
  LbStatsSpeedDn.Caption := Format('%.1n k/s', [FStats.SpeedDn / 1024]);
  LbStatsAvgSpUp.Caption := Format('%.1n k/s', [FStats.AvgSpUp / 1024]);
  LbStatsAvgSpDn.Caption := Format('%.1n k/s', [FStats.AvgSpDn / 1024]);
end;

function TFrmMain.NumInsThreads: Integer;
begin
  Result := GetNumberOfThreads.NumInsThreads;
end;

function TFrmMain.NumGetThreads: Integer;
begin
  Result := GetNumberOfThreads.NumGetThreads;
end;

function TFrmMain.NumHighDutyThreads: Integer;
var inf: TNumThreadsInfo;
begin
  inf := GetNumberOfThreads;
  Result := inf.NumDecThreads + inf.NumChkThreads + inf.NumPrpThreads;
end;

function  TFrmMain.GetNumberOfThreads: TNumThreadsInfo;
var i: Integer;
begin
  Result.NumInsThreads := 0;
  Result.NumGetThreads := 0;
  Result.NumDecThreads := 0;
  Result.NumChkThreads := 0;
  Result.NumPrpThreads := 0;
  Result.NumUpdThreads := 0;
  for i := 0 to FThreadPool.Count-1 do
    if      TFreenetThread(FThreadPool.Items[i]) is TInsertThread      then inc(Result.NumInsThreads)
    else if TFreenetThread(FThreadPool.Items[i]) is TDownloadThread    then inc(Result.NumGetThreads)
    else if TFreenetThread(FThreadPool.Items[i]) is TFECDecodeThread   then inc(Result.NumDecThreads)
    else if TFreenetThread(FThreadPool.Items[i]) is TChecksumThread    then inc(Result.NumChkThreads)
    else if TFreenetThread(FThreadPool.Items[i]) is TPrepareThread     then inc(Result.NumPrpThreads)
    else if TFreenetThread(FThreadPool.Items[i]) is TCheckUpdateThread then inc(Result.NumUpdThreads);
end;



procedure TFrmMain.FCPconsole1Click(Sender: TObject);
begin
  if not Assigned(FrmFCPConsole) then FrmFCPConsole := TFrmFCPConsole.Create(Self);
  if FrmFCPConsole.Showing then FrmFCPConsole.BringToFront else FrmFCPConsole.Show;
end;

function TFrmMain.RemoveFreenetPrefix(const sKey: String): String;
// remove 'freenet:' from the Key
begin
  Result := sKey;
  if CompareText(Copy(Result,1,Length('freenet:')), 'freenet:') = 0 then
    Delete(Result,1,Length('freenet:'));
end;

procedure TFrmMain.MiAnyQueueOpenFileClick(Sender: TObject);
var
  qt:   TQueueType;
  item: TListItem;
  pQ:   TQueueFile;
  sDir,sFNam: String;
  i:    Integer;
begin
  if not FindQueueType(Sender, qt) then exit;

  sFNam := '';
  if not LockTicker then exit;
  try
    item := FQueueInfo[qt].ListView.Selected; if item = nil then exit;
    pQ := item.Data; if pQ = nil then exit;
    if qt = qtInsQueue then
      sFNam := (pQ as TInsQueueFile).OrgFilename
    else
      sFNam := (pQ as TGetQueueFile).SavFilename;
  finally
    UnlockTicker;
  end;
  if sFNam = '' then exit;

  if not FileExists(sFNam) then begin
    MessageDlg('The file "' + sFNam + '" does not exist.', mtError, [mbOk], 0);
    exit;
  end;
  sDir := ExtractFilePath(sFNam);
  i := ShellExecute(Handle, nil, PChar(sFNam), nil, PChar(sDir), SW_SHOW);
  if i <= 32 then
    MessageDlg('Failed to open file "' + sFNam + '". Error code ' + IntToStr(i), mtError, [mbOk], 0);
end;

procedure TFrmMain.GenerateHealInsert(CalledFromTicker: Boolean; Descript: String; PrepFile: TPreparedFile; HealBlocks: String; Style: TInsertStyle);
// generate a new insert queue entry for heal blocks
var
  HealPrepFile: TPreparedFile;
  HealList:     TList;
  s,sMeta:      String;
  i:            Integer;
  pData:        PChar;
  DataLen:      DWord;
  Size:         DWord;
  Lck:          Boolean;
begin
  if HealBlocks = '' then exit;

  HealPrepFile := nil; HealList := nil; pData := nil; Lck := False;
  try
    if not CalledFromTicker then begin
      Lck := LockTicker; if not Lck then exit;
    end;

    HealList := TList.Create;
    s := HealBlocks + ',';
    while Pos(',',s) > 0 do begin
      HealList.Add(Pointer(StrToInt('$'+Copy(s,1,Pos(',',s)-1))));
      Delete(s,1,Pos(',',s));
    end;

    HealPrepFile := TPreparedFile.CreateInsert(GetUniquePrepareName(True));
    HealPrepFile.InitHeal(HealList.Count);
    HealPrepFile.WriteHeader; // ok
    Size := 0;
    for i := 0 to HealList.Count-1 do begin
      Assert(pData = nil);
      PrepFile.GetData(DWord(HealList.Items[i]), pData, DataLen, sMeta);
      try
        HealPrepFile.WriteData(i, pData, DataLen, sMeta);
        inc(Size, DataLen);
      finally
        if pData <> nil then FreeMem(pData); pData := nil;
      end;
    end;
    HealPrepFile.WriteHeader; // ok

    AddToInsQueue(True, True, Descript, HealPrepFile.Basename, Size, Style, False, '');
    UpdateInsertQueue(True);
    SaveQueues(True);
    
  finally
    if Lck then UnlockTicker;
    HealPrepFile.Free;
    HealList.Free;
    if pData <> nil then FreeMem(pData);
  end;
end;

procedure TFrmMain.Dontdeleteprepfiles1Click(Sender: TObject);
begin
  Dontdeleteprepfiles1.Checked := not Dontdeleteprepfiles1.Checked;
  FDebugKeepPrepFiles := Dontdeleteprepfiles1.Checked;
end;

function TFrmMain.GetKeyPart(sFullKey: String): String;
var sType: String;
begin
  Result := sFullKey;
  sType := UpperCase(Copy(RemoveFreenetPrefix(sFullKey),1,4));

  if sType = 'SSK@' then begin
    if Pos('//',sFullKey) <> 0 then
      Result := Copy(sFullKey,1,Pos('//',sFullKey)-1);
    exit;
  end;

  if sType = 'CHK@' then begin
    if Pos('/',sFullKey) <> 0 then
      Result := Copy(sFullKey,1,Pos('/',sFullKey)-1);
  end;
end;

procedure TFrmMain.Settickerinterval1Click(Sender: TObject);
var
  s: String;
  i: Integer;
begin
  s := IntToStr(TimerTicker.Interval);
  if not InputQuery('Set ticker interval','Milliseconds',s) then exit;
  i := StrToInt(s);
  if i < 100 then raise Exception.Create('Invalid interval. Minimum is 100ms.');
  TimerTicker.Interval := i;
end;

procedure TFrmMain.Setthreadspertick1Click(Sender: TObject);
var
  s: String;
  i: Integer;
begin
  s := IntToStr(FMaxThreadsPerTick);
  if not InputQuery('Max new threads per tick','Number of threads',s) then exit;
  i := StrToInt(s);
  if i < 1 then raise Exception.Create('Invalid. Minimum is 1.');
  FMaxThreadsPerTick := i;
end;


procedure TFrmMain.CbAutoRemoveClick(Sender: TObject);
begin
  if Sender = CbInsAutoRemove then AutoRemoveIns
  else if Sender = CbGetAutoRemove then AutoRemoveGet;
end;

procedure TFrmMain.AutoRemoveIns;
var
  i:  Integer;
  pI: TInsQueueFile;
  DelList: TList;
  bRemoveNonHeal: Boolean;
begin
  bRemoveNonHeal := CbInsAutoRemove.Checked;
  DelList := nil;
  if not LockTicker then exit;
  try
    DelList := TList.Create;
    for i := 0 to LvInsQueue.Items.Count-1 do begin
      pI := LvInsQueue.Items[i].Data;
      if (pI.Status = ifsDone) and (pI.IsHeal or bRemoveNonHeal) then DelList.Add(LvInsQueue.Items[i]);
    end;
    for i := 0 to DelList.Count-1 do DeleteInsQueueItem(DelList.Items[i]);
    if DelList.Count > 0 then SaveQueues(True);
  finally
    UnlockTicker;
    DelList.Free;
  end;
end;

procedure TFrmMain.AutoRemoveGet;
var
  i:  Integer;
  pG: TGetQueueFile;
  DelList: TList;
begin
  if not CbGetAutoRemove.Checked then exit;
  DelList := nil;
  if not LockTicker then exit;
  try
    DelList := TList.Create;
    for i := 0 to LvGetQueue.Items.Count-1 do begin
      pG := LvGetQueue.Items[i].Data;
      if pG.Status = gfsDone then DelList.Add(LvGetQueue.Items[i]);
    end;
    for i := 0 to DelList.Count-1 do DeleteGetQueueItem(DelList.Items[i]);
    if DelList.Count > 0 then SaveQueues(True);
  finally
    UnlockTicker;
    DelList.Free;
  end;
end;


procedure TFrmMain.BtAboutClick(Sender: TObject);
begin
  MessageDlg(
      APPNAME + ' ' + VERSIONSTRING + '    -    ' + APPDESC + #13
    +'(c) 2003-2005 mxbee'#13#13#13
    +'This program is free software; you can redistribute it and/or modify'#13
    +'it under the terms of the GNU General Public License as published by'#13
    +'the Free Software Foundation; either version 2 of the License, or'#13
    +'(at your option) any later version.'#13
    +#13
    +'This program is distributed in the hope that it will be useful,'#13
    +'but WITHOUT ANY WARRANTY; without even the implied warranty of'#13
    +'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the'#13
    +'GNU General Public License for more details.'#13
    +#13
    +'You should have received a copy of the GNU General Public License'#13
    +'along with this program; if not, write to the Free Software'#13
    +'Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA'
    +#13
    +#13
    +'Zip file support: Paszlib (c) 1998,1999,2000 by Jacques Nomssi Nzali',
    mtInformation, [mbOk], 0
  );
end;

// Trayicon stuff
const TRAYICON_ID = 1;

procedure TFrmMain.AppMinimized(Sender: TObject);
begin
  if not GlobalSettings.MinToTray then exit;

  // hide app - only if tray icon is visible
  if FTrayIconVisible then
    ShowWindow(Application.Handle, SW_HIDE);
end;

procedure TFrmMain.AppRestored(Sender: TObject);
begin
  // just make sure...
  if not IsWindowVisible(Application.Handle) then ShowWindow(Application.Handle, SW_SHOW);
end;

procedure TFrmMain.RestoreApp;
begin
  if not IsWindowVisible(Application.Handle) then ShowWindow(Application.Handle, SW_SHOW);
  Application.ProcessMessages;
  Application.Restore;
  Application.BringToFront;
end;

procedure TFrmMain.MinimizeApp(ForceToTray: Boolean);
begin
  Application.Minimize;
  Application.ProcessMessages;
  if ForceToTray then begin
    if IsWindowVisible(Application.Handle) then ShowWindow(Application.Handle, SW_HIDE);
  end;
end;

procedure TFrmMain.TrayIconMessage(var M: TMessage);
begin
  if M.WParam <> TRAYICON_ID then exit;
  if M.LParam = WM_LBUTTONDBLCLK then begin
    // restore TrayIcon
    if (FTrayAnim = taStop) or (FTrayAnim = taGlow) then begin
      if FActive then SetTrayIconAnim(taActive) else SetTrayIconAnim(taSleep);
    end;
    if IsWindowVisible(Application.Handle) then MinimizeApp(True) else RestoreApp;
  end;
end;

function TFrmMain.SetTrayIcon(Icon: HICON; Force: Boolean): Boolean;
var NIData: TNotifyIconData;
begin
  Result := False;

  FillChar(NIData, SizeOf(NIData), 0);
  NIData.cbSize := SizeOf(NIData);
  NIData.Wnd    := Handle; // Main form handle
  NIData.uID    := TRAYICON_ID;

  if Icon <> 0 then begin
    if not FTrayIconVisible then begin
      // create new tray icon
      NIData.uFlags := NIF_ICON or NIF_MESSAGE or NIF_TIP;
      NIData.uCallbackMessage := WMFUQID_TRAYICON;
      NIData.hIcon  := Icon;
      StrPLCopy(NIData.szTip, APPNAME, 63);
      if not Shell_NotifyIcon(NIM_ADD, @NIData) then exit;
    end else begin
      // modify existing
      if Force or (Icon <> FCurrentTrayIcon) then begin
        NIData.uFlags := NIF_ICON;
        NIData.hIcon  := Icon;
        if not Shell_NotifyIcon(NIM_MODIFY, @NIData) then exit;
      end;
    end;
    FTrayIconVisible := True;
  end else begin
    // destroy try icon
    if Force or (Icon <> FCurrentTrayIcon) then begin
      Shell_NotifyIcon(NIM_DELETE, @NIData);
      FTrayIconVisible := False;
    end;
  end;
  Result := True;
  FCurrentTrayIcon := Icon;
end;

procedure TFrmMain.SetTrayIconAnim(Anim: TTrayAnim);
begin
  if FTrayAnim = Anim then exit;
  FTrayAnim := Anim;
  FTrayAnimCount := 0;
  AnimateTrayIcon;
end;

procedure TFrmMain.AnimateTrayIcon;
var IconNum: Integer;
begin
  IconNum := TRAYANIM_SEQUENCE[FTrayAnim].IconNum[FTrayAnimCount];
  if IconNum >= 0 then SetTrayIcon( FTrayIcons[IconNum] );
  if GlobalSettings.TrayAnim then begin
    inc(FTrayAnimCount);
    if FTrayAnimCount > TRAYANIM_SEQUENCE[FTrayAnim].MaxCnt then FTrayAnimCount := 0;
  end else
    FTrayAnimCount := 0;
end;


function TFrmMain.LockTicker(ForLongOperation: Boolean; TimeoutMillis: Integer): Boolean;
var
  tStart,t: Int64; // use Int64 to avoid timer wrapping problems
begin
  tStart := GetTickCount();
  repeat
    if not FTickerLock.Locked then begin
      FTickerLock.Locked := True;
      if ForLongOperation and TimerTicker.Enabled then begin
        TimerTicker.Enabled := False; FTickerLock.DisabledTimer := True;
      end else
        FTickerLock.DisabledTimer := False;
      Result := True; exit;
    end;
    Application.ProcessMessages;
    t := GetTickCount(); if t < tStart then t := t + $100000000;
  until t > (tStart + TimeoutMillis);
  Result := False;
  MainLog('!!! Failed to lock ticker', nil, LOGLVL_IMPORTANT); Beep;
end;

procedure TFrmMain.UnLockTicker;
begin
  if FTickerLock.Locked then begin
    FTickerLock.Locked := False;
    if FTickerLock.DisabledTimer and (not TimerTicker.Enabled) then TimerTicker.Enabled := True;
  end else begin
    MainLog('!!! UnlockTicker: not locked!', nil, LOGLVL_IMPORTANT); Beep;
  end;
end;

procedure TFrmMain.CheckAbortedEntries;
// note: Ticker MUST be locked when calling this proc
var
  i: Integer;
  item: TListItem;
  pI:   TInsQueueFile;
  pG:   TGetQueueFile;
  bDidRemove: Boolean;
begin
  Assert(FTickerLock.Locked);

  bDidRemove := False;

  // check any insert entries with state aborting
  for i := 0 to LvInsQueue.Items.Count-1 do begin
    item := LvInsQueue.Items[i]; pI := item.Data;
    if (pI.Status = ifsAborting) and (pI.NumActiveThreads = 0) then begin
      // pI.Status := ifsError;
      if pI.PrepBasename = '' then pI.Status := ifsUnprepared else pI.Status := ifsReady; 
      pI.Progress := 'Aborted'; pI.Freeze := True;
      SetInsQueueListItem(item);
      bDidRemove := True;
    end;
  end;
  // check any download entries with state aborting
  for i := 0 to LvGetQueue.Items.Count-1 do begin
    item := LvGetQueue.Items[i]; pG := item.Data;
    if (pG.Status = gfsAborting) and (pG.NumActiveThreads = 0) then begin
      pG.Status := gfsError; pG.Progress := 'Aborted'; pG.Freeze := True;
      SetGetQueueListItem(item);
      bDidRemove := True;
    end;
  end;

  if bDidRemove then SaveQueues(True);
end;


procedure TFrmMain.RescheduleDownload(pG: TGetQueueFile; LogMsg: String);
// note: MUST only be called from ticker!
var item: TListItem;
begin
  if GlobalSettings.GetRetMin = 0 then begin
    MainLog(LogMsg, pG, LOGLVL_IMPORTANT); exit;
  end;
  if LogMsg <> '' then LogMsg := LogMsg + ' ';
  MainLog(LogMsg + Format('Will retry download in %d min.',[GlobalSettings.GetRetMin]), pG, LOGLVL_NORMAL);
  pG.RestartAt := Now + GlobalSettings.GetRetMin / (60*24);
  pG.Progress := '(retry: ' + FormatDateTime('hh:nn',pG.RestartAt) + ')';
  item := LvGetQueue.FindData(0, pG, True, False);
  if item <> nil then SetGetQueueListItem(item);
end;

procedure TFrmMain.MiGetQueueGraphStyleClick(Sender: TObject);
var st: Integer;
begin
  if not (Sender is TMenuItem) then exit;
  st := (Sender as TMenuItem).Tag;
  if (st < 0) or (st > 2) then exit;

  if not LockTicker then exit;
  try
    FGraphStyle := st;
    (Sender as TMenuItem).Checked := True;
    UpdateGetQueue(True);
  finally
    UnlockTicker;
  end;
end;

procedure TFrmMain.MiHideBugDetectedClick(Sender: TObject);
begin
  LbBugDetected.Visible := False;
end;

function TFrmMain.FindQueueType(Sender: TObject; out qt: TQueueType): Boolean;
var
  MenuItem: TMenuItem;
  WinCtrl:  TWinControl;
begin
  Result := False;
  if (Sender = LvInsQueue) or (Sender = PopupInsQueue) or (Sender is TInsQueueFile) then begin
    qt := qtInsQueue; Result := True;
  end else if (Sender = LvGetQueue) or (Sender = PopupGetQueue) or (Sender is TGetQueueFile) then begin
    qt := qtGetQueue; Result := True;
  end else if (Sender is TListItem) then begin
    if (Sender as TListItem).ListView = LvInsQueue then begin
      qt := qtInsQueue; Result := True;
    end else if (Sender as TListItem).ListView = LvGetQueue then begin
      qt := qtGetQueue; Result := True;
    end;
  end else if (Sender is TMenuItem) then begin
    MenuItem := Sender as TMenuItem;
    while (MenuItem <> nil) and (not Result) do begin
      if MenuItem = PopupInsQueue.Items then begin
        qt := qtInsQueue; Result := True;
      end else if MenuItem = PopupGetQueue.Items then begin
        qt := qtGetQueue; Result := True;
      end else if MenuItem = PopupColumns.Items then begin
        qt := TQueueType(PopupColumns.Tag); Result := True;
      end else
        MenuItem := MenuItem.Parent;
    end;
  end else if (Sender is TWinControl) then begin
    WinCtrl := Sender as TWinControl;
    while (WinCtrl <> nil) and (WinCtrl <> FrmMain) and (not Result) do begin
      if WinCtrl = PanelInsQueue then begin
        qt := qtInsQueue; Result := True;
      end else if WinCtrl = PanelGetQueue then begin
        qt := qtGetQueue; Result := True;
      end else
        WinCtrl := WinCtrl.Parent;
    end;
  end;
end;

procedure TFrmMain.SHA11Click(Sender: TObject);
const BUFSIZE = 1024 * 512;
var
  sha:          TSHA1Context;
  Digest:       TSHA1Digest;
  Str:          TFileStream;
  pBuf:         PChar;
  BufLen,DatLen: Integer;
  t0,t1: Int64;
begin
  OpenDlgInsQueue.UseExtensions := False;
  if not OpenDlgInsQueue.Execute then exit;
  Str := nil; pBuf := nil;
  try
    Str := CreateFileStream(OpenDlgInsQueue.FileName, fmOpenRead or fmShareDenyWrite);
    GetMem(pBuf, BUFSIZE);

    t0 := GetTickCount;

    SHA1Reset(sha);
    DatLen := Str.Size;
    while DatLen > 0 do begin
      if DatLen > BUFSIZE then BufLen := BUFSIZE else BufLen := DatLen;
      Str.ReadBuffer(pBuf^, BufLen);
      SHA1Input(sha, pBuf, BufLen);
      dec(DatLen,BufLen);
    end;
    SHA1Result(sha, Digest);

    t1 := GetTickCount; if t1 < t0 then inc(t1, $100000000);

    if MessageDlg('Calculation took ' + IntToStr(t1-t0) + ' ms'#13#13'SHA1 digest for ' + OpenDlgInsQueue.FileName + ':'#13 + SHA1DigestToLoHexString(Digest) + #13#13'Copy to clipboard?', mtConfirmation, [mbYes,mbNo], 0) = mrYes then
      Clipboard.AsText := SHA1DigestToLoHexString(Digest);

  finally
    if pBuf <> nil then FreeMem(pBuf);
    Str.Free;
  end;
end;

procedure TFrmMain.MiCalcCHKClick(Sender: TObject);
var
  k1,k2:  String;
  Str:          TFileStream;
  pBuf:         PChar;
  BufLen: Integer;
begin
  OpenDlgInsQueue.UseExtensions := False;
  if not OpenDlgInsQueue.Execute then exit;
  Str := nil; pBuf := nil;
  try
    Str := CreateFileStream(OpenDlgInsQueue.FileName, fmOpenRead or fmShareDenyWrite);
    BufLen := Str.Size;
    GetMem(pBuf, BufLen);
    Str.ReadBuffer(pBuf^, BufLen);

    k1 := Util_NormKey(Util_GenerateCHK_Native(pBuf, BufLen, '', CIPHERNAME_TWOFISH));
    k2 := Util_NormKey(Util_GenerateCHK_Native(pBuf, BufLen, '', CIPHERNAME_RIJNDAEL));

    if MessageDlg('Twofish key for '  + OpenDlgInsQueue.FileName + ':'#13 + k1 + #13#13'Copy to clipboard?', mtConfirmation, [mbYes,mbNo], 0) = mrYes then
      Clipboard.AsText := k1;
    if MessageDlg('Rijndael key for ' + OpenDlgInsQueue.FileName + ':'#13 + k2 + #13#13'Copy to clipboard?', mtConfirmation, [mbYes,mbNo], 0) = mrYes then
      Clipboard.AsText := k2;

  finally
    if pBuf <> nil then FreeMem(pBuf);
    Str.Free;
  end;
end;

procedure TFrmMain.GetAllGetFilenames(FilenameList: TStringList);
var
  i: Integer;
  p: TGetQueueFile;
begin
  FilenameList.Clear;
  if not LockTicker then exit;
  try
    for i := 0 to FGetQueue.Count-1 do begin
      p := FGetQueue.Items[i];
      if p.SavFilename <> '' then FilenameList.Add(p.SavFilename);
    end;
  finally
    UnlockTicker;
  end;
end;

procedure TFrmMain.LogFormClosing(Sender: TObject; var Action: TCloseAction);
begin
  if Sender = FFileLogForm then begin
    Action := caFree; FFileLogForm := nil;
  end else
    Action := caHide;
end;

procedure TFrmMain.LbUpdateFoundDblClick(Sender: TObject);
begin
  if MessageDlg(
      'An updated version of the FUQID freepage has been found:'#13 +
      FUpdateKey + '//' + #13#13 +
      'Do you want to copy this key to the clipboard?',
      mtInformation, [mbYes,mbNo], 0
    ) = mrNo then exit;
  Clipboard.AsText := FUpdateKey + '//';
end;

function TFrmMain.FindInsQueueFileByUniqueID(ID: Int64): TInsQueueFile;
var
  i: Integer;
  p: TInsQueueFile;
begin
  Result := nil; if ID = 0 then exit;
  for i := 0 to FInsertQueue.Count-1 do begin
    p := FInsertQueue.Items[i];
    if p.UniqueID = ID then begin Result := p; exit; end;
  end;
end;

function TFrmMain.FindGetQueueFileByUniqueID(ID: Int64): TGetQueueFile;
var
  i: Integer;
  p: TGetQueueFile;
begin
  Result := nil; if ID = 0 then exit;
  for i := 0 to FGetQueue.Count-1 do begin
    p := FGetQueue.Items[i];
    if p.UniqueID = ID then begin Result := p; exit; end;
  end;
end;

function TFrmMain.FindAnyQueueFileByUniqueID(ID: Int64): TQueueFile;
begin
  Result := FindInsQueueFileByUniqueID(ID);
  if Result = nil then Result := FindGetQueueFileByUniqueID(ID);
end;

procedure TFrmMain.MiAnyQueueFileDetailsClick(Sender: TObject);
var qt: TQueueType;
begin
  if not FindQueueType(Sender, qt) then exit;
  if FQueueInfo[qt].ListView.Selected = nil then exit;
  ShowPrepFileDetails(FQueueInfo[qt].ListView.Selected.Data);
end;

procedure TFrmMain.MiGetQueueSaveIncompleteClick(Sender: TObject);
var
  item: TListItem;
  pG: TGetQueueFile;
  PrepFile: TPreparedFile;
  sName: String;
  oldcur: TCursor;
  WaitForm:  TFrmWaitForThread;
  DecThread: TFECDecodeThread;
begin
  if LvGetQueue.Selected = nil then exit;

  if not LockTicker(True {for long operation}) then exit;
  try
    item := LvGetQueue.Selected;
    pG := item.Data;

    SaveIncompleteFile(pG);
    exit;

    if pG.PrepBasename = '' then
      MessageDlg('Need at least some blocks to save incomplete file', mtError, [mbOk], 0)
    else begin
      // not if the file is active! - otherwise we can get a race condition in DecodeThread!
      if pG.NumActiveThreads <> 0 then begin
        MessageDlg('There are active threads for this file. Abort the download first!', mtError, [mbOk], 0);
        exit;
      end;

      sName := ChangeFileExt(pG.SavFilename, '_INCOMPLETE_' + ExtractFileExt(pG.SavFilename));
      SaveDlgGetQueue.FileName := sName;
      if not ExecuteSaveDialogSafely(SaveDlgGetQueue) then exit;
      sName := SaveDlgGetQueue.FileName;
      oldcur := Screen.Cursor;
      WaitForm := nil; DecThread := nil;
      PrepFile := TPreparedFile.CreateDownload(pG.PrepBasename);
      try
        Screen.Cursor := crHourglass;
        PrepFile.ReadHeader;

        // check if we have (or at least can decode) the first data block
        if (not PrepFile.BlockDone[0]) and (PrepFile.BlocksCompletedInSeg[0] < PrepFile.BlocksRequiredInSeg[0]) then begin
          if MessageDlg('The first data block is not available. This often renders the incomplete file useless.'#13'Do you want to save anyway?', mtWarning, [mbYes,mbAbort], 0) <> mrYes then
            exit;
        end;

        // fully decode any segments we have enough blocks for
        DecThread := TFECDecodeThread.Create(
                       MakeThreadID(ExtractFileName(sName), 'Decode'),
                       GlobalSettings.FCPAddr, GlobalSettings.FCPPort,
                       PrepFile.Basename,
                       sName,
                       0,
                       psSkipMissing,
                       StatusCallback,
                       pG, pG.UniqueID,
                       True
                     );
        WaitForm := TFrmWaitForThread.Create(Self);
        WaitForm.LaunchAndWait( DecThread );

        if DecThread.DecodeResult then
          MessageDlg('Incomplete file saved as ' + sName, mtInformation, [mbOk], 0)
        else
          MessageDlg('Incomplete file not saved.', mtError, [mbOk], 0);
        // PrepFile.SaveOutputFile(sName, nil, True);
      finally
        PrepFile.Free;
        Screen.Cursor := oldcur;
        WaitForm.Free;
        DecThread.Free;
      end;
    end;
  finally
    UnlockTicker;
  end;
end;

procedure TFrmMain.MiGetQueueVerifyBlocksClick(Sender: TObject);
var
  item: TListItem;
  pG: TGetQueueFile;
  PrepFile: TPreparedFile;
  oldcur: TCursor;
  iBlock: Cardinal;
  slBadList: TStringList;
  p,pData:     PChar;
  DataLen:     DWord;
  sMeta,sKey1,sKey2,sKey3: String;
  i: Integer;
  bAsked,bDelete: Boolean;
  SegInfo:        TFECSegmentInfo;
  iSeg,SegStart,NumData,NumCheck: Cardinal;
  PaddedLen,RealLen: Int64;
  ok,bFixedBlock: Boolean;
  FixedBlock: Cardinal;
  SegList: TList;
  sSegs,s: String;
begin
  if LvGetQueue.Selected = nil then exit;
  slBadList := nil; SegList := nil;
  if not LockTicker then exit;
  try
    item := LvGetQueue.Selected;
    pG := item.Data;
    if pG.PrepBasename = '' then
      MessageDlg('No blocks available', mtError, [mbOk], 0)
    else if pG.NumActiveThreads > 0 then
      MessageDlg('File has active threads running, cannot verify now', mtError, [mbOk], 0)
    else begin
      oldcur := Screen.Cursor;
      slBadList := TStringList.Create;
      SegList := TList.Create;
      PrepFile := TPreparedFile.CreateDownload(pG.PrepBasename);
      try
        Screen.Cursor := crHourglass;
        PrepFile.ReadHeader;

        bAsked := False; bDelete := False;
        Assert(PrepFile.NumBlocks > 0);

        // check last data block for insert bug
        FixedBlock := 0; bFixedBlock := False;
        PaddedLen := 0;
        for i := 0 to PrepFile.NumSegments-1 do begin
          Util_GetFECSegmentInfo(PrepFile.SegHeader[i], SegInfo);
          PaddedLen := PaddedLen + SegInfo.BlockCount * SegInfo.BlockSize;
        end;
        Util_GetFECSegmentInfo(PrepFile.SegHeader[PrepFile.NumSegments-1], SegInfo);
        RealLen := SegInfo.BlockSize - (PaddedLen - pG.Size);
        PrepFile.GetSegmentBlockInfo(PrepFile.NumSegments-1, SegStart, NumData, NumCheck);
        iBlock := SegStart + NumData - 1;
//        Util_GetFECSegmentInfo(PrepFile.SegHeader[PrepFile.NumSegments-1], SegInfo);
        if RealLen > 0 then begin
          pData := nil;
          try
            PrepFile.GetData(iBlock, pData, DataLen, sMeta);
            Assert(RealLen < DataLen);
            p := pData + RealLen; ok := True;
            for i := RealLen to DataLen-1 do begin
              if p^ <> #0 then begin ok := False; p^ := #0; end;
              inc(p);
            end;
            if not ok then begin
              if MessageDlg('Last data block affected by the insert bug! Fix it?',mtWarning,[mbYes,mbNo],0) = mrYes then begin
                PrepFile.BlockDone[iBlock] := False;
                PrepFile.BlockOffset[iBlock] := $FFFFFFFF;
                PrepFile.WriteHeader;
                PrepFile.WriteData(iBlock, pData, DataLen, sMeta);
                PrepFile.BlockDone[iBlock] := True;
                PrepFile.CloseDataFile;
                PrepFile.WriteHeader;
                FixedBlock := iBlock; bFixedBlock := True;
              end;
            end;
          finally
            if pData <> nil then FreeMem(pData); pData := nil;
          end;
        end;

        repeat
          sSegs := '';
          for i := 1 to PrepFile.NumSegments do sSegs := sSegs + ',' + IntToStr(i);
          Delete(sSegs,1,1);
          if not InputQuery('Segments to verify','Enter segment numbers',sSegs) then exit;
          SegList.Clear;
          s := sSegs + ',';
          while Pos(',',s) <> 0 do begin
            i := StrToIntDef(Copy(s,1,Pos(',',s)-1),0); Delete(s,1,Pos(',',s));
            if i = 0 then begin
              MessageDlg('Invalid input', mtError, [mbOk], 0);
              SegList.Clear;
              break;
            end;
            SegList.Add(Pointer(i-1));
          end;
        until SegList.Count > 0;

        iSeg := 0; PrepFile.GetSegmentBlockInfo(iSeg, SegStart, NumData, NumCheck);
        for iBlock := 0 to PrepFile.NumBlocks-1 do begin
          if Cardinal(iBlock) >= (SegStart + NumData + NumCheck) then begin
            inc(iSeg); PrepFile.GetSegmentBlockInfo(iSeg, SegStart, NumData, NumCheck);
          end;
          Assert((Cardinal(iBlock) >= SegStart) and (Cardinal(iBlock) < (SegStart + NumData + NumCheck)));

          if SegList.IndexOf(Pointer(iSeg)) < 0 then continue;

          if not PrepFile.BlockDone[iBlock] then continue;
          pData := nil;
          try
            PrepFile.GetData(iBlock, pData, DataLen, sMeta);
            if (pData = nil) or (DataLen = 0) then begin
              slBadList.AddObject(Format('Block %d - ERROR empty block',[iBlock]),Pointer(iBlock));
              continue;
            end;

            if (sMeta <> '') {and (iBlock <> PrepFile.MainBlock) }then
              slBadList.AddObject(Format('Block %d - WARNING block contains metadata',[iBlock]),Pointer(iBlock));

            sKey1 := Util_NormKey(PrepFile.Key[iBlock]);
            if Copy(sKey1,1,4) <> 'CHK@' then begin
              slBadList.AddObject(Format('Block %d - WARNING block is not a CHK, cannot verify',[iBlock]),Pointer(iBlock));
              continue;
            end;

            sKey2 := Util_NormKey(Util_GenerateCHK(pData, DataLen, sMeta, nil, CIPHERNAME_TWOFISH));
            if (sKey1 = sKey2) then continue;

            sKey3 := Util_NormKey(Util_GenerateCHK(pData, DataLen, sMeta, nil, CIPHERNAME_RIJNDAEL));
            if (sKey1 = sKey3) then continue;

            if (iBlock = FixedBlock) and bFixedBlock then begin
              MessageDlg('Key mismatch on fixed last data block - this is normal',mtInformation,[mbOk],0);
              continue;
            end;

            slBadList.AddObject(Format('Block %d - ERROR CHK mismatch: should be %s but is %s or %s',[iBlock,sKey1,sKey2,sKey3]),Pointer(iBlock));

            if not bAsked then begin
              bDelete := ( MessageDlg('Bad blocks found. Do you want to mark them as unretrieved?',mtConfirmation,[mbYes,mbNo],0) = mrYes );
              bAsked := True;
            end;

            if bDelete then begin
              PrepFile.BlockDone[iBlock] := False;
              PrepFile.BlockOffset[iBlock] := $FFFFFFFF;
            end;

          finally
            if pData <> nil then FreeMem(pData); pData := nil;
          end;
        end;

        if bDelete then begin
          PrepFile.WriteHeader;
          pG.BlockStat := PrepFile.GetBlockStatusString;
          SetGetQueueListItem(item);
        end;

        for i := 0 to slBadList.Count-1 do begin
          MainLog(slBadList.Strings[i],pG,LOGLVL_IMPORTANT);
        end;
        if slBadList.Count > 0 then
          MessageDlg('Bad blocks found - see log', mtWarning, [mbOk], 0)
        else
          MessageDlg('File seems to be ok', mtInformation, [mbOk], 0);

      finally
        PrepFile.Free;
        Screen.Cursor := oldcur;
      end;
    end;
  finally
    UnlockTicker;
    slBadList.Free;
    SegList.Free;
  end;
end;


procedure TFrmMain.MiDebugMiscClick(Sender: TObject);
const
  s:   String = '';
var
  uri: TFreenetURI;
begin
  if not InputQuery('URI','URI',s) then exit;
  uri := TFreenetURI.Create;
  try
    uri.SetURI(s);
    uri.Debug;
  finally
    uri.Free;
  end;
end;

procedure TFrmMain.InitClipboardFormats;
var
  item:  TMenuItem;
  i:     Integer;
  pClip: PClipFormatShort;
begin
  i := MiInsQueueCopyCustomStart.MenuIndex;
  while MiInsQueueCopy.Count > (i+1) do MiInsQueueCopy.Delete(i+1);
  i := MiGetQueueCopyCustomStart.MenuIndex;
  while MiGetQueueCopy.Count > (i+1) do MiGetQueueCopy.Delete(i+1);
  ClipFormats_ClearList(FClipList);

  ClipFormats_StringToList(GlobalSettings.ClipFmts, FClipList);
  for i := 0 to FClipList.Count-1 do begin
    pClip := FClipList.Items[i];
    if pClip^.Enabled then begin
      item := TMenuItem.Create(MiInsQueueCopy);
      item.Caption := pClip^.Description;
      item.Tag     := 1+i;
      item.OnClick := MiAnyQueueCopyClick;
      MiInsQueueCopy.Add(item);

      item := TMenuItem.Create(MiGetQueueCopy);
      item.Caption := pClip^.Description;
      item.Tag     := 1+i;
      item.OnClick := MiAnyQueueCopyClick;
      MiGetQueueCopy.Add(item);
    end;
  end;
  MiInsQueueCopyCustomStart.Visible := FClipList.Count > 0;
  MiGetQueueCopyCustomStart.Visible := FClipList.Count > 0;
end;

procedure TFrmMain.SettingsChanged;
begin
  if GlobalSettings.NoNativeCHK <> (not FreenetUtils.USE_NATIVE_CHK) then
    FreenetUtils.USE_NATIVE_CHK := not GlobalSettings.NoNativeCHK;
  if GlobalSettings.NoNativeFEC <> (not FreenetUtils.USE_NATIVE_FEC) then
    FreenetUtils.USE_NATIVE_FEC := not GlobalSettings.NoNativeFEC;
  if GlobalSettings.LogLevel    <> FreenetUtils.LOG_LEVEL then
    FreenetUtils.LOG_LEVEL      := GlobalSettings.LogLevel;
  if (GlobalSettings.ClrEmpty[1] <> LvInsQueue.Color)
  or (GlobalSettings.ClrEmpty[1] <> LvGetQueue.Color) then begin
    LvInsQueue.Color := GlobalSettings.ClrEmpty[1];
    LvGetQueue.Color := GlobalSettings.ClrEmpty[1];
  end;
  UpdateInsertQueue(False);
  UpdateGetQueue(False);
end;

procedure TFrmMain.Fakeinsertsonlycalckey1Click(Sender: TObject);
begin
  FDebugFakeInserts := not FDebugFakeInserts;
  Fakeinsertsonlycalckey1.Checked := FDebugFakeInserts;
end;

procedure TFrmMain.AddToStats(const UDStats: TUpDownloadStats);
var p: PUpDownloadStats;
begin
  if not UDStats.Valid then exit;
  try inc(FStats.BytesUp, UDStats.BytesUp); except FStats.BytesUp := High(FStats.BytesUp); end;
  try inc(FStats.BytesDn, UDStats.BytesDn); except FStats.BytesDn := High(FStats.BytesDn); end;
  try
    New(p);
    try
      p^ := UDStats;
      FStats.UpDownloadStatsList.Add(p);
    except
      Dispose(p);
      raise;
    end;
  except
  end;
  FStats.Changed := True;
end;

procedure TFrmMain.CalcStats;
const
  AVERAGE_TIME_SECONDS = 3 * 60; // 3 minutes
var
  dt0,dt1: TDateTime;
  p:  PUpDownloadStats;
  i:  Integer;
  BytesUp,BytesDn,secs: Int64;
  f: Extended;
begin
  dt1 := Now; dt0 := dt1 - AVERAGE_TIME_SECONDS / (60 * 60 * 24);
  BytesUp := 0; BytesDn := 0;
  i := 0;
  while i < FStats.UpDownloadStatsList.Count do begin
    p := FStats.UpDownloadStatsList.Items[i];
    if p^.TimeEnd < dt0 then begin
      FStats.UpDownloadStatsList.Delete(i);
      Dispose(p);
    end else begin
      f := 1;
      // if p^.TimeStart < dt0 then
      //  try f := (p^.TimeEnd - dt0) / (p^.TimeEnd - p^.TimeStart); except end;
      try inc(BytesUp, Round(f * p^.BytesUp)); except BytesUp := High(BytesUp); end;
      try inc(BytesDn, Round(f * p^.BytesDn)); except BytesDn := High(BytesDn); end;
      inc(i);
    end;
  end;
  try FStats.SpeedUp := Round(BytesUp / AVERAGE_TIME_SECONDS); except FStats.SpeedUp := 0; end;
  try FStats.SpeedDn := Round(BytesDn / AVERAGE_TIME_SECONDS); except FStats.SpeedDn := 0; end;
  if FStats.AvgStartTime <> 0 then begin
    secs := Round((dt1 - FStats.AvgStartTime) * 24 * 60 * 60);
    if secs > 0 then begin
      try FStats.AvgSpUp := Round(FStats.BytesUp / secs); except FStats.AvgSpUp := 0; end;
      try FStats.AvgSpDn := Round(FStats.BytesDn / secs); except FStats.AvgSpDn := 0; end;
    end;
  end;
  FStats.Changed := False;
end;

procedure TFrmMain.UpdateFileStats(pQ: TQueueFile; Succeeded: Boolean; FailReason: TFreenetThreadFailReason);
var
  dtNow: TDateTime;
  fst:   TFileStatType;
begin
  dtNow := Now;
  // update both overall and session stats
  for fst := Low(TFileStatType) to High(TFileStatType) do begin
    if Succeeded then begin
      inc(pQ.Stats[fst].SuccCount);
      pQ.Stats[fst].LastSucc := dtNow;
    end else begin
      inc(pQ.Stats[fst].FailCount[FailReason]);
      inc(pQ.Stats[fst].FailCountTotal);
      pQ.Stats[fst].LastFail := dtNow;
    end;
  end;
end;


function TFrmMain.NumBytesToStr(n: Int64): String;
begin
  if n < 1024 then
    Result := Format('%d b',[n])
  else if n < (1024*1024) then
    Result := Format('%.2n k',[n / 1024])
  else if n < (1024*1024*1024) then
    Result := Format('%.2n M',[n / (1024*1024)])
  else
    Result := Format('%.2n G',[n / (1024*1024*1024)]);
end;

procedure TFrmMain.MiClearStatsClick(Sender: TObject);
var
  bClearSpeed: Boolean;
  bClearFiles: Boolean;
  bResetFiles: Boolean;
  qt:          TQueueType;
  p:           TQueueFile;
  i:           Integer;
begin
  bClearSpeed := (Sender = MiClearAllStats) or (Sender = MiClearSpeedStats);
  bClearFiles := (Sender = MiClearAllStats) or (Sender = MiClearFileStats);
  bResetFiles := (Sender = MiResetFileStats);

  if bClearSpeed then begin
    FStats.BytesUp := 0;
    FStats.BytesDn := 0;
    FStats.AvgStartTime := Now;
    UpdateStatsDisplay;
  end;

  if (bClearFiles or bResetFiles) and LockTicker then begin
    try
      for qt := qtInsQueue to qtGetQueue do begin
        FQueueInfo[qt].ListView.Items.BeginUpdate;
        try
          for i := 0 to FQueueInfo[qt].ListView.Items.Count-1 do begin
            p := FQueueInfo[qt].ListView.Items[i].Data;
            if bClearFiles then p.ClearStats(fstSession) else p.Stats[fstSession] := p.Stats[fstOverall];
            SetAnyQueueListItem(qt, FQueueInfo[qt].ListView.Items[i]);
          end;
        finally
          FQueueInfo[qt].ListView.Items.EndUpdate;
        end;
      end;
    finally
      UnlockTicker;
    end;
  end;
end;

procedure TFrmMain.SetAnchors;
begin
  // Set anchors for controls that stick to the right or bottom of their parent.
  // Normally this would be done at design time, but D7 then saves .DesignSize,
  // breaking compatibility with earlier Delphi versions. So do it at runtime.
  with LbUpdateFound do Anchors := [akTop,akRight];
  with BtCheckUpdate do Anchors := [akTop,akRight];
  with BtSettings    do Anchors := [akTop,akRight];
  with BtAbort       do Anchors := [akTop,akRight];
  with LvInsQueue    do Anchors := [akLeft,akTop,akRight,akBottom];
  with LvGetQueue    do Anchors := [akLeft,akTop,akRight,akBottom];
  with BtInsLog      do Anchors := [akTop,akRight];
  with BtGetLog      do Anchors := [akTop,akRight];
  with BtShowLog     do Anchors := [akTop,akRight];
  with BtAbout       do Anchors := [akTop,akRight];
  with BtFrostSearch do Anchors := [akTop,akRight];
end;

procedure TFrmMain.MiFindKeysInFilesClick(Sender: TObject);
var sl: TStringList;
begin
  if not OpenDlgKeyFiles.Execute then exit;
  sl := TStringList.Create;
  try
    sl.Assign(OpenDlgKeyFiles.Files);
    FindKeysInFiles(sl);
  finally
    sl.Free;
  end;
end;

procedure TFrmMain.MiFindKeysInClipboardClick(Sender: TObject);
var sl: TStringList;
begin
  if not Clipboard.HasFormat(CF_TEXT) then begin
    MessageDlg('Clipboard does not contain text', mtError, [mbOk], 0);
    exit;
  end;
  sl := TStringList.Create;
  try
    sl.Add(CLIPBOARD_FILE_NAME);
    FindKeysInFiles(sl);
  finally
    sl.Free;
  end;
end;

{
procedure TFrmMain.MiFindKeysInFrostClick(Sender: TObject);
var slFiles,slComments: TStringList;
begin
  slFiles := nil; slComments := nil;
  try
    slFiles    := TStringList.Create;
    slComments := TStringList.Create;
    if FrmScanFrost = nil then FrmScanFrost := TFrmScanFrost.Create(Application);
    if FrmScanFrost.ShowModal = mrOk then begin
      slFiles.Text    := FrmScanFrost.Files;
      slComments.Text := FrmScanFrost.Comments;
      FindKeysInFiles(slFiles, slComments);
    end;
  finally
    slFiles.Free;
    slComments.Free;
  end;
end;
}

procedure TFrmMain.FindKeysInFiles(FileList, CommentList: TStringList);
var
  slFile: TStringList;
  slKeys: TStringList;
  slTmp:  TStringList;
  iFile,iLine: Integer;
  oldcur:      TCursor;
  bRelFound:   Boolean;
  RelBase:     String;
  s,sXML,sRest:  String;
  iPos1,iPos2:   Integer;
  sToken,sFName,sKey: String;
  sComment,sKeyComment: String;
  iNumKeys,iKey: Integer;
begin
  slFile := nil; slKeys := nil; slTmp := nil; bRelFound := False;
  oldcur := Screen.Cursor;
  try
    Screen.Cursor := crHourglass;
    slFile := TStringList.Create;
    slKeys := TStringList.Create;
    slTmp  := TStringList.Create;
    for iFile := 0 to FileList.Count-1 do begin
      if Assigned(CommentList) and (iFile < CommentList.Count) then
        sComment := CommentList.Strings[iFile]
      else
        sComment := '';

      iNumKeys := slKeys.Count;

      // Frost xml files are usually unicode
      if CompareText('.xml', ExtractFileExt(FileList.Strings[iFile])) = 0 then begin
        slFile.Clear;

        try
          sXML := GetFrostXMLAsString(FileList.Strings[iFile]);
        except
          continue;
        end;

        // extract FrostMessage block
        s := sXML;
        sToken := 'FrostMessage';
        iPos1 := Pos('<' + sToken + '>', s);
        iPos2 := LastPos('</' + sToken + '>', s);
        if (iPos1 = 0) or (iPos2 = 0) or (iPos1 > iPos2) then continue;
        Delete(s, iPos2, Length(s)); Delete(s, 1, iPos1 + Length(sToken) + 1);

        // extract message body
        sToken := 'Body';
        iPos1 := Pos('<' + sToken + '>', s);
        iPos2 := LastPos('</' + sToken + '>', s);
        if (iPos1 = 0) or (iPos2 = 0) or (iPos1 > iPos2) then continue;
        sRest := Copy(s, iPos2 + Length(sToken) + 3, Length(s));
        Delete(s, iPos2, Length(s)); Delete(s, 1, iPos1 + Length(sToken) + 1);

        // scan body for keys
        sToken := '<![CDATA['; if CompareText(Copy(s,1,Length(sToken)), sToken) = 0 then Delete(s,1,Length(sToken));
        sToken := ']]>';       if CompareText(Copy(s,Length(s)-Length(sToken)+1,Length(sToken)), sToken) = 0 then Delete(s,Length(s)-Length(sToken)+1,Length(sToken));
        slTmp.Text := s;
        for iLine := 0 to slTmp.Count-1 do begin
          ExtractKeysFromString(slTmp.Strings[iLine], slKeys);
        end;

        // remove any CR/LF
        while Pos(#10, sRest) <> 0 do Delete(sRest, Pos(#10, sRest), 1);
        while Pos(#13, sRest) <> 0 do Delete(sRest, Pos(#13, sRest), 1);

        // extract file attachments
        while True do begin
          s := sRest;
          sToken := '<Attachment type="file">';
          iPos1 := Pos(sToken, s); if iPos1 = 0 then break;
          Delete(s, 1, iPos1 + Length(sToken) - 1);
          sToken := '</Attachment>';
          iPos1 := Pos(sToken, s); if iPos1 = 0 then break;
          sRest := Copy(s, iPos1 + Length(sToken), Length(s));
          Delete(s, iPos1, Length(s));

          sToken := '<name><![CDATA[';
          iPos1 := Pos(sToken, s); if iPos1 = 0 then continue;
          Delete(s, 1, iPos1 + Length(sToken) - 1);
          sToken := ']]></name>';
          iPos1 := Pos(sToken, s); if iPos1 = 0 then continue;
          sFName := Copy(s, 1, iPos1 - 1); Delete(s, 1, iPos1 + Length(sToken) - 1);
          sToken := '<key>';
          iPos1 := Pos(sToken, s); if iPos1 = 0 then continue;
          Delete(s, 1, iPos1 + Length(sToken) - 1);
          sToken := '</key>';
          iPos1 := Pos(sToken, s); if iPos1 = 0 then continue;
          sKey := Copy(s, 1, iPos1 - 1); Delete(s, 1, iPos1 + Length(sToken) - 1);
          if Copy(sKey,1,4) <> 'CHK@' then continue; // for now only CHK-keys
          slKeys.Add(sKey + '/' + sFName);
        end;

      end else begin
        if FileList.Strings[iFile] = CLIPBOARD_FILE_NAME then begin
          try slFile.Text := Clipboard.AsText; except slFile.Clear; end;
        end else begin
          slFile.LoadFromFile(FileList.Strings[iFile]);
        end;
        for iLine := 0 to slFile.Count-1 do begin
          ExtractKeysFromString(slFile.Strings[iLine], slKeys);
          if ExtractLinksFromString(slFile.Strings[iLine], slKeys) > 0 then bRelFound := True;
        end;
      end;

      // if we have a File-specific comment, add it for new keys
      if sComment <> '' then begin
        for iKey := iNumKeys to slKeys.Count-1 do begin
          sKey := slKeys.Strings[iKey];
          sKeyComment := ExtractCommentFromKey(sKey);
          if sKeyComment = '' then sKeyComment := sComment else Insert(sComment + '; ', sKeyComment, 1);
          slKeys.Strings[iKey] := sKey + COMMENT_TAG + sKeyComment;
        end;
      end;
    end;
    // for iLine := 0 to slKeys.Count-1 do begin
    //   if slKeys.Objects[iLine] = nil then
    //     MainLog('KEY: ' + slKeys.Strings[iLine], nil, LOGLVL_DEBUG)
    //   else
    //     MainLog('REL: ' + slKeys.Strings[iLine], nil, LOGLVL_DEBUG);
    // end;
    if bRelFound then begin
      RelBase := '';
      if AskForBaseKey(RelBase) = mrCancel then exit;
      if RelBase <> '' then begin
        // add to each rel. key
        for iLine := 0 to slKeys.Count-1 do begin
          if slKeys.Objects[iLine] <> nil then
            slKeys.Strings[iLine] := RelBase + slKeys.Strings[iLine];
        end;
      end else begin
        // remove rel. keys
        iLine := 0;
        while iLine < slKeys.Count do begin
          if slKeys.Objects[iLine] <> nil then slKeys.Delete(iLine) else inc(iLine);
        end;
      end;
    end;

    if slKeys.Count = 0 then begin
      MessageDlg('No keys found.', mtInformation, [mbOk], 0);
      exit;
    end;

    AddKeys(slKeys.Text);
  finally
    slFile.Free;
    slKeys.Free;
    slTmp.Free;
    Screen.Cursor := oldcur;
  end;
end;

function  TFrmMain.ExtractKeysFromString(sLine: String; KeyList: TStringList): Integer;
var
  iPos,i,iStart: Integer;
  s,sTmp,sKey: String;
begin
  s := sLine; Result := 0;
  while s <> '' do begin
    iPos := 0;
    i := Pos('CHK@',s); if (i <> 0) and ((iPos = 0) or (i < iPos)) then iPos := i;
    i := Pos('SSK@',s); if (i <> 0) and ((iPos = 0) or (i < iPos)) then iPos := i;
    i := Pos('KSK@',s); if (i <> 0) and ((iPos = 0) or (i < iPos)) then iPos := i;
    i := Pos('SVK@',s); if (i <> 0) and ((iPos = 0) or (i < iPos)) then iPos := i;

    if iPos = 0 then exit;

    iStart := iPos;
    sTmp :=AnsiUpperCase(Trim(Copy(s,1,iStart-1))); // remember what appeared before the key
    Delete(s,1,iPos-1);
    sKey := '';

    // find end of key
    while Pos(' ',sTmp) <> 0 do Delete(sTmp,Pos(' ',sTmp),1);
    // may be a url in format href = "http://127.0.0.1:8088/CHK@...." or /CHK@...
    if Copy(sTmp,Length(sTmp),1) = '/' then begin
      Delete(sTmp,Length(sTmp),1);
      iPos := Pos('HTTP://',sTmp);
      if iPos <> 0 then Delete(sTmp,iPos,Length(sTmp));
    end;
    if (Length(sTmp) >= 6) and (Copy(sTmp,Length(sTmp)-5,6) = 'HREF="') then begin
      // href = "
      iPos := Pos('"',s);
      if iPos = 0 then iPos := Length(s)+1;
      sKey := Copy(s,1,iPos-1);
      Delete(s,1,iPos);
    end else if (Length(sTmp) >= 6) and (Copy(sTmp,Length(sTmp)-5,6) = 'HREF=''') then begin
      // href = '
      iPos := Pos('''',s);
      if iPos = 0 then iPos := Length(s)+1;
      sKey := Copy(s,1,iPos-1);
      Delete(s,1,iPos);
    end else if (Length(sTmp) >= 5) and (Copy(sTmp,Length(sTmp)-4,5) = 'HREF=') then begin
      // href =   (without quotes)
      iPos := Pos(' ',s);
      i := Pos('>',s); if (i <> 0) and ((iPos = 0) or (i < iPos)) then iPos := i;
      if iPos = 0 then iPos := Length(s)+1;
      sKey := Copy(s,1,iPos-1);
      Delete(s,1,iPos);
    end else begin
      // we have to guess where the key ends
      iPos := Pos(' ',s);
      i := Pos('>',s); if (i <> 0) and ((iPos = 0) or (i < iPos)) then iPos := i;
      i := Pos('<',s); if (i <> 0) and ((iPos = 0) or (i < iPos)) then iPos := i;
      i := Pos('?',s); if (i <> 0) and ((iPos = 0) or (i < iPos)) then iPos := i;
      i := Pos('"',s); if (i <> 0) and ((iPos = 0) or (i < iPos)) then iPos := i;
      // try to be smart about spaces in filenames
      if (iPos <> 0) and (iPos = Pos(' ',s)) and (iPos > 6) then begin
        if (s[iPos-5] <> '.') and (s[iPos-4] <> '.') and (s[iPos-3] <> '.') then begin
          if Length(s) - iPos < 50 then begin
            if (s[Length(s)-4] = '.') or (s[Length(s)-3] = '.') or (s[Length(s)-2] = '.') then begin
              iPos := 0;
            end;
          end;
        end;
      end;
      if iPos = 0 then iPos := Length(s)+1;
      sKey := Copy(s,1,iPos-1);
      Delete(s,1,iPos);
    end;

    // check if key looks reasonable
    if sKey <> '' then begin
      if Length(sKey) <= 4 then
        sKey := ''
      else if (CompareText(Copy(sKey,1,4),'CHK@') = 0) and (Length(sKey) < 58) then
        sKey := ''
    end;
    // add if it's not already in the list
    if sKey <> '' then begin
      if KeyList.IndexOf(sKey) < 0 then begin KeyList.Add(sKey); inc(Result); end;
    end;

  end;
end;

function  TFrmMain.ExtractLinksFromString(sLine: String; KeyList: TStringList): Integer;
var
  s,sKey: String;
  i,iPos: Integer;
begin
  s := sLine; Result := 0;
  // remove all spaces
  repeat
    iPos := Pos(' ', s);
    if iPos <> 0 then Delete(s,iPos,1);
  until iPos = 0;

  while s <> '' do begin
    iPos := Pos('HREF=',UpperCase(s));
    if iPos = 0 then exit;
    Delete(s,1,iPos+4);
    if Length(s) = 0 then continue;
    sKey := '';
    if s[1] = '"' then begin
      Delete(s,1,1);
      iPos := Pos('"',s); if (iPos = 0) then continue;
      sKey := Copy(s,1,iPos-1);
      Delete(s,1,iPos);
    end else if s[1] = '''' then begin
      Delete(s,1,1);
      iPos := Pos('''',s); if (iPos = 0) then continue;
      sKey := Copy(s,1,iPos-1);
      Delete(s,1,iPos);
    end else begin
      iPos := Pos(' ',s);
      i    := Pos('>',s); if (i <> 0) and ((iPos = 0) or (i < iPos)) then iPos := i;
      if (iPos = 0) then continue;
      sKey := Copy(s,1,iPos-1);
      Delete(s,1,iPos);
    end;

    // do only add relative links
    if Copy(sKey,1,1) = '/' then continue;
    if CompareText(Copy(sKey,1,7),'HTTP://') = 0 then continue;
    if CompareText(Copy(sKey,1,7),'MAILTO:') = 0 then continue;
    if Copy(sKey,1,1) = '#' then continue;
    if sKey = '' then continue;

    // add if it's not already in the list
    if sKey <> '' then begin
      if KeyList.IndexOf(sKey) < 0 then begin KeyList.AddObject(sKey, Pointer(1)); inc(Result); end;
    end;

  end;
end;

procedure TFrmMain.MiGetQueueDebugGetAllClick(Sender: TObject);
var
  item: TListItem;
  pG: TGetQueueFile;
  s:  String;
begin
  if LvGetQueue.Selected = nil then exit;
  if not LockTicker then exit;
  try
    item := LvGetQueue.Selected;
    pG := item.Data;
    pG.Debug_GetAll := not pG.Debug_GetAll;
    if pG.Debug_GetAll then s := 'ON' else s := 'OFF';
  finally
    UnlockTicker;
  end;
  MessageDlg('Debug_GetAll is now ' + s,mtInformation,[mbOk],0);
end;

procedure TFrmMain.PopupGetQueuePopup(Sender: TObject);
var pG:    TGetQueueFile;
begin
  if MiDebug2.Visible then begin
    MiGetQueueDebugGetAll.Enabled := (LvGetQueue.SelCount = 1);
    if MiGetQueueDebugGetAll.Enabled then begin
      pG := LvGetQueue.Selected.Data;
      MiGetQueueDebugGetAll.Checked := pG.Debug_GetAll;
    end else
      MiGetQueueDebugGetAll.Checked := False;
  end;
end;

procedure TFrmMain.LvAnyQueueMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  qt:   TQueueType;
  item: TListItem;
begin
  if Button = mbMiddle then begin
    // Middle button -> show Explorer menu
    if not FindQueueType(Sender, qt) then exit;
    // select the item under the cursor (we can only handle single files anyway so far)
    item := FQueueInfo[qt].ListView.GetItemAt(X, Y);
    if item <> nil then begin
      FQueueInfo[qt].ListView.ClearSelection;
      FQueueInfo[qt].ListView.Selected := item;
    end;
    MiAnyQueueExplorerMenuClick(Sender);
  end;
end;

procedure TFrmMain.LvAnyQueueColumnRightClick(Sender: TObject; Column: TListColumn; Point: TPoint);
begin
  FColumnRightClicked := True;
end;

procedure TFrmMain.LvAnyQueueContextPopup(Sender: TObject; MousePos: TPoint; var Handled: Boolean);
var
  pt: TPoint;
  qt: TQueueType;
begin
  try
    if FColumnRightClicked and FindQueueType(Sender, qt) then begin
      Handled := True;
      pt := FQueueInfo[qt].ListView.ClientToScreen(MousePos);
      PopupColumns.Tag := Ord(qt);
      PopupColumns.Popup(pt.X, pt.Y);
    end;
  finally
    FColumnRightClicked := False;
  end;
end;


procedure TFrmMain.MiAnyQueueExplorerMenuClick(Sender: TObject);
var
  qt:      TQueueType;
  item:    TListItem;
  pQ:      TQueueFile;
  sFNam:   String;
  ExVerbs: Boolean;
begin
  if not FindQueueType(Sender, qt) then exit;

  sFNam := '';
  if not LockTicker then exit;
  try
    item := FQueueInfo[qt].ListView.Selected; if item = nil then exit;
    pQ := item.Data; if pQ = nil then exit;
    if qt = qtInsQueue then
      sFNam := (pQ as TInsQueueFile).OrgFilename
    else
      sFNam := (pQ as TGetQueueFile).SavFilename;
  finally
    UnlockTicker;
  end;
  if sFNam = '' then exit;

  ExVerbs := (GetAsyncKeyState(VK_SHIFT) < 0);
  if FileExists(sFNam) then
    DoFileContextMenu(sFNam, ExVerbs)
  else
    MessageDlg('The file "' + sFNam + '" does not exist.', mtError, [mbOk], 0);
end;


procedure TFrmMain.ZipTest1Click(Sender: TObject);
var
  ZipFile: unzFile;
  Path: AnsiString;
  globinf: unz_global_info;
  fileinf: unz_file_info;
  Buf:     packed Array [0..512] of Char;
  ret:     Integer;
begin
  OpenDlgInsQueue.UseExtensions := False;
  if not OpenDlgInsQueue.Execute then exit;
  Path := OpenDlgInsQueue.FileName;
  ZipFile := nil;
  try
    ZipFile := unzOpen(PChar(Path)); if ZipFile = nil then raise Exception.Create('unzOpen failed');
    if unzGetGlobalInfo(ZipFile, globinf) = UNZ_OK then
      MainLog(Format('Num.entries: %d',[globinf.number_entry]));
    ret := unzGoToFirstFile(ZipFile); if ret <> UNZ_OK then raise Exception.CreateFmt('unzGoToFirstFile failed: %d',[ret]);
    repeat
      FillChar(Buf, SizeOf(Buf), 0); FillChar(fileinf, SizeOf(fileinf), 0);
      ret := unzGetCurrentFileInfo(ZipFile, @fileinf, @Buf, SizeOf(Buf)-1, nil, 0, nil, 0);
      if ret <> UNZ_OK then raise Exception.CreateFmt('unzGetCurrentFileInfo failed: %d',[ret]);

      MainLog(Format('Filename: "%s", Compressed:%d Uncompressed:%d',[PChar(@Buf),fileinf.compressed_size,fileinf.uncompressed_size]));

      ret := unzGoToNextFile(ZipFile);
      if (ret <> UNZ_OK) and (ret <> UNZ_END_OF_LIST_OF_FILE) then raise Exception.CreateFmt('unzGoToNextFile failed: %d',[ret]);
    until ret = UNZ_END_OF_LIST_OF_FILE;
  finally
    if ZipFile <> nil then unzClose(ZipFile);
  end;
end;

procedure TFrmMain.MiWriteFCPlogOnErrorsClick(Sender: TObject);
begin
  FreenetUtils.gWriteFCPDebugLogOnErrors := not FreenetUtils.gWriteFCPDebugLogOnErrors;
  MiWriteFCPlogOnErrors.Checked := FreenetUtils.gWriteFCPDebugLogOnErrors;
end;

{$IFDEF DELPHI_7_OR_HIGHER}
procedure TFrmMain.LvAnyQueueInfoTip(Sender: TObject; Item: TListItem; var InfoTip: String);
  procedure AddToInfoTip(const S: String);
  begin
    if InfoTip = '' then InfoTip := S else InfoTip := InfoTip + #13#10 + S;
  end;
var
  pQ:  TQueueFile;
  s:   String;
  fr:  TFreenetThreadFailReason;
  fst: TFileStatType;
  iPass: Integer;
begin
  try
    pQ := Item.Data; if pQ = nil then exit;

    InfoTip := '';
    AddToInfoTip('File: ' + pQ.GetFilename);
    if pQ.Comment <> '' then AddToInfoTip('Comment: ' + pQ.Comment);
    if pQ.Size = 0 then s := 'Unknown' else s := Format('%.2f M (%.0n bytes)',[pQ.Size / (1024*1024), 1.0 * pQ.Size]);
    AddToInfoTip('Size: ' + s);
    if pQ.Key <> '' then AddToInfoTip('Key: ' + pQ.Key);
    if pQ.DateAdded <> 0 then AddToInfoTip('Added on: ' + DateTimeToStr(pQ.DateAdded));
    for iPass := 1 to 2 do begin
      AddToInfoTip('');
      if iPass = 1 then begin
        fst := fstSession;
        AddToInfoTip('Session stats:');
      end else begin
        fst := fstOverall;
        AddToInfoTip('Overall stats:');
      end;
      if pQ.Stats[fst].LastSucc = 0 then s := '' else s := ', last: ' + DateTimeToStr(pQ.Stats[fst].LastSucc);
      AddToInfoTip(IntToStr(pQ.Stats[fst].SuccCount) + ' blocks succeeded' + s);
      if pQ.Stats[fst].LastFail = 0 then s := '' else s := ', last: ' + DateTimeToStr(pQ.Stats[fst].LastFail);
      AddToInfoTip(IntToStr(pQ.Stats[fst].FailCountTotal) + ' blocks failed' + s);
      for fr := Low(TFreenetThreadFailReason) to High(TFreenetThreadFailReason) do begin
        if pQ.Stats[fst].FailCount[fr] <> 0 then begin
          case fr of
            ftfrUnknown: s := 'Unknown errors';
            ftfrDNF:     s := 'Data not found';
            ftfrRNF:     s := 'Route not found';
            ftfrInvalid: s := 'Invalid response';
            ftfrCutoff:  s := 'Aborted by Freenet';
            ftfrTimeout: s := 'Timeout exceeded';
            ftfrBadData: s := 'Key mismatch';
            ftfrAborted: s := 'Aborted by user';
            else         s := '??????????????';
          end;
          AddToInfoTip('  ' + IntToStr(pQ.Stats[fst].FailCount[fr]) + ' ' + s);
        end;
      end;
    end;
  except
  end;
end;
{$ENDIF}

function TFrmMain.MyTimeToString(dt: TDateTime; Mode: Integer): String;
// Mode 0: absolute, 1: relative
var
  dtDelta: TDateTime;
begin
  if Mode = 0 then begin
    Result := DateTimeToStr(dt); // FormatDateTime('yyyy-mm-dd hh:nn', dt);
  end else begin
    dtDelta := Now - dt;
    if dtDelta < 0 then dtDelta := 0;
    if dtDelta >= 1 then
      Result := IntToStr(Trunc(dtDelta)) + 'd, '
    else
      Result := '';
    Result := Result + FormatDateTime('hh:nn', dtDelta) + ' ago';
  end;
end;

procedure TFrmMain.LVInsWindowProc(var Msg: TMessage);
begin
  LVAllWindowProc(Msg, True, FLVInsOrigWindowProc);
end;

procedure TFrmMain.LVGetWindowProc(var Msg: TMessage);
begin
  LVAllWindowProc(Msg, False, FLVGetOrigWindowProc);
end;

procedure TFrmMain.LVAllWindowProc(var Msg: TMessage; IsLvIns: Boolean; OrigHandler: TWndMethod);
const
  BGCOL_EVEN = clWhite;
  BGCOL_ODD  = $DDFFFF;
  BGCOL_FRZ  = $FFF9B7;

  procedure GetColors(ItemIndex: Integer; out BGCol,FGCol: TColor);
  var qf:  TQueueFile;
      qfI: TInsQueueFile;
      qfG: TGetQueueFile;
      iOdd: Integer;
  begin
    if Odd(ItemIndex) then iOdd := 1 else iOdd := 0;
    try
      qfI := nil; qfG := nil;
      if IsLvIns then begin qfI := TInsQueueFile(LvInsQueue.Items[ItemIndex].Data); qf := qfI; end
                 else begin qfG := TGetQueueFile(LvGetQueue.Items[ItemIndex].Data); qf := qfG; end;
      if Assigned(qf) and qf.Freeze then begin
        BGCol := GlobalSettings.ClrFrozen[1 + iOdd];
        FGCol := GlobalSettings.ClrFrozen[3 + iOdd];
        exit;
      end else if (Assigned(qfI) and (qfI.Status = ifsDone)) or (Assigned(qfG) and (qfG.Status = gfsDone)) then begin
        BGCol := GlobalSettings.ClrDone[1 + iOdd];
        FGCol := GlobalSettings.ClrDone[3 + iOdd];
        exit;
      end else if (Assigned(qfI) and (qfI.Status = ifsError)) or (Assigned(qfG) and (qfG.Status = gfsError)) then begin
        BGCol := GlobalSettings.ClrError[1 + iOdd];
        FGCol := GlobalSettings.ClrError[3 + iOdd];
        exit;
      end;
    except
    end;
    BGCol := GlobalSettings.ClrNormal[1 + iOdd];
    FGCol := GlobalSettings.ClrNormal[3 + iOdd];
  end;

  function GetBGColor(ItemIndex: Integer): TColor;
  var dummy: TColor;
  begin
    GetColors(ItemIndex, Result, dummy);
  end;

var
  p_nmlvcd: PNMLVCUSTOMDRAW;
  bHandled: Boolean;
  pColCfg:  PColumnConfig;
  i:        Integer;
  colBG,colFG: TColor;
begin
  bHandled := False;
  try
    if Msg.Msg <> CN_NOTIFY then exit;
    if (TWMNotify(Msg).NMHdr^.hwndFrom <> LvInsQueue.Handle) and (TWMNotify(Msg).NMHdr^.hwndFrom <> LvGetQueue.Handle) then exit;
    if TWMNotify(Msg).NMHdr^.code <> NM_CUSTOMDRAW then exit;

    bHandled := True;

    p_nmlvcd := Pointer(TWMNotify(Msg).NMHdr);
    case p_nmlvcd^.nmcd.dwDrawStage of
      CDDS_PREPAINT:
          Msg.Result := CDRF_NOTIFYITEMDRAW;

      CDDS_ITEMPREPAINT:
          begin
            //mainlog('itemprepaint ' + inttostr(p_nmlvcd^.nmcd.dwItemSpec));
            GetColors(p_nmlvcd^.nmcd.dwItemSpec, colBG, colFG);
            p_nmlvcd^.clrTextBk := ColorToRGB(colBG);
            p_nmlvcd^.clrText   := ColorToRGB(colFG);
            if IsLvIns then
              Msg.Result := CDRF_NEWFONT
            else
              Msg.Result := CDRF_NOTIFYITEMDRAW or CDRF_NEWFONT;
          end;

      CDDS_ITEMPREPAINT or CDDS_SUBITEM:
        begin
          //mainlog('subitemprepaint ' + inttostr(p_nmlvcd^.nmcd.dwItemSpec) + '.' + inttostr(p_nmlvcd^.iSubItem));
          Msg.Result := CDRF_DODEFAULT;
          if not IsLvIns then begin
            for i := 0 to FColumnConfigList.Count-1 do begin
              pColCfg := FColumnConfigList.Items[i];
              if (not pColCfg^.InsQueue) and pColCfg^.Visible and (p_nmlvcd^.iSubItem = pColCfg^.Index) and (pColCfg^.Column = Ord(getcol_BLOCKS)) then begin
                LVGetDrawProgressOnHDC( p_nmlvcd^.nmcd.hdc, LvGetQueue.Items[p_nmlvcd^.nmcd.dwItemSpec], GetBGColor(p_nmlvcd^.nmcd.dwItemSpec), pColCfg^.Index);
                Msg.Result := CDRF_SKIPDEFAULT;
                break;
              end;
            end;
          end;
        end;

      else
          Msg.Result := CDRF_DODEFAULT;
    end;

  finally
    if not bHandled then OrigHandler(Msg);
  end;
end;

procedure TFrmMain.LVGetDrawProgressOnHDC(LvHDC: HDC; Item: TListItem; BGColor: TColor; BlocksColumnIndex: Integer);

const
  SHADE_VAL_1 = $60;
  SHADE_VAL_2 = $30;

var
  CurBrush:   TLogBrush;
  CurPen:     TLogPen;
  hBr,hOldBr: HBRUSH;
  hPn,hOldPn: HPEN;

  procedure SetBrush(lbStyle: UINT; lbColor: COLORREF; JustCleanup: Boolean = False);
  begin
    if hOldBr <> 0 then SelectObject(LvHDC, hOldBr); hOldBr := 0;
    if hBr    <> 0 then DeleteObject(hBr);           hBr := 0;
    if not JustCleanup then begin
      CurBrush.lbStyle := lbStyle;
      CurBrush.lbColor := lbColor;
      CurBrush.lbHatch := 0;
      hBr := CreateBrushIndirect(CurBrush);
      hOldBr := SelectObject(LvHDC, hBr);
    end;
  end;

  procedure SetBrushStyle(lbStyle: UINT);
  begin SetBrush(lbStyle, CurBrush.lbColor); end;

  procedure SetBrushColor(lbColor: COLORREF);
  begin SetBrush(CurBrush.lbStyle, lbColor); end;

  procedure SetPen(lopnStyle: UINT; lopnColor: COLORREF; JustCleanup: Boolean = False);
  begin
    if hOldPn <> 0 then SelectObject(LvHDC, hOldPn); hOldPn := 0;
    if hPn    <> 0 then DeleteObject(hPn);           hPn := 0;
    if not JustCleanup then begin
      CurPen.lopnStyle := lopnStyle;
      CurPen.lopnWidth := Point(0,0);
      CurPen.lopnColor := lopnColor;
      hPn := CreatePenIndirect(CurPen);
      hOldPn := SelectObject(LvHDC, hPn);
    end;
  end;

  procedure SetPenColor(lopnColor: COLORREF);
  begin SetPen(CurPen.lopnStyle, lopnColor); end;

  procedure DoPolyline(const Points: array of TPoint);
  type
    TPoints = array[0..0] of TPoint;
    PPoints = ^TPoints;
  begin
    Polyline(LvHDC, PPoints(@Points)^, High(Points) + 1);
  end;

  function ShadeColor(AColor: TColor; ShadeVal: Integer): TColor;
  var r,g,b: Byte;
  begin
    r := AColor and $FF;
    g := (AColor shr 8) and $FF;
    b := (AColor shr 16) and $FF;
    if r > ShadeVal then dec(r,ShadeVal) else r := 0;
    if g > ShadeVal then dec(g,ShadeVal) else g := 0;
    if b > ShadeVal then dec(b,ShadeVal) else b := 0;
    Result := (b shl 16) or (g shl 8) or r;
  end;

  procedure ShadedFillRect(AColor: TColor; ARect: TRect);
  var x0,x1,y0,y1: Integer;
  begin
    x0 := ARect.Left; x1 := ARect.Right;
    y0 := ARect.Top;  y1 := ARect.Bottom-1;
    SetPenColor(ColorToRGB(ShadeColor(AColor,SHADE_VAL_1)));
    DoPolyline([Point(x0,y0),Point(x1,y0)]);
    DoPolyline([Point(x0,y1),Point(x1,y1)]);
    inc(y0); dec(y1);
    SetPenColor(ColorToRGB(ShadeColor(AColor,SHADE_VAL_2)));
    DoPolyline([Point(x0,y0),Point(x1,y0)]);
    DoPolyline([Point(x0,y1),Point(x1,y1)]);
    SetBrushColor(ColorToRGB(AColor));
    FillRect(LvHDC, Rect(x0,y0+1,x1,y1), hBr);
  end;

// note: SubItem passed as parameter is 1-based!
const
  COL_DONE     = clLime;
  COL_FAIL     = clRed;
  COL_WORK     = clBlack;
  COL_WORK_INV = $0000D2D2;
  COL_SEGDONE  = clAqua;
  COL_UNTRIED  = clWhite;
  BOTTOMLINEHEIGHT = 8;
  BOTTOMLINEHEIGHT_OLD = 5;
  WORK_HEIGHT  = 3;
var
  R,Bounds:  TRect;
  Lv:        TListView;
  x,len,n,i: Integer;
//  pG:        TGetQueueFile;
  sStat,s:   String;
  bStat,b:   Byte;
  col:       TColor;
  bWork:     Boolean;
  y0,y1,x0,x1,w,xx,xx2: Integer;
  iPass:     Integer;
  nReq,nGood,nBad,nTotal: Integer;
  sTotal: String;
begin
  hBr := 0; hOldBr := 0;
  hPn := 0; hOldPn := 0;
  try
    Lv := LvGetQueue;
    R := Rect(LVIR_BOUNDS, BlocksColumnIndex, 0, 0);
    if BlocksColumnIndex = 0 then begin
      if 0 = SendMessage(Lv.Handle, LVM_GETITEMRECT, Item.Index, Integer(@R)) then exit;
    end else begin
      if 0 = SendMessage(Lv.Handle, LVM_GETSUBITEMRECT, Item.Index, Integer(@R)) then exit;
    end;

    if Item.SubItems.Count < BlocksColumnIndex then sStat := '' else sStat := Item.SubItems[BlocksColumnIndex-1];

    Bounds := R;

    CurBrush.lbStyle := BS_SOLID;
    CurBrush.lbColor := ColorToRGB(clWhite);
    CurBrush.lbHatch := 0;
    CurPen.lopnStyle := PS_SOLID;
    CurPen.lopnWidth := Point(0,0);
    CurPen.lopnColor := ColorToRGB(clBlack);

    // Block status

    i := Pos('#',sStat); // strip percentage complete
    if i <> 0 then Delete(sStat,1,i);

    if (sStat = '') or (FGraphStyle = 2) then begin
      SetBrushColor(ColorToRGB(BGColor)); // clear background
      FillRect(LvHDC, R, hBr);
      exit;
    end;

    nReq := 0; nGood := 0; nBad := 0; //nRetry := 0;

    i := Pos('#',sStat);
    if i <> 0 then begin
      s := Copy(sStat,i+1,Length(sStat));
      Delete(sStat,i,Length(sStat));
      nReq := StrToIntDef('$'+s, 0); // blocks required
    end;

    len := Length(sStat); n := len div 2; nTotal := n;

    if FGraphStyle > 0 then begin
      // use entire area and scale

      //Lv.Canvas.Brush.Color := Lv.Color; // clear background
      //Lv.Canvas.FillRect(R);
      //inc(R.Left,2); dec(R.Right,4);

      w := R.Right - (R.Left+1) - 1;
      if w <= 0 then exit;

      for i := 0 to nTotal-1 do begin
        bStat := StrToInt('$'+Copy(sStat,1+2*i,2));
        if bStat = $FF then continue;
        if (bStat and PREPFILEDONEMASK_DONE) <> 0 then
          inc(nGood)
        else if (bStat and PREPFILEDONEMASK_TRIES) > GlobalSettings.GetRetries then
          inc(nBad);
      end;

      // draw block indicators
      y0 := R.Top+1; y1 := R.Bottom-2-BOTTOMLINEHEIGHT;
      SetBrushColor(ColorToRGB(clBlack));
      FrameRect(LvHDC, Rect(R.Left,y0-1,R.Right,y1+1), hBr);

      for iPass := 1 to 2 do begin
        // pass 1: draw color bars
        // pass 2: draw working blocks
        if iPass = 2 then SetPenColor(ColorToRGB(COL_WORK)); // COL_WORK_INV;
        for xx := 0 to w-1 do begin
          x := R.Left + 1 + xx;
          i := (nTotal * xx) div w;
          if (i < 0) or (i >= nTotal) then break; // shouldn't happen, but just make sure...
          bStat := StrToInt('$'+Copy(sStat,1+2*i,2));

          bWork := (bStat <> $FF) and ((bStat and PREPFILEDONEMASK_WORKING) <> 0);
          if (not bWork) and (iPass = 2) then continue;

          if iPass = 1 then begin
            if bStat = $FF then
              col := COL_SEGDONE
            else if (bStat and PREPFILEDONEMASK_DONE) <> 0 then
              col := COL_DONE
            else begin
              bStat := bStat and PREPFILEDONEMASK_TRIES;
              if bStat = 0 then
                col := COL_UNTRIED
              else if bStat > GlobalSettings.GetRetries then
                col := COL_FAIL
              else begin
                b := Round($A0 - $40 * bStat / GlobalSettings.GetRetries);
                col := (b shl 16) or (b shl 8) or b;
              end;
            end;
            SetPenColor(ColorToRGB(col));
          end;

          if not bWork then
            DoPolyline([Point(x,y0),Point(x,y1)])
          else if iPass = 1 then
            DoPolyline([Point(x,y0+WORK_HEIGHT),Point(x,y1)])
          else
            DoPolyline([Point(x,y0),Point(x,y0+WORK_HEIGHT)]);
        end;
      end;

      // total indicator:
      // <good blocks>..->.. | ..<-..<bad blocks>
      y0 := y1+1; y1 := y0 + BOTTOMLINEHEIGHT-2;
      SetPenColor(ColorToRGB(clBlack));
      SetBrushColor(ColorToRGB(clWhite));
      Rectangle(LvHDC, R.Left,y0-1,R.Right,y1+1);

      x0 := R.Left + 1; x1 := x0 + w*nGood div nTotal - 1;
      if x1 > x0 then begin
        ShadedFillRect(COL_DONE, Rect(x0,y0,x1+1,y1));
        xx := x1 + 1;
      end else
        xx := x0;

      x1 := R.Right - 2; x0 := x1 - w*nBad div nTotal + 1;
      if x1 > x0 then begin
        ShadedFillRect(COL_FAIL, Rect(x0,y0,x1+1,y1));
        xx2 := x0-1;
      end else
        xx2 := x1;

      x0 := xx; x1 := xx2;
      if x1 > x0 then begin
        ShadedFillRect(COL_UNTRIED, Rect(x0,y0,x1+1,y1));
      end;

      x := R.Left + 1 + w*nReq div nTotal - 1;
      SetPenColor(ColorToRGB(clBlack));
      DoPolyline([Point(x,y0),Point(x,y1+1)]);

    end else begin
      // old drawing style
      R.Right := R.Left + 1 + n + 1;
      dec(R.Bottom);

      SetPenColor(ColorToRGB(clBlack));
      SetBrushColor(ColorToRGB(clWhite));
      if R.Right <= Bounds.Right then
        Rectangle(LvHDC,R.Left,R.Top,R.Right,R.Bottom)
      else begin
        FillRect(LvHDC, Bounds, hBr);
        DoPolyline([Point(Bounds.Right-1,R.Top),Point(R.Left,R.Top),Point(R.Left,R.Bottom-1),Point(Bounds.Right-1,R.Bottom-1)]);
      end;

      // keep in mind polyline (and lineto) draw up to, but NOT including, the last point

      y0 := R.Top+1; y1 := R.Bottom-1-BOTTOMLINEHEIGHT_OLD;
      for iPass := 1 to 2 do begin
        // pass 1: draw color bars
        // pass 2: draw working blocks
        for i := 0 to n-1 do begin
          x := R.Left + 1 + i; if x >= Bounds.Right then break;
          bStat := StrToInt('$'+Copy(sStat,1+2*i,2));

          bWork := (bStat <> $FF) and ((bStat and PREPFILEDONEMASK_WORKING) <> 0);
          if bWork <> (iPass = 2) then continue;

          if bWork then begin
            col := COL_WORK;
            //inc(nRetry);
          end else if bStat = $FF then begin
            col := COL_SEGDONE;
          end else if (bStat and PREPFILEDONEMASK_DONE) <> 0 then begin
            col := COL_DONE;
            inc(nGood);
          end else begin
            bStat := bStat and PREPFILEDONEMASK_TRIES;
            if bStat = 0 then
              col := COL_UNTRIED
            else if bStat > GlobalSettings.GetRetries then begin
              col := COL_FAIL;
              inc(nBad);
            end else begin
              b := Round($A0 - $50 * bStat / GlobalSettings.GetRetries);
              col := (b shl 16) or (b shl 8) or b;
              //inc(nRetry);
            end;
          end;

          SetPenColor(ColorToRGB(col));
          if bWork then
            DoPolyline([Point(x-1,y0),Point(x+1,y0),Point(x,y0),Point(x,y1),Point(x-1,y1),Point(x+2,y1)])
          else
            DoPolyline([Point(x,y0),Point(x,y1+1)]);
        end;
      end;

      // total indicator:
      // <good blocks>..->.. | ..<-..<bad blocks>
      SetPenColor(ColorToRGB(clBlack));
      x := R.Right; if x >= Bounds.Right then x := Bounds.Right-1;
      DoPolyline([Point(R.Left,y1+1),Point(x,y1+1)]);
      y0 := y1+2; y1 := R.Bottom-1;
      if nGood > 0 then begin
        x0 := R.Left+1; x1 := x0 + nGood - 1;
        if x1 >= Bounds.Right then x1 := Bounds.Right-1;
        SetBrushColor(ColorToRGB(COL_DONE));
        FillRect(LvHDC, Rect(x0,y0,x1+1,y1), hBr);
      end;
      if nBad > 0 then begin
        x1 := R.Left+1 + nTotal-1; x0 := x1 - nBad + 1;
        if x0 <= (Bounds.Right-1) then begin
          if x1 >= Bounds.Right then x1 := Bounds.Right-1;
          SetBrushColor(ColorToRGB(COL_FAIL));
          FillRect(LvHDC, Rect(x0,y0,x1+1,y1), hBr);
        end;
      end;
      if nReq > 0 then begin
        x := R.Left+1 + nReq - 1;
        if x <= (Bounds.Right-1) then begin
          SetPenColor(ColorToRGB(clBlack));
          DoPolyline([Point(x,y0),Point(x,y1+1)]);
        end;
      end;
    end;
  finally
    SetBrush(0,0,True); // cleanup
    SetPen  (0,0,True); // cleanup
  end;
end;

procedure TFrmMain.GetCurrentColumnWidths(Queues: TQueueTypes);
// update FColumnConfigList with current column widths
var
  qt: TQueueType;
  Lv: TListView;
  i,j,w: Integer;
  pColCfg:  PColumnConfig;
begin
  for qt := Low(TQueueType) to High(TQueueType) do begin
    if not (qt in Queues) then continue;
    if qt = qtInsQueue then Lv := LvInsQueue else Lv := LvGetQueue;
    for i := 0 to Lv.Columns.Count-1 do begin
      w := SendMessage(Lv.Handle, LVM_GETCOLUMNWIDTH, i, 0);
      for j := 0 to FColumnConfigList.Count-1 do begin
        pColCfg := FColumnConfigList.Items[j];
        if (pColCfg^.InsQueue = (qt = qtInsQueue)) and pColCfg^.Visible and (pColCfg^.Index = i) then begin
          pColCfg^.Width := w;
          break;
        end;
      end;
    end;
  end;
end;

procedure TFrmMain.SetListViewColumns(TickerAlreadyLocked: Boolean; Queues: TQueueTypes);
var
  InsQueue: Boolean;
  Lv:       TListView;
  i:        Integer;
  pColCfg:  PColumnConfig;
  TmpList:  TList;
  Col:      TListColumn;
  qt:       TQueueType;
begin
  TmpList := nil;
  if not TickerAlreadyLocked then begin
    if not LockTicker then exit;
  end;
  try
    TmpList := TList.Create;
    for qt := Low(TQueueType) to High(TQueueType) do begin
      if not (qt in Queues) then continue;
      InsQueue := (qt = qtInsQueue);
      if InsQueue then Lv := LvInsQueue else Lv := LvGetQueue;
      FNeedPermanentRefresh[qt] := False;

      Lv.Items.BeginUpdate;
      try
        Lv.Columns.Clear;

        // get visible columns into TmpList
        TmpList.Clear;
        for i := 0 to FColumnConfigList.Count-1 do begin
          pColCfg := FColumnConfigList.Items[i];
          if (pColCfg^.InsQueue = InsQueue) and pColCfg^.Visible then TmpList.Add(pColCfg);
        end;
        // sort TmpList by desired position
        TmpList.Sort(CompareColumnConfig_ByPosition);

        // add columns to ListView
        for i := 0 to TmpList.Count-1 do begin
          pColCfg := TmpList.Items[i];
          Col := Lv.Columns.Add;
          Col.Caption   := pColCfg^.Caption;
          Col.Alignment := pColCfg^.Align;
          Col.Width     := pColCfg^.Width;
          pColCfg^.Index := i;
          // check if we need to continuously refresh (relative time display)
          if (     InsQueue  and (TInsColumn(pColCfg^.Column) in [inscol_DATE,inscol_LASTSUCC,inscol_LASTFAIL]))
          or ((not InsQueue) and (TGetColumn(pColCfg^.Column) in [getcol_DATE,getcol_LASTSUCC,getcol_LASTFAIL])) then begin
            if pColCfg^.Option = 1 then FNeedPermanentRefresh[qt] := True;
          end;
        end;

        // update entries
        if InsQueue then UpdateInsertQueue(True) else UpdateGetQueue(True);
      finally
        Lv.Items.EndUpdate;
      end;

    end;
  finally
    TmpList.Free;
    if not TickerAlreadyLocked then UnlockTicker;
  end;
end;

procedure TFrmMain.MiAnyQueueConfigColumnsClick(Sender: TObject);
var qt: TQueueType;
begin
  if not FindQueueType(Sender, qt) then exit;
  if not Assigned(FColumnConfigForm[qt]) then begin
    GetCurrentColumnWidths([qt]);
    FColumnConfigForm[qt] := TFrmColumnConfig.Create(Self, (qt = qtInsQueue));
    FColumnConfigForm[qt].SetWorkList(FColumnConfigList);
    FColumnConfigForm[qt].OnApply   := ColumnConfigApply;
    FColumnConfigForm[qt].OnClosing := ColumnConfigClosing;
  end;
  with FColumnConfigForm[qt] do if Visible then BringToFront else Show;
end;

procedure TFrmMain.ColumnConfigApply(Sender: TObject);
var
  frm: TFrmColumnConfig;
begin
 frm := (Sender as TFrmColumnConfig);
 frm.GetWorkList(FColumnConfigList);
 if frm.InsQueue then
   SetListViewColumns(False, [qtInsQueue])
 else
   SetListViewColumns(False, [qtGetQueue]);
end;

procedure TFrmMain.ColumnConfigClosing(Sender: TObject);
begin
  if Sender = FColumnConfigForm[qtInsQueue] then FColumnConfigForm[qtInsQueue] := nil;
  if Sender = FColumnConfigForm[qtGetQueue] then FColumnConfigForm[qtGetQueue] := nil;
end;

procedure TFrmMain.MiAnyQueueStatsClick(Sender: TObject);
var
  qt:     TQueueType;
  bClear: Boolean;
  p:      TQueueFile;
  i:      Integer;
begin
  if not LockTicker then exit;
  try
    if not FindQueueType(Sender, qt) then exit;
    if not (Sender is TMenuItem) then exit;
    case (Sender as TMenuItem).Tag of
      1: bClear := True;
      2: bClear := False;
      else exit;
    end;

    for i := 0 to FQueueInfo[qt].ListView.Items.Count-1 do begin
      if FQueueInfo[qt].ListView.Items[i].Selected then begin
        p := FQueueInfo[qt].ListView.Items[i].Data;
        if bClear then p.ClearStats(fstSession) else p.Stats[fstSession] := p.Stats[fstOverall];
        SetAnyQueueListItem(qt, FQueueInfo[qt].ListView.Items[i]);
      end;
    end;

  finally
    UnlockTicker;
  end;
end;

procedure TFrmMain.MiAnyQueueRefreshListClick(Sender: TObject);
var qt: TQueueType;
begin
  if not FindQueueType(Sender, qt) then exit;
  UpdateQueue(FQueueInfo[qt].ListView, FQueueInfo[qt].QueueList, False);
end;

procedure TFrmMain.CheckNodeUp;
var
  fcp: TFCPSession;
  bUp: Boolean;
begin
  // check if Node is up - just test if we can connect to the FCP port
  try
    fcp := TFCPSession.Create(GlobalSettings.FCPAddr, GlobalSettings.FCPPort);
    try
      fcp.ConnectToFCP;
      bUp := True;
    finally
      fcp.Free;
    end;
  except
    bUp := False;
  end;
  FNodeUp.IsUp      := bUp;
  FNodeUp.LastCheck := Now;
end;

procedure TFrmMain.Msg_ENDSESSION(var M: TMessage);
begin
  FEndSession := True;
  M.Result := 0;
end;

procedure TFrmMain.Msg_QUERYENDSESSION(var M: TMessage);
begin
  if BtStop.Enabled  then BtStopClick(nil);
  if BtAbort.Enabled then BtAbortClick(nil);
  M.Result := 1;
end;

procedure TFrmMain.InsFinishedNotification;
begin
  if GlobalSettings.InsFiniAnim  then SetTrayIconAnim(taGlow);
  if GlobalSettings.InsFiniSound then
    PlaySound(PChar(GlobalSettings.InsFiniWav), 0, SND_FILENAME or SND_ASYNC or SND_NODEFAULT or SND_NOWAIT);
end;

procedure TFrmMain.GetFinishedNotification;
begin
  if GlobalSettings.GetFiniAnim  then SetTrayIconAnim(taGlow);
  if GlobalSettings.GetFiniSound then
    PlaySound(PChar(GlobalSettings.GetFiniWav), 0, SND_FILENAME or SND_ASYNC or SND_NODEFAULT or SND_NOWAIT);
end;

procedure TFrmMain.SetShowInfoTip(const Value: Boolean);
begin
  FShowInfoTip := Value;
  LvInsQueue.ShowHint := FShowInfoTip;
  LvGetQueue.ShowHint := FShowInfoTip;
end;

procedure TFrmMain.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if UpCase(Key) = 'I' then begin
    ShowInfoTip := not ShowInfoTip;
    if ShowInfoTip then
      Caption := '* File info on *'
    else
      Caption := '* File info off *';
    TimerRestoreCaption.Enabled := False;
    TimerRestoreCaption.Enabled := True;
    Key := #0;
  end;
end;

procedure TFrmMain.TimerRestoreCaptionTimer(Sender: TObject);
begin
  TimerRestoreCaption.Enabled := False;
  Caption := FFormCaption;
end;

procedure TFrmMain.MiAnyQueueEditCommentClick(Sender: TObject);
var
  qt:       TQueueType;
  p:        TQueueFile;
  i,iPass:  Integer;
  sComment: String;
  sFile:    String;
  bChanged: Boolean;
  item:     TListItem;
  bLockedTicker: Boolean;
begin
  bLockedTicker := False;
  try
    if not FindQueueType(Sender, qt) then exit;
    if FQueueInfo[qt].ListView.SelCount = 0 then exit;
    sComment := ''; sFile := ''; bChanged := False;
    if FQueueInfo[qt].ListView.SelCount > 1 then sFile := 'multiple files';
    for iPass := 1 to 2 do begin
      for i := 0 to FQueueInfo[qt].ListView.Items.Count-1 do begin
        item := FQueueInfo[qt].ListView.Items[i];
        if item.Selected then begin
          p := item.Data;
          if iPass = 1 then begin
            if sComment = '' then sComment := p.Comment;
            if sFile    = '' then sFile    := p.GetFilename();
            if (sComment <> '') and (sFile <> '') then break;
          end else begin
            if p.Comment <> sComment then begin
              bChanged := True;
              p.Comment := sComment;
              SetAnyQueueListItem(qt, item);
            end;
          end;
        end;
      end;

      if iPass = 1 then begin
        if not InputQuery('Comment for ' + sFile, 'Comment:', sComment) then exit;
      end else begin
        while not bLockedTicker do begin
          if not LockTicker then begin
            if MessageDlg('Failed to lock ticker!', mtError, [mbAbort,mbRetry], 0) <> mrRetry then exit;
          end else
            bLockedTicker := True;
        end;
      end;
    end;

    if bChanged then SaveQueues(True);
  finally
    if bLockedTicker then UnlockTicker;
  end;
end;

procedure TFrmMain.MiFrostSearchClick(Sender: TObject);
begin
  FFrostSearch.MsgResults := nil;
  FFrostSearch.KeyResults := nil;
  FFrostSearch.TmpStrLst  := nil;
  try
    MiFrostSearch.Enabled := False;
    BtFrostSearch.Enabled := False;

    if FrmScanFrost = nil then FrmScanFrost := TFrmScanFrost.Create(Application);
    if FrmScanFrost.ShowModal <> mrOk then exit;

    FFrostSearch.Keys         := FrostScanSettings.SearchKeys;
    FFrostSearch.Text         := FrostScanSettings.SearchText;
    FFrostSearch.CheckSubject := FrostScanSettings.SearchSubject;
    FFrostSearch.CheckPoster  := FrostScanSettings.SearchPoster;
    FFrostSearch.CheckBody    := FrostScanSettings.SearchBody;
    FFrostSearch.CheckFiles   := FrostScanSettings.SearchFiles;

    FFrostSearch.MsgResults := TList.Create;
    FFrostSearch.KeyResults := TStringList.Create;
    FFrostSearch.TmpStrLst  := TStringList.Create;
    IterateFrostMessages(FrmScanFrost.Files, FrostSearchCallback);

    if FFrostSearch.Keys then begin
      if FFrostSearch.KeyResults.Count = 0 then
        ShowMessage('No keys found')
      else
        AddKeys(FFrostSearch.KeyResults.Text);
    end else begin
      if FFrostSearch.MsgResults.Count = 0 then
        ShowMessage('No messages found')
      else
        ShowFrostSearchResults(FFrostSearch.MsgResults, FFrostSearch.Text);
    end;
  finally
    MiFrostSearch.Enabled := True;
    BtFrostSearch.Enabled := True;
    if Assigned(FFrostSearch.MsgResults) then begin
      while FFrostSearch.MsgResults.Count > 0 do begin Dispose(FFrostSearch.MsgResults.Items[0]); FFrostSearch.MsgResults.Delete(0); end;
      FFrostSearch.MsgResults.Free;
      FFrostSearch.MsgResults := nil;
    end;
    FFrostSearch.KeyResults.Free;
    FFrostSearch.TmpStrLst.Free;
    if Assigned(FrmScanFrost) then FrmScanFrost.DiscardFilesAndComments; // save memory
  end;
end;

procedure TFrmMain.FrostSearchCallback(Sender: TObject);
var
  sSearch,sComment,sKeyComment,sKey: String;
  Frm: TFrmFrostSearchProgress;
  pR:  PFrostSearchResult;
  Msg: TFrostMessage;
  i,iNumKeys: Integer;
  dtDat: TDateTime;
  sBrd:  String;
begin
  Frm := Sender as TFrmFrostSearchProgress;
  if not GetFrostMessage(Frm.CurrentFile, Msg) then exit;
  sSearch := AnsiUpperCase(FFrostSearch.Text);

  // search messages
  if (FFrostSearch.Text = '')
  or (FFrostSearch.CheckSubject and (Pos(sSearch, AnsiUpperCase(Msg.Header.Subject )) <> 0))
  or (FFrostSearch.CheckPoster  and (Pos(sSearch, AnsiUpperCase(Msg.Header.From    )) <> 0))
  or (FFrostSearch.CheckBody    and (Pos(sSearch, AnsiUpperCase(Msg.Body           )) <> 0))
  or (FFrostSearch.CheckFiles   and (Pos(sSearch, AnsiUpperCase(Msg.FileAttachments)) <> 0))
  then begin
    if FFrostSearch.Keys then begin
      iNumKeys := FFrostSearch.KeyResults.Count;

      // extract keys from body
      FFrostSearch.TmpStrLst.Text := Msg.Body;
      for i := 0 to FFrostSearch.TmpStrLst.Count-1 do begin
        ExtractKeysFromString(FFrostSearch.TmpStrLst.Strings[i], FFrostSearch.KeyResults);
      end;
      // and add each file attachment
      FFrostSearch.TmpStrLst.Text := Msg.FileAttachments;
      for i := 0 to FFrostSearch.TmpStrLst.Count-1 do begin
        FFrostSearch.KeyResults.Add(FFrostSearch.TmpStrLst.Strings[i])
      end;
      // add comment for new keys
      if GetInfoFromFrostFilename(Frm.CurrentFile,sBrd,dtDat,i) then
        sComment := Format('%s %s(%d) by %s',[sBrd, FormatDateTime('yyyy-mm-dd',dtDat), i, Msg.Header.From])
      else
        sComment := ExtractFileName(Frm.CurrentFile) + ' by ' + Msg.Header.From;
      for i := iNumKeys to FFrostSearch.KeyResults.Count-1 do begin
        sKey := FFrostSearch.KeyResults.Strings[i];
        sKeyComment := ExtractCommentFromKey(sKey);
        if sKeyComment = '' then sKeyComment := sComment else Insert(sComment + '; ', sKeyComment, 1);
        FFrostSearch.KeyResults.Strings[i] := sKey + COMMENT_TAG + sKeyComment;
      end;
      Frm.MatchCount := FFrostSearch.KeyResults.Count;
    end else begin
      New(pR);
      pR^.Header   := Msg.Header;
      pR^.Filename := Frm.CurrentFile;
      FFrostSearch.MsgResults.Add( pR );
      Frm.MatchCount := FFrostSearch.MsgResults.Count;
    end;
  end;
end;

end.
