//PROFILE-NO
unit Log;

// *****************************************************************************
// * Copyright 2003-2005 mxbee                                                 *
// *****************************************************************************
// * This program is free software; you can redistribute it and/or modify      *
// * it under the terms of the GNU General Public License as published by      *
// * the Free Software Foundation; either version 2 of the License, or         *
// * (at your option) any later version.                                       *
// *                                                                           *
// * This program is distributed in the hope that it will be useful,           *
// * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
// * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
// * GNU General Public License for more details.                              *
// *                                                                           *
// * You should have received a copy of the GNU General Public License         *
// * along with this program; if not, write to the Free Software               *
// * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
// *****************************************************************************

{$INCLUDE CompilerOpts.pas}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, Menus, ExtCtrls;

type
  TFrmLog = class(TForm)
    RichEdit: TRichEdit;
    PopupLog: TPopupMenu;
    Clear1: TMenuItem;
    LbFilenames: TListBox;
    Splitter1: TSplitter;
    PopupFileLog: TPopupMenu;
    Copy1: TMenuItem;
    PanelAutoscroll: TPanel;
    CbAutoscroll: TCheckBox;
    procedure Clear1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure LbFilenamesClick(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
  private
    FIsFileLog: Boolean;
  public
    procedure Log(Logmsg: String);
    procedure SetContents(Title: String; StrList: TStringList);
  end;

var
  FrmLog: TFrmLog;

implementation

uses Main, RichEdit;

{$R *.DFM}

procedure TFrmLog.Clear1Click(Sender: TObject);
begin
  RichEdit.Clear;
end;

procedure TFrmLog.Log(Logmsg: String);
var
  bHadFocus, bHadHideSel: Boolean;
  CharRng:                TCharRange;
begin
  // still problems with maintaining backwards selection... but better than before
  if Showing and (not CbAutoscroll.Checked) then begin
    bHadFocus   := (GetFocus = RichEdit.Handle);
    if bHadFocus then Windows.SetFocus(0);
    bHadHideSel := RichEdit.HideSelection;
    if not bHadHideSel then RichEdit.HideSelection := True;
    SendMessage(RichEdit.Handle, EM_EXGETSEL, 0, Longint(@CharRng));
    RichEdit.SelStart := RichEdit.GetTextLen;
    RichEdit.SelText  := Logmsg + #13#10;
    SendMessage(RichEdit.Handle, EM_EXSETSEL, 0, Longint(@CharRng));
    if not bHadHideSel then RichEdit.HideSelection := False;
    if bHadFocus then Windows.SetFocus(RichEdit.Handle);
  end else begin
    with RichEdit do begin
      SelStart := GetTextLen;
      SelText  := Logmsg + #13#10;
    end;
  end;
end;

procedure TFrmLog.SetContents(Title: String; StrList: TStringList);
var
  i,iPos: Integer;
  s: String;
begin
  Caption := Title;
  RichEdit.Lines.Assign(StrList);
  FIsFileLog := True;
  RichEdit.PopupMenu := PopupFileLog;
  PanelAutoscroll.Visible := False;
  CbAutoscroll.Checked    := False;
  // pick filenames
  LbFilenames.Items.BeginUpdate;
  try
    for i := 0 to StrList.Count-1 do begin
      s := StrList.Strings[i];
      iPos := Pos('/',s);
      if iPos <> 0 then begin
        repeat Delete(s,1,iPos); iPos := Pos('/',s); until iPos = 0;
      end else
        s := '(unknown)';
      LbFilenames.Items.AddObject(s, Pointer(i));
    end;
  finally
    LbFilenames.Items.EndUpdate;
  end;
  LbFilenames.Visible := True;
  Splitter1.Visible := True;
end;

procedure TFrmLog.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  FrmMain.LogFormClosing(Sender, Action);
end;

procedure TFrmLog.LbFilenamesClick(Sender: TObject);
var
  i,iLine,idx: Integer;
begin
  i := LbFilenames.ItemIndex; if i < 0 then exit;
  iLine := Integer(LbFilenames.Items.Objects[i]);
  if iLine >= RichEdit.Lines.Count then exit;
  idx := SendMessage(RichEdit.Handle, EM_LINEINDEX, iLine, 0);
  if idx < 0 then exit;
  // RichEdit.SelStart  := idx + Length(RichEdit.Lines[iLine]);
  // RichEdit.SelLength := -Length(RichEdit.Lines[iLine]);
  SendMessage(RichEdit.Handle, EM_SETSEL, idx + Length(RichEdit.Lines[iLine]), idx);
  // SendMessage(RichEdit.Handle, EM_SCROLLCARET, 0, 0);
end;

procedure TFrmLog.Copy1Click(Sender: TObject);
begin
  RichEdit.CopyToClipboard;
end;

end.
