//PROFILE-NO
unit FreenetWinLauncherUtils;

// *****************************************************************************
// * Copyright 2003-2005 mxbee                                                 *
// *****************************************************************************
// * This program is free software; you can redistribute it and/or modify      *
// * it under the terms of the GNU General Public License as published by      *
// * the Free Software Foundation; either version 2 of the License, or         *
// * (at your option) any later version.                                       *
// *                                                                           *
// * This program is distributed in the hope that it will be useful,           *
// * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
// * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
// * GNU General Public License for more details.                              *
// *                                                                           *
// * You should have received a copy of the GNU General Public License         *
// * along with this program; if not, write to the Free Software               *
// * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
// *****************************************************************************

{$INCLUDE CompilerOpts.pas}

{
  functions for controlling the Windows Freenet Launcher (Blue rabbit in SysTray)
}

interface

uses SysUtils;

type
  EFreenetWinLauncherError = class(Exception);

procedure FLaunch_RestartFreenet;
procedure FLaunch_DebugTest;

implementation

uses Windows, Messages, Dialogs;

const
  FLAUNCH_WINCLASS = 'TrayIconFreenetClass';
  CMD_STARTSTOP    = 1001;
  CMD_RESTART      = 1004;
  CMD_EXIT         = 1003;

function  GetFLaunchWindowHandle: THandle;
begin
  Result := FindWindow(FLAUNCH_WINCLASS, nil);
  if Result = 0 then raise EFreenetWinLauncherError.Create('Cannot find the freenet launcher (not running?)');
  Result := GetLastActivePopup(Result);
end;

function  SendFLaunchCommand(Command: Integer): LRESULT;
begin
  Result := SendMessage(GetFLaunchWindowHandle, WM_COMMAND, Command, 0);
end;

procedure FLaunch_RestartFreenet;
begin
  // first send a start/stop command.
  // if Freenet is running, starting or restarting it will stop
  // if it was stopped, stopping or in state cannot start it will try to start
  // in any case, afterwards the state should be: stopping, stopped, starting or started
  SendFLaunchCommand(CMD_STARTSTOP);
  // now send a restart command. That will only work if state is in running, starting, stopping
  // Problem: if state is already "stopped" it won't work..
  SendFLaunchCommand(CMD_RESTART);
end;

procedure FLaunch_DebugTest;
var cnt: Integer;
begin
  // terminate the launcher
  try
    SendFLaunchCommand(CMD_EXIT);
  except
    ShowMessage('Not running');
    exit;
  end;

  // wait until it's really gone
  cnt := 0;
  while FindWindow(FLAUNCH_WINCLASS, nil) <> 0 do begin
    inc(cnt);
    if cnt > 20 then begin ShowMessage('Launcher still not terminated after 10 seconds...'); exit; end;
    Sleep(500);
  end;
end;

end.
