//PROFILE-NO
unit FCPConsole;

// *****************************************************************************
// * Copyright 2003-2005 mxbee                                                 *
// *****************************************************************************
// * This program is free software; you can redistribute it and/or modify      *
// * it under the terms of the GNU General Public License as published by      *
// * the Free Software Foundation; either version 2 of the License, or         *
// * (at your option) any later version.                                       *
// *                                                                           *
// * This program is distributed in the hope that it will be useful,           *
// * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
// * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
// * GNU General Public License for more details.                              *
// *                                                                           *
// * You should have received a copy of the GNU General Public License         *
// * along with this program; if not, write to the Free Software               *
// * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
// *****************************************************************************

{$INCLUDE CompilerOpts.pas}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls, Menus;

type
  TFrmFCPConsole = class(TForm)
    Panel1: TPanel;
    RichEdInput: TRichEdit;
    Splitter1: TSplitter;
    RichEdOutput: TRichEdit;
    PopupMenu1: TPopupMenu;
    Clear1: TMenuItem;
    PanelButtons: TPanel;
    BtSend: TButton;
    BtAbort: TButton;
    N1: TMenuItem;
    ClientGet1: TMenuItem;
    ClientPut1: TMenuItem;
    ClientInfo1: TMenuItem;
    ClientHello1: TMenuItem;
    Deletekey1: TMenuItem;
    GenerateSVKpair1: TMenuItem;
    Invertprivatekey1: TMenuItem;
    LbInfo: TLabel;
    SelectAll1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    MiSaveLastRcv: TMenuItem;
    MiSendRaw: TMenuItem;
    MiConvertLinefeeds: TMenuItem;
    CbContSend: TCheckBox;
    PageControl1: TPageControl;
    TsText: TTabSheet;
    TsHex: TTabSheet;
    RichEdOutHex: TRichEdit;
    CbASCIIOnly: TCheckBox;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Clear1Click(Sender: TObject);
    procedure BtSendClick(Sender: TObject);
    procedure BtAbortClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure ClientGet1Click(Sender: TObject);
    procedure ClientPut1Click(Sender: TObject);
    procedure ClientInfo1Click(Sender: TObject);
    procedure ClientHello1Click(Sender: TObject);
    procedure Deletekey1Click(Sender: TObject);
    procedure GenerateSVKpair1Click(Sender: TObject);
    procedure Invertprivatekey1Click(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure SelectAll1Click(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure Paste1Click(Sender: TObject);
    procedure MiSaveLastRcvClick(Sender: TObject);
    procedure MiSendRawClick(Sender: TObject);
    procedure PopupMenu1Popup(Sender: TObject);
    procedure MiConvertLinefeedsClick(Sender: TObject);
  private
    FAborted: Boolean;
    FLastRcvBuf: Pointer;
    FLastRcvLen: Integer;
    FHexDumpOffset: Integer;
    procedure SendData(pData: PChar; DataLen: Integer);
    function TranslateLinefeeds(s: String): String;
    function HexDump(pData: PChar; DataLen: Integer; Flush: Boolean): Integer;
  public
    { Public declarations }
  end;

var FrmFCPConsole: TFrmFCPConsole = nil;

implementation

uses FreenetUtils, Settings, Misc;

{$R *.DFM}

procedure TFrmFCPConsole.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TFrmFCPConsole.FormDestroy(Sender: TObject);
begin
  if FLastRcvBuf <> nil then begin FreeMem(FLastRcvBuf); FLastRcvBuf := nil; end;
  FrmFCPConsole := nil;
end;

procedure TFrmFCPConsole.Clear1Click(Sender: TObject);
var REd: TRichEdit;
begin
  if not (PopupMenu1.PopupComponent is TRichEdit) then exit;
  REd := PopupMenu1.PopupComponent as TRichEdit;
  REd.Clear;
  if REd = RichEdOutput then RichEdOutHex.Clear;
  if REd = RichEdOutHex then RichEdOutput.Clear;
end;

procedure TFrmFCPConsole.SelectAll1Click(Sender: TObject);
var REd: TRichEdit;
begin
  if not (PopupMenu1.PopupComponent is TRichEdit) then exit;
  REd := PopupMenu1.PopupComponent as TRichEdit;
  REd.SelectAll;
end;

procedure TFrmFCPConsole.Copy1Click(Sender: TObject);
var REd: TRichEdit;
begin
  if not (PopupMenu1.PopupComponent is TRichEdit) then exit;
  REd := PopupMenu1.PopupComponent as TRichEdit;
  REd.CopyToClipboard;
end;

procedure TFrmFCPConsole.Paste1Click(Sender: TObject);
var REd: TRichEdit;
begin
  if not (PopupMenu1.PopupComponent is TRichEdit) then exit;
  REd := PopupMenu1.PopupComponent as TRichEdit;
  REd.PasteFromClipboard;
end;

procedure TFrmFCPConsole.MiSaveLastRcvClick(Sender: TObject);
var
  Dlg: TSaveDialog;
  Str: TFileStream;
begin
  Dlg := nil; Str := nil;
  try
    Dlg := TSaveDialog.Create(Self);
    Dlg.Title  := 'Save data as';
    Dlg.Options := Dlg.Options + [ofOverwritePrompt];
    if Dlg.Execute then begin
      Str := CreateFileStream(Dlg.FileName, fmCreate or fmShareExclusive);
      Str.WriteBuffer(FLastRcvBuf^, FLastRcvLen);
    end;
  finally
    Str.Free;
    Dlg.Free;
  end;
end;

procedure TFrmFCPConsole.MiSendRawClick(Sender: TObject);
var
  Dlg: TOpenDialog;
  Str: TFileStream;
  BufLen: Integer;
  pBuf:   PChar;
begin
  Dlg := nil; Str := nil; pBuf := nil; BufLen := 0;
  try
    Dlg := TOpenDialog.Create(Self);
    Dlg.Title  := 'Select raw data to send';
    Dlg.Options := Dlg.Options + [ofFileMustExist,ofPathMustExist];
    if Dlg.Execute then begin
      Str := CreateFileStream(Dlg.FileName, fmOpenRead or fmShareDenyWrite);
      BufLen := Str.Size;
      GetMem(pBuf, BufLen);
      Str.ReadBuffer(pBuf^, BufLen);
    end;
    Str.Free; Str := nil;
    if pBuf <> nil then begin
      SendData(pBuf, BufLen);
    end;
  finally
    if pBuf <> nil then FreeMem(pBuf);
    Str.Free;
    Dlg.Free;
  end;
end;

procedure TFrmFCPConsole.BtSendClick(Sender: TObject);
begin
  SendData(nil,0);
end;

procedure TFrmFCPConsole.SendData(pData: PChar; DataLen: Integer);
var
  fcp: TFCPSession;
  s,sTmp: String;
  rbuf: packed array [0..1024] of Char;
  nbytes: Integer;
  sInfo: String;
  i:     Integer;
  p:     PChar;
  bRawData: Boolean;
  BytesDumped: Integer;
  tLastDump,tNow: TDateTime;
begin
  bRawData := (pData <> nil);
  if bRawData then begin
    if (DataLen < 4)
    or not ( (pData^ = #0) and ((pData+1)^ = #0) and ((pData+2)^ = #0) and ((pData+3)^ = #2) )
    then begin
      if MessageDlg('Warning: data does not start with 00 00 00 02! Send anyway?', mtWarning, [mbYes,mbNo], 0) <> mrYes then
        exit;
    end;
  end;

  repeat

    FLastRcvLen := 0;
    ReAllocMem(FLastRcvBuf, FLastRcvLen); // free it and set pointer to nil

    fcp := TFCPSession.Create(GlobalSettings.FCPAddr, GlobalSettings.FCPPort);
    try
      BtSend.Enabled := False; BtAbort.Enabled := True; FAborted := False;
      if bRawData then begin
        sInfo := 'Sent(raw): ' + Hex(DataLen); LbInfo.Caption := sInfo; LbInfo.Update;
        fcp.SendData(pData, DataLen);
      end else begin
        s := RichEdInput.Text;
        while Pos(#13#10,s) <> 0 do Delete(s,Pos(#13#10,s),1);
        while Pos(#13,s) <> 0 do s[Pos(#13,s)] := #10;
        sInfo := 'Sent: ' + Hex(Length(s)); LbInfo.Caption := sInfo; LbInfo.Update;
        i := Pos('Data'#10, s);
        if i <> 0 then begin
          sInfo := sInfo + ' (data: ' + Hex(Length(s) - i - 5 + 1) + ')'; LbInfo.Caption := sInfo; LbInfo.Update;
        end;
        fcp.SendStringCommand(s);
      end;
      s := ''; BytesDumped := 0;
      repeat
        while not fcp.WaitForDataAvailable(500) do begin
          Application.ProcessMessages;
          if FAborted then raise Exception.Create('Aborted');
        end;
        fcp.ReadData(@rbuf, SizeOf(rbuf)-1, nbytes);
        if nbytes <> 0 then begin
          rbuf[nbytes] := #0;
          s := s + rbuf;

          ReAllocMem(FLastRcvBuf, FLastRcvLen + nbytes);
          p := PChar(FLastRcvBuf) + FLastRcvLen;
          Move(rbuf[0], p^, nbytes);
          inc(FLastRcvLen, nbytes);

{
          if not CbASCIIOnly.Checked then begin
            i := Pos(#10,s);
            if i <> 0 then begin
              sTmp := Copy(s,1,i); Delete(s,1,i);
              RichEdOutput.Text := RichEdOutput.Text + TranslateLinefeeds(sTmp);
            end;
          end;

          if (FLastRcvLen - BytesDumped) >= 16 then begin
            inc(BytesDumped, HexDump(PChar(FLastRcvBuf) + BytesDumped, FLastRcvLen - BytesDumped, False));
          end;
}
        end;
      until nbytes = 0;
      sInfo := sInfo + ' Rcvd: ' + Hex(Length(s)); LbInfo.Caption := sInfo; LbInfo.Update;
      if not CbASCIIOnly.Checked then RichEdOutput.Text := RichEdOutput.Text + TranslateLinefeeds(s);
      HexDump(PChar(FLastRcvBuf) + BytesDumped, FLastRcvLen - BytesDumped, True);
    finally
      BtSend.Enabled := True; BtAbort.Enabled := False; FAborted := False;
      fcp.Free;
      MiSaveLastRcv.Caption := Format('Save latest received data (%d bytes)...',[FLastRcvLen]);
      MiSaveLastRcv.Enabled := (FLastRcvLen <> 0);
    end;

  until not CbContSend.Checked;
end;

procedure TFrmFCPConsole.BtAbortClick(Sender: TObject);
begin
  FAborted := True;
  BtAbort.Enabled := False;
end;

procedure TFrmFCPConsole.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #27 {Esc} then begin
    Key := #0;
    if BtAbort.Enabled then BtAbort.Click;
  end;
end;

procedure TFrmFCPConsole.ClientGet1Click(Sender: TObject);
begin
  RichEdInput.Clear;
  RichEdInput.Lines.Add('ClientGet');
  RichEdInput.Lines.Add('URI=');
  RichEdInput.Lines.Add('HopsToLive=0');
  RichEdInput.Lines.Add('EndMessage');
end;

procedure TFrmFCPConsole.ClientPut1Click(Sender: TObject);
begin
  RichEdInput.Clear;
  RichEdInput.Lines.Add('ClientPut');
  RichEdInput.Lines.Add('URI=CHK@');
  RichEdInput.Lines.Add('HopsToLive=0');
  RichEdInput.Lines.Add('DataLength=');
  RichEdInput.Lines.Add('MetadataLength=');
  RichEdInput.Lines.Add('Data');
end;

procedure TFrmFCPConsole.ClientInfo1Click(Sender: TObject);
begin
  RichEdInput.Clear;
  RichEdInput.Lines.Add('ClientInfo');
  RichEdInput.Lines.Add('EndMessage');
end;

procedure TFrmFCPConsole.ClientHello1Click(Sender: TObject);
begin
  RichEdInput.Clear;
  RichEdInput.Lines.Add('ClientHello');
  RichEdInput.Lines.Add('EndMessage');
end;

procedure TFrmFCPConsole.Deletekey1Click(Sender: TObject);
begin
  RichEdInput.Clear;
  RichEdInput.Lines.Add('ClientGet');
  RichEdInput.Lines.Add('URI=');
  RichEdInput.Lines.Add('HopsToLive=0');
  RichEdInput.Lines.Add('RemoveLocalKey=true');
  RichEdInput.Lines.Add('EndMessage');
end;

procedure TFrmFCPConsole.GenerateSVKpair1Click(Sender: TObject);
begin
  RichEdInput.Clear;
  RichEdInput.Lines.Add('GenerateSVKPair');
  RichEdInput.Lines.Add('EndMessage');
end;

procedure TFrmFCPConsole.Invertprivatekey1Click(Sender: TObject);
begin
  RichEdInput.Clear;
  RichEdInput.Lines.Add('InvertPrivateKey');
  RichEdInput.Lines.Add('Private=');
  RichEdInput.Lines.Add('EndMessage');
end;

procedure TFrmFCPConsole.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  if BtAbort.Enabled then begin
    MessageDlg('Abort first', mtError, [mbOk], 0);
    CanClose := False;
  end;
end;

procedure TFrmFCPConsole.PopupMenu1Popup(Sender: TObject);
var
  bLowerPane: Boolean;
  i:          Integer;
begin
  bLowerPane := ( PopupMenu1.PopupComponent = RichEdOutput ) or ( PopupMenu1.PopupComponent = RichEdOutHex );
  for i := 0 to PopupMenu1.Items.Count-1 do
    if PopupMenu1.Items[i].Tag = 1 then
      PopupMenu1.Items[i].Visible := (not bLowerPane);
end;

procedure TFrmFCPConsole.MiConvertLinefeedsClick(Sender: TObject);
begin
  MiConvertLinefeeds.Checked := not MiConvertLinefeeds.Checked;
end;

function TFrmFCPConsole.TranslateLinefeeds(s: String): String;
var
  i: Integer;
  c: Char;
begin
  if not MiConvertLinefeeds.Checked then begin
    Result := s; exit;
  end;
  // convert LF to CRLF
  Result := ''; c := #0;
  for i := 1 to Length(s) do begin
    if (s[i] = #$0A) and (c <> #$0D) then Result := Result + #$0D;
    c := s[i];
    Result := Result + c;
  end;
end;

function TFrmFCPConsole.HexDump(pData: PChar; DataLen: Integer; Flush: Boolean): Integer;
var
  sHex,sAsc,sTxt: String;
  p:         PChar;
  i:         Integer;
  bDoText:   Boolean;
begin
  bDoText := CbASCIIOnly.Checked;
  if not Flush then DataLen := DataLen - DataLen mod 16;
  Result := DataLen;
  p := pData; sHex := ''; sAsc := ''; sTxt := '';
  while DataLen > 0 do begin
    for i := 0 to 15 do begin
      sHex := sHex + IntToHex(Ord(p^),2) + ' ';
      if p^ in [#32..#127] then sAsc := sAsc + p^ else sAsc := sAsc + '.';
      if bDoText and (p^ in [#10,#13,#32..#127]) then sTxt := sTxt + p^ else sTxt := sTxt + '.';
      inc(p); dec(DataLen);
      if DataLen = 0 then break;
    end;
    RichEdOutHex.Text := RichEdOutHex.Text + Format('%.8x: %-48s %-16s',[FHexDumpOffset,sHex,sAsc]) + #13#10;
    sHex := ''; sAsc := '';
    inc(FHexDumpOffset,16);
  end;
  if Flush then FHexDumpOffset := 0;
  if bDoText then RichEdOutput.Text := RichEdOutput.Text + TranslateLinefeeds(sTxt);
end;

end.
