//PROFILE-NO
unit CustomOpenDialog;

// *****************************************************************************
// * Copyright 2003-2005 mxbee                                                 *
// *****************************************************************************
// * This program is free software; you can redistribute it and/or modify      *
// * it under the terms of the GNU General Public License as published by      *
// * the Free Software Foundation; either version 2 of the License, or         *
// * (at your option) any later version.                                       *
// *                                                                           *
// * This program is distributed in the hope that it will be useful,           *
// * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
// * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
// * GNU General Public License for more details.                              *
// *                                                                           *
// * You should have received a copy of the GNU General Public License         *
// * along with this program; if not, write to the Free Software               *
// * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
// *****************************************************************************

{$INCLUDE CompilerOpts.pas}

interface

uses Windows,Classes,Dialogs;

type
  TCustomOpenDialog = class (TOpenDialog)
  private
    FUseExtensions: Boolean;
    procedure SetUseExtensions(const Value: Boolean);
  protected
    function TaskModalDialog(DialogFunc: Pointer; var DialogData): Bool; override;
  public
    CustomText: String;
    CustomBool: Boolean;
    constructor CreateWithExtensions(AOwner: TComponent);
    property    UseExtensions: Boolean read FUseExtensions write SetUseExtensions;
  end;

  TFuqidOpenDialog = class (TCustomOpenDialog)
  public
    property Comment: String read CustomText write CustomText;
    property Freeze: Boolean read CustomBool write CustomBool;
  end;

implementation

uses SysUtils,Messages,CommDlg,Dlgs, Types;

{ TMyOpenDialog }

const
  USERIDS = $0EED;
  lbSOMETEXT = (USERIDS+1);
  edSOMETEXT = (USERIDS+2);
  cbCHECKBOX = (USERIDS+3);

type
  TExplorerHook = function (Wnd: HWnd; Msg: UINT; WParam: WPARAM; LParam: LPARAM): UINT; stdcall;

var
  OldHook: TExplorerHook = nil;
  ThisDlg: TCustomOpenDialog = nil;

function GetTheItemText(Wnd: HWnd; Id: Integer): String;
var Buf: packed Array [0..512] of Char;
begin
  FillChar(Buf, SizeOf(Buf), 0);
  if 0 <> GetDlgItemText(Wnd, Id, @Buf[0], SizeOf(Buf)-1) then
    Result := Buf
  else
    Result := ''; // 'Error: ' + IntToStr(GetLastError);
end;

function NewHook(Wnd: HWnd; Msg: UINT; WParam: WPARAM; LParam: LPARAM): UINT; stdcall;

  procedure MoveControl(HItem: HWnd; NewX,NewY,NewW,NewH: Integer);
  var Flags: UINT;
  begin
    Flags := SWP_NOZORDER or SWP_SHOWWINDOW or SWP_NOACTIVATE;
    if (NewW = 0) or (NewH = 0) then Flags := Flags or SWP_NOSIZE;
    SetWindowPos(HItem, 0, NewX, NewY, NewW, NewH, Flags);
  end;

  function  GetItemRectInClientCoords(HItem: HWnd; out R: TRect): Boolean;
  begin
    Result := False;
    if not GetWindowRect(HItem, R) then exit;
    if not ScreenToClient(Wnd, R.TopLeft) then exit;
    if not ScreenToClient(Wnd, R.BottomRight) then exit;
    Result := True;
  end;

  procedure AlignControls;
  var
    REd,RLb,RBt,RMe,RDl: TRect;
    DlgWin:  HWnd;
    pt:      TPoint;
    midY:    Integer;
    hItem:   HWnd;
  begin
    DlgWin := GetParent(Wnd);
    GetItemRectInClientCoords(GetDlgItem(DlgWin, cmb1), REd);
    GetItemRectInClientCoords(GetDlgItem(DlgWin, stc3), RLb);
    GetItemRectInClientCoords(GetDlgItem(DlgWin, IDOK), RBt);

    // enlarge client window width in case it is too small
    GetClientRect(DlgWin, RDl);
    GetWindowRect(Wnd,    RMe);
    SetWindowPos(Wnd, 0, RMe.Left, RMe.Right, (RDl.Right - RDl.Left), (RDl.Bottom - RDl.Top), SWP_NOMOVE or SWP_NOZORDER or SWP_SHOWWINDOW or SWP_NOACTIVATE);

    // Label
    hItem := GetDlgItem(Wnd, lbSOMETEXT);
    GetItemRectInClientCoords(hItem, RMe);
    midY := RMe.Top + (RLb.Bottom - RLb.Top) div 2;
    pt.X := RLb.Left; pt.Y := RMe.Top;
    MoveControl(hItem, pt.X, pt.Y, REd.Left - RLb.Left, RLb.Bottom - RLb.Top);

    // Edit box
    hItem := GetDlgItem(Wnd, edSOMETEXT);
    GetItemRectInClientCoords(hItem, RMe);
    pt.X := REd.Left; pt.Y := midY - (REd.Bottom - REd.Top) div 2;
    MoveControl(hItem, pt.X, pt.Y, REd.Right - REd.Left, REd.Bottom - REd.Top);

    // Checkbox
    hItem := GetDlgItem(Wnd, cbCHECKBOX);
    GetItemRectInClientCoords(hItem, RMe);
    pt.X := RBt.Left; pt.Y := midY - (RMe.Bottom - RMe.Top) div 2;
    MoveControl(hItem, pt.X, pt.Y, RBt.Right - RBt.Left, RMe.Bottom - RMe.Top);
  end;

const
  Inited: Boolean = False;
var
  hdr: PNMHdr;
begin
  case Msg of
    WM_INITDIALOG:
      Inited := False;

    WM_NOTIFY:
      begin
        hdr := PNMHdr(LParam);
        if hdr^.code = CDN_INITDONE then begin
          // controls are positioned now

          AlignControls; // properly align them

          // init control values
          SetDlgItemText(Wnd, edSOMETEXT, PChar(ThisDlg.CustomText));
          if ThisDlg.CustomBool then
            SendDlgItemMessage(Wnd, cbCHECKBOX, BM_SETCHECK, BST_CHECKED, 0)
          else
            SendDlgItemMessage(Wnd, cbCHECKBOX, BM_SETCHECK, BST_UNCHECKED, 0);

          Inited := True;
        end else if hdr^.code = CDN_FILEOK then begin
          ThisDlg.CustomText := GetTheItemText(Wnd, edSOMETEXT);
          ThisDlg.CustomBool := SendDlgItemMessage(Wnd, cbCHECKBOX, BM_GETCHECK, 0, 0) = BST_CHECKED;
        end;
      end;

    WM_SIZE:
      if Inited then AlignControls;
  end;

  Result := OldHook(Wnd, Msg, WParam, LParam);
end;

constructor TCustomOpenDialog.CreateWithExtensions(AOwner: TComponent);
begin
  inherited Create(AOwner);
  UseExtensions := True;
end;

procedure TCustomOpenDialog.SetUseExtensions(const Value: Boolean);
begin
  if Value = FUseExtensions then exit;
  FUseExtensions := Value;
  if FUseExtensions then
    Template := 'FUQIDOPNDLG'
  else
    Template := nil;
end;

function TCustomOpenDialog.TaskModalDialog(DialogFunc: Pointer; var DialogData): Bool;
begin
  if FUseExtensions then begin
    // Bug in original TaskModalDialog?
    TOpenFilename(DialogData).Flags := TOpenFilename(DialogData).Flags or OFN_EXPLORER;
    TOpenFilename(DialogData).hInstance :=  FindClassHInstance(Self.ClassType);
    OldHook := TOpenFilename(DialogData).lpfnHook;
    TOpenFilename(DialogData).lpfnHook := NewHook;
    ThisDlg := Self;
    Result := inherited TaskModalDialog(DialogFunc, DialogData);
    ThisDlg := nil;
    TOpenFilename(DialogData).lpfnHook := OldHook;
  end else
    Result := inherited TaskModalDialog(DialogFunc, DialogData);
end;

end.
