//PROFILE-NO
unit AddSingleKey;

// *****************************************************************************
// * Copyright 2003-2005 mxbee                                                 *
// *****************************************************************************
// * This program is free software; you can redistribute it and/or modify      *
// * it under the terms of the GNU General Public License as published by      *
// * the Free Software Foundation; either version 2 of the License, or         *
// * (at your option) any later version.                                       *
// *                                                                           *
// * This program is distributed in the hope that it will be useful,           *
// * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
// * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
// * GNU General Public License for more details.                              *
// *                                                                           *
// * You should have received a copy of the GNU General Public License         *
// * along with this program; if not, write to the Free Software               *
// * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
// *****************************************************************************

{$INCLUDE CompilerOpts.pas}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TFrmAddSingleKey = class(TForm)
    Label1: TLabel;
    EdKey: TEdit;
    Label2: TLabel;
    EdComment: TEdit;
    Ok: TButton;
    Cancel: TButton;
    CbFrozen: TCheckBox;
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

function AskSingleKey(var sKey, sComment: String; var bFrozen: Boolean): Boolean;

implementation

{$R *.dfm}

function AskSingleKey(var sKey, sComment: String; var bFrozen: Boolean): Boolean;
var Form: TFrmAddSingleKey;
begin
  Form := TFrmAddSingleKey.Create(Application);
  try
    Form.EdKey.Text       := sKey;
    Form.EdComment.Text   := sComment;
    Form.CbFrozen.Checked := bFrozen;
    Result := (Form.ShowModal = mrOk);
    if Result then begin
      sKey     := Form.EdKey.Text;
      sComment := Form.EdComment.Text;
      bFrozen  := Form.CbFrozen.Checked;
    end else begin
      sKey     := '';
      sComment := '';
      bFrozen  := False;
    end;
  finally
    Form.Free;
  end;
end;

end.
