//PROFILE-NO
unit AddMultipleKeys;

// *****************************************************************************
// * Copyright 2003-2005 mxbee                                                 *
// *****************************************************************************
// * This program is free software; you can redistribute it and/or modify      *
// * it under the terms of the GNU General Public License as published by      *
// * the Free Software Foundation; either version 2 of the License, or         *
// * (at your option) any later version.                                       *
// *                                                                           *
// * This program is distributed in the hope that it will be useful,           *
// * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
// * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
// * GNU General Public License for more details.                              *
// *                                                                           *
// * You should have received a copy of the GNU General Public License         *
// * along with this program; if not, write to the Free Software               *
// * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
// *****************************************************************************

{$INCLUDE CompilerOpts.pas}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ExtCtrls, Menus, StdCtrls;

type
  TFrmAddMultipleKeys = class(TForm)
    Panel1: TPanel;
    LvKeys: TListView;
    PopupKeys: TPopupMenu;
    BtOk: TButton;
    BtCancel: TButton;
    MiSetFilename: TMenuItem;
    MiSetSelFolder: TMenuItem;
    MiSetAllFolder: TMenuItem;
    BtCheck: TButton;
    SaveDlg: TSaveDialog;
    MiRemove: TMenuItem;
    MiRemoveInv: TMenuItem;
    MiEditSelComment: TMenuItem;
    CbFrozen: TCheckBox;
    procedure FormShow(Sender: TObject);
    procedure LvKeysCompare(Sender: TObject; Item1, Item2: TListItem; Data: Integer; var Compare: Integer);
    procedure LvKeysColumnClick(Sender: TObject; Column: TListColumn);
    procedure BtCheckClick(Sender: TObject);
    procedure BtOkClick(Sender: TObject);
    procedure MiSetFilenameClick(Sender: TObject);
    procedure MiSetFolderClick(Sender: TObject);
    procedure MiRemoveClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure MiEditSelCommentClick(Sender: TObject);
  private
    FKeyList:     TStringList;
    FFileList:    TStringList;
    FCommentList: TStringList;
    FInited:   Boolean;
    FSortColumn:   Integer;
    FSortInverted: Boolean;
    procedure SetKeyListItem(Item: TListItem; sKey, sFolder, sFile, sComment: String);
    function  Check: Boolean;
    procedure SetAnchors;
  public
  end;

function AskKeys(KeyList,FilenameList,CommentList: TStringList): Boolean;

implementation

{$R *.DFM}

// avoid FileCtrl is platform specific warning
{$IFDEF DELPHI_6_OR_HIGHER} {$WARN UNIT_PLATFORM OFF} {$ENDIF}

uses FileCtrl, Main, Misc;

const
  COL_IDX_KEY  = 0;
  COL_IDX_DIR  = 1;
  COL_IDX_FILE = 2;
  COL_IDX_INFO = 3;
  COL_IDX_COMMENT = 4;

{ Util }

function AskKeys(KeyList,FilenameList,CommentList: TStringList): Boolean;
var Form: TFrmAddMultipleKeys;
begin
  Form := TFrmAddMultipleKeys.Create(Application);
  try
    Form.FKeyList     := KeyList;
    Form.FFileList    := FilenameList;
    Form.FCommentList := CommentList;
    Result := (Form.ShowModal = mrOk);
    if not Result then begin
      KeyList.Clear; FilenameList.Clear; CommentList.Clear;
    end;
  finally
    Form.Free;
  end;
end;

{ TFrmAddMultipleKeys }

procedure TFrmAddMultipleKeys.FormShow(Sender: TObject);
var i: Integer;
begin
  if FInited then exit;

  FSortColumn   := -1;
  FSortInverted := False;
  
  LvKeys.Items.BeginUpdate;
  try
    LvKeys.Items.Clear;
    for i := 0 to FKeyList.Count-1 do begin
      SetKeyListItem(
        LvKeys.Items.Add,
        FKeyList.Strings[i],
        ExtractFilePath(FFileList.Strings[i]),
        ExtractFileName(FFileList.Strings[i]),
        FCommentList.Strings[i]
      );
    end;
  finally
    LvKeys.Items.EndUpdate;
  end;
  FInited := True;
  Check;
end;

procedure TFrmAddMultipleKeys.SetKeyListItem(Item: TListItem; sKey, sFolder, sFile, sComment: String);
begin
  Item.Data := nil;
  Item.Caption := sKey;
  Item.SubItems.Clear;
  Item.SubItems.Add( sFolder );
  Item.SubItems.Add( sFile );
  Item.SubItems.Add( '(unchecked)' );
  Item.SubItems.Add( sComment );
end;

procedure TFrmAddMultipleKeys.LvKeysCompare(Sender: TObject; Item1,Item2: TListItem; Data: Integer; var Compare: Integer);
var s1,s2: String;
begin
  if FSortColumn = 0 then begin
    s1 := Item1.Caption; s2 := Item2.Caption;
  end else if FSortColumn > 0 then begin
    try s1 := Item1.SubItems[FSortColumn-1] except s1 := ''; end;
    try s2 := Item2.SubItems[FSortColumn-1] except s2 := ''; end;
  end else begin
    Compare := 0; exit;
  end;
  Compare := AnsiCompareText(s1,s2);
  if FSortInverted then Compare := -Compare;
end;

procedure TFrmAddMultipleKeys.LvKeysColumnClick(Sender: TObject; Column: TListColumn);
begin
  if Column.Index = FSortColumn then
    FSortInverted := not FSortInverted
  else begin
    FSortColumn := Column.Index;
    FSortInverted := False;
  end;
  LvKeys.CustomSort(nil,0);
end;

procedure TFrmAddMultipleKeys.BtCheckClick(Sender: TObject);
begin
  Check;
end;

function TFrmAddMultipleKeys.Check: Boolean;
var
  i,j: Integer;
  item,item2: TListItem;
  sDir,sFile,sInfo: String;
  QueueFiles: TStringList;
begin
  Result := True;
  QueueFiles := nil;
  LvKeys.Items.BeginUpdate;
  try
    QueueFiles := TStringList.Create;
    FrmMain.GetAllGetFilenames(QueueFiles);
    for i := 0 to LvKeys.Items.Count-1 do begin
      item := LvKeys.Items[i];
      sDir  := item.SubItems[COL_IDX_DIR-1];
      sFile := item.SubItems[COL_IDX_FILE-1];
      sInfo := '';
      if (sDir = '') or not DirectoryExists(sDir) then
        sInfo := 'No such folder'
      else if sFile = '' then
        sInfo := 'No filename'
      else if FileExists(sDir + sFile) then
        sInfo := 'File exists'
      else begin
        for j := 0 to LvKeys.Items.Count-1 do begin
          if j = i then continue;
          item2 := LvKeys.Items[j];
          if  (AnsiCompareText(item2.SubItems[COL_IDX_DIR-1],  sDir)  = 0)
          and (AnsiCompareText(item2.SubItems[COL_IDX_FILE-1], sFile) = 0) then begin
            sInfo := 'Dup.filename'; break;
          end;
        end;
        if sInfo = '' then begin
          for j := 0 to QueueFiles.Count-1 do begin
            if AnsiCompareText(sDir+sFile, QueueFiles.Strings[j]) = 0 then begin
              sInfo := 'Filename already in Q'; break;
            end;
          end;
        end;
      end;
      if item.SubItems[COL_IDX_INFO-1] <> sInfo then item.SubItems[COL_IDX_INFO-1] := sInfo;
      if sInfo <> '' then Result := False;
    end;
  finally
    LvKeys.Items.EndUpdate;
    QueueFiles.Free;
  end;
end;

procedure TFrmAddMultipleKeys.BtOkClick(Sender: TObject);
var
  i:    Integer;
  item: TListItem;
  bFreeze: Boolean;
begin
  if not Check then begin
    MessageDlg('Check did not pass - see column Check-Info', mtError, [mbOk], 0);
    exit;
  end;
  FKeyList.Clear; FFileList.Clear; FCommentList.Clear;
  bFreeze := CbFrozen.Checked;
  for i := 0 to LvKeys.Items.Count-1 do begin
    item := LvKeys.Items[i];
    FKeyList.AddObject(item.Caption, Pointer(bFreeze));
    FFileList.Add(item.SubItems[COL_IDX_DIR-1] + item.SubItems[COL_IDX_FILE-1]);
    FCommentList.Add(item.SubItems[COL_IDX_COMMENT-1]);
  end;
  ModalResult := mrOk;
end;

procedure TFrmAddMultipleKeys.MiSetFilenameClick(Sender: TObject);
var
  item:       TListItem;
  sDir,sFile,sComment: String;
begin
  item := LvKeys.Selected; if item = nil then exit;
  sDir     := item.SubItems[COL_IDX_DIR-1];
  sFile    := item.SubItems[COL_IDX_FILE-1];
  sComment := item.SubItems[COL_IDX_COMMENT-1];
  if (sDir = '') or DirectoryExists(sDir) then SaveDlg.InitialDir := sDir;
  SaveDlg.FileName := sDir + sFile;
  SaveDlg.Title := 'Save download as';
  if not ExecuteSaveDialogSafely(SaveDlg) then exit;
  sDir  := ExtractFilePath(SaveDlg.FileName);
  sFile := ExtractFileName(SaveDlg.FileName);
  SetKeyListItem(item, item.Caption, sDir, sFile, sComment);
  FrmMain.LastGetDir := sDir;
  Check;
end;

procedure TFrmAddMultipleKeys.MiSetFolderClick(Sender: TObject);
var
  ItemList: TList;
  bAll:     Boolean;
  i:        Integer;
  sDir:     String;
  item:     TListItem;
begin
  ItemList := nil;
  try
    ItemList := TList.Create;
    bAll := (Sender = MiSetAllFolder);
    sDir := '';
    for i := 0 to LvKeys.Items.Count-1 do begin
      item := LvKeys.Items[i];
      if bAll or item.Selected then begin
        if sDir = '' then sDir := item.SubItems[COL_IDX_DIR-1];
        ItemList.Add(item);
      end;
    end;
    if ItemList.Count = 0 then exit;

    if (sDir = '') or DirectoryExists(sDir) then SaveDlg.InitialDir := sDir;
    SaveDlg.FileName := sDir + '(Dummy-File, leave this alone)';
    SaveDlg.Title := 'Go into download dir and press Ok';
    if not SaveDlg.Execute then exit;
    sDir := ExtractFilePath(SaveDlg.FileName);
    FrmMain.LastGetDir := sDir;
    LvKeys.Items.BeginUpdate;
    try
      for i := 0 to ItemList.Count-1 do begin
        item := ItemList.Items[i];
        SetKeyListItem(item, item.Caption, sDir, item.SubItems[COL_IDX_FILE-1], item.SubItems[COL_IDX_COMMENT-1]);
      end;
    finally
      LvKeys.Items.EndUpdate;
    end;
  finally
    ItemList.Free;
  end;
  Check;
end;

procedure TFrmAddMultipleKeys.MiRemoveClick(Sender: TObject);
var
  i: Integer;
  bRemSelected: Boolean;
begin
  bRemSelected := not (Sender = MiRemoveInv);
  LvKeys.Items.BeginUpdate;
  try
    i := 0;
    while i < LvKeys.Items.Count do begin
      if LvKeys.Items[i].Selected = bRemSelected then
        LvKeys.Items[i].Delete
      else
        inc(i);
    end;
  finally
    LvKeys.Items.EndUpdate;
  end;
  Check;
end;

procedure TFrmAddMultipleKeys.MiEditSelCommentClick(Sender: TObject);
var
  i:        Integer;
  sComment: String;
  sFile:    String;
  item:     TListItem;
begin
  if LvKeys.SelCount = 0 then exit;
  if LvKeys.SelCount > 1 then sFile := 'multiple files' else sFile := '';
  sComment := '';
  for i := 0 to LvKeys.Items.Count-1 do begin
    item := LvKeys.Items[i];
    if item.Selected then begin
      if sComment = '' then sComment := item.SubItems[COL_IDX_COMMENT-1];
      if sFile    = '' then sFile    := item.SubItems[COL_IDX_FILE-1];
      if (sComment <> '') and (sFile <> '') then break;
    end;
  end;

  if not InputQuery('Comment for ' + sFile, 'Comment:', sComment) then exit;

  LvKeys.Items.BeginUpdate;
  try
    for i := 0 to LvKeys.Items.Count-1 do begin
      item := LvKeys.Items[i];
      if item.Selected then begin
        SetKeyListItem(item, item.Caption, item.SubItems[COL_IDX_DIR-1], item.SubItems[COL_IDX_FILE-1], sComment);
      end;
    end;
  finally
    LvKeys.Items.EndUpdate;
  end;
end;


procedure TFrmAddMultipleKeys.FormCreate(Sender: TObject);
begin
  SetAnchors;
end;

procedure TFrmAddMultipleKeys.SetAnchors;
begin
  // Set anchors for controls that stick to the right or bottom of their parent.
  // Normally this would be done at design time, but D7 then saves .DesignSize,
  // breaking compatibility with earlier Delphi versions. So do it at runtime.
  with BtCancel do Anchors := [akTop,akRight];
end;

end.
